/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.seq;

import java.util.Arrays;
import org.monte.media.image.BitmapImage;
import org.monte.media.seq.SEQFrame;
import org.monte.media.seq.SEQMovieTrack;

public class SEQDeltaFrame
extends SEQFrame {
    private int leftBound;
    private int topBound;
    private int rightBound;
    private int bottomBound;
    public static final int OP_Copy = 0;
    public static final int OP_XOR = 1;
    public static final int SM_UNCOMPRESSED = 0;
    public static final int SM_COMPRESSED = 1;
    private static final int ENCODING_COPY_UNCOMPRESSED = 0;
    private static final int ENCODING_COPY_COMPRESSED = 1;
    private static final int ENCODING_XOR_UNCOMPRESSED = 2;
    private static final int ENCODING_XOR_COMPRESSED = 3;
    private boolean isWarningPrinted = false;

    private int getEncoding() {
        return this.getOperation() << 1 | this.getStorageMethod();
    }

    @Override
    public void decode(BitmapImage bitmap, SEQMovieTrack track) {
        switch (this.getEncoding()) {
            case 0: {
                this.decodeCopyUncompressed(bitmap, track);
                break;
            }
            case 1: {
                this.decodeCopyCompressed(bitmap, track);
                break;
            }
            case 2: {
                this.decodeXORUncompressed(bitmap, track);
                break;
            }
            case 3: {
                this.decodeXORCompressed(bitmap, track);
                break;
            }
            default: {
                throw new InternalError("Unsupported encoding." + this.getEncoding());
            }
        }
    }

    private void decodeCopyUncompressed(BitmapImage bitmap, SEQMovieTrack track) {
    }

    private void decodeCopyCompressed(BitmapImage bitmap, SEQMovieTrack track) {
        int di = 0;
        byte[] screen = bitmap.getBitmap();
        Arrays.fill(screen, (byte)0);
        int bStride = bitmap.getBitplaneStride();
        int sStride = bitmap.getScanlineStride();
        int x = this.leftBound;
        int y = this.topBound;
        int shift = x & 7;
        int b = 0;
        int si = y * sStride + x / 8;
        int width = bitmap.getWidth();
        if (shift == 0) {
            while (di < this.data.length) {
                int op;
                if (((op = (this.data[di++] & 0xFF) << 8 | this.data[di++] & 0xFF) & 0x8000) == 0) {
                    byte d1 = this.data[di++];
                    byte d2 = this.data[di++];
                    for (int i = 0; i < op; ++i) {
                        screen[si] = d1;
                        if (x < width - 8) {
                            screen[si + 1] = d2;
                        }
                        si += sStride;
                        if (++y < this.bottomBound) continue;
                        y = this.topBound;
                        if ((x += 16) >= this.rightBound) {
                            x = this.leftBound;
                            y = this.topBound;
                            ++b;
                        }
                        si = b * bStride + y * sStride + x / 8;
                    }
                    continue;
                }
                op ^= 0x8000;
                for (int i = 0; i < op; ++i) {
                    byte d1 = this.data[di++];
                    byte d2 = this.data[di++];
                    screen[si] = d1;
                    if (x < width - 8) {
                        screen[si + 1] = d2;
                    }
                    si += sStride;
                    if (++y < this.bottomBound) continue;
                    y = this.topBound;
                    if ((x += 16) >= this.rightBound) {
                        x = this.leftBound;
                        y = this.topBound;
                        ++b;
                    }
                    si = b * bStride + y * sStride + x / 8;
                }
            }
        } else {
            int invShift = 8 - shift;
            int mask = 255 << shift & 0xFF;
            int invMask = 255 << invShift & 0xFF;
            int xorInvMask = 255 >>> shift;
            while (di < this.data.length) {
                int op;
                if (((op = (this.data[di++] & 0xFF) << 8 | this.data[di++] & 0xFF) & 0x8000) == 0) {
                    byte d1 = this.data[di++];
                    byte d2 = this.data[di++];
                    byte d3 = (byte)(d2 << invShift);
                    d2 = (byte)(d1 << invShift & invMask | (d2 & 0xFF) >>> shift);
                    d1 = (byte)((d1 & 0xFF) >>> shift);
                    for (int i = 0; i < op; ++i) {
                        screen[si] = (byte)(screen[si] & invMask | d1);
                        if (x < width - 8) {
                            screen[si + 1] = d2;
                            if (x < width - 16) {
                                screen[si + 2] = (byte)(screen[si + 2] & xorInvMask | d3);
                            }
                        }
                        si += sStride;
                        if (++y < this.bottomBound) continue;
                        y = this.topBound;
                        if ((x += 16) >= this.rightBound) {
                            x = this.leftBound;
                            y = this.topBound;
                            ++b;
                        }
                        si = b * bStride + y * sStride + x / 8;
                    }
                    continue;
                }
                op ^= 0x8000;
                for (int i = 0; i < op; ++i) {
                    byte d1 = this.data[di++];
                    byte d2 = this.data[di++];
                    byte d3 = (byte)(d2 << invShift);
                    d2 = (byte)(d1 << invShift & invMask | (d2 & 0xFF) >>> shift);
                    d1 = (byte)((d1 & 0xFF) >>> shift);
                    screen[si] = (byte)(screen[si] & invMask | d1);
                    if (x < width - 8) {
                        screen[si + 1] = d2;
                        if (x < width - 16) {
                            screen[si + 2] = (byte)(screen[si + 2] & xorInvMask | d3);
                        }
                    }
                    si += sStride;
                    if (++y < this.bottomBound) continue;
                    y = this.topBound;
                    if ((x += 16) >= this.rightBound) {
                        x = this.leftBound;
                        y = this.topBound;
                        ++b;
                    }
                    si = b * bStride + y * sStride + x / 8;
                }
            }
        }
    }

    private void decodeXORUncompressed(BitmapImage bitmap, SEQMovieTrack track) {
    }

    private void decodeXORCompressed(BitmapImage bitmap, SEQMovieTrack track) {
        int di = 0;
        byte[] screen = bitmap.getBitmap();
        int bStride = bitmap.getBitplaneStride();
        int sStride = bitmap.getScanlineStride();
        int x = this.leftBound;
        int y = this.topBound;
        int shift = x & 7;
        int b = 0;
        int si = y * sStride + x / 8;
        int width = bitmap.getWidth();
        if (shift == 0) {
            while (di < this.data.length) {
                int op;
                if (((op = (this.data[di++] & 0xFF) << 8 | this.data[di++] & 0xFF) & 0x8000) == 0) {
                    byte d1 = this.data[di++];
                    byte d2 = this.data[di++];
                    for (int i = 0; i < op; ++i) {
                        int n = si;
                        screen[n] = (byte)(screen[n] ^ d1);
                        if (x < width - 8) {
                            int n2 = si + 1;
                            screen[n2] = (byte)(screen[n2] ^ d2);
                        }
                        si += sStride;
                        if (++y < this.bottomBound) continue;
                        y = this.topBound;
                        if ((x += 16) >= this.rightBound) {
                            x = this.leftBound;
                            y = this.topBound;
                            ++b;
                        }
                        si = b * bStride + y * sStride + x / 8;
                    }
                    continue;
                }
                op ^= 0x8000;
                for (int i = 0; i < op; ++i) {
                    byte d1 = this.data[di++];
                    byte d2 = this.data[di++];
                    int n = si;
                    screen[n] = (byte)(screen[n] ^ d1);
                    if (x < width - 8) {
                        int n3 = si + 1;
                        screen[n3] = (byte)(screen[n3] ^ d2);
                    }
                    si += sStride;
                    if (++y < this.bottomBound) continue;
                    y = this.topBound;
                    if ((x += 16) >= this.rightBound) {
                        x = this.leftBound;
                        y = this.topBound;
                        ++b;
                    }
                    si = b * bStride + y * sStride + x / 8;
                }
            }
        } else {
            int invShift = 8 - shift;
            int mask = 255 << shift & 0xFF;
            int xorMask = 0xFF ^ mask;
            int invMask = 255 << invShift & 0xFF;
            int xorInvMask = 255 >>> shift;
            while (di < this.data.length) {
                int op;
                if (((op = (this.data[di++] & 0xFF) << 8 | this.data[di++] & 0xFF) & 0x8000) == 0) {
                    byte d1 = this.data[di++];
                    byte d2 = this.data[di++];
                    byte d3 = (byte)(d2 << invShift);
                    d2 = (byte)(d1 << invShift & invMask | (d2 & 0xFF) >>> shift);
                    d1 = (byte)((d1 & 0xFF) >>> shift);
                    for (int i = 0; i < op; ++i) {
                        screen[si] = (byte)(screen[si] & invMask | screen[si] & xorInvMask ^ d1);
                        if (x < width - 8) {
                            int n = si + 1;
                            screen[n] = (byte)(screen[n] ^ d2);
                            if (x < width - 16) {
                                screen[si + 2] = (byte)(screen[si + 2] & xorInvMask | screen[si + 2] & invMask ^ d3);
                            }
                        }
                        si += sStride;
                        if (++y < this.bottomBound) continue;
                        y = this.topBound;
                        if ((x += 16) >= this.rightBound) {
                            x = this.leftBound;
                            y = this.topBound;
                            ++b;
                        }
                        si = b * bStride + y * sStride + x / 8;
                    }
                    continue;
                }
                op ^= 0x8000;
                for (int i = 0; i < op; ++i) {
                    byte d1 = this.data[di++];
                    byte d2 = this.data[di++];
                    byte d3 = (byte)(d2 << invShift);
                    d2 = (byte)(d1 << invShift & invMask | (d2 & 0xFF) >>> shift);
                    d1 = (byte)((d1 & 0xFF) >>> shift);
                    screen[si] = (byte)(screen[si] & invMask | screen[si] & xorInvMask ^ d1);
                    if (x < width - 8) {
                        int n = si + 1;
                        screen[n] = (byte)(screen[n] ^ d2);
                        if (x < width - 16) {
                            screen[si + 2] = (byte)(screen[si + 2] & xorInvMask | screen[si + 2] & invMask ^ d3);
                        }
                    }
                    si += sStride;
                    if (++y < this.bottomBound) continue;
                    y = this.topBound;
                    if ((x += 16) >= this.rightBound) {
                        x = this.leftBound;
                        y = this.topBound;
                        ++b;
                    }
                    si = b * bStride + y * sStride + x / 8;
                }
            }
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        this.leftBound = x;
        this.topBound = y;
        this.rightBound = x + w;
        this.bottomBound = y + h;
    }

    @Override
    public int getTopBound(SEQMovieTrack track) {
        return this.topBound;
    }

    @Override
    public int getBottomBound(SEQMovieTrack track) {
        return this.bottomBound;
    }

    @Override
    public int getLeftBound(SEQMovieTrack track) {
        return this.leftBound;
    }

    @Override
    public int getRightBound(SEQMovieTrack track) {
        return this.rightBound;
    }

    @Override
    public boolean isBidirectional() {
        return this.getOperation() == 1;
    }
}

