/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import org.monte.media.ColorCyclePlayer;
import org.monte.media.MovieControl;
import org.monte.media.Player;
import org.monte.media.gui.JMovieSliderAqua;
import org.monte.media.gui.border.BackdropBorder;
import org.monte.media.gui.border.ButtonStateBorder;
import org.monte.media.gui.border.ImageBevelBorder;
import org.monte.media.gui.plaf.CustomButtonUI;
import org.monte.media.image.Images;

public class JMovieControlAqua
extends JComponent
implements MovieControl,
ActionListener,
ChangeListener,
PropertyChangeListener {
    private Player player;
    private JMovieSliderAqua slider;
    private JButton forwardButton;
    private JButton rewindButton;
    private JToggleButton startButton;
    private JToggleButton audioButton;
    private JToggleButton colorCyclingButton;
    private BoundedRangeModel boundedRangeModel;
    private Timer scrollTimer;
    private ScrollHandler scrollHandler;
    private JPanel spacer;

    public JMovieControlAqua() {
        this.setBackground(Color.WHITE);
        Dimension buttonSize = new Dimension(16, 16);
        GridBagLayout gridbag = new GridBagLayout();
        Insets margin = new Insets(0, 0, 0, 0);
        this.setLayout(gridbag);
        ResourceBundle labels = ResourceBundle.getBundle("org.monte.media.Labels");
        this.colorCyclingButton = new JToggleButton();
        this.colorCyclingButton.setToolTipText(labels.getString("colorCycling.toolTipText"));
        this.colorCyclingButton.addActionListener(this);
        this.colorCyclingButton.setPreferredSize(buttonSize);
        this.colorCyclingButton.setMinimumSize(buttonSize);
        this.colorCyclingButton.setVisible(false);
        this.colorCyclingButton.setMargin(margin);
        GridBagConstraints c = new GridBagConstraints();
        gridbag.setConstraints(this.colorCyclingButton, c);
        this.add(this.colorCyclingButton);
        this.audioButton = new JToggleButton();
        this.audioButton.setToolTipText(labels.getString("audio.toolTipText"));
        this.audioButton.addActionListener(this);
        this.audioButton.setPreferredSize(buttonSize);
        this.audioButton.setMinimumSize(buttonSize);
        this.audioButton.setVisible(false);
        this.audioButton.setMargin(margin);
        c = new GridBagConstraints();
        gridbag.setConstraints(this.audioButton, c);
        this.add(this.audioButton);
        this.startButton = new JToggleButton();
        this.startButton.setToolTipText(labels.getString("play.toolTipText"));
        this.startButton.addActionListener(this);
        this.startButton.setPreferredSize(buttonSize);
        this.startButton.setMinimumSize(buttonSize);
        this.startButton.setMargin(margin);
        c = new GridBagConstraints();
        gridbag.setConstraints(this.startButton, c);
        this.add(this.startButton);
        this.slider = new JMovieSliderAqua();
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.slider, c);
        this.add(this.slider);
        this.rewindButton = new JButton();
        this.rewindButton.setToolTipText(labels.getString("previous.toolTipText"));
        this.rewindButton.setPreferredSize(buttonSize);
        this.rewindButton.setMinimumSize(buttonSize);
        this.rewindButton.setMargin(margin);
        c = new GridBagConstraints();
        gridbag.setConstraints(this.rewindButton, c);
        this.add(this.rewindButton);
        this.rewindButton.addActionListener(this);
        this.forwardButton = new JButton();
        this.forwardButton.setToolTipText(labels.getString("next.toolTipText"));
        buttonSize = new Dimension(17, 16);
        this.forwardButton.setPreferredSize(buttonSize);
        this.forwardButton.setMinimumSize(buttonSize);
        this.forwardButton.setMargin(margin);
        c = new GridBagConstraints();
        gridbag.setConstraints(this.forwardButton, c);
        this.add(this.forwardButton);
        this.forwardButton.addActionListener(this);
        this.spacer = new JPanel(new BorderLayout());
        this.spacer.setVisible(false);
        this.spacer.setPreferredSize(new Dimension(16, 16));
        this.spacer.setMinimumSize(new Dimension(16, 16));
        this.spacer.setOpaque(false);
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.spacer, c);
        this.add(this.spacer);
        BackdropBorder border = new BackdropBorder(new ButtonStateBorder(new ImageBevelBorder(Images.createImage(this.getClass(), "images/Player.border.png"), new Insets(1, 1, 1, 1), new Insets(0, 4, 1, 4)), new ImageBevelBorder(Images.createImage(this.getClass(), "images/Player.borderP.png"), new Insets(1, 1, 1, 1), new Insets(0, 4, 1, 4))));
        BackdropBorder westBorder = new BackdropBorder(new ButtonStateBorder(new ImageBevelBorder(Images.createImage(this.getClass(), "images/Player.borderWest.png"), new Insets(1, 1, 1, 0), new Insets(0, 4, 1, 4)), new ImageBevelBorder(Images.createImage(this.getClass(), "images/Player.borderWestP.png"), new Insets(1, 1, 1, 0), new Insets(0, 4, 1, 4))));
        this.startButton.setBorder(westBorder);
        this.colorCyclingButton.setBorder(westBorder);
        this.audioButton.setBorder(westBorder);
        this.rewindButton.setBorder(westBorder);
        this.forwardButton.setBorder(border);
        this.startButton.setUI((ButtonUI)CustomButtonUI.createUI(this.startButton));
        this.colorCyclingButton.setUI((ButtonUI)CustomButtonUI.createUI(this.audioButton));
        this.audioButton.setUI((ButtonUI)CustomButtonUI.createUI(this.audioButton));
        this.rewindButton.setUI((ButtonUI)CustomButtonUI.createUI(this.rewindButton));
        this.forwardButton.setUI((ButtonUI)CustomButtonUI.createUI(this.forwardButton));
        this.colorCyclingButton.setIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStartColorCycling.png")));
        this.colorCyclingButton.setSelectedIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStartColorCycling.png")));
        this.colorCyclingButton.setDisabledIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStartColorCycling.disabled.png")));
        this.audioButton.setIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStartAudio.png")));
        this.audioButton.setSelectedIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStopAudio.png")));
        this.audioButton.setDisabledIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStartAudio.disabled.png")));
        this.startButton.setIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStart.png")));
        this.startButton.setSelectedIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStop.png")));
        this.startButton.setDisabledIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerStart.disabled.png")));
        this.rewindButton.setIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerBack.png")));
        this.rewindButton.setDisabledIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerBack.disabled.png")));
        this.forwardButton.setIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerNext.png")));
        this.forwardButton.setDisabledIcon(new ImageIcon(Images.createImage(this.getClass(), "images/PlayerNext.disabled.png")));
        this.scrollHandler = new ScrollHandler();
        this.scrollTimer = new Timer(60, this.scrollHandler);
        this.scrollTimer.setInitialDelay(300);
        this.forwardButton.addMouseListener(this.scrollHandler);
        this.rewindButton.addMouseListener(this.scrollHandler);
    }

    @Override
    public synchronized void setPlayer(Player player) {
        if (this.player != null) {
            this.player.removeChangeListener(this);
            player.removePropertyChangeListener(this);
        }
        this.player = player;
        this.boundedRangeModel = player == null ? null : player.getTimeModel();
        this.slider.setModel(this.boundedRangeModel);
        if (player != null) {
            if (player.getState() >= 2 && this.boundedRangeModel != null && this.boundedRangeModel.getMaximum() == 0) {
                this.setPlayerControlsVisible(false);
            }
            this.slider.setProgressModel(player.getCachingModel());
            this.startButton.setSelected(player.isActive());
            player.addChangeListener(this);
            player.addPropertyChangeListener(this);
            this.audioButton.setVisible(player.isAudioAvailable());
            this.audioButton.setSelected(player.isAudioEnabled());
            this.colorCyclingButton.setVisible(player instanceof ColorCyclePlayer ? ((ColorCyclePlayer)player).isColorCyclingAvailable() : false);
            this.colorCyclingButton.setSelected(player instanceof ColorCyclePlayer ? ((ColorCyclePlayer)player).isColorCyclingStarted() : false);
            this.validate();
            this.repaint();
            BoundedRangeModel boundedRangeModel = this.slider.getProgressModel();
        }
    }

    public void setPlayerControlsVisible(boolean b) {
        boolean oldValue = this.forwardButton.isVisible();
        if (oldValue != b) {
            this.forwardButton.setVisible(b);
            this.rewindButton.setVisible(b);
            this.startButton.setVisible(b);
            this.slider.setVisible(b);
            this.spacer.setVisible(!b);
            this.revalidate();
        }
    }

    public void setProgressModel(BoundedRangeModel brm) {
        this.slider.setProgressModel(brm);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.boundedRangeModel != null) {
            int value = this.boundedRangeModel.getValue();
            if (source == this.forwardButton) {
                this.boundedRangeModel.setValue(value == this.boundedRangeModel.getMaximum() ? this.boundedRangeModel.getMinimum() : value + 1);
            } else if (source == this.rewindButton) {
                this.boundedRangeModel.setValue(value == this.boundedRangeModel.getMinimum() ? this.boundedRangeModel.getMaximum() : value - 1);
            } else if (source == this.startButton) {
                if (this.startButton.isSelected() != this.player.isActive()) {
                    if (this.startButton.isSelected()) {
                        this.player.start();
                    } else {
                        this.player.stop();
                    }
                }
            } else if (source == this.audioButton) {
                this.player.setAudioEnabled(this.audioButton.isSelected());
            } else if (source == this.colorCyclingButton && this.player instanceof ColorCyclePlayer) {
                ((ColorCyclePlayer)this.player).setColorCyclingStarted(this.colorCyclingButton.isSelected());
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (Component c : this.getComponents()) {
            c.setEnabled(b);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.startButton.setSelected(this.player.isActive());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("audioEnabled")) {
            this.audioButton.setSelected(this.player.isAudioEnabled());
        } else if (name.equals("audioAvailable")) {
            this.audioButton.setVisible(this.player.isAudioAvailable());
            this.validate();
            this.repaint();
        } else if (name.equals("colorCyclingStarted")) {
            this.colorCyclingButton.setSelected(this.player instanceof ColorCyclePlayer ? ((ColorCyclePlayer)this.player).isColorCyclingStarted() : false);
        } else if (name.equals("colorCyclingAvailable")) {
            this.colorCyclingButton.setVisible(this.player instanceof ColorCyclePlayer ? ((ColorCyclePlayer)this.player).isColorCyclingAvailable() : false);
            this.validate();
            this.repaint();
        } else if (name.equals("cached")) {
            this.setPlayerControlsVisible(this.player.getTimeModel().getMaximum() > 0);
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    protected class ScrollHandler
    extends MouseAdapter
    implements ActionListener {
        private JButton button;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.button.isEnabled() && this.button.getModel().isArmed()) {
                int value = JMovieControlAqua.this.boundedRangeModel.getValue();
                if (this.button == JMovieControlAqua.this.forwardButton) {
                    JMovieControlAqua.this.boundedRangeModel.setValue(value == JMovieControlAqua.this.boundedRangeModel.getMaximum() ? JMovieControlAqua.this.boundedRangeModel.getMinimum() : value + 1);
                } else {
                    JMovieControlAqua.this.boundedRangeModel.setValue(value == JMovieControlAqua.this.boundedRangeModel.getMinimum() ? JMovieControlAqua.this.boundedRangeModel.getMaximum() : value - 1);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JMovieControlAqua.this.scrollTimer.start();
            this.button = (JButton)e.getSource();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JMovieControlAqua.this.scrollTimer.stop();
        }
    }
}

