/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.console;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemoteThread;
import com.orientechnologies.orient.console.OConsoleDatabaseListener;
import com.orientechnologies.orient.console.OTableFormatter;
import com.orientechnologies.orient.console.OrientConsole;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.OSignalHandler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.db.tool.ODatabaseCompare;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORetryQueryException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.intent.OIntentMassiveRead;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebug;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebugProperty;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryDebug;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPageDebug;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedClusterDebug;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class OConsoleDatabaseApp
extends OrientConsole
implements OCommandOutputListener,
OProgressListener {
    protected static final int DEFAULT_WIDTH = 150;
    protected ODatabaseDocumentTx currentDatabase;
    protected String currentDatabaseName;
    protected ORecord currentRecord;
    protected int currentRecordIdx;
    protected List<OIdentifiable> currentResultSet;
    protected Object currentResult;
    protected OServerAdmin serverAdmin;
    private int windowSize = 150;
    private int lastPercentStep;
    private String currentDatabaseUserName;
    private String currentDatabaseUserPassword;
    private int collectionMaxItems = 10;

    public OConsoleDatabaseApp(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result = 0;
        try {
            boolean tty = false;
            try {
                if (OConsoleDatabaseApp.setTerminalToCBreak()) {
                    tty = true;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        OConsoleDatabaseApp.restoreTerminal();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            new OSignalHandler().installDefaultSignals(new SignalHandler(){

                @Override
                public void handle(Signal signal) {
                    OConsoleDatabaseApp.restoreTerminal();
                }
            });
            OConsoleDatabaseApp console = new OConsoleDatabaseApp(args);
            if (tty) {
                console.setReader((OConsoleReader)new TTYConsoleReader());
            }
            result = console.run();
        }
        finally {
            OConsoleDatabaseApp.restoreTerminal();
        }
        Orient.instance().shutdown();
        System.exit(result);
    }

    protected static void restoreTerminal() {
        try {
            OConsoleDatabaseApp.stty("echo");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static boolean setTerminalToCBreak() throws IOException, InterruptedException {
        int result = OConsoleDatabaseApp.stty("-icanon min 1");
        if (result != 0) {
            return false;
        }
        OConsoleDatabaseApp.stty("-echo");
        return true;
    }

    protected static int stty(String args) throws IOException, InterruptedException {
        String cmd = "stty " + args + " < /dev/tty";
        return OConsoleDatabaseApp.exec(new String[]{"sh", "-c", cmd});
    }

    protected static int exec(String[] cmd) throws IOException, InterruptedException {
        int c;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = p.getInputStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        in = p.getErrorStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        p.waitFor();
        return p.exitValue();
    }

    @ConsoleCommand(aliases={"use database"}, description="Connect to a database or a remote Server instance", onlineHelp="Console-Command-Connect")
    public void connect(@ConsoleParameter(name="url", description="The url of the remote server or the database to connect to in the format '<mode>:<path>'") String iURL, @ConsoleParameter(name="user", description="User name") String iUserName, @ConsoleParameter(name="password", description="User password", optional=true) String iUserPassword) throws IOException {
        this.disconnect();
        if (iUserPassword == null) {
            this.message("Enter password: ", new Object[0]);
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            iUserPassword = br.readLine();
            this.message("\n", new Object[0]);
        }
        this.currentDatabaseUserName = iUserName;
        this.currentDatabaseUserPassword = iUserPassword;
        if (iURL.contains("/")) {
            this.message("\nConnecting to database [" + iURL + "] with user '" + iUserName + "'...", new Object[0]);
            this.currentDatabase = new ODatabaseDocumentTx(iURL);
            this.currentDatabase.registerListener((Object)new OConsoleDatabaseListener(this));
            this.currentDatabase.open(iUserName, iUserPassword);
            this.currentDatabaseName = this.currentDatabase.getName();
        } else {
            this.message("\nConnecting to remote Server instance [" + iURL + "] with user '" + iUserName + "'...", new Object[0]);
            this.serverAdmin = new OServerAdmin(iURL).connect(iUserName, iUserPassword);
            this.currentDatabase = null;
            this.currentDatabaseName = null;
        }
        this.message("OK", new Object[0]);
        this.dumpDistributedConfiguration(false);
    }

    @ConsoleCommand(aliases={"close database"}, description="Disconnect from the current database", onlineHelp="Console-Command-Disconnect")
    public void disconnect() {
        if (this.serverAdmin != null) {
            this.message("\nDisconnecting from remote server [" + this.serverAdmin.getURL() + "]...", new Object[0]);
            this.serverAdmin.close(true);
            this.serverAdmin = null;
            this.message("\nOK", new Object[0]);
        }
        if (this.currentDatabase != null) {
            this.message("\nDisconnecting from the database [" + this.currentDatabaseName + "]...", new Object[0]);
            OStorage stg = Orient.instance().getStorage(this.currentDatabase.getURL());
            this.currentDatabase.activateOnCurrentThread();
            if (!this.currentDatabase.isClosed()) {
                this.currentDatabase.close();
            }
            if (stg != null) {
                stg.close(true, false);
            }
            this.currentDatabase = null;
            this.currentDatabaseName = null;
            this.currentRecord = null;
            this.message("OK", new Object[0]);
        }
    }

    @ConsoleCommand(description="Create a new database", onlineHelp="Console-Command-Create-Database")
    public void createDatabase(@ConsoleParameter(name="database-url", description="The url of the database to create in the format '<mode>:<path>'") String iDatabaseURL, @ConsoleParameter(name="user", optional=true, description="Server administrator name") String iUserName, @ConsoleParameter(name="password", optional=true, description="Server administrator password") String iUserPassword, @ConsoleParameter(name="storage-type", optional=true, description="The type of the storage. 'local' and 'plocal' for disk-based databases and 'memory' for in-memory database") String iStorageType, @ConsoleParameter(name="db-type", optional=true, description="The type of the database used between 'document' and 'graph'. By default is graph.") String iDatabaseType) throws IOException {
        if (iUserName == null) {
            iUserName = "admin";
        }
        if (iUserPassword == null) {
            iUserPassword = "admin";
        }
        if (iStorageType == null) {
            if (iDatabaseURL.startsWith("remote:")) {
                throw new IllegalArgumentException("Missing storage type for remote database");
            }
            int pos = iDatabaseURL.indexOf(":");
            if (pos == -1) {
                throw new IllegalArgumentException("Invalid URL");
            }
            iStorageType = iDatabaseURL.substring(0, pos);
        }
        if (iDatabaseType == null) {
            iDatabaseType = "graph";
        }
        this.message("\nCreating database [" + iDatabaseURL + "] using the storage type [" + iStorageType + "]...", new Object[0]);
        this.currentDatabaseUserName = iUserName;
        this.currentDatabaseUserPassword = iUserPassword;
        if (iDatabaseURL.startsWith("remote")) {
            String dbURL = iDatabaseURL.substring("remote".length() + 1);
            new OServerAdmin(dbURL).connect(iUserName, iUserPassword).createDatabase(iDatabaseType, iStorageType).close();
            this.connect(iDatabaseURL, "admin", "admin");
        } else {
            if (iStorageType != null && !iDatabaseURL.toLowerCase().startsWith(iStorageType.toLowerCase())) {
                throw new IllegalArgumentException("Storage type '" + iStorageType + "' is different by storage type in URL");
            }
            this.currentDatabase = Orient.instance().getDatabaseFactory().createDatabase(iDatabaseType, iDatabaseURL);
            this.currentDatabase.create();
            this.currentDatabaseName = this.currentDatabase.getName();
        }
        this.message("\nDatabase created successfully.", new Object[0]);
        this.message("\n\nCurrent database is: " + iDatabaseURL, new Object[0]);
    }

    @ConsoleCommand(description="List all the databases available on the connected server", onlineHelp="Console-Command-List-Databases")
    public void listDatabases() throws IOException {
        if (this.serverAdmin != null) {
            Map databases = this.serverAdmin.listDatabases();
            this.message("\nFound %d databases:\n", new Object[]{databases.size()});
            for (Map.Entry database : databases.entrySet()) {
                this.message("\n* %s (%s)", new Object[]{database.getKey(), ((String)database.getValue()).substring(0, ((String)database.getValue()).indexOf(":"))});
            }
        } else {
            this.message("\nNot connected to the Server instance. You've to connect to the Server using server's credentials (look at orientdb-*server-config.xml file)", new Object[0]);
        }
        this.out.println();
    }

    @ConsoleCommand(description="Reload the database schema")
    public void reloadSchema() throws IOException {
        this.message("\nreloading database schema...", new Object[0]);
        this.updateDatabaseInfo();
        this.message("\n\nDone.", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new cluster in the current database. The cluster can be physical or memory")
    public void createCluster(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCluster created correctly with id #%d\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Remove a cluster in the current database. The cluster can be physical or memory")
    public void dropCluster(@ConsoleParameter(name="cluster-name", description="The name or the id of the cluster to remove") String iClusterName) {
        this.checkForDatabase();
        this.message("\nDropping cluster [" + iClusterName + "] in database " + this.currentDatabaseName + "...", new Object[0]);
        boolean result = this.currentDatabase.dropCluster(iClusterName, true);
        if (!result) {
            try {
                int clusterId = Integer.parseInt(iClusterName);
                if (clusterId > -1) {
                    result = this.currentDatabase.dropCluster(clusterId, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result) {
            this.message("\nCluster correctly removed", new Object[0]);
        } else {
            this.message("\nCannot find the cluster to remove", new Object[0]);
        }
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alters a cluster in the current database. The cluster can be physical or memory")
    public void alterCluster(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nCluster updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Begins a transaction. All the changes will remain local")
    public void begin() throws IOException {
        this.checkForDatabase();
        if (this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: an active transaction is currently open (id=" + this.currentDatabase.getTransaction().getId() + "). Commit or rollback before starting a new one.", new Object[0]);
            return;
        }
        if (this.currentDatabase.getStorage().isRemote()) {
            this.message("\nWARNING - Transactions are not supported from console in remote, please use an sql script: \neg.\n\nscript sql\nbegin;\n<your commands here>\ncommit;\nend\n\n", new Object[0]);
            return;
        }
        this.currentDatabase.begin();
        this.message("\nTransaction " + this.currentDatabase.getTransaction().getId() + " is running", new Object[0]);
    }

    @ConsoleCommand(description="Commits transaction changes to the database")
    public void commit() throws IOException {
        this.checkForDatabase();
        if (!this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: no active transaction is currently open.", new Object[0]);
            return;
        }
        if (this.currentDatabase.getStorage().isRemote()) {
            this.message("\nWARNING - Transactions are not supported from console in remote, please use an sql script: \neg.\n\nscript sql\nbegin;\n<your commands here>\ncommit;\nend\n\n", new Object[0]);
            return;
        }
        long begin = System.currentTimeMillis();
        int txId = this.currentDatabase.getTransaction().getId();
        this.currentDatabase.commit();
        this.message("\nTransaction " + txId + " has been committed in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
    }

    @ConsoleCommand(description="Rolls back transaction changes to the previous state")
    public void rollback() throws IOException {
        this.checkForDatabase();
        if (!this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: no active transaction is running right now.", new Object[0]);
            return;
        }
        if (this.currentDatabase.getStorage().isRemote()) {
            this.message("\nWARNING - Transactions are not supported from console in remote, please use an sql script: \neg.\n\nscript sql\nbegin;\n<your commands here>\ncommit;\nend\n\n", new Object[0]);
            return;
        }
        long begin = System.currentTimeMillis();
        int txId = this.currentDatabase.getTransaction().getId();
        this.currentDatabase.rollback();
        this.message("\nTransaction " + txId + " has been rollbacked in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate the class content in the current database")
    public void truncateClass(@ConsoleParameter(name="text", description="The name of the class to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate the cluster content in the current database")
    public void truncateCluster(@ConsoleParameter(name="text", description="The name of the class to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate a record deleting it at low level")
    public void truncateRecord(@ConsoleParameter(name="text", description="The record(s) to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(description="Load a record in memory using passed fetch plan")
    public void loadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId, @ConsoleParameter(name="fetch-plan", description="The fetch plan to load the record with") String iFetchPlan) {
        this.loadRecordInternal(iRecordId, iFetchPlan);
    }

    @ConsoleCommand(description="Load a record in memory and set it as the current")
    public void loadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId) {
        this.loadRecordInternal(iRecordId, null);
    }

    @ConsoleCommand(description="Reloads a record using passed fetch plan")
    public void reloadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId, @ConsoleParameter(name="fetch-plan", description="The fetch plan to load the record with") String iFetchPlan) {
        this.reloadRecordInternal(iRecordId, iFetchPlan);
    }

    @ConsoleCommand(description="Reload a record and set it as the current one", onlineHelp="Console-Command-Reload-Record")
    public void reloadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId) {
        this.reloadRecordInternal(iRecordId, null);
    }

    @ConsoleCommand(splitInWords=false, description="Explain how a command is executed profiling it", onlineHelp="SQL-Explain")
    public void explain(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        Object result = this.sqlCommand("explain", iCommandText, "\nProfiled command '%s' in %f sec(s):\n", true);
        if (result != null && result instanceof ODocument) {
            this.message(((ODocument)result).toJSON(), new Object[0]);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Executes a command inside a transaction")
    public void transactional(@ConsoleParameter(name="command-text", description="The command to execute") String iCommandText) {
        this.sqlCommand("transactional", iCommandText, "\nResult: '%s'. Executed in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Insert a new record into the database", onlineHelp="SQL-Insert")
    public void insert(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("insert", iCommandText, "\nInserted record '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new vertex into the database", onlineHelp="SQL-Create-Vertex")
    public void createVertex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated vertex '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new edge into the database", onlineHelp="SQL-Create-Edge")
    public void createEdge(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated edge '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Update records in the database", onlineHelp="SQL-Update")
    public void update(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("update", iCommandText, "\nUpdated record(s) '%s' in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.currentDatabase.getLocalCache().invalidate();
    }

    @ConsoleCommand(splitInWords=false, description="Move vertices to another position (class/cluster)", priority=8, onlineHelp="SQL-Move-Vertex")
    public void moveVertex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("move", iCommandText, "\nMove vertex command executed with result '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Optimizes the current database", onlineHelp="SQL-Optimize-Database")
    public void optimizeDatabase(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("optimize", iCommandText, "\nDatabase optimized in %f sec(s).\n", true);
    }

    @ConsoleCommand(description="Force calling of JVM Garbage Collection")
    public void gc() {
        System.gc();
    }

    @ConsoleCommand(splitInWords=false, description="Delete records from the database", onlineHelp="SQL-Delete")
    public void delete(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("delete", iCommandText, "\nDelete record(s) '%s' in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.currentDatabase.getLocalCache().invalidate();
    }

    @ConsoleCommand(splitInWords=false, description="Grant privileges to a role", onlineHelp="SQL-Grant")
    public void grant(@ConsoleParameter(name="text", description="Grant command") String iCommandText) {
        this.sqlCommand("grant", iCommandText, "\nPrivilege granted to the role: %s\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Revoke privileges to a role", onlineHelp="SQL-Revoke")
    public void revoke(@ConsoleParameter(name="text", description="Revoke command") String iCommandText) {
        this.sqlCommand("revoke", iCommandText, "\nPrivilege revoked to the role: %s\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a link from a JOIN", onlineHelp="SQL-Create-Link")
    public void createLink(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated %d link(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Find all references the target record id @rid", onlineHelp="SQL-Find-References")
    public void findReferences(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("find", iCommandText, "\nFound %s in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Alter a database property", onlineHelp="SQL-Alter-Database")
    public void alterDatabase(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nDatabase updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Freeze database and flush on the disk", onlineHelp="Console-Command-Freeze-Database")
    public void freezeDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (storageType == null) {
                storageType = "plocal";
            }
            new OServerAdmin(this.currentDatabase.getURL()).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).freezeDatabase(storageType);
        } else {
            this.currentDatabase.freeze();
        }
        this.message("\n\nDatabase '" + dbName + "' was frozen successfully", new Object[0]);
    }

    @ConsoleCommand(description="Release database after freeze", onlineHelp="Console-Command-Release-Db")
    public void releaseDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (storageType == null) {
                storageType = "plocal";
            }
            new OServerAdmin(this.currentDatabase.getURL()).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).releaseDatabase(storageType);
        } else {
            this.currentDatabase.release();
        }
        this.message("\n\nDatabase '" + dbName + "' was released successfully", new Object[0]);
    }

    @ConsoleCommand(description="Flushes all database content to the disk")
    public void flushDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.freezeDatabase(storageType);
        this.releaseDatabase(storageType);
    }

    @ConsoleCommand(description="Display current record")
    public void current() {
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Move the current record cursor to the next one in result set")
    public void next() {
        this.setCurrentRecord(this.currentRecordIdx + 1);
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Move the current record cursor to the previous one in result set")
    public void prev() {
        this.setCurrentRecord(this.currentRecordIdx - 1);
        this.dumpRecordDetails();
    }

    @ConsoleCommand(splitInWords=false, description="Alter a class in the database schema")
    public void alterClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nClass updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a class", onlineHelp="SQL-Create-Class")
    public void createClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nClass created successfully. Total classes in database now: %d\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alter a class property in the database schema", onlineHelp="SQL-Alter-Property")
    public void alterProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nProperty updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a property", onlineHelp="SQL-Create-Property")
    public void createProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nProperty created successfully with id=%d\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a stored function", onlineHelp="SQL-Create-Function")
    public void createFunction(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nFunction created successfully with id=%s\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Traverse records and display the results", onlineHelp="SQL-Traverse")
    public void traverse(@ConsoleParameter(name="query-text", description="The traverse to execute") String iQueryText) {
        int limit = iQueryText.contains("limit") ? -1 : Integer.parseInt((String)this.properties.get("limit"));
        long start = System.currentTimeMillis();
        this.setResultset((List)this.currentDatabase.command((OCommandRequest)new OCommandSQL("traverse " + iQueryText)).execute(new Object[0]));
        float elapsedSeconds = this.getElapsedSecs(start);
        this.dumpResultSet(limit);
        this.message("\n\n" + this.currentResultSet.size() + " item(s) found. Traverse executed in " + elapsedSeconds + " sec(s).", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Execute a query against the database and display the results", onlineHelp="SQL-Query")
    public void select(@ConsoleParameter(name="query-text", description="The query to execute") String iQueryText) {
        this.checkForDatabase();
        if (iQueryText == null) {
            return;
        }
        if ((iQueryText = iQueryText.trim()).length() == 0 || iQueryText.equalsIgnoreCase("select")) {
            return;
        }
        iQueryText = "select " + iQueryText;
        int limit = iQueryText.contains("limit") ? -1 : Integer.parseInt((String)this.properties.get("limit"));
        long start = System.currentTimeMillis();
        this.setResultset(this.currentDatabase.query((OQuery)new OSQLSynchQuery(iQueryText, limit).setFetchPlan("*:0"), new Object[0]));
        float elapsedSeconds = this.getElapsedSecs(start);
        this.dumpResultSet(limit);
        this.message("\n\n" + this.currentResultSet.size() + " item(s) found. Query executed in " + elapsedSeconds + " sec(s).", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Move from current record by evaluating a predicate against current record")
    public void move(@ConsoleParameter(name="text", description="The sql predicate to evaluate") String iText) {
        if (iText == null) {
            return;
        }
        if (this.currentRecord == null) {
            return;
        }
        Object result = new OSQLPredicate(iText).evaluate((OIdentifiable)this.currentRecord, null, null);
        if (result != null) {
            if (result instanceof OIdentifiable) {
                this.setResultset(new ArrayList<OIdentifiable>());
                this.currentRecord = ((OIdentifiable)result).getRecord();
                this.dumpRecordDetails();
            } else if (result instanceof List) {
                this.setResultset((List)result);
                this.dumpResultSet(-1);
            } else if (result instanceof Iterator) {
                ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                while (((Iterator)result).hasNext()) {
                    list.add((OIdentifiable)((Iterator)result).next());
                }
                this.setResultset(list);
                this.dumpResultSet(-1);
            } else {
                this.setResultset(new ArrayList<OIdentifiable>());
            }
        }
    }

    @ConsoleCommand(splitInWords=false, description="Evaluate a predicate against current record")
    public void eval(@ConsoleParameter(name="text", description="The sql predicate to evaluate") String iText) {
        if (iText == null) {
            return;
        }
        if (this.currentRecord == null) {
            return;
        }
        Object result = new OSQLPredicate(iText).evaluate((OIdentifiable)this.currentRecord, null, null);
        if (result != null) {
            this.out.println("\n" + result);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Execute a script containing multiple commands separated by ; or new line")
    public void script(@ConsoleParameter(name="text", description="Commands to execute, one per line") String iText) {
        int languageEndPos = iText.indexOf(";");
        if (languageEndPos <= -1) {
            throw new IllegalArgumentException("Missing language in script (sql, js, gremlin, etc.) as first argument");
        }
        String language = iText.substring(0, languageEndPos);
        iText = iText.substring(languageEndPos + 1);
        this.executeServerSideScript(language, iText);
    }

    @ConsoleCommand(splitInWords=false, description="Execute javascript commands in the console")
    public void js(@ConsoleParameter(name="text", description="The javascript to execute. Use 'db' to reference to a document database, 'gdb' for a graph database") String iText) {
        float elapsedSeconds;
        if (iText == null) {
            return;
        }
        this.resetResultSet();
        while (true) {
            try {
                OCommandExecutorScript cmd = new OCommandExecutorScript();
                cmd.parse((OCommandRequest)new OCommandScript("Javascript", iText));
                long start = System.currentTimeMillis();
                this.currentResult = cmd.execute(null);
                elapsedSeconds = this.getElapsedSecs(start);
            }
            catch (ORetryQueryException e) {
                continue;
            }
            break;
        }
        this.parseResult();
        if (this.currentResultSet != null) {
            this.dumpResultSet(-1);
            this.message("\nClient side script executed in %f sec(s). Returned %d records", new Object[]{Float.valueOf(elapsedSeconds), this.currentResultSet.size()});
        } else {
            this.message("\nClient side script executed in %f sec(s). Value returned is: %s", new Object[]{Float.valueOf(elapsedSeconds), this.currentResult});
        }
    }

    @ConsoleCommand(splitInWords=false, description="Execute javascript commands against a remote server")
    public void jss(@ConsoleParameter(name="text", description="The javascript to execute. Use 'db' to reference to a document database, 'gdb' for a graph database") String iText) {
        this.checkForRemoteServer();
        this.executeServerSideScript("javascript", iText);
    }

    @ConsoleCommand(splitInWords=false, description="Create an index against a property", onlineHelp="SQL-Create-Index")
    public void createIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nCreating index...", new Object[0]);
        this.sqlCommand("create", iCommandText, "\nCreated index successfully with %d entries in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.message("\n\nIndex created successfully", new Object[0]);
    }

    @ConsoleCommand(description="Delete the current database", onlineHelp="Console-Command-Drop-Database")
    public void dropDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (this.serverAdmin == null) {
                this.message("\n\nCannot drop a remote database without connecting to the server with a valid server's user", new Object[0]);
                return;
            }
            if (storageType == null) {
                storageType = "plocal";
            }
            String dbURL = this.currentDatabase.getURL().substring("remote".length() + 1);
            new OServerAdmin(dbURL).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).dropDatabase(storageType);
        } else {
            this.currentDatabase.drop();
            this.currentDatabase = null;
            this.currentDatabaseName = null;
        }
        this.message("\n\nDatabase '" + dbName + "' deleted successfully", new Object[0]);
    }

    @ConsoleCommand(description="Delete the specified database", onlineHelp="Console-Command-Drop-Database")
    public void dropDatabase(@ConsoleParameter(name="database-url", description="The url of the database to drop in the format '<mode>:<path>'") String iDatabaseURL, @ConsoleParameter(name="user", description="Server administrator name") String iUserName, @ConsoleParameter(name="password", description="Server administrator password") String iUserPassword, @ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        if (iDatabaseURL.startsWith("remote")) {
            String dbURL = iDatabaseURL.substring("remote".length() + 1);
            if (this.serverAdmin != null) {
                this.serverAdmin.close();
            }
            this.serverAdmin = new OServerAdmin(dbURL).connect(iUserName, iUserPassword);
            this.serverAdmin.dropDatabase(storageType);
            this.disconnect();
        } else {
            this.currentDatabase = new ODatabaseDocumentTx(iDatabaseURL);
            if (this.currentDatabase.exists()) {
                this.currentDatabase.open(iUserName, iUserPassword);
                this.currentDatabase.drop();
            } else {
                this.message("\n\nCannot drop database '" + iDatabaseURL + "' because was not found", new Object[0]);
            }
        }
        this.currentDatabase = null;
        this.currentDatabaseName = null;
        this.message("\n\nDatabase '" + iDatabaseURL + "' deleted successfully", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Remove an index", onlineHelp="SQL-Drop-Index")
    public void dropIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nRemoving index...", new Object[0]);
        this.sqlCommand("drop", iCommandText, "\nDropped index in %f sec(s).\n", false);
        this.updateDatabaseInfo();
        this.message("\n\nIndex removed successfully", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Rebuild an index if it is automatic", onlineHelp="SQL-Rebuild-Index")
    public void rebuildIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nRebuilding index(es)...", new Object[0]);
        this.sqlCommand("rebuild", iCommandText, "\nRebuilt index(es). Found %d link(s) in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.message("\n\nIndex(es) rebuilt successfully", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Remove a class from the schema", onlineHelp="SQL-Drop-Class")
    public void dropClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.sqlCommand("drop", iCommandText, "\nRemoved class in %f sec(s).\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Remove a property from a class", onlineHelp="SQL-Drop-Property")
    public void dropProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.sqlCommand("drop", iCommandText, "\nRemoved class property in %f sec(s).\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Browse all records of a class", onlineHelp="Console-Command-Browse-Class")
    public void browseClass(@ConsoleParameter(name="class-name", description="The name of the class") String iClassName) {
        this.checkForDatabase();
        this.resetResultSet();
        int limit = Integer.parseInt((String)this.properties.get("limit"));
        ORecordIteratorClass it = this.currentDatabase.browseClass(iClassName);
        this.browseRecords(limit, (OIdentifiableIterator<?>)it);
    }

    @ConsoleCommand(description="Browse all records of a cluster", onlineHelp="Console-Command-Browse-Cluster")
    public void browseCluster(@ConsoleParameter(name="cluster-name", description="The name of the cluster") String iClusterName) {
        this.checkForDatabase();
        this.resetResultSet();
        int limit = Integer.parseInt((String)this.properties.get("limit"));
        ORecordIteratorCluster it = this.currentDatabase.browseCluster(iClusterName);
        this.browseRecords(limit, (OIdentifiableIterator<?>)it);
    }

    @ConsoleCommand(aliases={"display"}, description="Display current record attributes", onlineHelp="Console-Command-Display-Record")
    public void displayRecord(@ConsoleParameter(name="number", description="The number of the record in the most recent result set") String iRecordNumber) {
        this.checkForDatabase();
        if (iRecordNumber == null || this.currentResultSet == null) {
            this.checkCurrentObject();
        } else {
            int recNumber = Integer.parseInt(iRecordNumber);
            if (this.currentResultSet.size() == 0) {
                throw new OException("No result set where to find the requested record. Execute a query first.");
            }
            if (this.currentResultSet.size() <= recNumber) {
                throw new OException("The record requested is not part of current result set (0" + (this.currentResultSet.size() > 0 ? "-" + (this.currentResultSet.size() - 1) : "") + ")");
            }
            this.setCurrentRecord(recNumber);
        }
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Display a record as raw bytes", onlineHelp="Console-Command-Display-Raw-Record")
    public void displayRawRecord(@ConsoleParameter(name="rid", description="The record id to display") String iRecordId) throws IOException {
        ORawBuffer record;
        ORecordId rid;
        this.checkForDatabase();
        if (iRecordId.indexOf(58) > -1) {
            rid = new ORecordId(iRecordId);
        } else {
            OIdentifiable rec = this.setCurrentRecord(Integer.parseInt(iRecordId));
            if (rec != null) {
                rid = (ORecordId)rec.getIdentity();
            } else {
                return;
            }
        }
        ORecordId id = new ORecordId((ORID)rid);
        if (!(this.currentDatabase.getStorage() instanceof OLocalPaginatedStorage)) {
            record = (ORawBuffer)this.currentDatabase.getStorage().readRecord(rid, null, false, null).getResult();
            if (record != null) {
                String content = Integer.parseInt((String)this.properties.get("maxBinaryDisplay")) < record.buffer.length ? new String(Arrays.copyOf(record.buffer, Integer.parseInt((String)this.properties.get("maxBinaryDisplay")))) : new String(record.buffer);
                this.out.println("\nRaw record content. The size is " + record.buffer.length + " bytes, while settings force to print first " + content.length() + " bytes:\n\n" + content);
            }
        } else {
            OLocalPaginatedStorage storage = (OLocalPaginatedStorage)this.currentDatabase.getStorage();
            OPaginatedCluster cluster = (OPaginatedCluster)storage.getClusterById(id.getClusterId());
            if (cluster == null) {
                this.message("\n cluster with id %i does not exist", new Object[]{id.getClusterId()});
                return;
            }
            OPaginatedClusterDebug debugInfo = cluster.readDebug(id.clusterPosition);
            this.message("\n\nLOW LEVEL CLUSTER INFO", new Object[0]);
            this.message("\n cluster fieldId: %d", new Object[]{debugInfo.fileId});
            this.message("\n cluster name: %s", new Object[]{cluster.getName()});
            this.message("\n in cluster position: %d", new Object[]{debugInfo.clusterPosition});
            this.message("\n empty: %b", new Object[]{debugInfo.empty});
            this.message("\n contentSize: %d", new Object[]{debugInfo.contentSize});
            this.message("\n n-pages: %d", new Object[]{debugInfo.pages.size()});
            this.message("\n\n +----------PAGE_ID---------------+------IN_PAGE_POSITION----------+---------IN_PAGE_SIZE-----------+----PAGE_CONTENT---->> ", new Object[0]);
            for (OClusterPageDebug page : debugInfo.pages) {
                this.message("\n |%30d ", new Object[]{page.pageIndex});
                this.message(" |%30d ", new Object[]{page.inPagePosition});
                this.message(" |%30d ", new Object[]{page.inPageSize});
                this.message(" |%s", new Object[]{OBase64Utils.encodeBytes((byte[])page.content)});
            }
            record = cluster.readRecord(id.clusterPosition);
        }
        if (record == null) {
            throw new OException("The record has been deleted");
        }
        if ("ORecordSerializerBinary".equals(this.currentDatabase.getSerializer().toString())) {
            byte[] buff = record.getBuffer();
            ORecordSerializerBinaryDebug debugger = new ORecordSerializerBinaryDebug();
            ORecordSerializationDebug deserializeDebug = debugger.deserializeDebug(buff, this.currentDatabase);
            this.message("\n\nRECORD CONTENT INFO", new Object[0]);
            this.message("\n class name: %s", new Object[]{deserializeDebug.className});
            this.message("\n fail on Reading: %b", new Object[]{deserializeDebug.readingFailure});
            this.message("\n fail position: %d", new Object[]{deserializeDebug.failPosition});
            if (deserializeDebug.readingException != null) {
                StringWriter writer = new StringWriter();
                deserializeDebug.readingException.printStackTrace(new PrintWriter(writer));
                this.message("\n Exception On Reading: %s", new Object[]{writer.getBuffer().toString()});
            }
            this.message("\n number of properties : %d", new Object[]{deserializeDebug.properties.size()});
            this.message("\n\n PROPERTIES", new Object[0]);
            for (ORecordSerializationDebugProperty prop : deserializeDebug.properties) {
                this.message("\n  property name: %s", new Object[]{prop.name});
                this.message("\n  property type: %s", new Object[]{prop.type.name()});
                this.message("\n  property globlaId: %d", new Object[]{prop.globalId});
                this.message("\n  fail on reading: %b", new Object[]{prop.faildToRead});
                if (prop.faildToRead) {
                    this.message("\n  failed on reading position: %b", new Object[]{prop.failPosition});
                    StringWriter writer = new StringWriter();
                    prop.readingException.printStackTrace(new PrintWriter(writer));
                    this.message("\n  Exception on reading: %s", new Object[]{writer.getBuffer().toString()});
                } else if (prop.value instanceof ORidBag) {
                    this.message("\n  property value: ORidBug ", new Object[0]);
                    ((ORidBag)prop.value).debugPrint(System.out);
                } else {
                    this.message("\n  property value: %s", new Object[]{prop.value != null ? prop.value.toString() : "null"});
                }
                this.message("\n", new Object[0]);
            }
        }
    }

    @ConsoleCommand(aliases={"status"}, description="Display information about the database", onlineHelp="Console-Command-Info")
    public void info() {
        if (this.currentDatabaseName != null) {
            this.message("\nCurrent database: " + this.currentDatabaseName + " (url=" + this.currentDatabase.getURL() + ")", new Object[0]);
            OStorage stg = this.currentDatabase.getStorage();
            if (stg instanceof OStorageRemoteThread) {
                this.dumpDistributedConfiguration(true);
            }
            this.listProperties();
            this.listClusters();
            this.listClasses();
            this.listIndexes();
        }
    }

    @ConsoleCommand(description="Display the database properties")
    public void listProperties() {
        if (this.currentDatabase == null) {
            return;
        }
        OStorage stg = this.currentDatabase.getStorage();
        OStorageConfiguration dbCfg = stg.getConfiguration();
        this.message("\n\nDATABASE PROPERTIES", new Object[0]);
        if (dbCfg.getProperties() != null) {
            this.message("\n--------------------------------+----------------------------------------------------+", new Object[0]);
            this.message("\n NAME                           | VALUE                                              |", new Object[0]);
            this.message("\n--------------------------------+----------------------------------------------------+", new Object[0]);
            this.message("\n %-30s | %-50s |", new Object[]{"Name", this.format(dbCfg.name, 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Version", this.format("" + dbCfg.version, 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Conflict Strategy", this.format(dbCfg.getConflictStrategy(), 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Date format", this.format(dbCfg.dateFormat, 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Datetime format", this.format(dbCfg.dateTimeFormat, 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Timezone", this.format(dbCfg.getTimeZone().getID(), 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Locale Country", this.format(dbCfg.getLocaleCountry(), 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Locale Language", this.format(dbCfg.getLocaleLanguage(), 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Charset", this.format(dbCfg.getCharset(), 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Schema RID", this.format(dbCfg.schemaRecordId, 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Index Manager RID", this.format(dbCfg.indexMgrRecordId, 50)});
            this.message("\n %-30s | %-50s |", new Object[]{"Dictionary RID", this.format(dbCfg.dictionaryRecordId, 50)});
            this.message("\n--------------------------------+----------------------------------------------------+", new Object[0]);
            if (!dbCfg.getProperties().isEmpty()) {
                this.message("\n\nDATABASE CUSTOM PROPERTIES:", new Object[0]);
                this.message("\n +-------------------------------+--------------------------------------------------+", new Object[0]);
                this.message("\n | NAME                          | VALUE                                            |", new Object[0]);
                this.message("\n +-------------------------------+--------------------------------------------------+", new Object[0]);
                for (OStorageEntryConfiguration cfg : dbCfg.getProperties()) {
                    this.message("\n | %-29s | %-49s|", new Object[]{cfg.name, this.format(cfg.value, 49)});
                }
                this.message("\n +-------------------------------+--------------------------------------------------+", new Object[0]);
            }
        }
    }

    @ConsoleCommand(aliases={"desc"}, description="Display a class in the schema", onlineHelp="Console-Command-Info-Class")
    public void infoClass(@ConsoleParameter(name="class-name", description="The name of the class") String iClassName) {
        Set indexes;
        this.checkForDatabase();
        OClass cls = this.currentDatabase.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName);
        if (cls == null) {
            this.message("\n! Class '" + iClassName + "' does not exist in the database '" + this.currentDatabaseName + "'", new Object[0]);
            return;
        }
        this.message("\nCLASS '" + cls.getName() + "'\n", new Object[0]);
        if (cls.getShortName() != null) {
            this.message("\nAlias................: " + cls.getShortName(), new Object[0]);
        }
        if (cls.hasSuperClasses()) {
            this.message("\nSuper classes........: " + Arrays.toString(cls.getSuperClassesNames().toArray()), new Object[0]);
        }
        this.message("\nDefault cluster......: " + this.currentDatabase.getClusterNameById(cls.getDefaultClusterId()) + " (id=" + cls.getDefaultClusterId() + ")", new Object[0]);
        StringBuilder clusters = new StringBuilder();
        for (int clId : cls.getClusterIds()) {
            if (clusters.length() > 0) {
                clusters.append(", ");
            }
            clusters.append(this.currentDatabase.getClusterNameById(clId));
            clusters.append("(");
            clusters.append(clId);
            clusters.append(")");
        }
        this.message("\nSupported clusters...: " + clusters.toString(), new Object[0]);
        this.message("\nCluster selection....: " + cls.getClusterSelection().getName(), new Object[0]);
        this.message("\nOversize.............: " + cls.getClassOverSize(), new Object[0]);
        if (!cls.getSubclasses().isEmpty()) {
            this.message("\nSubclasses.........: ", new Object[0]);
            int i = 0;
            for (OClass c : cls.getSubclasses()) {
                if (i > 0) {
                    this.message(", ", new Object[0]);
                }
                this.message(c.getName(), new Object[0]);
                ++i;
            }
            this.out.println();
        }
        if (cls.properties().size() > 0) {
            this.message("\n\nPROPERTIES", new Object[0]);
            this.message("\n-------------------------------+-------------+-------------------------------+-----------+----------+----------+-----------+-----------+----------+", new Object[0]);
            this.message("\n NAME                          | TYPE        | LINKED TYPE/CLASS             | MANDATORY | READONLY | NOT NULL |    MIN    |    MAX    | COLLATE  |", new Object[0]);
            this.message("\n-------------------------------+-------------+-------------------------------+-----------+----------+----------+-----------+-----------+----------+", new Object[0]);
            for (OProperty p : cls.properties()) {
                try {
                    this.message("\n %-30s| %-12s| %-30s| %-10s| %-9s| %-9s| %-10s| %-10s| %-9s|", new Object[]{p.getName(), p.getType(), p.getLinkedClass() != null ? p.getLinkedClass() : p.getLinkedType(), p.isMandatory(), p.isReadonly(), p.isNotNull(), p.getMin() != null ? p.getMin() : "", p.getMax() != null ? p.getMax() : "", p.getCollate() != null ? p.getCollate().getName() : ""});
                }
                catch (Exception c) {}
            }
            this.message("\n-------------------------------+-------------+-------------------------------+-----------+----------+----------+-----------+-----------+----------+", new Object[0]);
        }
        if (!(indexes = cls.getClassIndexes()).isEmpty()) {
            this.message("\n\nINDEXES (" + indexes.size() + " altogether)", new Object[0]);
            this.message("\n-------------------------------+----------------+", new Object[0]);
            this.message("\n NAME                          | PROPERTIES     |", new Object[0]);
            this.message("\n-------------------------------+----------------+", new Object[0]);
            for (OIndex index : indexes) {
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition != null) {
                    List fields = indexDefinition.getFields();
                    this.message("\n %-30s| %-15s|", new Object[]{index.getName(), (String)fields.get(0) + (fields.size() > 1 ? " (+)" : "")});
                    for (int i = 1; i < fields.size(); ++i) {
                        if (i < fields.size() - 1) {
                            this.message("\n %-30s| %-15s|", new Object[]{"", (String)fields.get(i) + " (+)"});
                            continue;
                        }
                        this.message("\n %-30s| %-15s|", new Object[]{"", fields.get(i)});
                    }
                    continue;
                }
                this.message("\n %-30s| %-15s|", new Object[]{index.getName(), ""});
            }
            this.message("\n-------------------------------+----------------+", new Object[0]);
        }
        if (cls.getCustomKeys().size() > 0) {
            this.message("\n\nCUSTOM ATTRIBUTES", new Object[0]);
            this.message("\n-------------------------------+-----------------------------------------+", new Object[0]);
            this.message("\n NAME                          | VALUE                                   |", new Object[0]);
            this.message("\n-------------------------------+-----------------------------------------+", new Object[0]);
            for (String k : cls.getCustomKeys()) {
                try {
                    this.message("\n %-30s| %-40s|", new Object[]{k, cls.getCustom(k)});
                }
                catch (Exception exception) {}
            }
            this.message("\n-------------------------------+-----------------------------------------+", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display a class property", onlineHelp="Console-Command-Info-Property")
    public void infoProperty(@ConsoleParameter(name="property-name", description="The name of the property as <class>.<property>") String iPropertyName) {
        Collection indexes;
        this.checkForDatabase();
        if (iPropertyName.indexOf(46) == -1) {
            throw new OException("Property name is in the format <class>.<property>");
        }
        String[] parts = iPropertyName.split("\\.");
        OClass cls = this.currentDatabase.getMetadata().getImmutableSchemaSnapshot().getClass(parts[0]);
        if (cls == null) {
            this.message("\n! Class '" + parts[0] + "' does not exist in the database '" + this.currentDatabaseName + "'", new Object[0]);
            return;
        }
        OProperty prop = cls.getProperty(parts[1]);
        if (prop == null) {
            this.message("\n! Property '" + parts[1] + "' does not exist in class '" + parts[0] + "'", new Object[0]);
            return;
        }
        this.message("\nPROPERTY '" + prop.getFullName() + "'\n", new Object[0]);
        this.message("\nType.................: " + prop.getType(), new Object[0]);
        this.message("\nMandatory............: " + prop.isMandatory(), new Object[0]);
        this.message("\nNot null.............: " + prop.isNotNull(), new Object[0]);
        this.message("\nRead only............: " + prop.isReadonly(), new Object[0]);
        this.message("\nDefault value........: " + prop.getDefaultValue(), new Object[0]);
        this.message("\nMinimum value........: " + prop.getMin(), new Object[0]);
        this.message("\nMaximum value........: " + prop.getMax(), new Object[0]);
        this.message("\nREGEXP...............: " + prop.getRegexp(), new Object[0]);
        this.message("\nCollate..............: " + prop.getCollate(), new Object[0]);
        this.message("\nLinked class.........: " + prop.getLinkedClass(), new Object[0]);
        this.message("\nLinked type..........: " + prop.getLinkedType(), new Object[0]);
        if (prop.getCustomKeys().size() > 0) {
            this.message("\n\nCUSTOM ATTRIBUTES", new Object[0]);
            this.message("\n-------------------------------+-----------------------------------------+", new Object[0]);
            this.message("\n NAME                          | VALUE                                   |", new Object[0]);
            this.message("\n-------------------------------+-----------------------------------------+", new Object[0]);
            for (String k : prop.getCustomKeys()) {
                try {
                    this.message("\n %-30s| %-40s|", new Object[]{k, prop.getCustom(k)});
                }
                catch (Exception exception) {}
            }
            this.message("\n-------------------------------+-----------------------------------------+", new Object[0]);
        }
        if (!(indexes = prop.getAllIndexes()).isEmpty()) {
            this.message("\n\nINDEXES (" + indexes.size() + " altogether)", new Object[0]);
            this.message("\n-------------------------------+----------------+", new Object[0]);
            this.message("\n NAME                          | PROPERTIES     |", new Object[0]);
            this.message("\n-------------------------------+----------------+", new Object[0]);
            for (OIndex index : indexes) {
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition != null) {
                    List fields = indexDefinition.getFields();
                    this.message("\n %-30s| %-15s|", new Object[]{index.getName(), (String)fields.get(0) + (fields.size() > 1 ? " (+)" : "")});
                    for (int i = 1; i < fields.size(); ++i) {
                        if (i < fields.size() - 1) {
                            this.message("\n %-30s| %-15s|", new Object[]{"", (String)fields.get(i) + " (+)"});
                            continue;
                        }
                        this.message("\n %-30s| %-15s|", new Object[]{"", fields.get(i)});
                    }
                    continue;
                }
                this.message("\n %-30s| %-15s|", new Object[]{index.getName(), ""});
            }
            this.message("\n-------------------------------+----------------+", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all indexes", aliases={"indexes"}, onlineHelp="Console-Command-List-Indexes")
    public void listIndexes() {
        if (this.currentDatabaseName != null) {
            this.message("\n\nINDEXES", new Object[0]);
            this.message("\n----------------------------------------------+------------+-----------------------+----------------+------------+", new Object[0]);
            this.message("\n NAME                                         | TYPE       |         CLASS         |     FIELDS     | RECORDS    |", new Object[0]);
            this.message("\n----------------------------------------------+------------+-----------------------+----------------+------------+", new Object[0]);
            int totalIndexes = 0;
            long totalRecords = 0L;
            ArrayList indexes = new ArrayList(this.currentDatabase.getMetadata().getIndexManager().getIndexes());
            Collections.sort(indexes, new Comparator<OIndex<?>>(){

                @Override
                public int compare(OIndex<?> o1, OIndex<?> o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (OIndex index : indexes) {
                try {
                    OIndexDefinition indexDefinition = index.getDefinition();
                    long size = index.getKeySize();
                    if (indexDefinition == null || indexDefinition.getClassName() == null) {
                        this.message("\n %-45s| %-10s | %-22s| %-15s|%11d |", new Object[]{this.format(index.getName(), 45), this.format(index.getType(), 10), "", "", size});
                    } else {
                        List fields = indexDefinition.getFields();
                        if (fields.size() == 1) {
                            this.message("\n %-45s| %-10s | %-22s| %-15s|%11d |", new Object[]{this.format(index.getName(), 45), this.format(index.getType(), 10), this.format(indexDefinition.getClassName(), 22), this.format((String)fields.get(0), 10), size});
                        } else {
                            this.message("\n %-45s| %-10s | %-22s| %-15s|%11d |", new Object[]{this.format(index.getName(), 45), this.format(index.getType(), 10), this.format(indexDefinition.getClassName(), 22), this.format((String)fields.get(0), 10), size});
                            for (int i = 1; i < fields.size(); ++i) {
                                this.message("\n %-45s| %-10s | %-22s| %-15s|%11s |", new Object[]{"", "", "", fields.get(i), ""});
                            }
                        }
                    }
                    ++totalIndexes;
                    totalRecords += size;
                }
                catch (Exception exception) {}
            }
            this.message("\n----------------------------------------------+------------+-----------------------+----------------+------------+", new Object[0]);
            this.message("\n TOTAL = %-3d                                                                                     %15d |", new Object[]{totalIndexes, totalRecords});
            this.message("\n-----------------------------------------------------------------------------------------------------------------+", new Object[0]);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all the configured clusters", aliases={"clusters"}, onlineHelp="Console-Command-List-Clusters")
    public void listClusters() {
        if (this.currentDatabaseName != null) {
            this.message("\n\nCLUSTERS (collections)", new Object[0]);
            this.message("\n----------------------------------------------+-------+-------------------+----------------+", new Object[0]);
            this.message("\n NAME                                         | ID    | CONFLICT STRATEGY | RECORDS        |", new Object[0]);
            this.message("\n----------------------------------------------+-------+-------------------+----------------+", new Object[0]);
            long totalElements = 0L;
            ArrayList clusters = new ArrayList(this.currentDatabase.getClusterNames());
            Collections.sort(clusters);
            for (String clusterName : clusters) {
                try {
                    int clusterId = this.currentDatabase.getClusterIdByName(clusterName);
                    OCluster cluster = this.currentDatabase.getStorage().getClusterById(clusterId);
                    String conflictStrategy = cluster.getRecordConflictStrategy() != null ? cluster.getRecordConflictStrategy().getName() : "";
                    long count = this.currentDatabase.countClusterElements(clusterName);
                    totalElements += count;
                    this.message("\n %-45s| %5d | %-17s |%15d |", new Object[]{this.format(clusterName, 45), clusterId, this.format(conflictStrategy, 15), count});
                }
                catch (Exception e) {
                    if (!(e instanceof OIOException)) continue;
                    break;
                }
            }
            this.message("\n----------------------------------------------+-------+-------------------+----------------+", new Object[0]);
            this.message("\n TOTAL = %-3d                                                              |%15d |", new Object[]{clusters.size(), totalElements});
            this.message("\n--------------------------------------------------------------------------+----------------+", new Object[0]);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all the configured classes", aliases={"classes"}, onlineHelp="Console-Command-List-Classes")
    public void listClasses() {
        if (this.currentDatabaseName != null) {
            this.message("\n\nCLASSES", new Object[0]);
            this.message("\n----------------------------------------------+------------------------------------+------------+----------------+", new Object[0]);
            this.message("\n NAME                                         | SUPERCLASS                         | CLUSTERS   | RECORDS        |", new Object[0]);
            this.message("\n----------------------------------------------+------------------------------------+------------+----------------+", new Object[0]);
            long totalElements = 0L;
            ArrayList classes = new ArrayList(this.currentDatabase.getMetadata().getImmutableSchemaSnapshot().getClasses());
            Collections.sort(classes, new Comparator<OClass>(){

                @Override
                public int compare(OClass o1, OClass o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (OClass cls : classes) {
                try {
                    StringBuilder clusters = new StringBuilder(1024);
                    if (cls.isAbstract()) {
                        clusters.append("-");
                    } else {
                        for (int i = 0; i < cls.getClusterIds().length; ++i) {
                            if (i > 0) {
                                clusters.append(",");
                            }
                            clusters.append(cls.getClusterIds()[i]);
                        }
                    }
                    long count = this.currentDatabase.countClass(cls.getName(), false);
                    totalElements += count;
                    String superClasses = cls.hasSuperClasses() ? Arrays.toString(cls.getSuperClassesNames().toArray()) : "";
                    this.message("\n %-45s| %-35s| %-11s|%15d |", new Object[]{this.format(cls.getName(), 45), this.format(superClasses, 35), clusters.toString(), count});
                }
                catch (Exception exception) {}
            }
            this.message("\n----------------------------------------------+------------------------------------+------------+----------------+", new Object[0]);
            this.message("\n TOTAL = %-3d                                                                                     %15d |", new Object[]{classes.size(), totalElements});
            this.message("\n----------------------------------------------+------------------------------------+------------+----------------+", new Object[0]);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Loook up a record using the dictionary. If found, set it as the current record", onlineHelp="Console-Command-Dictionary-Get")
    public void dictionaryGet(@ConsoleParameter(name="key", description="The key to search") String iKey) {
        this.checkForDatabase();
        this.currentRecord = (ORecord)this.currentDatabase.getDictionary().get(iKey);
        if (this.currentRecord == null) {
            this.message("\nEntry not found in dictionary.", new Object[0]);
        } else {
            this.currentRecord = this.currentRecord.load();
            this.displayRecord(null);
        }
    }

    @ConsoleCommand(description="Insert or modify an entry in the database dictionary. The entry is comprised of key=String, value=record-id", onlineHelp="Console-Command-Dictionary-Put")
    public void dictionaryPut(@ConsoleParameter(name="key", description="The key to bind") String iKey, @ConsoleParameter(name="record-id", description="The record-id of the record to bind to the key") String iRecordId) {
        this.checkForDatabase();
        this.currentRecord = this.currentDatabase.load((ORID)new ORecordId(iRecordId));
        if (this.currentRecord == null) {
            this.message("\nError: record with id '" + iRecordId + "' was not found in database", new Object[0]);
        } else {
            this.currentDatabase.getDictionary().put(iKey, (Object)this.currentRecord);
            this.displayRecord(null);
            this.message("\nThe entry " + iKey + "=" + iRecordId + " has been inserted in the database dictionary", new Object[0]);
        }
    }

    @ConsoleCommand(description="Remove the association in the dictionary", onlineHelp="Console-Command-Dictionary-Remove")
    public void dictionaryRemove(@ConsoleParameter(name="key", description="The key to remove") String iKey) {
        this.checkForDatabase();
        boolean result = this.currentDatabase.getDictionary().remove(iKey);
        if (!result) {
            this.message("\nEntry not found in dictionary.", new Object[0]);
        } else {
            this.message("\nEntry removed from the dictionary.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Copy a database to a remote server")
    public void copyDatabase(@ConsoleParameter(name="db-name", description="Name of the database to share") String iDatabaseName, @ConsoleParameter(name="db-user", description="Database user") String iDatabaseUserName, @ConsoleParameter(name="db-password", description="Database password") String iDatabaseUserPassword, @ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iRemoteName, @ConsoleParameter(name="engine-name", description="Remote server's engine to use between 'local' or 'memory'") String iRemoteEngine) throws IOException {
        try {
            if (this.serverAdmin == null) {
                throw new IllegalStateException("You must be connected to a remote server to share a database");
            }
            this.message("\nCopying database '" + iDatabaseName + "' to the server '" + iRemoteName + "' via network streaming...", new Object[0]);
            this.serverAdmin.copyDatabase(iDatabaseName, iDatabaseUserName, iDatabaseUserPassword, iRemoteName, iRemoteEngine);
            this.message("\nDatabase '" + iDatabaseName + "' has been copied to the server '" + iRemoteName + "'", new Object[0]);
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Displays the status of the cluster nodes")
    public void clusterStatus() throws IOException {
        if (this.serverAdmin == null) {
            throw new IllegalStateException("You must be connected to a remote server to get the cluster status");
        }
        this.checkForRemoteServer();
        try {
            this.message("\nCluster status:", new Object[0]);
            this.out.println(this.serverAdmin.clusterStatus().toJSON("attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0"));
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Check database integrity")
    public void checkDatabase(@ConsoleParameter(name="options", description="Options: -v", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        if (!(this.currentDatabase.getStorage() instanceof OAbstractPaginatedStorage)) {
            this.message("\nCannot check integrity of non-local database. Connect to it using local mode.", new Object[0]);
            return;
        }
        boolean verbose = iOptions != null && iOptions.contains("-v");
        try {
            ((OAbstractPaginatedStorage)this.currentDatabase.getStorage()).check(verbose, (OCommandOutputListener)this);
        }
        catch (ODatabaseImportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Repair database structure")
    public void repairDatabase(@ConsoleParameter(name="options", description="Options: -v", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        this.message("\nRepairing database...", new Object[0]);
        boolean verbose = iOptions != null && iOptions.contains("-v");
        long fixedLinks = 0L;
        long modifiedDocuments = 0L;
        long errors = 0L;
        try {
            this.message("\n- Fixing dirty links...", new Object[0]);
            for (String clusterName : this.currentDatabase.getClusterNames()) {
                for (ORecord rec : this.currentDatabase.browseCluster(clusterName)) {
                    try {
                        if (!(rec instanceof ODocument)) continue;
                        boolean changed = false;
                        ODocument doc = (ODocument)rec;
                        for (String fieldName : doc.fieldNames()) {
                            Object fieldValue = doc.rawField(fieldName);
                            if (fieldValue instanceof OIdentifiable) {
                                if (!this.fixLink(fieldValue)) continue;
                                doc.field(fieldName, (Object)null);
                                ++fixedLinks;
                                changed = true;
                                if (!verbose) continue;
                                this.message("\n--- reset link " + ((OIdentifiable)fieldValue).getIdentity() + " in field '" + fieldName + "' (rid=" + doc.getIdentity() + ")", new Object[0]);
                                continue;
                            }
                            if (!(fieldValue instanceof Iterable)) continue;
                            if (fieldValue instanceof ORecordLazyMultiValue) {
                                ((ORecordLazyMultiValue)fieldValue).setAutoConvertToRecord(false);
                            }
                            Iterator it = ((Iterable)fieldValue).iterator();
                            int i = 0;
                            while (it.hasNext()) {
                                Object v = it.next();
                                if (this.fixLink(v)) {
                                    it.remove();
                                    ++fixedLinks;
                                    changed = true;
                                    if (verbose) {
                                        this.message("\n--- reset link " + ((OIdentifiable)v).getIdentity() + " as item " + i + " in collection of field '" + fieldName + "' (rid=" + doc.getIdentity() + ")", new Object[0]);
                                    }
                                }
                                ++i;
                            }
                        }
                        if (!changed) continue;
                        ++modifiedDocuments;
                        doc.save();
                        if (!verbose) continue;
                        this.message("\n-- updated document " + doc.getIdentity(), new Object[0]);
                    }
                    catch (Exception e) {
                        ++errors;
                    }
                }
            }
            if (verbose) {
                this.message("\n", new Object[0]);
            }
            this.message("Done! Fixed links: " + fixedLinks + ", modified documents: " + modifiedDocuments, new Object[0]);
            this.message("\nRepair database complete (" + errors + " errors)", new Object[0]);
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Compare two databases")
    public void compareDatabases(@ConsoleParameter(name="db1-url", description="URL of the first database") String iDb1URL, @ConsoleParameter(name="db2-url", description="URL of the second database") String iDb2URL, @ConsoleParameter(name="username", description="User name", optional=true) String iUserName, @ConsoleParameter(name="password", description="User password", optional=true) String iUserPassword, @ConsoleParameter(name="detect-mapping-data", description="Whether RID mapping data after DB import should be tried to found on the disk.", optional=true) String autoDiscoveringMappingData) throws IOException {
        try {
            ODatabaseCompare compare = iUserName == null ? new ODatabaseCompare(iDb1URL, iDb2URL, (OCommandOutputListener)this) : new ODatabaseCompare(iDb1URL, iDb2URL, iUserName, iUserPassword, (OCommandOutputListener)this);
            compare.setAutoDetectExportImportMap(autoDiscoveringMappingData != null ? Boolean.valueOf(autoDiscoveringMappingData) : true);
            compare.setCompareIndexMetadata(true);
            compare.compare();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Import a database into the current one", splitInWords=false, onlineHelp="Console-Command-Import")
    public void importDatabase(@ConsoleParameter(name="options", description="Import options") String text) throws IOException {
        this.checkForDatabase();
        this.message("\nImporting database " + text + "...", new Object[0]);
        List items = OStringSerializerHelper.smartSplit((String)text, (char)' ', (char[])new char[0]);
        String fileName = items.size() <= 0 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        String options = fileName != null ? text.substring(((String)items.get(0)).length() + ((String)items.get(1)).length() + 1).trim() : text;
        try {
            ODatabaseImport databaseImport = new ODatabaseImport((ODatabaseDocumentInternal)this.currentDatabase, fileName, (OCommandOutputListener)this);
            databaseImport.setOptions(options).importDatabase();
            databaseImport.close();
        }
        catch (ODatabaseImportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConsoleCommand(description="Backup a database", splitInWords=false, onlineHelp="Console-Command-Backup")
    public void backupDatabase(@ConsoleParameter(name="options", description="Backup options") String iText) throws IOException {
        String fileName;
        this.checkForDatabase();
        List items = OStringSerializerHelper.smartSplit((String)iText, (char)' ', (char[])new char[]{' '});
        if (items.size() < 2) {
            try {
                this.syntaxError("backupDatabase", ((Object)((Object)this)).getClass().getMethod("backupDatabase", String.class));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return;
        }
        String string = fileName = items.size() <= 0 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        if (fileName == null || fileName.trim().isEmpty()) {
            try {
                this.syntaxError("backupDatabase", ((Object)((Object)this)).getClass().getMethod("backupDatabase", String.class));
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        int bufferSize = Integer.parseInt((String)this.properties.get("backupBufferSize"));
        int compressionLevel = Integer.parseInt((String)this.properties.get("backupCompressionLevel"));
        for (int i = 2; i < items.size(); ++i) {
            String parValue;
            String parName;
            String item = (String)items.get(i);
            int sep = item.indexOf(61);
            if (sep > -1) {
                parName = item.substring(1, sep);
                parValue = item.substring(sep + 1);
            } else {
                parName = item.substring(1);
                parValue = null;
            }
            if (parName.equalsIgnoreCase("bufferSize")) {
                bufferSize = Integer.parseInt(parValue);
                continue;
            }
            if (!parName.equalsIgnoreCase("compressionLevel")) continue;
            compressionLevel = Integer.parseInt(parValue);
        }
        long startTime = System.currentTimeMillis();
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            try {
                this.currentDatabase.backup((OutputStream)fos, null, null, (OCommandOutputListener)this, compressionLevel, bufferSize);
                this.message("\nBackup executed in %.2f seconds", new Object[]{Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f)});
            }
            finally {
                fos.flush();
                fos.close();
            }
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConsoleCommand(description="Restore a database into the current one", splitInWords=false, onlineHelp="Console-Command-Restore")
    public void restoreDatabase(@ConsoleParameter(name="options", description="Restore options") String text) throws IOException {
        this.checkForDatabase();
        this.message("\nRestoring database %s...", new Object[]{text});
        List items = OStringSerializerHelper.smartSplit((String)text, (char)' ', (char[])new char[0]);
        if (items.size() < 2) {
            try {
                this.syntaxError("restoreDatabase", ((Object)((Object)this)).getClass().getMethod("restoreDatabase", String.class));
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        String fileName = items.size() <= 0 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        long startTime = System.currentTimeMillis();
        try {
            FileInputStream f = new FileInputStream(fileName);
            try {
                this.currentDatabase.restore((InputStream)f, null, null, (OCommandOutputListener)this);
            }
            finally {
                f.close();
            }
            this.message("\nDatabase restored in %.2f seconds", new Object[]{Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f)});
        }
        catch (ODatabaseImportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Export a database", splitInWords=false, onlineHelp="Console-Command-Export")
    public void exportDatabase(@ConsoleParameter(name="options", description="Export options") String iText) throws IOException {
        this.checkForDatabase();
        this.out.println(new StringBuilder("Exporting current database to: ").append(iText).append(" in GZipped JSON format ..."));
        List items = OStringSerializerHelper.smartSplit((String)iText, (char)' ', (char[])new char[0]);
        String fileName = items.size() <= 1 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        String options = fileName != null ? iText.substring(((String)items.get(0)).length() + ((String)items.get(1)).length() + 1).trim() : iText;
        try {
            new ODatabaseExport((ODatabaseDocumentInternal)this.currentDatabase, fileName, (OCommandOutputListener)this).setOptions(options).exportDatabase().close();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Export a database schema")
    public void exportSchema(@ConsoleParameter(name="output-file", description="Output file path") String iOutputFilePath) throws IOException {
        this.checkForDatabase();
        this.message("\nExporting current database to: " + iOutputFilePath + "...", new Object[0]);
        try {
            ODatabaseExport exporter = new ODatabaseExport((ODatabaseDocumentInternal)this.currentDatabase, iOutputFilePath, (OCommandOutputListener)this);
            exporter.setIncludeRecords(false);
            exporter.exportDatabase().close();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Export the current record in the requested format", onlineHelp="Console-Command-Export-Record")
    public void exportRecord(@ConsoleParameter(name="format", description="Format, such as 'json'") String iFormat, @ConsoleParameter(name="options", description="Options", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        this.checkCurrentObject();
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getFormat(iFormat.toLowerCase());
        if (serializer == null) {
            this.message("\nERROR: Format '" + iFormat + "' was not found.", new Object[0]);
            this.printSupportedSerializerFormat();
            return;
        }
        if (!(serializer instanceof ORecordSerializerStringAbstract)) {
            this.message("\nERROR: Format '" + iFormat + "' does not export as text.", new Object[0]);
            this.printSupportedSerializerFormat();
            return;
        }
        if (iOptions == null || iOptions.length() <= 0) {
            iOptions = "rid,version,class,type,keepTypes,alwaysFetchEmbedded,fetchPlan:*:0,prettyPrint";
        }
        try {
            this.out.println(((ORecordSerializerStringAbstract)serializer).toString(this.currentRecord, iOptions));
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Return all configured properties")
    public void properties() {
        this.message("\nPROPERTIES:", new Object[0]);
        this.message("\n+-------------------------------+--------------------------------+", new Object[0]);
        this.message("\n| %-30s| %-30s |", new Object[]{"NAME", "VALUE"});
        this.message("\n+-------------------------------+--------------------------------+", new Object[0]);
        for (Map.Entry p : this.properties.entrySet()) {
            this.message("\n| %-30s| %-30s |", new Object[]{p.getKey(), p.getValue()});
        }
        this.message("\n+-------------------------------+--------------------------------+", new Object[0]);
    }

    @ConsoleCommand(description="Return the value of a property")
    public void get(@ConsoleParameter(name="property-name", description="Name of the property") String iPropertyName) {
        Object value = this.properties.get(iPropertyName);
        this.out.println();
        if (value == null) {
            this.message("\nProperty '" + iPropertyName + "' is not setted", new Object[0]);
        } else {
            this.out.println(iPropertyName + " = " + value);
        }
    }

    @ConsoleCommand(description="Change the value of a property", onlineHelp="Console-Command-Set")
    public void set(@ConsoleParameter(name="property-name", description="Name of the property") String iPropertyName, @ConsoleParameter(name="property-value", description="Value to set") String iPropertyValue) {
        Object prevValue = this.properties.get(iPropertyName);
        this.out.println();
        if (iPropertyName.equalsIgnoreCase("limit") && (Integer.parseInt(iPropertyValue) == 0 || Integer.parseInt(iPropertyValue) < -1)) {
            this.message("\nERROR: Limit must be > 0 or = -1 (no limit)", new Object[0]);
        } else {
            if (prevValue != null) {
                this.message("\nPrevious value was: " + prevValue, new Object[0]);
            }
            this.properties.put(iPropertyName, iPropertyValue);
            this.out.println();
            this.out.println(iPropertyName + " = " + iPropertyValue);
        }
    }

    @ConsoleCommand(description="Declare an intent", onlineHelp="")
    public void declareIntent(@ConsoleParameter(name="Intent name", description="name of the intent to execute") String iIntentName) {
        this.checkForDatabase();
        this.message("\nDeclaring intent '" + iIntentName + "'...", new Object[0]);
        if (iIntentName.equalsIgnoreCase("massiveinsert")) {
            this.currentDatabase.declareIntent((OIntent)new OIntentMassiveInsert());
        } else if (iIntentName.equalsIgnoreCase("massiveread")) {
            this.currentDatabase.declareIntent((OIntent)new OIntentMassiveRead());
        } else if (iIntentName.equalsIgnoreCase("null")) {
            this.currentDatabase.declareIntent(null);
        } else {
            throw new IllegalArgumentException("Intent '" + iIntentName + "' not supported. Available ones are: massiveinsert, massiveread, null");
        }
        this.message("\nIntent '" + iIntentName + "' set successfully", new Object[0]);
    }

    @ConsoleCommand(description="Execute a command against the profiler")
    public void profiler(@ConsoleParameter(name="profiler command", description="command to execute against the profiler") String iCommandName) {
        if (iCommandName.equalsIgnoreCase("on")) {
            Orient.instance().getProfiler().startRecording();
            this.message("\nProfiler is ON now, use 'profiler off' to turn off.", new Object[0]);
        } else if (iCommandName.equalsIgnoreCase("off")) {
            Orient.instance().getProfiler().stopRecording();
            this.message("\nProfiler is OFF now, use 'profiler on' to turn on.", new Object[0]);
        } else if (iCommandName.equalsIgnoreCase("dump")) {
            this.out.println(Orient.instance().getProfiler().dump());
        }
    }

    @ConsoleCommand(description="Return the value of a configuration value")
    public void configGet(@ConsoleParameter(name="config-name", description="Name of the configuration") String iConfigName) throws IOException {
        String value;
        OGlobalConfiguration config = OGlobalConfiguration.findByKey((String)iConfigName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration variable '" + iConfigName + "' wasn't found");
        }
        if (this.serverAdmin != null) {
            value = this.serverAdmin.getGlobalConfiguration(config);
            this.message("\nRemote configuration: ", new Object[0]);
        } else {
            value = config.getValueAsString();
            this.message("\nLocal configuration: ", new Object[0]);
        }
        this.out.println(iConfigName + " = " + value);
    }

    @ConsoleCommand(description="Sleep X milliseconds")
    public void sleep(String iTime) {
        try {
            Thread.sleep(Long.parseLong(iTime));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @ConsoleCommand(description="Change the value of a configuration value")
    public void configSet(@ConsoleParameter(name="config-name", description="Name of the configuration") String iConfigName, @ConsoleParameter(name="config-value", description="Value to set") String iConfigValue) throws IOException {
        OGlobalConfiguration config = OGlobalConfiguration.findByKey((String)iConfigName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration variable '" + iConfigName + "' not found");
        }
        if (this.serverAdmin != null) {
            this.serverAdmin.setGlobalConfiguration(config, (Object)iConfigValue);
            this.message("\n\nRemote configuration value changed correctly", new Object[0]);
        } else {
            config.setValue((Object)iConfigValue);
            this.message("\n\nLocal configuration value changed correctly", new Object[0]);
        }
        this.out.println();
    }

    @ConsoleCommand(description="Return all the configuration values")
    public void config() throws IOException {
        if (this.serverAdmin != null) {
            Map values = this.serverAdmin.getGlobalConfigurations();
            this.message("\nREMOTE SERVER CONFIGURATION:", new Object[0]);
            this.message("\n+--------------------------------------------------------------------------------------+---------------------------+", new Object[0]);
            this.message("\n| %-85s| %-25s |", new Object[]{"NAME", "VALUE"});
            this.message("\n+--------------------------------------------------------------------------------------+---------------------------+", new Object[0]);
            for (Map.Entry p : values.entrySet()) {
                this.message("\n| %-85s| %-25s |", new Object[]{p.getKey(), p.getValue()});
            }
        } else {
            this.message("\nLOCAL SERVER CONFIGURATION:", new Object[0]);
            this.message("\n+--------------------------------------------------------------------------------------+---------------------------+", new Object[0]);
            this.message("\n| %-85s| %-25s |", new Object[]{"NAME", "VALUE"});
            this.message("\n+--------------------------------------------------------------------------------------+---------------------------+", new Object[0]);
            for (OGlobalConfiguration cfg : OGlobalConfiguration.values()) {
                this.message("\n| %-85s| %-25s |", new Object[]{cfg.getKey(), cfg.getValue()});
            }
        }
        this.message("\n+--------------------------------------------------------------------------------------+---------------------------+", new Object[0]);
    }

    public ODatabaseDocument getCurrentDatabase() {
        return this.currentDatabase;
    }

    public OConsoleDatabaseApp setCurrentDatabase(ODatabaseDocumentTx iCurrentDatabase) {
        this.currentDatabase = iCurrentDatabase;
        this.currentDatabaseName = iCurrentDatabase.getName();
        return this;
    }

    public String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    public String getCurrentDatabaseUserName() {
        return this.currentDatabaseUserName;
    }

    public String getCurrentDatabaseUserPassword() {
        return this.currentDatabaseUserPassword;
    }

    public ORecord getCurrentRecord() {
        return this.currentRecord;
    }

    public List<OIdentifiable> getCurrentResultSet() {
        return this.currentResultSet;
    }

    public void loadRecordInternal(String iRecordId, String iFetchPlan) {
        this.checkForDatabase();
        this.currentRecord = this.currentDatabase.load((ORID)new ORecordId(iRecordId), iFetchPlan);
        this.displayRecord(null);
        this.message("\nOK", new Object[0]);
    }

    public void reloadRecordInternal(String iRecordId, String iFetchPlan) {
        this.checkForDatabase();
        this.currentRecord = this.currentDatabase.executeReadRecord(new ORecordId(iRecordId), null, null, iFetchPlan, true, false, false, OStorage.LOCKING_STRATEGY.NONE, (ODatabaseDocumentTx.RecordReader)new ODatabaseDocumentTx.SimpleRecordReader());
        this.displayRecord(null);
        this.message("\nOK", new Object[0]);
    }

    protected void checkForRemoteServer() {
        if (this.serverAdmin == null && (this.currentDatabase == null || !(this.currentDatabase.getStorage() instanceof OStorageRemoteThread) || this.currentDatabase.isClosed())) {
            throw new OException("Remote server is not connected. Use 'connect remote:<host>[:<port>][/<database-name>]' to connect");
        }
    }

    protected void checkForDatabase() {
        if (this.currentDatabase == null) {
            throw new OException("Database not selected. Use 'connect <database-name>' to connect to a database.");
        }
        if (this.currentDatabase.isClosed()) {
            throw new ODatabaseException("Database '" + this.currentDatabaseName + "' is closed");
        }
    }

    protected void checkCurrentObject() {
        if (this.currentRecord == null) {
            throw new OException("The is no current object selected: create a new one or load it");
        }
    }

    public String ask(String iText) {
        this.out.print(iText);
        Scanner scanner = new Scanner(this.in);
        String answer = scanner.nextLine();
        scanner.close();
        return answer;
    }

    public void onMessage(String iText) {
        this.message(iText, new Object[0]);
    }

    public void onBegin(Object iTask, long iTotal, Object metadata) {
        this.lastPercentStep = 0;
        this.message("[", new Object[0]);
        if (this.interactiveMode) {
            for (int i = 0; i < 10; ++i) {
                this.message(" ", new Object[0]);
            }
            this.message("]   0%", new Object[0]);
        }
    }

    public boolean onProgress(Object iTask, long iCounter, float iPercent) {
        int completitionBar = (int)iPercent / 10;
        if ((int)(iPercent * 10.0f) == this.lastPercentStep) {
            return true;
        }
        StringBuilder buffer = new StringBuilder(64);
        if (this.interactiveMode) {
            int i;
            buffer.append("\r[");
            for (i = 0; i < completitionBar; ++i) {
                buffer.append('=');
            }
            for (i = completitionBar; i < 10; ++i) {
                buffer.append(' ');
            }
            this.message("] %3.1f%% ", new Object[]{Float.valueOf(iPercent)});
        } else {
            for (int i = this.lastPercentStep / 100; i < completitionBar; ++i) {
                buffer.append('=');
            }
        }
        this.message(buffer.toString(), new Object[0]);
        this.lastPercentStep = (int)(iPercent * 10.0f);
        return true;
    }

    @ConsoleCommand(description="Display the current path")
    public void pwd() {
        this.message("\nCurrent path: " + new File("").getAbsolutePath(), new Object[0]);
    }

    public void onCompletition(Object iTask, boolean iSucceed) {
        if (this.interactiveMode) {
            if (iSucceed) {
                this.message("\r[==========] 100% Done.", new Object[0]);
            } else {
                this.message(" Error!", new Object[0]);
            }
        } else {
            this.message(iSucceed ? "] Done." : " Error!", new Object[0]);
        }
    }

    public void close() {
        if (this.currentDatabase != null) {
            this.currentDatabase.activateOnCurrentThread();
            this.currentDatabase.close();
            this.currentDatabase = null;
        }
        if (this.serverAdmin != null) {
            this.serverAdmin.close(true);
            this.serverAdmin = null;
        }
        this.currentResultSet = null;
        this.currentRecord = null;
        this.currentResult = null;
        this.commandBuffer.setLength(0);
    }

    protected boolean fixLink(Object fieldValue) {
        ORID id;
        if (fieldValue instanceof OIdentifiable && (id = ((OIdentifiable)fieldValue).getIdentity()).isValid()) {
            if (id.isPersistent()) {
                ORecord connected = ((OIdentifiable)fieldValue).getRecord();
                if (connected == null) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected void dumpDistributedConfiguration(boolean iForce) {
        if (this.currentDatabase == null) {
            return;
        }
        OStorage stg = this.currentDatabase.getStorage();
        if (stg instanceof OStorageRemoteThread) {
            ODocument distributedCfg = ((OStorageRemoteThread)stg).getClusterConfiguration();
            if (distributedCfg != null && !distributedCfg.isEmpty()) {
                this.message("\n\nDISTRIBUTED CONFIGURATION:\n" + distributedCfg.toJSON("prettyPrint"), new Object[0]);
            } else if (iForce) {
                this.message("\n\nDISTRIBUTED CONFIGURATION: none (OrientDB is running in standalone mode)", new Object[0]);
            }
        }
    }

    protected boolean isCollectingCommands(String iLine) {
        return iLine.startsWith("js") || iLine.startsWith("script");
    }

    @Override
    protected void onBefore() {
        super.onBefore();
        this.setResultset(new ArrayList<OIdentifiable>());
        this.properties.put("limit", "20");
        this.properties.put("width", "150");
        this.properties.put("debug", "false");
        this.properties.put("collectionMaxItems", "10");
        this.properties.put("maxBinaryDisplay", "150");
        this.properties.put("verbose", "2");
        this.properties.put("ignoreErrors", "false");
        this.properties.put("backupCompressionLevel", "9");
        this.properties.put("backupBufferSize", "1048576");
    }

    protected OIdentifiable setCurrentRecord(int iIndex) {
        this.currentRecordIdx = iIndex;
        this.currentRecord = iIndex < this.currentResultSet.size() ? (ORecord)this.currentResultSet.get(iIndex) : null;
        return this.currentRecord;
    }

    @Override
    protected void printApplicationInfo() {
        this.message("\nOrientDB console v." + OConstants.getVersion() + " " + "www.orientdb.com", new Object[0]);
        this.message("\nType 'help' to display all the supported commands.", new Object[0]);
    }

    protected void dumpResultSet(int limit) {
        new OTableFormatter(this).setMaxWidthSize(this.getWindowSize()).writeRecords(this.currentResultSet, limit);
    }

    protected float getElapsedSecs(long start) {
        return (float)(System.currentTimeMillis() - start) / 1000.0f;
    }

    protected void printError(Exception e) {
        if (this.properties.get("debug") != null && Boolean.parseBoolean((String)this.properties.get("debug"))) {
            this.message("\n\n!ERROR:", new Object[0]);
            e.printStackTrace(this.err);
        } else {
            this.message("\n\n!ERROR: " + e.getMessage(), new Object[0]);
            if (e.getCause() != null) {
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    this.message("\n-> " + t.getMessage(), new Object[0]);
                }
            }
        }
    }

    protected void updateDatabaseInfo() {
        this.currentDatabase.getStorage().reload();
        this.currentDatabase.getMetadata().getSchema().reload();
        this.currentDatabase.getMetadata().getIndexManager().reload();
    }

    protected String getContext() {
        if (this.currentDatabase != null && this.currentDatabaseName != null) {
            this.currentDatabase.activateOnCurrentThread();
            StringBuilder buffer = new StringBuilder(64);
            buffer.append(" {db=");
            buffer.append(this.currentDatabaseName);
            if (this.currentDatabase.getTransaction().isActive()) {
                buffer.append(" tx=[");
                buffer.append(this.currentDatabase.getTransaction().getEntryCount());
                buffer.append(" entries]");
            }
            buffer.append("}");
            return buffer.toString();
        }
        if (this.serverAdmin != null) {
            return " {server=" + this.serverAdmin.getURL() + "}";
        }
        return "";
    }

    protected String getPrompt() {
        return String.format("orientdb%s> ", this.getContext());
    }

    protected void parseResult() {
        this.setResultset(null);
        if (this.currentResult instanceof Map) {
            return;
        }
        Object first = OMultiValue.getFirstValue((Object)this.currentResult);
        if (first instanceof OIdentifiable) {
            if (this.currentResult instanceof List) {
                this.currentResultSet = (List)this.currentResult;
            } else if (this.currentResult instanceof Collection) {
                this.currentResultSet = new ArrayList<OIdentifiable>();
                this.currentResultSet.addAll((Collection)this.currentResult);
            } else if (this.currentResult.getClass().isArray()) {
                this.currentResultSet = new ArrayList<OIdentifiable>();
                Collections.addAll(this.currentResultSet, (OIdentifiable[])this.currentResult);
            }
            this.setResultset(this.currentResultSet);
        }
    }

    protected void setResultset(List<OIdentifiable> iResultset) {
        this.currentResultSet = iResultset;
        this.currentRecordIdx = 0;
        this.currentRecord = iResultset == null || iResultset.isEmpty() ? null : iResultset.get(0).getRecord();
    }

    protected void resetResultSet() {
        this.currentResultSet = null;
        this.currentRecord = null;
    }

    protected void executeServerSideScript(String iLanguage, String iText) {
        if (iText == null) {
            return;
        }
        this.resetResultSet();
        long start = System.currentTimeMillis();
        this.currentResult = this.currentDatabase.command((OCommandRequest)new OCommandScript(iLanguage, iText)).execute(new Object[0]);
        float elapsedSeconds = this.getElapsedSecs(start);
        this.parseResult();
        if (this.currentResultSet != null) {
            this.dumpResultSet(-1);
            this.message("\nServer side script executed in %f sec(s). Returned %d records", new Object[]{Float.valueOf(elapsedSeconds), this.currentResultSet.size()});
        } else {
            String lineFeed = this.currentResult instanceof Map ? "\n" : "";
            this.message("\nServer side script executed in %f sec(s). Value returned is: %s%s", new Object[]{Float.valueOf(elapsedSeconds), lineFeed, this.currentResult});
        }
    }

    protected Map<String, List<String>> parseOptions(String iOptions) {
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (iOptions != null) {
            List opts = OStringSerializerHelper.smartSplit((String)iOptions, (char)' ', (char[])new char[0]);
            for (String o : opts) {
                int sep = o.indexOf(61);
                if (sep == -1) {
                    OLogManager.instance().warn((Object)this, "Unrecognized option %s, skipped", new Object[]{o});
                    continue;
                }
                String option = o.substring(0, sep);
                List items = OStringSerializerHelper.smartSplit((String)o.substring(sep + 1), (char)' ', (char[])new char[0]);
                options.put(option, items);
            }
        }
        return options;
    }

    protected int getWindowSize() {
        if (this.properties.containsKey("width")) {
            return Integer.parseInt((String)this.properties.get("width"));
        }
        return this.windowSize;
    }

    protected int getCollectionMaxItems() {
        if (this.properties.containsKey("collectionMaxItems")) {
            return Integer.parseInt((String)this.properties.get("collectionMaxItems"));
        }
        return this.collectionMaxItems;
    }

    private void dumpRecordDetails() {
        if (this.currentRecord == null) {
            return;
        }
        if (this.currentRecord instanceof ODocument) {
            ODocument rec = (ODocument)this.currentRecord;
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| Document - @class: %-37s @rid: %-15s @version: %-6s |", new Object[]{rec.getClassName(), rec.getIdentity().toString(), rec.getRecordVersion().toString()});
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| %24s | %-68s |", new Object[]{"Name", "Value"});
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            for (String fieldName : rec.fieldNames()) {
                int size;
                ArrayList value = rec.field(fieldName);
                if (value instanceof byte[]) {
                    value = "byte[" + ((byte[])value).length + "]";
                } else if (value instanceof Iterator) {
                    ArrayList coll = new ArrayList();
                    while (((Iterator)((Object)value)).hasNext()) {
                        coll.add(((Iterator)((Object)value)).next());
                    }
                    value = coll;
                } else if (OMultiValue.isMultiValue((Object)value) && (size = OMultiValue.getSize((Object)value)) < this.getCollectionMaxItems()) {
                    StringBuilder buffer = new StringBuilder(50);
                    for (Object o : OMultiValue.getMultiValueIterable((Object)value)) {
                        if (buffer.length() > 0) {
                            buffer.append(',');
                        }
                        buffer.append(o);
                    }
                    value = "[" + buffer.toString() + "]";
                }
                this.message("\n| %24s | %-68s |", new Object[]{fieldName, value});
            }
        } else if (this.currentRecord instanceof ORecordFlat) {
            ORecordFlat rec = (ORecordFlat)this.currentRecord;
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| Flat     - @rid: %s @version: %s", new Object[]{rec.getIdentity().toString(), rec.getRecordVersion().toString()});
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message(rec.value(), new Object[0]);
        } else if (this.currentRecord instanceof ORecordBytes) {
            ORecordBytes rec = (ORecordBytes)this.currentRecord;
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| Bytes    - @rid: %s @version: %s", new Object[]{rec.getIdentity().toString(), rec.getRecordVersion().toString()});
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            byte[] value = rec.toStream();
            int max = Math.min(Integer.parseInt((String)this.properties.get("maxBinaryDisplay")), Array.getLength(value));
            for (int i = 0; i < max; ++i) {
                this.message("%03d", new Object[]{Array.getByte(value, i)});
            }
        } else {
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| %s - record id: %s   v.%s", new Object[]{this.currentRecord.getClass().getSimpleName(), this.currentRecord.getIdentity().toString(), this.currentRecord.getRecordVersion().toString()});
        }
        this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
        this.out.println();
    }

    private void printSupportedSerializerFormat() {
        this.message("\nSupported formats are:", new Object[0]);
        for (ORecordSerializer s : ORecordSerializerFactory.instance().getFormats()) {
            if (!(s instanceof ORecordSerializerStringAbstract)) continue;
            this.message("\n- " + s.toString(), new Object[0]);
        }
    }

    private void browseRecords(int limit, OIdentifiableIterator<?> it) {
        OTableFormatter tableFormatter = new OTableFormatter(this).setMaxWidthSize(this.getWindowSize());
        this.setResultset(new ArrayList<OIdentifiable>());
        while (it.hasNext() && this.currentResultSet.size() <= limit) {
            this.currentResultSet.add((OIdentifiable)it.next());
        }
        tableFormatter.writeRecords(this.currentResultSet, limit);
    }

    private Object sqlCommand(String iExpectedCommand, String iReceivedCommand, String iMessage, boolean iIncludeResult) {
        this.checkForDatabase();
        if (iReceivedCommand == null) {
            return null;
        }
        iReceivedCommand = iExpectedCommand + " " + iReceivedCommand.trim();
        this.resetResultSet();
        long start = System.currentTimeMillis();
        Object result = new OCommandSQL(iReceivedCommand).setProgressListener((OProgressListener)this).execute(new Object[0]);
        float elapsedSeconds = this.getElapsedSecs(start);
        if (iIncludeResult) {
            this.message(iMessage, new Object[]{result, Float.valueOf(elapsedSeconds)});
        } else {
            this.message(iMessage, new Object[]{Float.valueOf(elapsedSeconds)});
        }
        return result;
    }
}

