/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OCharSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import java.nio.ByteOrder;

public class OStringSerializer
implements OBinarySerializer<String> {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static final OStringSerializer INSTANCE = new OStringSerializer();
    public static final byte ID = 13;

    @Override
    public int getObjectSize(String object) {
        return object.length() * 2 + 4;
    }

    @Override
    public void serialize(String object, byte[] stream, int startPosition) {
        OCharSerializer charSerializer = OCharSerializer.INSTANCE;
        int length = object.length();
        OIntegerSerializer.INSTANCE.serialize(length, stream, startPosition);
        for (int i = 0; i < length; ++i) {
            charSerializer.serialize(Character.valueOf(object.charAt(i)), stream, startPosition + 4 + i * 2);
        }
    }

    @Override
    public String deserialize(byte[] stream, int startPosition) {
        OCharSerializer charSerializer = OCharSerializer.INSTANCE;
        int len = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(charSerializer.deserialize(stream, startPosition + 4 + i * 2));
        }
        return stringBuilder.toString();
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, startPosition) * 2 + 4;
    }

    @Override
    public byte getId() {
        return 13;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition) * 2 + 4;
    }

    @Override
    public void serializeNative(String object, byte[] stream, int startPosition) {
        int length = object.length();
        CONVERTER.putInt(stream, startPosition, length, ByteOrder.nativeOrder());
        int pos = startPosition + 4;
        for (int i = 0; i < length; ++i) {
            char strChar = object.charAt(i);
            CONVERTER.putChar(stream, pos, strChar, ByteOrder.nativeOrder());
            pos += 2;
        }
    }

    @Override
    public String deserializeNative(byte[] stream, int startPosition) {
        int len = CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder());
        char[] buffer = new char[len];
        int pos = startPosition + 4;
        for (int i = 0; i < len; ++i) {
            buffer[i] = CONVERTER.getChar(stream, pos, ByteOrder.nativeOrder());
            pos += 2;
        }
        return new String(buffer);
    }

    @Override
    public void serializeInDirectMemory(String object, ODirectMemory memory, long pointer) {
        int length = object.length();
        memory.setInt(pointer, length);
        pointer += 4L;
        for (int i = 0; i < length; ++i) {
            char strChar = object.charAt(i);
            memory.setChar(pointer, strChar);
            pointer += 2L;
        }
    }

    @Override
    public String deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        int len = memory.getInt(pointer);
        char[] buffer = new char[len];
        pointer += 4L;
        for (int i = 0; i < len; ++i) {
            buffer[i] = memory.getChar(pointer);
            pointer += 2L;
        }
        return new String(buffer);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return memory.getInt(pointer) * 2 + 4;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }
}

