/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory.collections;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.hash.OMurmurHash3;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import java.util.ArrayList;
import java.util.Iterator;

public class ODirectMemoryHashMap<K, V> {
    private static final int SEED = 362498820;
    private static int BUCKET_SIZE = 8;
    private static final int INITIAL_CAPACITY = 1024;
    private final int hashLineSize;
    private final ODirectMemory memory;
    private final OBinarySerializer<V> valueSerializer;
    private final OBinarySerializer<K> keySerializer;
    private final int bucketSize;
    private final int hashLinePointerOffset;
    private long size;
    private long capacity;
    private long nextThreshold;
    private int entries;

    public ODirectMemoryHashMap(ODirectMemory memory, OBinarySerializer<V> valueSerializer, OBinarySerializer<K> keySerializer) {
        this(memory, valueSerializer, keySerializer, 1024L, BUCKET_SIZE);
    }

    public ODirectMemoryHashMap(ODirectMemory memory, OBinarySerializer<V> valueSerializer, OBinarySerializer<K> keySerializer, long initialCapacity, int bucketSize) {
        this.memory = memory;
        this.valueSerializer = valueSerializer;
        this.keySerializer = keySerializer;
        this.size = 0L;
        this.bucketSize = bucketSize;
        this.hashLinePointerOffset = 4 + bucketSize * 16;
        this.hashLineSize = bucketSize * 16 + 8;
        this.capacity = initialCapacity;
        this.nextThreshold = (long)((double)this.capacity * 0.75);
        if (!this.allocateInitialMemory(this.capacity)) {
            throw new IllegalStateException("There is n enough memory to allocate");
        }
    }

    private boolean allocateInitialMemory(long capacity) {
        long hashAllocationSize = capacity * (long)this.hashLineSize;
        int entriesPtr = this.memory.allocate((int)hashAllocationSize);
        if (entriesPtr == -1) {
            return false;
        }
        for (long i = 0L; i < capacity; ++i) {
            this.memory.setInt(entriesPtr, (int)i * this.hashLineSize, 0);
            this.memory.setInt(entriesPtr, (int)(i * (long)this.hashLineSize + (long)this.hashLinePointerOffset), -1);
        }
        this.entries = entriesPtr;
        return true;
    }

    public V get(K key) {
        byte[] serializedKey = new byte[this.keySerializer.getObjectSize(key)];
        this.keySerializer.serialize(key, serializedKey, 0);
        long hashCode = OMurmurHash3.murmurHash3_x64_64(serializedKey, 362498820);
        long index = this.index(hashCode);
        int hashLineSize = this.getHashLineSize(this.entries, index);
        block0: for (int i = 0; i < hashLineSize; ++i) {
            byte[] currentKey;
            long currentHash = this.getHashCode(this.entries, index, i);
            if (currentHash != hashCode || (currentKey = this.getKey(this.entries, index, i)).length != serializedKey.length) continue;
            for (int j = 0; j < currentKey.length; ++j) {
                if (serializedKey[j] != currentKey[j]) continue block0;
            }
            return this.getValue(this.entries, index, i);
        }
        int hashLinePtr = this.getNextHashLinePtr(this.entries, index);
        while (hashLinePtr != -1) {
            hashLineSize = this.getHashLineSizeFromHashLine(hashLinePtr);
            block3: for (int i = 0; i < hashLineSize; ++i) {
                byte[] currentKey;
                long currentHash = this.getHashCodeFromHashLine(hashLinePtr, i);
                if (currentHash != hashCode || (currentKey = this.getKeyFromHashLine(hashLinePtr, i)).length != serializedKey.length) continue;
                for (int j = 0; j < currentKey.length; ++j) {
                    if (serializedKey[j] != currentKey[j]) continue block3;
                }
                return this.getValueFromHashLine(hashLinePtr, i);
            }
            hashLinePtr = this.getNextHashLinePtrFromHashLine(hashLinePtr);
        }
        return null;
    }

    public V remove(K key) {
        byte[] serializedKey = new byte[this.keySerializer.getObjectSize(key)];
        this.keySerializer.serialize(key, serializedKey, 0);
        long hashCode = OMurmurHash3.murmurHash3_x64_64(serializedKey, 362498820);
        long index = this.index(hashCode);
        int hashLineSize = this.getHashLineSize(this.entries, index);
        block0: for (int i = 0; i < hashLineSize; ++i) {
            byte[] currentKey;
            long currentHash = this.getHashCode(this.entries, index, i);
            if (currentHash != hashCode || (currentKey = this.getKey(this.entries, index, i)).length != serializedKey.length) continue;
            for (int j = 0; j < currentKey.length; ++j) {
                if (serializedKey[j] != currentKey[j]) continue block0;
            }
            V removedValue = this.getValue(this.entries, index, i);
            int removedKeyPtr = this.getKeyPtr(this.entries, index, i);
            int removedValuePtr = this.getValuePtr(this.entries, index, i);
            this.memory.free(removedValuePtr);
            this.memory.free(removedKeyPtr);
            int prevPrevLastHashLinePtr = -1;
            int prevLastHashLinePtr = -1;
            int lastHashLinePtr = this.getNextHashLinePtr(this.entries, index);
            while (lastHashLinePtr != -1) {
                prevPrevLastHashLinePtr = prevLastHashLinePtr;
                prevLastHashLinePtr = lastHashLinePtr;
                lastHashLinePtr = this.getNextHashLinePtrFromHashLine(lastHashLinePtr);
            }
            lastHashLinePtr = prevLastHashLinePtr;
            prevLastHashLinePtr = prevPrevLastHashLinePtr;
            if (lastHashLinePtr != -1) {
                int lastHashLineSize = this.getHashLineSizeFromHashLine(lastHashLinePtr);
                long replaceHashCode = this.getHashCodeFromHashLine(lastHashLinePtr, lastHashLineSize - 1);
                int keyPtr = this.getKeyPtrFromHashLine(lastHashLinePtr, lastHashLineSize - 1);
                int valuePtr = this.getValuePtrFromHashLine(lastHashLinePtr, lastHashLineSize - 1);
                this.replaceEntry(this.entries, index, i, replaceHashCode, keyPtr, valuePtr);
                this.setSizeInHashLine(lastHashLinePtr, lastHashLineSize - 1);
                if (lastHashLineSize == 1) {
                    this.memory.free(lastHashLinePtr);
                    if (prevLastHashLinePtr != -1) {
                        this.clearHashLinePtrInHashLine(prevLastHashLinePtr);
                    } else {
                        this.clearHashLinePtr(this.entries, index);
                    }
                }
            } else if (hashLineSize == 1) {
                this.setSize(this.entries, index, 0);
            } else if (hashLineSize - 1 != i) {
                int keyPtr = this.getKeyPtr(this.entries, index, hashLineSize - 1);
                int valuePtr = this.getValuePtr(this.entries, index, hashLineSize - 1);
                long replaceHashCode = this.getHashCode(this.entries, index, hashLineSize - 1);
                this.setSize(this.entries, index, hashLineSize - 1);
                this.replaceEntry(this.entries, index, i, replaceHashCode, keyPtr, valuePtr);
            } else {
                this.setSize(this.entries, index, hashLineSize - 1);
            }
            --this.size;
            return removedValue;
        }
        int prevHashLine = -1;
        int hashLinePtr = this.getNextHashLinePtr(this.entries, index);
        while (hashLinePtr != -1) {
            hashLineSize = this.getHashLineSizeFromHashLine(hashLinePtr);
            block4: for (int i = 0; i < hashLineSize; ++i) {
                byte[] currentKey;
                long currentHash = this.getHashCodeFromHashLine(hashLinePtr, i);
                if (currentHash != hashCode || (currentKey = this.getKeyFromHashLine(hashLinePtr, i)).length != serializedKey.length) continue;
                for (int j = 0; j < currentKey.length; ++j) {
                    if (serializedKey[j] != currentKey[j]) continue block4;
                }
                V removedValue = this.getValueFromHashLine(hashLinePtr, i);
                int removedKeyPtr = this.getKeyPtrFromHashLine(hashLinePtr, i);
                int removedValuePtr = this.getValuePtrFromHashLine(hashLinePtr, i);
                this.memory.free(removedValuePtr);
                this.memory.free(removedKeyPtr);
                int prevPrevLastHashLinePtr = -1;
                int prevLastHashLinePtr = -1;
                int lastHashLinePtr = this.getNextHashLinePtr(this.entries, index);
                while (lastHashLinePtr != -1) {
                    prevPrevLastHashLinePtr = prevLastHashLinePtr;
                    prevLastHashLinePtr = lastHashLinePtr;
                    lastHashLinePtr = this.getNextHashLinePtrFromHashLine(lastHashLinePtr);
                }
                lastHashLinePtr = prevLastHashLinePtr;
                prevLastHashLinePtr = prevPrevLastHashLinePtr;
                if (lastHashLinePtr != hashLinePtr) {
                    int lastHashLineSize = this.getHashLineSizeFromHashLine(lastHashLinePtr);
                    long replaceHashCode = this.getHashCodeFromHashLine(lastHashLinePtr, lastHashLineSize - 1);
                    int keyPtr = this.getKeyPtrFromHashLine(lastHashLinePtr, lastHashLineSize - 1);
                    int valuePtr = this.getValuePtrFromHashLine(lastHashLinePtr, lastHashLineSize - 1);
                    this.replaceEntryInHashLine(hashLinePtr, i, replaceHashCode, keyPtr, valuePtr);
                    this.setSizeInHashLine(lastHashLinePtr, lastHashLineSize - 1);
                    if (lastHashLineSize == 1) {
                        this.clearHashLinePtrInHashLine(prevLastHashLinePtr);
                    }
                } else if (hashLineSize == 1) {
                    this.memory.free(hashLinePtr);
                    if (prevHashLine != -1) {
                        this.clearHashLinePtrInHashLine(prevHashLine);
                    } else {
                        this.clearHashLinePtr(this.entries, index);
                    }
                } else if (i != hashLineSize - 1) {
                    int keyPtr = this.getKeyPtrFromHashLine(hashLinePtr, hashLineSize - 1);
                    int valuePtr = this.getValuePtrFromHashLine(hashLinePtr, hashLineSize - 1);
                    long replaceHashCode = this.getHashCodeFromHashLine(hashLinePtr, hashLineSize - 1);
                    this.setSizeInHashLine(hashLinePtr, hashLineSize - 1);
                    this.replaceEntryInHashLine(hashLinePtr, i, replaceHashCode, keyPtr, valuePtr);
                } else {
                    this.setSizeInHashLine(hashLinePtr, hashLineSize - 1);
                }
                --this.size;
                return removedValue;
            }
            prevHashLine = hashLinePtr;
            hashLinePtr = this.getNextHashLinePtrFromHashLine(hashLinePtr);
        }
        return null;
    }

    public boolean put(K key, V value) {
        byte[] serializedKey = new byte[this.keySerializer.getObjectSize(key)];
        this.keySerializer.serialize(key, serializedKey, 0);
        long hashCode = OMurmurHash3.murmurHash3_x64_64(serializedKey, 362498820);
        long index = this.index(hashCode);
        int hashLineSize = this.getHashLineSize(this.entries, index);
        int prevHashLine = -1;
        block0: for (int i = 0; i < hashLineSize; ++i) {
            byte[] currentKey;
            long currentHash = this.getHashCode(this.entries, index, i);
            if (currentHash != hashCode || (currentKey = this.getKey(this.entries, index, i)).length != serializedKey.length) continue;
            for (int j = 0; j < currentKey.length; ++j) {
                if (serializedKey[j] != currentKey[j]) continue block0;
            }
            int valuePtr = this.memory.allocate(this.valueSerializer.getObjectSize(value));
            if (valuePtr == -1) {
                return false;
            }
            this.memory.set(valuePtr, 0, value, this.valueSerializer);
            return this.replaceValue(this.entries, index, i, valuePtr);
        }
        int hashLinePtr = this.getNextHashLinePtr(this.entries, index);
        while (hashLinePtr != -1) {
            hashLineSize = this.getHashLineSizeFromHashLine(hashLinePtr);
            block3: for (int i = 0; i < hashLineSize; ++i) {
                byte[] currentKey;
                long currentHash = this.getHashCodeFromHashLine(hashLinePtr, i);
                if (currentHash != hashCode || (currentKey = this.getKeyFromHashLine(hashLinePtr, i)).length != serializedKey.length) continue;
                for (int j = 0; j < currentKey.length; ++j) {
                    if (serializedKey[j] != currentKey[j]) continue block3;
                }
                int valuePtr = this.memory.allocate(this.valueSerializer.getObjectSize(value));
                if (valuePtr == -1) {
                    return false;
                }
                this.memory.set(valuePtr, 0, value, this.valueSerializer);
                return this.replaceValueInHashLine(hashLinePtr, i, valuePtr);
            }
            prevHashLine = hashLinePtr;
            hashLinePtr = this.getNextHashLinePtrFromHashLine(hashLinePtr);
        }
        int keyPtr = this.memory.allocate(4 + serializedKey.length);
        if (keyPtr == -1) {
            return false;
        }
        int valuePtr = this.memory.allocate(this.valueSerializer.getObjectSize(value));
        if (valuePtr == -1) {
            this.memory.free(keyPtr);
            return false;
        }
        this.memory.setInt(keyPtr, 0, serializedKey.length);
        this.memory.set(keyPtr, 4, serializedKey.length, serializedKey);
        this.memory.set(valuePtr, 0, value, this.valueSerializer);
        if (!this.appendEntry(hashCode, keyPtr, valuePtr, index, prevHashLine)) {
            return false;
        }
        ++this.size;
        if (this.size >= this.nextThreshold) {
            this.rehash();
        }
        return true;
    }

    private void rehash() {
        long oldCapacity = this.capacity;
        int oldEntries = this.entries;
        this.capacity <<= 1;
        if (!this.allocateInitialMemory(this.capacity)) {
            this.capacity = oldCapacity;
            this.entries = oldEntries;
        }
        for (long oldIndex = 0L; oldIndex < oldCapacity; ++oldIndex) {
            long oldHashCode;
            int oldHashLineSize = this.getHashLineSize(oldEntries, oldIndex);
            for (int oldOffset = 0; oldOffset < oldHashLineSize; ++oldOffset) {
                int oldKeyPtr = this.getKeyPtr(oldEntries, oldIndex, oldOffset);
                int oldValuePtr = this.getValuePtr(oldEntries, oldIndex, oldOffset);
                oldHashCode = this.getHashCode(oldEntries, oldIndex, oldOffset);
                if (this.rehashEntry(oldHashCode, oldKeyPtr, oldValuePtr)) continue;
                this.clearLines(this.entries, this.capacity);
                this.memory.free(this.entries);
                this.entries = oldEntries;
                this.capacity = oldCapacity;
            }
            int oldHashLinePtr = this.getNextHashLinePtr(oldEntries, oldIndex);
            while (oldHashLinePtr != -1) {
                oldHashLineSize = this.getHashLineSizeFromHashLine(oldHashLinePtr);
                for (int oldOffset = 0; oldOffset < oldHashLineSize; ++oldOffset) {
                    int oldValuePtr;
                    int oldKeyPtr = this.getKeyPtrFromHashLine(oldHashLinePtr, oldOffset);
                    oldHashCode = this.getHashCodeFromHashLine(oldHashLinePtr, oldOffset);
                    if (this.rehashEntry(oldHashCode, oldKeyPtr, oldValuePtr = this.getValuePtrFromHashLine(oldHashLinePtr, oldOffset))) continue;
                    this.clearLines(this.entries, this.capacity);
                    this.memory.free(this.entries);
                    this.entries = oldEntries;
                    this.capacity = oldCapacity;
                }
                oldHashLinePtr = this.getNextHashLinePtrFromHashLine(oldHashLinePtr);
            }
        }
        this.nextThreshold = (long)((double)this.capacity * 0.75);
        this.clearLines(oldEntries, oldCapacity);
        this.memory.free(oldEntries);
    }

    public long size() {
        return this.size;
    }

    public void clear() {
        for (long index = 0L; index < this.capacity; ++index) {
            int hashLineSize = this.getHashLineSize(this.entries, index);
            for (int offset = 0; offset < hashLineSize; ++offset) {
                int keyPtr = this.getKeyPtr(this.entries, index, offset);
                int valuePtr = this.getValuePtr(this.entries, index, offset);
                this.memory.free(keyPtr);
                this.memory.free(valuePtr);
            }
            int hashLinePtr = this.getNextHashLinePtr(this.entries, index);
            while (hashLinePtr != -1) {
                hashLineSize = this.getHashLineSizeFromHashLine(hashLinePtr);
                for (int oldOffset = 0; oldOffset < hashLineSize; ++oldOffset) {
                    int keyPtr = this.getKeyPtrFromHashLine(hashLinePtr, oldOffset);
                    int valuePtr = this.getValuePtrFromHashLine(hashLinePtr, oldOffset);
                    this.memory.free(keyPtr);
                    this.memory.free(valuePtr);
                }
                hashLinePtr = this.getNextHashLinePtrFromHashLine(hashLinePtr);
            }
        }
        this.clearLines(this.entries, this.capacity);
        this.size = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
        this.memory.free(this.entries);
    }

    private void clearLines(int ptr, long len) {
        ArrayList<Integer> hashLinePointers = new ArrayList<Integer>();
        for (long i = 0L; i < len; ++i) {
            int hashLinePtr = this.getNextHashLinePtr(ptr, i);
            while (hashLinePtr != -1) {
                hashLinePointers.add(hashLinePtr);
                hashLinePtr = this.getNextHashLinePtrFromHashLine(hashLinePtr);
            }
        }
        Iterator i$ = hashLinePointers.iterator();
        while (i$.hasNext()) {
            int hashLinePtr = (Integer)i$.next();
            this.memory.free(hashLinePtr);
        }
    }

    private boolean rehashEntry(long hashCode, int keyPtr, int valuePtr) {
        long index = this.index(hashCode);
        int hashLinePtr = this.getNextHashLinePtr(this.entries, index);
        int prevHashLinePtr = -1;
        while (hashLinePtr != -1) {
            prevHashLinePtr = hashLinePtr;
            hashLinePtr = this.getNextHashLinePtrFromHashLine(hashLinePtr);
        }
        return this.appendEntry(hashCode, keyPtr, valuePtr, index, prevHashLinePtr);
    }

    private boolean appendEntry(long hashCode, int keyPtr, int valuePtr, long index, int currentHashLinePtr) {
        if (currentHashLinePtr == -1) {
            int hashLineSize = this.getHashLineSize(this.entries, index);
            if (hashLineSize < this.bucketSize) {
                this.addEntry(this.entries, index, hashLineSize, hashCode, keyPtr, valuePtr);
            } else {
                int hashLinePtr = this.addHashLine(this.entries, index);
                if (hashLinePtr == -1) {
                    return false;
                }
                this.addEntryInHashLine(hashLinePtr, 0, hashCode, keyPtr, valuePtr);
            }
        } else {
            int hashLineSize = this.getHashLineSizeFromHashLine(currentHashLinePtr);
            if (hashLineSize < this.bucketSize) {
                this.addEntryInHashLine(currentHashLinePtr, hashLineSize, hashCode, keyPtr, valuePtr);
            } else {
                int hashLinePtr = this.addHashLineInHashLine(currentHashLinePtr);
                if (hashLinePtr == -1) {
                    return false;
                }
                this.addEntryInHashLine(hashLinePtr, 0, hashCode, keyPtr, valuePtr);
            }
        }
        return true;
    }

    private long index(long hashCode) {
        return hashCode & this.capacity - 1L;
    }

    private int getHashLineSize(int ptr, long index) {
        long memoryOffset = index * (long)this.hashLineSize;
        return this.memory.getInt(ptr, (int)memoryOffset);
    }

    private int getHashLineSizeFromHashLine(int ptr) {
        return this.memory.getInt(ptr, 0);
    }

    private long getHashCode(int ptr, long index, int offset) {
        long memoryOffset = index * (long)this.hashLineSize + 4L + (long)(offset * 8);
        return this.memory.getLong(ptr, (int)memoryOffset);
    }

    private long getHashCodeFromHashLine(int hashLinePtr, long offset) {
        long memoryOffset = 4L + offset * 8L;
        return this.memory.getLong(hashLinePtr, (int)memoryOffset);
    }

    private int getNextHashLinePtr(int ptr, long index) {
        long memoryOffset = index * (long)this.hashLineSize + (long)this.hashLinePointerOffset;
        return this.memory.getInt(ptr, (int)memoryOffset);
    }

    private int getNextHashLinePtrFromHashLine(int hashLinePtr) {
        long memoryOffset = this.hashLinePointerOffset;
        return this.memory.getInt(hashLinePtr, (int)memoryOffset);
    }

    private int addHashLine(int ptr, long index) {
        int hashLinePtr = this.memory.allocate(this.hashLineSize);
        if (hashLinePtr == -1) {
            return hashLinePtr;
        }
        this.memory.setInt(hashLinePtr, 0, 0);
        this.memory.setInt(hashLinePtr, this.hashLinePointerOffset, -1);
        this.memory.setInt(ptr, (int)(index * (long)this.hashLineSize + (long)this.hashLinePointerOffset), hashLinePtr);
        return hashLinePtr;
    }

    private int addHashLineInHashLine(int ptr) {
        int hashLinePtr = this.memory.allocate(this.hashLineSize);
        if (hashLinePtr == -1) {
            return hashLinePtr;
        }
        this.memory.setInt(hashLinePtr, 0, 0);
        this.memory.setInt(hashLinePtr, this.hashLinePointerOffset, -1);
        this.memory.setInt(ptr, this.hashLinePointerOffset, hashLinePtr);
        return hashLinePtr;
    }

    private byte[] getKey(int ptr, long index, int offset) {
        int keyPtr = this.getKeyPtr(ptr, index, offset);
        int keyLength = this.memory.getInt(keyPtr, 0);
        return this.memory.get(keyPtr, 4, keyLength);
    }

    private int getKeyPtr(int ptr, long index, int offset) {
        long memoryOffset = index * (long)this.hashLineSize + 4L + (long)(8 * this.bucketSize) + (long)(2 * offset * 4);
        return this.memory.getInt(ptr, (int)memoryOffset);
    }

    private byte[] getKeyFromHashLine(int ptr, int offset) {
        int keyPtr = this.getKeyPtrFromHashLine(ptr, offset);
        int keyLength = this.memory.getInt(keyPtr, 0);
        return this.memory.get(keyPtr, 4, keyLength);
    }

    private int getKeyPtrFromHashLine(int ptr, int offset) {
        long memoryOffset = 4 + 8 * this.bucketSize + 2 * offset * 4;
        return this.memory.getInt(ptr, (int)memoryOffset);
    }

    private V getValue(int ptr, long index, int offset) {
        int valuePtr = this.getValuePtr(ptr, index, offset);
        return this.memory.get(valuePtr, 0, this.valueSerializer);
    }

    private int getValuePtr(int ptr, long index, int offset) {
        long memoryOffset = index * (long)this.hashLineSize + 4L + (long)(8 * this.bucketSize) + (long)(2 * offset * 4) + 4L;
        return this.memory.getInt(ptr, (int)memoryOffset);
    }

    private V getValueFromHashLine(int ptr, int offset) {
        int valuePtr = this.getValuePtrFromHashLine(ptr, offset);
        return this.memory.get(valuePtr, 0, this.valueSerializer);
    }

    private int getValuePtrFromHashLine(int ptr, int offset) {
        long memoryOffset = 4 + 8 * this.bucketSize + 2 * offset * 4 + 4;
        return this.memory.getInt(ptr, (int)memoryOffset);
    }

    private boolean replaceValue(int ptr, long index, int offset, int valuePtr) {
        long memoryOffset = index * (long)this.hashLineSize + 4L + (long)(8 * this.bucketSize) + (long)(2 * offset * 4) + 4L;
        int oldValuePtr = this.memory.getInt(ptr, (int)memoryOffset);
        this.memory.free(oldValuePtr);
        this.memory.setInt(ptr, (int)memoryOffset, valuePtr);
        return true;
    }

    private boolean replaceValueInHashLine(int ptr, int offset, int valuePtr) {
        long memoryOffset = 4 + 8 * this.bucketSize + 2 * offset * 4 + 4;
        int oldValuePtr = this.memory.getInt(ptr, (int)memoryOffset);
        this.memory.free(oldValuePtr);
        this.memory.setInt(ptr, (int)memoryOffset, valuePtr);
        return true;
    }

    private void addEntry(int ptr, long index, int offset, long hashCode, int keyPtr, int valuePtr) {
        long hashCodeMemoryOffset = index * (long)this.hashLineSize + 4L + (long)(8 * offset);
        long keyMemoryOffset = index * (long)this.hashLineSize + 4L + (long)(8 * this.bucketSize) + (long)(offset * 2 * 4);
        long valueMemoryOffset = keyMemoryOffset + 4L;
        this.memory.setLong(ptr, (int)hashCodeMemoryOffset, hashCode);
        this.memory.setInt(ptr, (int)keyMemoryOffset, keyPtr);
        this.memory.setInt(ptr, (int)valueMemoryOffset, valuePtr);
        this.memory.setInt(ptr, (int)index * this.hashLineSize, offset + 1);
    }

    private void addEntryInHashLine(int hashLinePtr, int offset, long hashCode, int keyPtr, int valuePtr) {
        long hashCodeMemoryOffset = 4 + 8 * offset;
        long keyMemoryOffset = 4 + 8 * this.bucketSize + offset * 2 * 4;
        long valueMemoryOffset = keyMemoryOffset + 4L;
        this.memory.setLong(hashLinePtr, (int)hashCodeMemoryOffset, hashCode);
        this.memory.setInt(hashLinePtr, (int)keyMemoryOffset, keyPtr);
        this.memory.setInt(hashLinePtr, (int)valueMemoryOffset, valuePtr);
        this.memory.setInt(hashLinePtr, 0, offset + 1);
    }

    private void replaceEntry(int ptr, long index, int offset, long hashCode, int keyPtr, int valuePtr) {
        long hashCodeMemoryOffset = index * (long)this.hashLineSize + 4L + (long)(8 * offset);
        long keyMemoryOffset = index * (long)this.hashLineSize + 4L + (long)(8 * this.bucketSize) + (long)(offset * 2 * 4);
        long valueMemoryOffset = keyMemoryOffset + 4L;
        this.memory.setLong(ptr, (int)hashCodeMemoryOffset, hashCode);
        this.memory.setInt(ptr, (int)keyMemoryOffset, keyPtr);
        this.memory.setInt(ptr, (int)valueMemoryOffset, valuePtr);
    }

    private void replaceEntryInHashLine(int hashLinePtr, int offset, long hashCode, int keyPtr, int valuePtr) {
        long hashCodeMemoryOffset = 4 + 8 * offset;
        long keyMemoryOffset = 4 + 8 * this.bucketSize + offset * 2 * 4;
        long valueMemoryOffset = keyMemoryOffset + 4L;
        this.memory.setLong(hashLinePtr, (int)hashCodeMemoryOffset, hashCode);
        this.memory.setInt(hashLinePtr, (int)keyMemoryOffset, keyPtr);
        this.memory.setInt(hashLinePtr, (int)valueMemoryOffset, valuePtr);
    }

    private void setSize(int ptr, long index, int size) {
        this.memory.setInt(ptr, (int)index * this.hashLineSize, size);
    }

    private void setSizeInHashLine(int ptr, int size) {
        this.memory.setInt(ptr, 0, size);
    }

    private void clearHashLinePtr(int ptr, long index) {
        this.memory.setInt(ptr, (int)(index * (long)this.hashLineSize + (long)this.hashLinePointerOffset), -1);
    }

    private void clearHashLinePtrInHashLine(int ptr) {
        this.memory.setInt(ptr, this.hashLinePointerOffset, -1);
    }
}

