/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.parallel;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

class BlockManager {
    private final BlockingDeque<byte[]> blockPool;

    public BlockManager(int blockPoolSize, int blockSize) {
        this.blockPool = new LinkedBlockingDeque<byte[]>(blockPoolSize);
        for (int i = 0; i < blockPoolSize; ++i) {
            this.blockPool.addFirst(new byte[blockSize]);
        }
    }

    public byte[] getBlockFromPool() {
        byte[] block = null;
        try {
            block = this.blockPool.takeFirst();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return block;
    }

    public void releaseBlockToPool(byte[] block) {
        assert (!this.blockPool.contains(block));
        try {
            this.blockPool.putLast(block);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

