/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.plugins.jetty.locator;

import com.mycila.testing.plugins.jetty.locator.FileLocator;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

class RegFileLocator
implements FileLocator {
    RegFileLocator() {
    }

    public File locate(String path) throws FileNotFoundException {
        Collection files = FileUtils.listFiles((File)new File("."), (IOFileFilter)new RegExpFileFilter(path), (IOFileFilter)FileFilterUtils.trueFileFilter());
        if (files.size() < 1) {
            throw new FileNotFoundException("regexp '" + Matcher.quoteReplacement(path) + "' matches less than one file : " + files);
        }
        if (files.size() > 1) {
            throw new FileNotFoundException("regexp '" + Matcher.quoteReplacement(path) + "' matches more than one file : " + files);
        }
        File file = (File)files.iterator().next();
        return file;
    }

    static class RegExpFileFilter
    implements IOFileFilter {
        private final String regexp;

        RegExpFileFilter(String regexp) {
            this.regexp = regexp;
        }

        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }

        public boolean accept(File file) {
            boolean matches = file.getPath().matches(this.regexp);
            return matches;
        }
    }
}

