/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log.log4j;

import com.mycila.log.AbstractLogger;
import com.mycila.log.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class Log4jLogger
extends AbstractLogger {
    private final Logger logger;

    public Log4jLogger(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    public boolean canLog(Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.TRACE);
            }
            case DEBUG: {
                return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.DEBUG);
            }
            case INFO: {
                return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.INFO);
            }
            case WARN: {
                return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
            }
            case ERROR: {
                return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.ERROR);
            }
        }
        return false;
    }

    protected void doLog(Level level, Throwable throwable, Object message, Object ... args) {
        switch (level) {
            case TRACE: {
                this.logger.log((Priority)org.apache.log4j.Level.TRACE, (Object)String.format(String.valueOf(message), args), throwable);
                break;
            }
            case DEBUG: {
                this.logger.log((Priority)org.apache.log4j.Level.DEBUG, (Object)String.format(String.valueOf(message), args), throwable);
                break;
            }
            case INFO: {
                this.logger.log((Priority)org.apache.log4j.Level.INFO, (Object)String.format(String.valueOf(message), args), throwable);
                break;
            }
            case WARN: {
                this.logger.log((Priority)org.apache.log4j.Level.WARN, (Object)String.format(String.valueOf(message), args), throwable);
                break;
            }
            case ERROR: {
                this.logger.log((Priority)org.apache.log4j.Level.ERROR, (Object)String.format(String.valueOf(message), args), throwable);
                break;
            }
        }
    }
}

