/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log.jdk.handler;

import com.mycila.log.jdk.hook.InvocationHandler;
import com.mycila.log.jdk.hook.MycilaInvocationHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Utils {
    private Utils() {
    }

    static Level maxLevel(Class c, Level def) {
        return Level.parse(Utils.property(c, "max", def.getName()));
    }

    static Level level(Class c, Level def) {
        return Level.parse(Utils.property(c, "level", def.getName()));
    }

    static <T extends Handler> InvocationHandler<T> hook(Class c) {
        return Utils.clazz(c, "hook", MycilaInvocationHandler.class);
    }

    static Formatter formatter(Class c) {
        return Utils.clazz(c, "formatter", SimpleFormatter.class);
    }

    static Filter filter(Class c) {
        return (Filter)Utils.clazz(c, "filter", null);
    }

    static String encoding(Class c) {
        return Utils.property(c, "encoding", null);
    }

    static <T> T clazz(Class c, String prop, Class<T> def) {
        try {
            String clazz = Utils.property(c, prop, def == null ? null : def.getName());
            return clazz == null ? null : (T)Thread.currentThread().getContextClassLoader().loadClass(clazz).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static String property(Class c, String prop, String def) {
        String val = LogManager.getLogManager().getProperty(c.getName() + "." + prop);
        return val == null ? def : val;
    }
}

