/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log.jdk.handler;

import com.mycila.log.jdk.handler.Utils;
import com.mycila.log.jdk.hook.InvocationHandler;
import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MycilaHandler<T extends Handler>
extends Handler {
    private T handler;
    private Level maxLevel;
    private InvocationHandler<T> hook;

    public MycilaHandler() {
        this.setHook(Utils.hook(this.getClass()));
    }

    public MycilaHandler(T handler) {
        this.setHook(Utils.hook(this.getClass()));
        this.setHandler(handler);
    }

    public final Level getMaxLevel() {
        return this.maxLevel;
    }

    public final void setMaxLevel(Level maxLevel) {
        this.maxLevel = maxLevel;
    }

    public final void setHook(InvocationHandler<T> hook) {
        this.hook = hook;
    }

    public final Level getThresold() {
        return this.maxLevel;
    }

    public final InvocationHandler<T> getHook() {
        return this.hook;
    }

    public final void setHandler(T handler) {
        this.handler = handler;
        this.setLevel(Utils.level(this.getClass(), Level.INFO));
        this.setMaxLevel(Utils.maxLevel(this.getClass(), Level.SEVERE));
        this.setFilter(Utils.filter(this.getClass()));
        this.setFormatter(Utils.formatter(this.getClass()));
        try {
            this.setEncoding(Utils.encoding(this.getClass()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public final T getHandler() {
        return this.handler;
    }

    @Override
    public final boolean isLoggable(LogRecord record) {
        int level = record.getLevel().intValue();
        return level == Level.ALL.intValue() || this.getHook().isLoggable(this.getHandler(), record) && level <= this.getThresold().intValue();
    }

    @Override
    public final void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            this.getHook().publish(this.getHandler(), record);
        }
    }

    @Override
    public final void flush() {
        this.getHook().flush(this.getHandler());
    }

    @Override
    public final void close() throws SecurityException {
        this.getHook().close(this.getHandler());
    }

    @Override
    public final void setFormatter(Formatter newFormatter) throws SecurityException {
        this.getHook().setFormatter(this.getHandler(), newFormatter);
    }

    @Override
    public final Formatter getFormatter() {
        return this.getHook().getFormatter(this.getHandler());
    }

    @Override
    public final String getEncoding() {
        return this.getHook().getEncoding(this.getHandler());
    }

    @Override
    public final void setFilter(Filter newFilter) throws SecurityException {
        this.getHook().setFilter(this.getHandler(), newFilter);
    }

    @Override
    public final Filter getFilter() {
        return this.getHook().getFilter(this.getHandler());
    }

    @Override
    public final void setErrorManager(ErrorManager em) {
        this.getHook().setErrorManager(this.getHandler(), em);
    }

    @Override
    public final ErrorManager getErrorManager() {
        return this.getHook().getErrorManager(this.getHandler());
    }

    @Override
    public final void setLevel(Level newLevel) throws SecurityException {
        this.getHook().setLevel(this.getHandler(), newLevel);
    }

    @Override
    public final Level getLevel() {
        return this.getHook().getLevel(this.getHandler());
    }
}

