/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log.jdk;

import com.mycila.log.AbstractLogger;
import com.mycila.log.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class JDKLogger
extends AbstractLogger {
    private final Logger logger;

    public JDKLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    public boolean canLog(Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isLoggable(java.util.logging.Level.FINEST);
            }
            case DEBUG: {
                return this.logger.isLoggable(java.util.logging.Level.FINE);
            }
            case INFO: {
                return this.logger.isLoggable(java.util.logging.Level.INFO);
            }
            case WARN: {
                return this.logger.isLoggable(java.util.logging.Level.WARNING);
            }
            case ERROR: {
                return this.logger.isLoggable(java.util.logging.Level.SEVERE);
            }
        }
        return false;
    }

    protected void doLog(Level level, Throwable throwable, Object message, Object ... args) {
        switch (level) {
            case TRACE: {
                this.logger.log(this.buildLogRecord(java.util.logging.Level.FINEST, throwable, message, args));
                break;
            }
            case DEBUG: {
                this.logger.log(this.buildLogRecord(java.util.logging.Level.FINE, throwable, message, args));
                break;
            }
            case INFO: {
                this.logger.log(this.buildLogRecord(java.util.logging.Level.INFO, throwable, message, args));
                break;
            }
            case WARN: {
                this.logger.log(this.buildLogRecord(java.util.logging.Level.WARNING, throwable, message, args));
                break;
            }
            case ERROR: {
                this.logger.log(this.buildLogRecord(java.util.logging.Level.SEVERE, throwable, message, args));
                break;
            }
        }
    }

    private LogRecord buildLogRecord(java.util.logging.Level level, Throwable throwable, Object message, Object ... args) {
        LogRecord logRecord = new LogRecord(level, String.format(String.valueOf(message), args));
        logRecord.setLoggerName(this.logger.getName());
        logRecord.setSourceClassName(this.logger.getName());
        logRecord.setSourceMethodName(Thread.currentThread().getName());
        logRecord.setThrown(throwable);
        return logRecord;
    }
}

