/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log;

import com.mycila.log.Logger;
import com.mycila.log.LoggerProvider;
import com.mycila.log.LoggerProviders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Loggers {
    private static volatile Usage current;
    private static volatile LoggerProvider loggerProvider;

    private Loggers() {
    }

    public static synchronized void useJDK() {
        if (current != Usage.JDK) {
            current = Usage.JDK;
            loggerProvider = LoggerProviders.cache(LoggerProviders.jdk());
        }
    }

    public static synchronized void useLog4j() {
        if (current != Usage.LOG4J) {
            current = Usage.LOG4J;
            loggerProvider = LoggerProviders.cache(LoggerProviders.log4j());
        }
    }

    public static synchronized void useNone() {
        if (current != Usage.NONE) {
            current = Usage.NONE;
            loggerProvider = LoggerProviders.cache(LoggerProviders.nop());
        }
    }

    public static synchronized void useSystemProperty() {
        current = Usage.CUSTOM;
        loggerProvider = LoggerProviders.cache(LoggerProviders.fromSystemProperty());
    }

    public static synchronized void use(LoggerProvider loggerProvider) {
        current = Usage.CUSTOM;
        Loggers.loggerProvider = loggerProvider;
    }

    public static synchronized void useAndCache(LoggerProvider loggerProvider) {
        Loggers.use(LoggerProviders.cache(loggerProvider));
    }

    public static Logger get(Class<?> c) {
        return Loggers.get(c.getName());
    }

    public static Logger get(String name) {
        return loggerProvider.get(name);
    }

    static {
        try {
            Loggers.useSystemProperty();
        }
        catch (Exception e) {
            Loggers.useNone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Usage {
        NONE,
        LOG4J,
        CUSTOM,
        JDK;

    }
}

