/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log;

import com.mycila.log.Logger;
import com.mycila.log.LoggerProvider;
import com.mycila.log.jdk.JDKLoggerProvider;
import com.mycila.log.log4j.Log4jLoggerProvider;
import com.mycila.log.nop.NopLoggerProvider;
import java.util.concurrent.ConcurrentHashMap;

public final class LoggerProviders {
    private LoggerProviders() {
    }

    public static LoggerProvider cache(final LoggerProvider loggerProvider) {
        return new LoggerProvider(){
            final ConcurrentHashMap<String, Logger> cache = new ConcurrentHashMap();

            public Logger get(String name) {
                Logger logger = this.cache.get(name);
                if (logger == null) {
                    logger = loggerProvider.get(name);
                    this.cache.putIfAbsent(name, logger);
                }
                return logger;
            }
        };
    }

    public static LoggerProvider fromSystemProperty() {
        String className = System.getProperty("mycila.log.provider");
        try {
            return (LoggerProvider)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading class '" + className + "' defined for system property 'mycila.log.provider': " + e.getMessage(), e);
        }
    }

    public static String getConfigFile() {
        return System.getProperty("mycila.log.config");
    }

    public static LoggerProvider log4j() {
        return Log4jLoggerProvider.get();
    }

    public static LoggerProvider jdk() {
        return JDKLoggerProvider.get();
    }

    public static LoggerProvider nop() {
        return NopLoggerProvider.get();
    }
}

