/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.TimerType;
import java.time.Duration;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Timer {
    private static ScheduledExecutorService executor = null;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(Timer.class);
    private static final HashSet<String> references = new HashSet();
    private static final Object syncReferences = new Object();

    private Timer() {
    }

    public static ScheduledFuture<?> schedule(Runnable runnable, Duration runFrequency, TimerType timerType) {
        switch (timerType) {
            case OneTimeRun: {
                return executor.schedule(runnable, runFrequency.toMillis(), TimeUnit.MILLISECONDS);
            }
            case RepeatRun: {
                return executor.scheduleWithFixedDelay(runnable, runFrequency.toMillis(), runFrequency.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        throw new UnsupportedOperationException("Unsupported timer pattern.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(String clientId) {
        Object object = syncReferences;
        synchronized (object) {
            if (references.size() == 0 && (executor == null || executor.isShutdown())) {
                int corePoolSize = Math.max(Runtime.getRuntime().availableProcessors(), 4);
                TRACE_LOGGER.debug("Starting ScheduledThreadPoolExecutor with coreThreadPoolSize:{}", (Object)corePoolSize);
                executor = Executors.newScheduledThreadPool(corePoolSize);
            }
            references.add(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(String clientId) {
        Object object = syncReferences;
        synchronized (object) {
            if (references.remove(clientId) && references.size() == 0 && executor != null) {
                TRACE_LOGGER.debug("Shuting down ScheduledThreadPoolExecutor");
                executor.shutdownNow();
            }
        }
    }
}

