/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.nio.conn;

import com.microsoft.applicationinsights.web.dependencies.apachecommons.logging.Log;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.logging.LogFactory;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.conn.routing.HttpRoute;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.conn.CPoolEntry;
import com.microsoft.applicationinsights.web.dependencies.http.nio.NHttpClientConnection;
import com.microsoft.applicationinsights.web.dependencies.http.nio.conn.ManagedNHttpClientConnection;
import com.microsoft.applicationinsights.web.dependencies.http.nio.pool.AbstractNIOConnPool;
import com.microsoft.applicationinsights.web.dependencies.http.nio.pool.NIOConnFactory;
import com.microsoft.applicationinsights.web.dependencies.http.nio.pool.SocketAddressResolver;
import com.microsoft.applicationinsights.web.dependencies.http.nio.reactor.ConnectingIOReactor;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE)
class CPool
extends AbstractNIOConnPool<HttpRoute, ManagedNHttpClientConnection, CPoolEntry> {
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit tunit;

    public CPool(ConnectingIOReactor ioreactor, NIOConnFactory<HttpRoute, ManagedNHttpClientConnection> connFactory, SocketAddressResolver<HttpRoute> addressResolver, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit tunit) {
        super(ioreactor, connFactory, addressResolver, defaultMaxPerRoute, maxTotal);
        this.timeToLive = timeToLive;
        this.tunit = tunit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute route, ManagedNHttpClientConnection conn) {
        CPoolEntry entry = new CPoolEntry(this.log, conn.getId(), route, conn, this.timeToLive, this.tunit);
        entry.setSocketTimeout(conn.getSocketTimeout());
        return entry;
    }

    @Override
    protected void onLease(CPoolEntry entry) {
        NHttpClientConnection conn = (NHttpClientConnection)entry.getConnection();
        conn.setSocketTimeout(entry.getSocketTimeout());
    }

    @Override
    protected void onRelease(CPoolEntry entry) {
        NHttpClientConnection conn = (NHttpClientConnection)entry.getConnection();
        conn.setSocketTimeout(0);
    }
}

