/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.tls;

import java.io.IOException;
import org.spongycastle.crypto.tls.Certificate;
import org.spongycastle.crypto.tls.CertificateRequest;
import org.spongycastle.crypto.tls.CertificateVerifyer;
import org.spongycastle.crypto.tls.TlsAuthentication;
import org.spongycastle.crypto.tls.TlsCredentials;
import org.spongycastle.crypto.tls.TlsFatalAlert;

public class LegacyTlsAuthentication
implements TlsAuthentication {
    protected CertificateVerifyer verifyer;

    public LegacyTlsAuthentication(CertificateVerifyer verifyer) {
        this.verifyer = verifyer;
    }

    public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
        if (!this.verifyer.isValid(serverCertificate.getCerts())) {
            throw new TlsFatalAlert(90);
        }
    }

    public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
        return null;
    }
}

