/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.swing;

import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PdfInformationPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4171577284617028707L;
    String filename = "";
    JLabel label = new JLabel();
    JScrollPane scrollpane = new JScrollPane();
    JPanel panel = new JPanel();

    public PdfInformationPanel() {
        try {
            this.setLayout(new BorderLayout());
            this.label.setHorizontalAlignment(0);
            this.panel.setLayout(new BorderLayout());
            this.add((Component)this.panel, "Center");
            this.scrollpane.setPreferredSize(new Dimension(200, 200));
            this.panel.add((Component)this.scrollpane, "Center");
            this.scrollpane.setViewportView(this.label);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createTextFromPDF(File file) {
        if (file.exists()) {
            int page = 1;
            PdfReader reader = null;
            try {
                reader = new PdfReader(new RandomAccessFileOrArray(file.getAbsolutePath()), null);
                HashMap pdfinfo = reader.getInfo();
                StringBuffer sb = new StringBuffer();
                sb.append("<html>=== Document Information ===<p>");
                sb.append(reader.getCropBox(page).getHeight() + "*" + reader.getCropBox(page).getWidth() + "<p>");
                sb.append("PDF Version: " + reader.getPdfVersion() + "<p>");
                sb.append("Number of pages: " + reader.getNumberOfPages() + "<p>");
                sb.append("Number of PDF objects: " + reader.getXrefSize() + "<p>");
                sb.append("File length: " + reader.getFileLength() + "<p>");
                sb.append("Encrypted= " + reader.isEncrypted() + "<p>");
                if (pdfinfo.get("Title") != null) {
                    sb.append("Title= " + (String)pdfinfo.get("Title") + "<p>");
                }
                if (pdfinfo.get("Author") != null) {
                    sb.append("Author= " + (String)pdfinfo.get("Author") + "<p>");
                }
                if (pdfinfo.get("Subject") != null) {
                    sb.append("Subject= " + (String)pdfinfo.get("Subject") + "<p>");
                }
                if (pdfinfo.get("Producer") != null) {
                    sb.append("Producer= " + (String)pdfinfo.get("Producer") + "<p>");
                }
                if (pdfinfo.get("ModDate") != null) {
                    sb.append("ModDate= " + PdfDate.decode((String)pdfinfo.get("ModDate")).getTime() + "<p>");
                }
                if (pdfinfo.get("CreationDate") != null) {
                    sb.append("CreationDate= " + PdfDate.decode((String)pdfinfo.get("CreationDate")).getTime() + "<p>");
                }
                sb.append("</html>");
                this.label.setText(sb.toString());
            }
            catch (IOException ex) {
                this.label.setText("");
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        File file;
        this.filename = evt.getPropertyName();
        if (this.filename.equals("SelectedFileChangedProperty") && (file = (File)evt.getNewValue()) != null) {
            this.createTextFromPDF(file);
            this.repaint();
        }
    }
}

