/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.QueryMakerImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FacetTopic;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Like;
import org.sharengo.wikitty.search.Search;

public class ThesaurusManager {
    private static final Log log = LogFactory.getLog(ThesaurusManager.class);
    private final WikittyProxy proxy;

    public ThesaurusManager(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public TreeNodeImpl getRootThesaurus() throws VradiException {
        Criteria criteria;
        TreeNodeImpl rootThesaurus;
        if (log.isDebugEnabled()) {
            log.debug((Object)"getRootThesaurus()");
        }
        if ((rootThesaurus = (TreeNodeImpl)this.proxy.findByCriteria(TreeNodeImpl.class, criteria = Search.query().eq(Element.ELT_EXTENSION, "TreeNode").eq("TreeNode.name", "Thesaurus").criteria())) == null) {
            log.warn((Object)"root thesaurus not found, creating ...");
            rootThesaurus = new TreeNodeImpl();
            rootThesaurus.setName("Thesaurus");
            rootThesaurus = (TreeNodeImpl)this.proxy.store((BusinessEntity)rootThesaurus);
        }
        log.info((Object)("root thesaurus: " + rootThesaurus));
        return rootThesaurus;
    }

    public List<TreeNodeImpl> getAllThesaurus() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllThesaurus()");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Thesaurus").criteria();
        PagedResult findAllByCriteria = this.proxy.findAllByCriteria(TreeNodeImpl.class, criteria);
        List nodes = findAllByCriteria.getAll();
        log.info((Object)String.format("found %s thesaurus entries", nodes.size()));
        return nodes;
    }

    public TreeNodeImpl getThesaurus(String thesaurusId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getThesaurus(" + thesaurusId + ")"));
        }
        TreeNodeImpl node = (TreeNodeImpl)this.proxy.restore(TreeNodeImpl.class, thesaurusId);
        return node;
    }

    public List<TreeNodeImpl> getThesaurus(List<String> thesaurusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getThesaurus(" + thesaurusIds + ")"));
        }
        List nodes = this.proxy.restore(TreeNodeImpl.class, thesaurusIds);
        return nodes;
    }

    public List<TreeNodeImpl> getChildrenThesaurus(String thesaurusId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildrenThesaurus(" + thesaurusId + ")"));
        }
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "Thesaurus");
        query.eq("TreeNode.parent", thesaurusId);
        Criteria criteria = query.criteria();
        PagedResult nodes = this.proxy.findAllByCriteria(TreeNodeImpl.class, criteria);
        List all = nodes.getAll();
        return all;
    }

    public int getNbFormsForThesaurus(String thesaurusId) throws VradiException {
        Map.Entry entry;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNbFormsForThesaurus(" + thesaurusId + ")"));
        }
        if ((entry = this.proxy.restoreNode(TreeNodeImpl.class, thesaurusId, null)) == null) {
            return 0;
        }
        return (Integer)entry.getValue();
    }

    public List<TreeNodeImpl> proposeThesaurus(Form form, List<TreeNodeImpl> thesaurus) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proposeThesaurus(form)");
        }
        if (form == null) {
            return null;
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Form").eq("Infogene.id", form.getId()).criteria();
        List<TreeNodeImpl> nodes = thesaurus;
        if (nodes == null) {
            nodes = this.getAllThesaurus();
        }
        Set formNodes = form.getThesaurus();
        for (TreeNodeImpl node : nodes) {
            List tags;
            if (formNodes != null && formNodes.contains(node.getWikittyId()) || (tags = node.getWikitty().getFieldAsList("Thesaurus", "tags", String.class)) == null || tags.isEmpty()) continue;
            Search tagSearch = Search.query((Search.KIND)Search.KIND.OR);
            for (String string : tags) {
                if (string.isEmpty()) continue;
                tagSearch.keyword(string);
            }
            Criteria facetCriteria = tagSearch.criteria(node.getWikittyId());
            criteria.addFacetCriteria(facetCriteria);
        }
        PagedResult forms = this.proxy.findAllByCriteria(Form.class, criteria);
        List<TreeNodeImpl> result = new ArrayList<TreeNodeImpl>();
        if (forms != null && forms.getNumFound() > 0) {
            ArrayList<String> thesaurusIds = new ArrayList<String>();
            Map facetsMap = forms.getFacets();
            block2: for (Map.Entry entry : facetsMap.entrySet()) {
                List facetTopics = (List)entry.getValue();
                for (FacetTopic facetTopic : facetTopics) {
                    if (facetTopic.getCount() <= 0) continue;
                    thesaurusIds.add(facetTopic.getTopicName());
                    continue block2;
                }
            }
            if (!thesaurusIds.isEmpty()) {
                result = this.getThesaurus(thesaurusIds);
            }
        }
        return result;
    }

    public Map<QueryMaker, List<VradiQueryBean>> getQueriesToModifyAfterThesaurusModification(String thesaurusName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getQueriesToModifyAfterThesaurusModification(" + thesaurusName + ")"));
        }
        HashMap<QueryMaker, List<VradiQueryBean>> results = new HashMap<QueryMaker, List<VradiQueryBean>>();
        if (thesaurusName == null) {
            return results;
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "QueryMaker").like("QueryMaker.queries", thesaurusName, Like.SearchAs.AsText).criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(QueryMaker.class, criteria);
        List queryMakers = pagedResult.getAll();
        for (QueryMaker queryMaker : queryMakers) {
            QueryMaker realQueryMaker = ClientManager.castAsRealQueryMaker((QueryMakerImpl)queryMaker);
            if (realQueryMaker == null) continue;
            Set queries = queryMaker.getQueries();
            ArrayList<VradiQueryBean> queriesToModify = new ArrayList<VradiQueryBean>();
            for (String query : queries) {
                try {
                    VradiQueryBean queryBean = new VradiQueryBean(query, queryMaker.getWikittyId());
                    FilterList filter = VradiQueryParser.parse(queryBean.getQuery());
                    if (!this.isThesaurusInQuery(filter, thesaurusName)) continue;
                    queriesToModify.add(queryBean);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (queriesToModify.isEmpty()) continue;
            results.put(realQueryMaker, queriesToModify);
        }
        return results;
    }

    boolean isThesaurusInQuery(FilterList list, String thesaurusName) {
        boolean insideQuery = false;
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                insideQuery = this.isThesaurusInQuery((FilterList)filter, thesaurusName);
            } else if (filter instanceof CompareFilter) {
                insideQuery = this.isThesaurusInQuery((CompareFilter)filter, thesaurusName);
            }
            if (!insideQuery) continue;
            break;
        }
        return insideQuery;
    }

    boolean isThesaurusInQuery(CompareFilter compareFilter, String thesaurusName) {
        String name = compareFilter.getName();
        String value = compareFilter.getValue();
        return ("thesaurus".equals(name) || "descripteurs".equals(name)) && thesaurusName.equals(value);
    }

    void replaceThesaurusInQuery(FilterList list, String oldThesaurusName, String newThesaurusName) {
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                this.replaceThesaurusInQuery((FilterList)filter, oldThesaurusName, newThesaurusName);
                continue;
            }
            if (!(filter instanceof CompareFilter)) continue;
            this.replaceThesaurusInQuery((CompareFilter)filter, oldThesaurusName, newThesaurusName);
        }
    }

    void replaceThesaurusInQuery(CompareFilter compareFilter, String oldThesaurusName, String newThesaurusName) {
        String name;
        String value = compareFilter.getValue();
        if (value.equals(oldThesaurusName) && ("thesaurus".equals(name = compareFilter.getName()) || "descripteurs".equals(name))) {
            compareFilter.setValue(newThesaurusName);
        }
    }
}

