/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.jurismarches.vradi.services.ServiceFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FacetTopic;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class ImportExportManager {
    private static final Log log = LogFactory.getLog(ImportExportManager.class);
    protected static final String FIELD_WIKITTY_ID = "Wikitty.Id";
    protected final WikittyProxy proxy;
    protected ExecutorService importExportExecutor = Executors.newFixedThreadPool(1);
    protected Map<String, Future<String>> importExportTask = new HashMap<String, Future<String>>();
    protected String EXPORT_DIRECTORY = "/tmp/";
    protected String EXPORT_URL = "file:///tmp/";

    public ImportExportManager() {
        this(ServiceFactory.getWikittyProxy());
    }

    public ImportExportManager(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public void syncImportFromCSV(String csv) {
        StringReader reader = new StringReader(csv);
        ImportCSVTask task = new ImportCSVTask(this.proxy.getWikittyService(), reader);
        task.run();
    }

    public void syncImportFromCSVUri(String uri) {
        try {
            URL url = new URL(uri);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            ImportCSVTask task = new ImportCSVTask(this.proxy.getWikittyService(), reader);
            task.run();
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public String asyncImportFromCSVUri(String uri) {
        try {
            URL url = new URL(uri);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            ImportCSVTask task = new ImportCSVTask(this.proxy.getWikittyService(), reader);
            FutureTask<Object> future = new FutureTask<Object>(task, null);
            this.importExportExecutor.submit(future);
            String jobId = UUID.randomUUID().toString();
            this.importExportTask.put(jobId, future);
            return jobId;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public String asyncExportCSVAllByCriteria(Criteria criteria) {
        try {
            String jobId = UUID.randomUUID().toString();
            File file = new File(this.EXPORT_DIRECTORY, jobId);
            String url = this.EXPORT_URL + jobId;
            FileWriter result = new FileWriter(file);
            ExportCSVTask task = new ExportCSVTask(this.proxy.getWikittyService(), criteria, result);
            FutureTask<String> future = new FutureTask<String>(task, url);
            this.importExportExecutor.submit(future);
            this.importExportTask.put(jobId, future);
            return jobId;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public String syncExportCSVAllByCriteria(Criteria criteria) {
        StringWriter result = new StringWriter();
        ExportCSVTask task = new ExportCSVTask(this.proxy.getWikittyService(), criteria, result);
        task.run();
        return result.toString();
    }

    public static class ExportCSVTask
    implements Runnable {
        protected WikittyService ws;
        protected WikittyTransaction transaction;
        protected Writer writer;
        protected Criteria criteria;

        public ExportCSVTask(WikittyService ws, Criteria criteria, Writer writer) {
            this.ws = ws;
            this.writer = writer;
            this.transaction = new WikittyTransaction();
            this.criteria = criteria;
        }

        @Override
        public void run() {
            try {
                CSVWriter csvWriter = new CSVWriter(this.writer);
                this.criteria.addFacetField(Element.ELT_EXTENSION);
                PagedResult pageResult = this.ws.findAllByCriteria(this.criteria);
                LinkedList<String> extensionHeader = new LinkedList<String>();
                extensionHeader.add(ImportExportManager.FIELD_WIKITTY_ID);
                for (FacetTopic topic : pageResult.getTopic(Element.ELT_EXTENSION)) {
                    String extName = topic.getTopicName();
                    log.debug((Object)("Extention = " + extName));
                    WikittyExtension extension = this.ws.restoreExtensionLastVersion(extName);
                    String ext = WikittyExtension.computeName((String)extName);
                    for (String fieldName : extension.getFieldNames()) {
                        extensionHeader.add(ext + "." + fieldName);
                    }
                }
                csvWriter.writeNext(extensionHeader.toArray(new String[extensionHeader.size()]));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exporting wikitty : " + pageResult.getAll().size() + " results"));
                }
                for (Wikitty w : pageResult.getAll()) {
                    String[] wikittyField = new String[extensionHeader.size()];
                    wikittyField[extensionHeader.indexOf((Object)ImportExportManager.FIELD_WIKITTY_ID)] = w.getId();
                    for (String fieldName : w.fieldNames()) {
                        String currentField = "";
                        FieldType type = w.getFieldType(fieldName);
                        if (type.isCollection()) {
                            Object fqField = w.getFqField(fieldName);
                            if (fqField != null) {
                                String separator = "";
                                for (Object o : (Collection)fqField) {
                                    String fqFieldValue = WikittyUtil.toString((FieldType)type, o);
                                    currentField = currentField + separator + "(" + fqFieldValue + ")";
                                    separator = ",";
                                }
                            }
                        } else {
                            String fqFieldValue;
                            currentField = fqFieldValue = WikittyUtil.toString((FieldType)type, (Object)w.getFqField(fieldName));
                        }
                        wikittyField[extensionHeader.indexOf((Object)fieldName)] = currentField;
                    }
                    csvWriter.writeNext(wikittyField);
                }
                csvWriter.close();
            }
            catch (Exception eee) {
                throw new WikittyException(eee);
            }
        }
    }

    public static class ImportCSVTask
    implements Runnable {
        protected WikittyService ws;
        protected WikittyTransaction transaction;
        protected Reader reader;
        protected Pattern queryPattern = Pattern.compile("^((\\w+)\\.(\\w+))=(\"(.+)\"|([^\"]+))$");

        public ImportCSVTask(WikittyService ws, Reader reader) {
            this.ws = ws;
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                int wikittyIdIndex = -1;
                CSVReader csvReader = new CSVReader(this.reader);
                String[] header = csvReader.readNext();
                String[] ext = new String[header.length];
                String[] fieldsName = new String[header.length];
                for (int i = 0; i < header.length; ++i) {
                    if (ImportExportManager.FIELD_WIKITTY_ID.equals(header[i])) {
                        wikittyIdIndex = i;
                        continue;
                    }
                    ext[i] = header[i].substring(0, header[i].indexOf("."));
                    fieldsName[i] = header[i].substring(header[i].indexOf(".") + 1);
                }
                String[] currentLine = null;
                while ((currentLine = csvReader.readNext()) != null) {
                    String wikittyId = currentLine[wikittyIdIndex];
                    Wikitty currentWikitty = null;
                    currentWikitty = StringUtils.isNotEmpty((String)wikittyId) ? new Wikitty(wikittyId) : new Wikitty();
                    for (int i = 0; i < header.length; ++i) {
                        if (i == wikittyIdIndex) continue;
                        String extName = ext[i];
                        String fieldName = fieldsName[i];
                        String value = currentLine[i];
                        if (!StringUtils.isNotEmpty((String)value)) continue;
                        this.addMissingExtension(this.ws, currentWikitty, extName);
                        value = this.convertLinkValues(value);
                        FieldType fieldType = currentWikitty.getFieldType(extName + "." + fieldName);
                        if (fieldType.isCollection()) {
                            String[] multiplesValues;
                            for (String multiplesValue : multiplesValues = StringUtil.split((String)value)) {
                                if (multiplesValue.startsWith("(") && multiplesValue.endsWith(")")) {
                                    multiplesValue = multiplesValue.substring(1, multiplesValue.length() - 1);
                                }
                                currentWikitty.addToField(extName, fieldName, (Object)multiplesValue);
                            }
                            continue;
                        }
                        currentWikitty.setField(extName, fieldName, (Object)value);
                    }
                    this.ws.store(currentWikitty);
                }
            }
            catch (Exception eee) {
                throw new WikittyException(eee);
            }
        }

        protected void addMissingExtension(WikittyService ws, Wikitty currentWikitty, String extName) {
            if (!currentWikitty.hasExtension(extName)) {
                WikittyExtension extension = ws.restoreExtensionLastVersion(extName);
                String requires = extension.getRequires();
                if (StringUtils.isNotEmpty((String)requires)) {
                    for (String require : requires.split(",")) {
                        String localRequire = require.trim();
                        this.addMissingExtension(ws, currentWikitty, localRequire);
                    }
                }
                currentWikitty.addExtension(extension);
            }
        }

        protected String convertLinkValues(String value) {
            boolean correctQueries;
            String resultValue;
            String originalValue;
            block7: {
                originalValue = value;
                resultValue = "";
                String separator = "";
                correctQueries = true;
                try {
                    String[] queries;
                    for (String query : queries = StringUtil.split((String)value, (String)",")) {
                        Matcher m = this.queryPattern.matcher(query.trim());
                        if (m.find()) {
                            Criteria criteria;
                            Wikitty wikitty;
                            String fqField = m.group(1);
                            String fValue = m.group(5);
                            if (fValue == null) {
                                fValue = m.group(6);
                            }
                            if ((wikitty = this.ws.findByCriteria(criteria = Search.query().eq(fqField, fValue).criteria())) == null) {
                                correctQueries = false;
                                continue;
                            }
                            resultValue = resultValue + separator + wikitty.getId();
                            separator = ",";
                            continue;
                        }
                        correctQueries = false;
                    }
                }
                catch (StringIndexOutOfBoundsException eee) {
                    if (!log.isTraceEnabled()) break block7;
                    log.trace((Object)"Can't split field on , skipping");
                }
            }
            if (!correctQueries || StringUtils.isEmpty((String)resultValue)) {
                resultValue = originalValue;
            }
            return resultValue;
        }
    }
}

