/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.services.managers.MailingManager;
import org.junit.Assert;
import org.junit.Test;

public class MailingManagerTest {
    protected MailingManager mailingManager = new MailingManager(null);

    @Test
    public void testGetHeaderInContent1() {
        String testString = "Final-Recipient: rfc822; toto@codelutin.com\nOriginal-Recipient: rfc822;toto@codelutin.com\nAction: failed\nStatus: 5.1.1\nRemote-MTA: dns; 87.98.187.174\nDiagnostic-Code: smtp; 550 5.1.1 <toto@codelutin.com>: Recipient address\n   rejected: User unknown in local recipient table\n";
        String headerValue = this.mailingManager.getHeaderValueInContent("Diagnostic-Code", testString);
        Assert.assertEquals((Object)"smtp; 550 5.1.1 <toto@codelutin.com>: Recipient address", (Object)headerValue);
    }

    @Test
    public void testGetHeaderInContent2() {
        String testString = "Reporting-UA: Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.2.5pre)\nGecko/20100503 Icedove/2.0.0.12\nFinal-Recipient: rfc822;chatellier@codelutin.com\nOriginal-Message-ID: <1833582695.1.1272991628810.JavaMail.chatellier@genux>\nDisposition: manual-action/MDN-sent-manually; displayed";
        String headerValue = this.mailingManager.getHeaderValueInContent("Original-Message-ID", testString);
        Assert.assertEquals((Object)"<1833582695.1.1272991628810.JavaMail.chatellier@genux>", (Object)headerValue);
    }

    @Test
    public void testGetHeaderInContent3() {
        String testString = "From: vradi\nTo: toto@codelutin.com\nMessage-ID: <804992706.5.1272991629788.JavaMail.chatellier@genux>";
        String headerValue = this.mailingManager.getHeaderValueInContent("Message-ID", testString);
        Assert.assertEquals((Object)"<804992706.5.1272991629788.JavaMail.chatellier@genux>", (Object)headerValue);
    }
}

