/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientBean;
import com.jurismarches.vradi.entities.ModificationTag;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:23:27
 */
public class VradiClientDTO extends ClientBean implements VradiDTO<Client>, SendingContainer {

    private static final long serialVersionUID = 1L;

    protected List<VradiUserDTO> usersDTO = null;
    protected VradiSendingDTO currentSending = null;

    public VradiClientDTO() {
        //Client$user = new HashSet<String>();
        QueryMaker$queries = new HashSet<String>();

        usersDTO = new ArrayList<VradiUserDTO>();
    }

    @Override
    public void fromWikitty(Client wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setAddress(wikitty.getAddress());
            setContact(wikitty.getContact());
            setCreationDate(wikitty.getCreationDate());
            setName(wikitty.getName());
            setPhone(wikitty.getPhone());

            if (wikitty.getExtensionNames().contains(ModificationTag.EXT_MODIFICATION_TAG)) {
                Object lastModified = wikitty.getField(ModificationTag.EXT_MODIFICATION_TAG,
                        ModificationTag.FIELD_LAST_MODIFIED);
                setLastModified(lastModified != null ? (Date) lastModified : null);
                Object lastModifier = wikitty.getField(ModificationTag.EXT_MODIFICATION_TAG,
                        ModificationTag.FIELD_LAST_MODIFIER);
                setLastModifier(lastModifier != null ? (String) lastModifier : null);
            } else {
                setLastModified(null);
                setLastModifier(null);
            }

            QueryMaker$queries.clear();
            addAllQueries(wikitty.getQueries());

            //Client$user.clear();
            //addAllUsers(wikitty.getUser());

        }
    }

    public void reset() {
        setWikittyId(null);
        setAddress(null);
        setContact(null);
        setCreationDate(null);
        setName(null);
        setPhone(null);
        setLastModified(null);
        setLastModifier(null);
        clearQueries();
        //clearUser();
    }
    
    @Override
    public void toWikitty(Client wikitty) {
        wikitty.setAddress(getAddress());
        wikitty.setContact(getContact());
        wikitty.setCreationDate(getCreationDate());
        wikitty.setName(getName());
        wikitty.setPhone(getPhone());
        wikitty.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED, getLastModified());
        wikitty.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER, getLastModifier());

        /*wikitty.clearUser();
        for (String id : getUser()) {
            wikitty.addUser(id);
        }*/

        wikitty.clearQueries();
        for (String id : getQueries()) {
            wikitty.addQueries(id);
        }
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public Date getLastModified() {
        return (Date) this.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED);
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = getLastModified();
        this.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED, lastModified);
        propertyChange.firePropertyChange("lastModified", oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String) this.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER);
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = getLastModifier();
        this.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER, lastModifier);
        propertyChange.firePropertyChange("lastModifier", oldValue, lastModifier);
    }

    /*public void addAllUsers(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                Client$user.add(s);
            }
        }
        propertyChange.firePropertyChange("user", null, Client$user);
    }*/

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                QueryMaker$queries.add(s);
            }
        }
        propertyChange.firePropertyChange("queries", null, QueryMaker$queries);
    }

    public List<VradiUserDTO> getUsersDTO() {
        return usersDTO;
    }

    public void setUsersDTO(List<VradiUserDTO> usersDTO) {
        List<VradiUserDTO> oldValue = this.usersDTO;
        this.usersDTO = usersDTO;
        propertyChange.firePropertyChange("usersDTO", oldValue, usersDTO);
    }

    public VradiSendingDTO getCurrentSending() {
        return currentSending;
    }

    public void setCurrentSending(VradiSendingDTO currentSending) {
        this.currentSending = currentSending;
    }

    @Override
    public int getNbFormToSend() {
        int nbForms = 0;
        for (VradiUserDTO user : getUsersDTO()){
            nbForms = nbForms + user.getNbFormToSend();
        }
        return nbForms;
    }

    @Override
    public String toString() {
        return getName();
    }
}
