/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ButtonBase;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class AutoRepeatButtonUtils {
    public static final String AUTO_REPEAT = "AutoRepeat";
    public static final String CLIENT_PROPERTY_AUTO_REPEAT = "AutoRepeat.AutoRepeatButtonUtils";
    public static final Duration DEFAULT_DELAY = Duration.millis((double)100.0);
    public static final Duration DEFAULT_INITIAL_DELAY = Duration.millis((double)500.0);
    private Timeline _timer = null;
    private ButtonBase _button;
    private EventHandler<MouseEvent> _mouseEventEventHandler;

    public static void install(ButtonBase button) {
        AutoRepeatButtonUtils.uninstall(button);
        new AutoRepeatButtonUtils().installListeners(button, DEFAULT_INITIAL_DELAY, DEFAULT_DELAY);
    }

    public static void install(ButtonBase button, Duration initialDelay, Duration interval) {
        AutoRepeatButtonUtils.uninstall(button);
        new AutoRepeatButtonUtils().installListeners(button, initialDelay, interval);
    }

    public static void uninstall(ButtonBase button) {
        Object clientProperty = button.getProperties().get((Object)CLIENT_PROPERTY_AUTO_REPEAT);
        if (clientProperty instanceof AutoRepeatButtonUtils) {
            ((AutoRepeatButtonUtils)clientProperty).uninstallListeners();
        }
    }

    protected void installListeners(ButtonBase button, Duration initialDelay, Duration interval) {
        this._button = button;
        button.getProperties().put((Object)CLIENT_PROPERTY_AUTO_REPEAT, (Object)this);
        if (this._mouseEventEventHandler == null) {
            this._mouseEventEventHandler = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                        AutoRepeatButtonUtils.this._timer.play();
                    } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                        AutoRepeatButtonUtils.this._timer.stop();
                    } else if (event.getEventType() == MouseEvent.MOUSE_RELEASED) {
                        AutoRepeatButtonUtils.this._timer.stop();
                    }
                }
            };
        }
        button.addEventHandler(MouseEvent.ANY, this._mouseEventEventHandler);
        this._timer = new Timeline(new KeyFrame[]{new KeyFrame(interval, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EventHandler action = AutoRepeatButtonUtils.this._button.getOnAction();
                if (action != null) {
                    action.handle((Event)new ActionEvent());
                }
            }
        }, new KeyValue[0])});
        this._timer.setDelay(initialDelay);
        this._timer.setCycleCount(-1);
    }

    protected void uninstallListeners() {
        if (this._button != null) {
            this._button.getProperties().put((Object)CLIENT_PROPERTY_AUTO_REPEAT, null);
            if (this._mouseEventEventHandler != null) {
                this._button.removeEventHandler(MouseEvent.ANY, this._mouseEventEventHandler);
            }
            this._button = null;
        }
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }
}

