/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.popup;

import com.jidefx.scene.control.skin.TooltipExSkin;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Window;
import javafx.util.Duration;

public class TooltipEx
extends PopupControl {
    private static String TOOLTIP_PROP_KEY = "javafx.scene.control.Tooltip";
    private static JideTooltipBehavior BEHAVIOR = new JideTooltipBehavior(new Duration(200.0), new Duration(2000.0), new Duration(200.0), false);
    private final StringProperty text = new SimpleStringProperty((Object)this, "text", "");
    private ObjectProperty<Node> graphic;
    private final ReadOnlyBooleanWrapper activated = new ReadOnlyBooleanWrapper((Object)this, "activated");
    private ObjectProperty<Pos> _posProperty;

    public static void install(Node node, TooltipEx t) {
        TooltipEx.BEHAVIOR.install(node, t);
    }

    public static void uninstall(Node node, TooltipEx t) {
        TooltipEx.BEHAVIOR.uninstall(node);
    }

    public TooltipEx() {
        this.bridge = new CSSBridge();
        this.initialize();
    }

    public TooltipEx(String text) {
        this.bridge = new CSSBridge();
        this.setText(text);
        this.initialize();
    }

    private void initialize() {
        if (this.bridge != null) {
            this.getContent().clear();
            this.bridge.idProperty().unbind();
            this.bridge.styleProperty().unbind();
            this.bridge.idProperty().bind((ObservableValue)this.idProperty());
            this.bridge.styleProperty().bind((ObservableValue)this.styleProperty());
        }
        this.getContent().add((Object)this.bridge);
        this.getStyleClass().setAll((Object[])new String[]{"tooltip"});
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String value) {
        if (this.isShowing() && value != null && !value.equals(this.getText())) {
            this.setX(BEHAVIOR.lastMouseX);
            this.setY(BEHAVIOR.lastMouseY);
        }
        this.textProperty().setValue(value);
    }

    public final String getText() {
        return this.text == null ? "" : this.text.getValue();
    }

    public final void setTextAlignment(TextAlignment value) {
        this.textAlignmentProperty().setValue((Object)value);
    }

    public final TextAlignment getTextAlignment() {
        return ((CSSBridge)this.bridge).textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((CSSBridge)this.bridge).textAlignment.getValue();
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        return ((CSSBridge)this.bridge).textAlignmentProperty();
    }

    public final void setTextOverrun(OverrunStyle value) {
        this.textOverrunProperty().setValue((Object)value);
    }

    public final OverrunStyle getTextOverrun() {
        return ((CSSBridge)this.bridge).textOverrun == null ? OverrunStyle.ELLIPSIS : (OverrunStyle)((CSSBridge)this.bridge).textOverrun.getValue();
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        return ((CSSBridge)this.bridge).textOverrunProperty();
    }

    public final void setWrapText(boolean value) {
        this.wrapTextProperty().setValue(Boolean.valueOf(value));
    }

    public final boolean isWrapText() {
        return ((CSSBridge)this.bridge).wrapText == null ? false : ((CSSBridge)this.bridge).wrapText.getValue();
    }

    public final BooleanProperty wrapTextProperty() {
        return ((CSSBridge)this.bridge).wrapTextProperty();
    }

    public final void setFont(Font value) {
        this.fontProperty().setValue((Object)value);
    }

    public final Font getFont() {
        return ((CSSBridge)this.bridge).font == null ? Font.getDefault() : (Font)((CSSBridge)this.bridge).font.getValue();
    }

    public final ObjectProperty<Font> fontProperty() {
        return ((CSSBridge)this.bridge).fontProperty();
    }

    public final void setGraphic(Node value) {
        this.graphicProperty().setValue((Object)value);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new ObjectPropertyBase<Node>(){

                public Object getBean() {
                    return TooltipEx.this;
                }

                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public final void setContentDisplay(ContentDisplay value) {
        this.contentDisplayProperty().setValue((Object)value);
    }

    public final ContentDisplay getContentDisplay() {
        return ((CSSBridge)this.bridge).contentDisplay == null ? ContentDisplay.LEFT : (ContentDisplay)((CSSBridge)this.bridge).contentDisplay.getValue();
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        return ((CSSBridge)this.bridge).contentDisplayProperty();
    }

    public final void setGraphicTextGap(double value) {
        this.graphicTextGapProperty().setValue((Number)value);
    }

    public final double getGraphicTextGap() {
        return ((CSSBridge)this.bridge).graphicTextGap == null ? 4.0 : ((CSSBridge)this.bridge).graphicTextGap.getValue();
    }

    public final DoubleProperty graphicTextGapProperty() {
        return ((CSSBridge)this.bridge).graphicTextGapProperty();
    }

    final void setActivated(boolean value) {
        this.activated.set(value);
    }

    public final boolean isActivated() {
        return this.activated.get();
    }

    public final ReadOnlyBooleanProperty activatedProperty() {
        return this.activated.getReadOnlyProperty();
    }

    protected Skin<?> createDefaultSkin() {
        return new TooltipExSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TooltipEx.getClassCssMetaData();
    }

    public Styleable getStyleableParent() {
        return BEHAVIOR.hoveredNode;
    }

    public ObjectProperty<Pos> posProperty() {
        if (this._posProperty == null) {
            this._posProperty = new SimpleObjectProperty((Object)Pos.BOTTOM_RIGHT);
        }
        return this._posProperty;
    }

    public Pos getPos() {
        return (Pos)this.posProperty().get();
    }

    public void setPos(Pos pos) {
        this.posProperty().set((Object)pos);
    }

    private static Point2D adjustTooltipLocation(Node hoveredNode, TooltipEx tooltip) {
        Pos pos = tooltip.getPos();
        Point2D nodeLocation = hoveredNode.localToScreen(0.0, 0.0);
        Point2D p = null;
        if (pos != null) {
            switch (pos) {
                case BOTTOM_RIGHT: {
                    p = new Point2D(nodeLocation.getX() + hoveredNode.getLayoutBounds().getWidth(), nodeLocation.getY() + hoveredNode.getLayoutBounds().getHeight());
                    break;
                }
                case BOTTOM_LEFT: {
                    p = new Point2D(nodeLocation.getX() - tooltip.prefWidth(-1.0), nodeLocation.getY() + hoveredNode.getLayoutBounds().getHeight());
                }
            }
        }
        return p;
    }

    private static class JideTooltipBehavior {
        private Timeline activationTimer = new Timeline();
        private Timeline hideTimer = new Timeline();
        private Timeline leftTimer = new Timeline();
        private Node hoveredNode;
        private TooltipEx activatedTooltip;
        private TooltipEx visibleTooltip;
        private double lastMouseX;
        private double lastMouseY;
        private boolean hideOnExit;
        private EventHandler<MouseEvent> MOVE_HANDLER = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newMouseX = event.getScreenX();
                double newMouseY = event.getScreenY();
                if (newMouseX == lastMouseX && newMouseY == lastMouseY) {
                    return;
                }
                lastMouseX = newMouseX;
                lastMouseY = newMouseY;
                if (hideTimer.getStatus() == Animation.Status.RUNNING) {
                    return;
                }
                hoveredNode = (Node)event.getSource();
                TooltipEx t = (TooltipEx)((Object)hoveredNode.getProperties().get((Object)TOOLTIP_PROP_KEY));
                if (t != null) {
                    Window owner = this.getWindow(hoveredNode);
                    boolean treeVisible = this.isWindowHierarchyVisible(hoveredNode);
                    if (owner != null && treeVisible) {
                        if (leftTimer.getStatus() == Animation.Status.RUNNING) {
                            if (visibleTooltip != null) {
                                visibleTooltip.hide();
                            }
                            visibleTooltip = t;
                            double x = event.getScreenX();
                            double y = event.getScreenY();
                            Point2D p = TooltipEx.adjustTooltipLocation(hoveredNode, t);
                            if (p != null) {
                                t.show(owner, p.getX(), p.getY());
                            } else {
                                t.show(owner, x, y);
                            }
                            leftTimer.stop();
                            hideTimer.playFromStart();
                        } else {
                            t.setActivated(true);
                            activatedTooltip = t;
                            activationTimer.stop();
                            activationTimer.playFromStart();
                        }
                    }
                }
            }
        };
        private EventHandler<MouseEvent> LEAVING_HANDLER = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newMouseX = event.getScreenX();
                double newMouseY = event.getScreenY();
                if (newMouseX == lastMouseX && newMouseY == lastMouseY) {
                    return;
                }
                if (activationTimer.getStatus() == Animation.Status.RUNNING) {
                    activationTimer.stop();
                } else if (hideTimer.getStatus() == Animation.Status.RUNNING) {
                    assert (visibleTooltip != null);
                    hideTimer.stop();
                    if (hideOnExit) {
                        visibleTooltip.hide();
                    }
                    leftTimer.playFromStart();
                }
                hoveredNode = null;
                activatedTooltip = null;
                if (hideOnExit) {
                    visibleTooltip = null;
                }
            }
        };
        private EventHandler<MouseEvent> KILL_HANDLER = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                activationTimer.stop();
                hideTimer.stop();
                leftTimer.stop();
                if (visibleTooltip != null) {
                    visibleTooltip.hide();
                }
                hoveredNode = null;
                activatedTooltip = null;
                visibleTooltip = null;
            }
        };

        JideTooltipBehavior(Duration openDelay, Duration visibleDuration, Duration closeDelay, final boolean hideOnExit) {
            this.hideOnExit = hideOnExit;
            this.activationTimer.getKeyFrames().add((Object)new KeyFrame(openDelay, new KeyValue[0]));
            this.activationTimer.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    assert (activatedTooltip != null);
                    Window owner = this.getWindow(hoveredNode);
                    boolean treeVisible = this.isWindowHierarchyVisible(hoveredNode);
                    if (owner != null && owner.isShowing() && treeVisible) {
                        double x = lastMouseX;
                        double y = lastMouseY;
                        NodeOrientation nodeOrientation = hoveredNode.getEffectiveNodeOrientation();
                        activatedTooltip.getScene().setNodeOrientation(nodeOrientation);
                        if (nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
                            x -= activatedTooltip.getWidth();
                        }
                        activatedTooltip.show(owner, x, y);
                        Point2D p = TooltipEx.adjustTooltipLocation(hoveredNode, activatedTooltip);
                        if (p != null) {
                            activatedTooltip.setX(p.getX());
                            activatedTooltip.setY(p.getY());
                        }
                        visibleTooltip = activatedTooltip;
                        hoveredNode = null;
                        hideTimer.playFromStart();
                    }
                    activatedTooltip.setActivated(false);
                    activatedTooltip = null;
                }
            });
            this.hideTimer.getKeyFrames().add((Object)new KeyFrame(visibleDuration, new KeyValue[0]));
            this.hideTimer.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    assert (visibleTooltip != null);
                    visibleTooltip.hide();
                    visibleTooltip = null;
                    hoveredNode = null;
                }
            });
            this.leftTimer.getKeyFrames().add((Object)new KeyFrame(closeDelay, new KeyValue[0]));
            this.leftTimer.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (!hideOnExit) {
                        assert (visibleTooltip != null);
                        visibleTooltip.hide();
                        visibleTooltip = null;
                        hoveredNode = null;
                    }
                }
            });
        }

        private void install(Node node, TooltipEx t) {
            if (node == null) {
                return;
            }
            node.addEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
            node.addEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
            node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
            node.getProperties().put((Object)TOOLTIP_PROP_KEY, (Object)t);
        }

        private void uninstall(Node node) {
            if (node == null) {
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
            TooltipEx t = (TooltipEx)((Object)node.getProperties().get((Object)TOOLTIP_PROP_KEY));
            if (t != null) {
                node.getProperties().remove((Object)TOOLTIP_PROP_KEY);
                if (((Object)((Object)t)).equals((Object)this.visibleTooltip) || ((Object)((Object)t)).equals((Object)this.activatedTooltip)) {
                    this.KILL_HANDLER.handle(null);
                }
            }
        }

        private Window getWindow(Node node) {
            Scene scene = node == null ? null : node.getScene();
            return scene == null ? null : scene.getWindow();
        }

        private boolean isWindowHierarchyVisible(Node node) {
            Parent parent;
            boolean treeVisible = node != null;
            Parent parent2 = parent = node == null ? null : node.getParent();
            while (parent != null && treeVisible) {
                treeVisible = parent.isVisible();
                parent = parent.getParent();
            }
            return treeVisible;
        }
    }

    final class CSSBridge
    extends PopupControl.CSSBridge {
        private ObjectProperty<TextAlignment> textAlignment;
        private ObjectProperty<OverrunStyle> textOverrun;
        private BooleanProperty wrapText;
        private ObjectProperty<Font> font;
        private StringProperty imageUrl;
        private ObjectProperty<ContentDisplay> contentDisplay;
        private DoubleProperty graphicTextGap;

        CSSBridge() {
            super((PopupControl)TooltipEx.this);
            this.imageUrl = null;
        }

        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return TooltipEx.this.getCssMetaData();
        }

        private final ObjectProperty<TextAlignment> textAlignmentProperty() {
            if (this.textAlignment == null) {
                this.textAlignment = new StyleableObjectProperty<TextAlignment>(TextAlignment.LEFT){

                    public CssMetaData<CSSBridge, TextAlignment> getCssMetaData() {
                        return StyleableProperties.TEXT_ALIGNMENT;
                    }

                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    public String getName() {
                        return "textAlignment";
                    }
                };
            }
            return this.textAlignment;
        }

        private final ObjectProperty<OverrunStyle> textOverrunProperty() {
            if (this.textOverrun == null) {
                this.textOverrun = new StyleableObjectProperty<OverrunStyle>(OverrunStyle.ELLIPSIS){

                    public CssMetaData<CSSBridge, OverrunStyle> getCssMetaData() {
                        return StyleableProperties.TEXT_OVERRUN;
                    }

                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    public String getName() {
                        return "textOverrun";
                    }
                };
            }
            return this.textOverrun;
        }

        private final BooleanProperty wrapTextProperty() {
            if (this.wrapText == null) {
                this.wrapText = new StyleableBooleanProperty(false){

                    public CssMetaData<CSSBridge, Boolean> getCssMetaData() {
                        return StyleableProperties.WRAP_TEXT;
                    }

                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    public String getName() {
                        return "wrapText";
                    }
                };
            }
            return this.wrapText;
        }

        private final ObjectProperty<Font> fontProperty() {
            if (this.font == null) {
                this.font = new StyleableObjectProperty<Font>(Font.getDefault()){

                    public CssMetaData<CSSBridge, Font> getCssMetaData() {
                        return StyleableProperties.FONT;
                    }

                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    public String getName() {
                        return "font";
                    }
                };
            }
            return this.font;
        }

        private StringProperty imageUrlProperty() {
            if (this.imageUrl == null) {
                this.imageUrl = new StyleableStringProperty(){

                    protected void invalidated() {
                        if (this.get() != null) {
                            URL url = null;
                            try {
                                url = new URL(this.get());
                            }
                            catch (MalformedURLException malf) {
                                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                                url = cl.getResource(this.get());
                            }
                            if (url != null) {
                                Image img = StyleManager.getInstance().getCachedImage(url.toExternalForm());
                                TooltipEx.this.setGraphic((Node)new ImageView(img));
                            }
                        } else {
                            TooltipEx.this.setGraphic(null);
                        }
                    }

                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    public String getName() {
                        return "imageUrl";
                    }

                    public CssMetaData<CSSBridge, String> getCssMetaData() {
                        return StyleableProperties.GRAPHIC;
                    }
                };
            }
            return this.imageUrl;
        }

        private final ObjectProperty<ContentDisplay> contentDisplayProperty() {
            if (this.contentDisplay == null) {
                this.contentDisplay = new StyleableObjectProperty<ContentDisplay>(ContentDisplay.LEFT){

                    public CssMetaData<CSSBridge, ContentDisplay> getCssMetaData() {
                        return StyleableProperties.CONTENT_DISPLAY;
                    }

                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    public String getName() {
                        return "contentDisplay";
                    }
                };
            }
            return this.contentDisplay;
        }

        private final DoubleProperty graphicTextGapProperty() {
            if (this.graphicTextGap == null) {
                this.graphicTextGap = new StyleableDoubleProperty(4.0){

                    public CssMetaData<CSSBridge, Number> getCssMetaData() {
                        return StyleableProperties.GRAPHIC_TEXT_GAP;
                    }

                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    public String getName() {
                        return "graphicTextGap";
                    }
                };
            }
            return this.graphicTextGap;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<CSSBridge, Font> FONT = new FontCssMetaData<CSSBridge>("-fx-font", Font.getDefault()){

            public boolean isSettable(CSSBridge n) {
                return n.font == null || !n.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(CSSBridge n) {
                return (StyleableProperty)n.fontProperty();
            }
        };
        private static final CssMetaData<CSSBridge, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<CSSBridge, TextAlignment>("-fx-text-alignment", (StyleConverter)new EnumConverter(TextAlignment.class), TextAlignment.LEFT){

            public boolean isSettable(CSSBridge n) {
                return n.textAlignment == null || !n.textAlignment.isBound();
            }

            public StyleableProperty<TextAlignment> getStyleableProperty(CSSBridge n) {
                return (StyleableProperty)n.textAlignmentProperty();
            }
        };
        private static final CssMetaData<CSSBridge, OverrunStyle> TEXT_OVERRUN = new CssMetaData<CSSBridge, OverrunStyle>("-fx-text-overrun", (StyleConverter)new EnumConverter(OverrunStyle.class), OverrunStyle.ELLIPSIS){

            public boolean isSettable(CSSBridge n) {
                return n.textOverrun == null || !n.textOverrun.isBound();
            }

            public StyleableProperty<OverrunStyle> getStyleableProperty(CSSBridge n) {
                return (StyleableProperty)n.textOverrunProperty();
            }
        };
        private static final CssMetaData<CSSBridge, Boolean> WRAP_TEXT = new CssMetaData<CSSBridge, Boolean>("-fx-wrap-text", BooleanConverter.getInstance(), Boolean.FALSE){

            public boolean isSettable(CSSBridge n) {
                return n.wrapText == null || !n.wrapText.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(CSSBridge n) {
                return (StyleableProperty)n.wrapTextProperty();
            }
        };
        private static final CssMetaData<CSSBridge, String> GRAPHIC = new CssMetaData<CSSBridge, String>("-fx-graphic", StringConverter.getInstance()){

            public boolean isSettable(CSSBridge n) {
                return n.imageUrl == null || !n.imageUrl.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(CSSBridge n) {
                return (StyleableProperty)n.imageUrlProperty();
            }
        };
        private static final CssMetaData<CSSBridge, ContentDisplay> CONTENT_DISPLAY = new CssMetaData<CSSBridge, ContentDisplay>("-fx-content-display", (StyleConverter)new EnumConverter(ContentDisplay.class), ContentDisplay.LEFT){

            public boolean isSettable(CSSBridge n) {
                return n.contentDisplay == null || !n.contentDisplay.isBound();
            }

            public StyleableProperty<ContentDisplay> getStyleableProperty(CSSBridge n) {
                return (StyleableProperty)n.contentDisplayProperty();
            }
        };
        private static final CssMetaData<CSSBridge, Number> GRAPHIC_TEXT_GAP = new CssMetaData<CSSBridge, Number>("-fx-graphic-text-gap", SizeConverter.getInstance(), (Number)4.0){

            public boolean isSettable(CSSBridge n) {
                return n.graphicTextGap == null || !n.graphicTextGap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(CSSBridge n) {
                return (StyleableProperty)n.graphicTextGapProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(PopupControl.getClassCssMetaData());
            styleables.add(FONT);
            styleables.add(TEXT_ALIGNMENT);
            styleables.add(TEXT_OVERRUN);
            styleables.add(WRAP_TEXT);
            styleables.add(GRAPHIC);
            styleables.add(CONTENT_DISPLAY);
            styleables.add(GRAPHIC_TEXT_GAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

