/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.popup;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeType;
import javafx.scene.shape.VLineTo;
import jidefx.scene.control.popup.PopupOutline;

public class RectanglePopupOutline
extends PopupOutline {
    private ObjectProperty<Pos> _originPositionProperty;
    private DoubleProperty _widthProperty;
    private DoubleProperty _heightProperty;
    private DoubleProperty _roundedRadiusProperty;

    public RectanglePopupOutline() {
        this.createPath();
        this.initializeStyle();
    }

    protected void initializeStyle() {
        this.getStyleClass().add((Object)"rectangle-popup-outline");
    }

    @Override
    public DoubleProperty widthProperty() {
        if (this._widthProperty == null) {
            this._widthProperty = new SimpleDoubleProperty();
        }
        return this._widthProperty;
    }

    public double getWidth() {
        return this.widthProperty().get();
    }

    public void setWidth(double width) {
        this.widthProperty().set(width);
    }

    @Override
    public DoubleProperty heightProperty() {
        if (this._heightProperty == null) {
            this._heightProperty = new SimpleDoubleProperty();
        }
        return this._heightProperty;
    }

    public double getHeight() {
        return this.heightProperty().get();
    }

    public void setHeight(double height) {
        this.heightProperty().set(height);
    }

    public DoubleProperty roundedRadiusProperty() {
        if (this._roundedRadiusProperty == null) {
            this._roundedRadiusProperty = new SimpleDoubleProperty(8.0);
        }
        return this._roundedRadiusProperty;
    }

    public double getRoundedRadius() {
        return this.roundedRadiusProperty().get();
    }

    public void setRoundedRadius(double roundedRadius) {
        this.roundedRadiusProperty().set(roundedRadius);
    }

    public ObjectProperty<Pos> originPositionProperty() {
        if (this._originPositionProperty == null) {
            this._originPositionProperty = new SimpleObjectProperty((Object)Pos.CENTER);
        }
        return this._originPositionProperty;
    }

    public Pos getOriginPosition() {
        return (Pos)this.originPositionProperty().get();
    }

    public void setOriginPosition(Pos pos) {
        this.originPositionProperty().set((Object)pos);
    }

    @Override
    public Insets getContentPadding() {
        return new Insets(0.0);
    }

    @Override
    public Point2D getOriginPoint() {
        double width = this.getWidth();
        double height = this.getHeight();
        Pos originPosition = this.getOriginPosition();
        switch (originPosition) {
            case TOP_LEFT: {
                return new Point2D(0.0, 0.0);
            }
            case TOP_CENTER: {
                return new Point2D(width / 2.0, 0.0);
            }
            case TOP_RIGHT: {
                return new Point2D(width, 0.0);
            }
            case BASELINE_LEFT: 
            case CENTER_LEFT: {
                return new Point2D(0.0, height / 2.0);
            }
            case CENTER: 
            case BASELINE_CENTER: {
                return new Point2D(width / 2.0, height / 2.0);
            }
            case CENTER_RIGHT: 
            case BASELINE_RIGHT: {
                return new Point2D(width, height / 2.0);
            }
            case BOTTOM_LEFT: {
                return new Point2D(0.0, height);
            }
            case BOTTOM_CENTER: {
                return new Point2D(width / 2.0, height);
            }
            case BOTTOM_RIGHT: {
                return new Point2D(width, height);
            }
        }
        return null;
    }

    protected void createPath() {
        this.getElements().clear();
        this.setStrokeType(StrokeType.INSIDE);
        MoveTo startPoint = new MoveTo();
        startPoint.xProperty().bind((ObservableValue)this.roundedRadiusProperty());
        startPoint.setY(0.0);
        HLineTo topLine = new HLineTo();
        topLine.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
        ArcTo trArc = new ArcTo();
        trArc.setSweepFlag(true);
        trArc.xProperty().bind((ObservableValue)this.widthProperty());
        trArc.yProperty().bind((ObservableValue)this.roundedRadiusProperty());
        trArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
        trArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
        VLineTo rightLine = new VLineTo();
        rightLine.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
        ArcTo brArc = new ArcTo();
        brArc.setSweepFlag(true);
        brArc.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
        brArc.yProperty().bind((ObservableValue)this.heightProperty());
        brArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
        brArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
        HLineTo bottomLine = new HLineTo();
        bottomLine.xProperty().bind((ObservableValue)this.roundedRadiusProperty());
        ArcTo blArc = new ArcTo();
        blArc.setSweepFlag(true);
        blArc.setX(0.0);
        blArc.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
        blArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
        blArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
        VLineTo leftLine = new VLineTo();
        leftLine.yProperty().bind((ObservableValue)this.roundedRadiusProperty());
        ArcTo tlArc = new ArcTo();
        tlArc.setSweepFlag(true);
        tlArc.xProperty().bind((ObservableValue)startPoint.xProperty());
        tlArc.yProperty().bind((ObservableValue)startPoint.yProperty());
        tlArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
        tlArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
        this.getElements().addAll((Object[])new PathElement[]{startPoint, topLine, trArc, rightLine, brArc, bottomLine, blArc, leftLine, tlArc});
    }
}

