/*
 * Decompiled with CFR 0.152.
 */
package com.fxexperience.javafx.animation;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.util.Duration;

public class CachedTimelineTransition
extends Transition {
    protected static final Interpolator WEB_EASE = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
    protected final Node node;
    protected Timeline timeline;
    private boolean oldCache = false;
    private CacheHint oldCacheHint = CacheHint.DEFAULT;
    private final boolean useCache;

    public CachedTimelineTransition(Node node, Timeline timeline) {
        this(node, timeline, true);
    }

    public CachedTimelineTransition(Node node, Timeline timeline, boolean useCache) {
        this.node = node;
        this.timeline = timeline;
        this.useCache = useCache;
        this.statusProperty().addListener((ChangeListener)new ChangeListener<Animation.Status>(){

            public void changed(ObservableValue<? extends Animation.Status> ov, Animation.Status t, Animation.Status newStatus) {
                switch (newStatus) {
                    case RUNNING: {
                        CachedTimelineTransition.this.starting();
                        break;
                    }
                    default: {
                        CachedTimelineTransition.this.stopping();
                    }
                }
            }
        });
    }

    protected void starting() {
        if (this.useCache) {
            this.oldCache = this.node.isCache();
            this.oldCacheHint = this.node.getCacheHint();
            this.node.setCache(true);
            this.node.setCacheHint(CacheHint.SPEED);
        }
    }

    protected void stopping() {
        if (this.useCache) {
            this.node.setCache(this.oldCache);
            this.node.setCacheHint(this.oldCacheHint);
        }
    }

    protected void interpolate(double d) {
        this.timeline.playFrom(Duration.seconds((double)d));
        this.timeline.stop();
    }
}

