/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.impl.read.ColumnToFieldMapper;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.schema.GroupType;

class GroupFieldsMapper {
    private final Class<?> recordClass;
    private final Map<String, Integer> fieldIndex = new HashMap<String, Integer>();
    private final Map<String, RecordComponent> fieldType = new HashMap<String, RecordComponent>();

    GroupFieldsMapper(GroupType schema, Class<?> recordClass, ColumnToFieldMapper columnToFieldMapper) {
        this.recordClass = recordClass;
        RecordComponent[] components = recordClass.getRecordComponents();
        Map<String, ColumnToFieldMapper.NameMap> mapFields = columnToFieldMapper.mapFields(schema, components);
        int cont = 0;
        for (RecordComponent recordComponent : components) {
            ColumnToFieldMapper.NameMap mapping = mapFields.get(recordComponent.getName());
            if (mapping != null) {
                String name = mapping.parquetType().getName();
                this.fieldIndex.put(name, cont);
                this.fieldType.put(name, recordComponent);
            }
            ++cont;
        }
    }

    public int getIndex(String name) {
        Integer idx = this.fieldIndex.get(name);
        if (idx == null) {
            throw new RuntimeException("Field " + name + " not present in class " + String.valueOf(this.recordClass));
        }
        return idx;
    }

    public RecordComponent getRecordComponent(String name) {
        RecordComponent rc = this.fieldType.get(name);
        if (rc == null) {
            throw new RuntimeException("Field " + name + " not present in class " + String.valueOf(this.recordClass));
        }
        return rc;
    }
}

