/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.CookiePreference;
import com.amazonaws.services.cloudfront.model.transform.CookieNamesStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookiePreferenceStaxUnmarshaller
implements Unmarshaller<CookiePreference, StaxUnmarshallerContext> {
    private static CookiePreferenceStaxUnmarshaller instance;

    @Override
    public CookiePreference unmarshall(StaxUnmarshallerContext context) throws Exception {
        CookiePreference cookiePreference = new CookiePreference();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cookiePreference;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Forward", targetDepth)) {
                    cookiePreference.setForward(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("WhitelistedNames", targetDepth)) continue;
                cookiePreference.setWhitelistedNames(CookieNamesStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cookiePreference;
    }

    public static CookiePreferenceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CookiePreferenceStaxUnmarshaller();
        }
        return instance;
    }
}

