/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access;

import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TableInfo {
    private String tableName;
    private AttributeDefinition hashKey;
    private AttributeDefinition rangeKey;
    private Map<String, AttributeDefinition> lsiKeys;
    private ProvisionedThroughput throughput;
    private Map<String, LocalSecondaryIndex> lsiMap;
    private long creationDateTime;
    private Long lastDecreaseDateTime;
    private Long lastIncreaseDateTime;
    private long numberOfDecreasesToday;

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> indexes, ProvisionedThroughput throughput) {
        this.tableName = tableName;
        this.hashKey = hashKey;
        this.rangeKey = rangeKey;
        this.lsiMap = new HashMap<String, LocalSecondaryIndex>();
        this.lsiKeys = new HashMap<String, AttributeDefinition>();
        if (indexes != null) {
            for (LocalSecondaryIndex curIndex : indexes) {
                String curIndexName = curIndex.getIndexName();
                KeySchemaElement curIndexRangeElement = (KeySchemaElement)curIndex.getKeySchema().get(1);
                this.lsiKeys.put(curIndexName, LocalDBUtils.findAttributeDefinition(curIndexRangeElement, allAttributes));
                this.lsiMap.put(curIndexName, curIndex);
            }
        }
        this.throughput = throughput;
    }

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> indexes, ProvisionedThroughput throughput, long creationDateTime) {
        this(tableName, hashKey, rangeKey, allAttributes, indexes, throughput);
        this.creationDateTime = creationDateTime;
        this.lastDecreaseDateTime = null;
        this.lastIncreaseDateTime = null;
        this.numberOfDecreasesToday = 0L;
    }

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> indexes, ProvisionedThroughput throughput, long creationDateTime, Long lastDecreaseDateTime, Long lastIncreaseDateTime, long numberOfDecreasesToday) {
        this(tableName, hashKey, rangeKey, allAttributes, indexes, throughput);
        this.creationDateTime = creationDateTime;
        this.lastDecreaseDateTime = lastDecreaseDateTime;
        this.lastIncreaseDateTime = lastIncreaseDateTime;
        this.numberOfDecreasesToday = numberOfDecreasesToday;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ProvisionedThroughput getThroughput() {
        return this.throughput;
    }

    public boolean hasRangeKey() {
        return this.rangeKey != null;
    }

    public AttributeDefinition getHashKey() {
        return this.hashKey;
    }

    public AttributeDefinition getRangeKey() {
        return this.rangeKey;
    }

    public AttributeDefinition getIndexRangeKey(String indexName) {
        return this.lsiKeys.get(indexName);
    }

    public boolean hasIndex(String indexName) {
        return this.lsiKeys.containsKey(indexName);
    }

    public long getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<String> getIndexNames() {
        return new ArrayList<String>(this.lsiMap.keySet());
    }

    public void setCreationDateTime(long curTime) {
        this.creationDateTime = curTime;
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        HashSet<AttributeDefinition> attrDefSet = new HashSet<AttributeDefinition>();
        attrDefSet.add(this.hashKey);
        if (this.rangeKey != null) {
            attrDefSet.add(this.rangeKey);
            for (String lsiName : this.lsiKeys.keySet()) {
                attrDefSet.add(this.lsiKeys.get(lsiName));
            }
        }
        ArrayList<AttributeDefinition> attrDefList = new ArrayList<AttributeDefinition>(attrDefSet);
        return attrDefList;
    }

    public List<KeySchemaElement> getKeySchema() {
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(new KeySchemaElement().withAttributeName(this.hashKey.getAttributeName()).withKeyType(KeyType.HASH));
        if (this.rangeKey != null) {
            keySchema.add(new KeySchemaElement().withAttributeName(this.rangeKey.getAttributeName()).withKeyType(KeyType.RANGE));
        }
        return keySchema;
    }

    public ProvisionedThroughputDescription getThroughputDescription() {
        return new ProvisionedThroughputDescription().withReadCapacityUnits(this.throughput.getReadCapacityUnits()).withWriteCapacityUnits(this.throughput.getWriteCapacityUnits()).withLastDecreaseDateTime(this.lastDecreaseDateTime == null ? null : new Date(this.lastDecreaseDateTime)).withLastIncreaseDateTime(this.lastIncreaseDateTime == null ? null : new Date(this.lastIncreaseDateTime)).withNumberOfDecreasesToday(Long.valueOf(this.numberOfDecreasesToday));
    }

    public List<LocalSecondaryIndexDescription> getIndexDescriptions() {
        if (this.lsiMap.size() == 0) {
            return null;
        }
        ArrayList<LocalSecondaryIndexDescription> indexDescList = new ArrayList<LocalSecondaryIndexDescription>();
        for (Map.Entry<String, LocalSecondaryIndex> entry : this.lsiMap.entrySet()) {
            LocalSecondaryIndex index = entry.getValue();
            indexDescList.add(new LocalSecondaryIndexDescription().withIndexName(index.getIndexName()).withKeySchema((Collection)index.getKeySchema()).withProjection(index.getProjection()).withIndexSizeBytes(Long.valueOf(0L)).withItemCount(Long.valueOf(0L)));
        }
        return indexDescList;
    }

    public Projection getProjection(String indexName) {
        return this.lsiMap.get(indexName).getProjection();
    }

    public AttributeDefinition getLsiRangeKey(String attrName) {
        for (Map.Entry<String, AttributeDefinition> entry : this.lsiKeys.entrySet()) {
            AttributeDefinition curDef = entry.getValue();
            if (!curDef.getAttributeName().equals(attrName)) continue;
            return curDef;
        }
        return null;
    }

    public List<LocalSecondaryIndex> getIndexes() {
        return new ArrayList<LocalSecondaryIndex>(this.lsiMap.values());
    }
}

