/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.access.DDBType;
import com.amazonaws.services.dynamodbv2.local.shared.access.ListTablesResultInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBComparisonOperator;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import com.amazonaws.services.dynamodbv2.local.shared.access.QueryResultInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.TableInfo;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionMessage;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionType;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class LocalDBClient
implements AmazonDynamoDB {
    private LocalDBAccess dbAccess;

    public LocalDBClient(LocalDBAccess dbAccess) {
        this.dbAccess = dbAccess;
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest) throws AmazonServiceException, AmazonClientException {
        if (batchGetItemRequest.getRequestItems() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_GET_NULL_REQUESTS.getMessage());
        }
        HashMap requestItems = new HashMap(batchGetItemRequest.getRequestItems());
        int count = 0;
        for (Map.Entry entry : batchGetItemRequest.getRequestItems().entrySet()) {
            String tableName = (String)entry.getKey();
            KeysAndAttributes requests = (KeysAndAttributes)entry.getValue();
            count = this.validateBatchGetEntry(tableName, requests, count);
        }
        BatchGetItemResult batchGetResult = new BatchGetItemResult();
        HashMap<String, List<Map<String, AttributeValue>>> responses = new HashMap<String, List<Map<String, AttributeValue>>>();
        HashMap<String, KeysAndAttributes> unprocessedKeys = new HashMap<String, KeysAndAttributes>();
        long totalSize = 0L;
        for (Map.Entry entry : batchGetItemRequest.getRequestItems().entrySet()) {
            String tableName = (String)entry.getKey();
            KeysAndAttributes requests = (KeysAndAttributes)entry.getValue();
            totalSize = this.doBatchGet(tableName, requests, responses, unprocessedKeys, totalSize);
        }
        batchGetResult.setResponses(responses);
        batchGetResult.setUnprocessedKeys(unprocessedKeys);
        return batchGetResult;
    }

    /*
     * Unable to fully structure code
     */
    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) throws AmazonServiceException, AmazonClientException {
        block21: {
            if (batchWriteItemRequest.getRequestItems() == null || batchWriteItemRequest.getRequestItems().isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_NULL_REQUESTS.getMessage());
            }
            count = 0;
            totalRequestSize = 0L;
            requestItems = new HashMap<K, V>(batchWriteItemRequest.getRequestItems());
            putsToMake = new HashMap<String, ArrayList<Map<String, AttributeValue>>>();
            deletesToMake = new HashMap<String, ArrayList<Map<String, AttributeValue>>>();
            tableNameToHashKeyNameMap = new HashMap<String, String>();
            for (Map.Entry<K, V> entry : requestItems.entrySet()) {
                tableName = (String)entry.getKey();
                this.validateTableName(tableName);
                info = this.validateTableExists(tableName);
                requests = (List)entry.getValue();
                if (requests == null || requests.isEmpty()) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_NULL_REQUEST_ENTRY.getMessage());
                }
                if ((count += requests.size()) > 25) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_TOO_MANY_REQUESTS.getMessage());
                }
                putsList = new ArrayList<Map<String, AttributeValue>>();
                deletesList = new ArrayList<Map<String, AttributeValue>>();
                keySet = new HashSet<Map<String, AttributeValue>>();
                for (WriteRequest writeRequest : requests) {
                    totalRequestSize = this.validateBatchWriteWriteRequest(writeRequest, (TableInfo)info, (List<Map<String, AttributeValue>>)putsList, (List<Map<String, AttributeValue>>)deletesList, (Set<Map<String, AttributeValue>>)keySet, totalRequestSize);
                }
                putsToMake.put(tableName, putsList);
                deletesToMake.put(tableName, deletesList);
                tableNameToHashKeyNameMap.put(tableName, info.getHashKey().getAttributeName());
            }
            batchWriteResult = new BatchWriteItemResult();
            unprocessedItems = new HashMap<String, ArrayList<E>>();
            try {
                for (Map.Entry<K, V> entry : putsToMake.entrySet()) {
                    tableName = (String)entry.getKey();
                    records = (List)entry.getValue();
                    while (!records.isEmpty()) {
                        lock = this.dbAccess.getLockForTable(tableName).readLock();
                        lock.lock();
                        try {
                            curRecord = (Map)records.get(0);
                            this.dbAccess.putRecord(tableName, curRecord, (AttributeValue)curRecord.get(tableNameToHashKeyNameMap.get(tableName)));
                            records.remove(0);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                for (Map.Entry<K, V> entry : deletesToMake.entrySet()) {
                    tableName = (String)entry.getKey();
                    keys = (List)entry.getValue();
                    while (!keys.isEmpty()) {
                        lock = this.dbAccess.getLockForTable(tableName).readLock();
                        lock.lock();
                        try {
                            curKey = (Map)keys.get(0);
                            this.dbAccess.deleteRecord(tableName, curKey);
                            keys.remove(0);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                break block21;
            }
            catch (LocalDBAccessException accessException) {
                ** for (entry : deletesToMake.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                tableName = (String)entry.getKey();
                tableRequests = new ArrayList<WriteRequest>();
                for (Map primaryKey : (List)entry.getValue()) {
                    tableRequests.add(new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(primaryKey)));
                }
                unprocessedItems.put(tableName, tableRequests);
                continue;
            }
lbl79:
            // 2 sources

            for (Map.Entry<K, V> entry : putsToMake.entrySet()) {
                tableName = (String)entry.getKey();
                tableRequests = unprocessedItems.containsKey(tableName) != false ? (List)unprocessedItems.get(tableName) : new ArrayList<E>();
                for (Map record : (List)entry.getValue()) {
                    tableRequests.add(new WriteRequest().withPutRequest(new PutRequest().withItem(record)));
                }
                unprocessedItems.put(tableName, tableRequests);
            }
        }
        batchWriteResult.setUnprocessedItems(unprocessedItems);
        return batchWriteResult;
    }

    public CreateTableResult createTable(CreateTableRequest createTableRequest) throws AmazonServiceException, AmazonClientException {
        int maxSize;
        String tableName = createTableRequest.getTableName();
        this.validateTableName(tableName);
        List keySchema = createTableRequest.getKeySchema();
        this.validateKeySchema(keySchema);
        int numKeys = keySchema.size();
        boolean hashAndRangeKey = numKeys == 2;
        List allAttributes = createTableRequest.getAttributeDefinitions();
        this.validateAttributeDefinitions(allAttributes);
        AttributeDefinition hashKey = LocalDBUtils.findAttributeDefinition((KeySchemaElement)keySchema.get(0), allAttributes);
        if (hashKey == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_HASH_KEY.getMessage());
        }
        AttributeDefinition rangeKey = null;
        if (hashAndRangeKey && (rangeKey = LocalDBUtils.findAttributeDefinition((KeySchemaElement)keySchema.get(1), allAttributes)) == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_RANGE_KEY.getMessage());
        }
        List indexes = createTableRequest.getLocalSecondaryIndexes();
        if (!hashAndRangeKey && indexes != null && indexes.size() > 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_LSI_ALLOWED.getMessage());
        }
        int numLSIKeys = this.validateLSISchema(indexes, hashKey.getAttributeName(), allAttributes, rangeKey);
        int n = maxSize = hashAndRangeKey ? 2 + numLSIKeys : 1;
        if (allAttributes.size() > maxSize) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_ATTRIBUTES.getMessage());
        }
        ProvisionedThroughput throughput = createTableRequest.getProvisionedThroughput();
        this.validateProvisionedThroughput(throughput);
        this.validateProvisionedThroughputIncrease(tableName, throughput);
        Lock lock = this.dbAccess.getLockForTable(tableName).writeLock();
        lock.lock();
        try {
            this.validateTableNotExists(tableName);
            this.dbAccess.createTable(tableName, hashKey, rangeKey, allAttributes, indexes, throughput);
        }
        finally {
            lock.unlock();
        }
        TableDescription newTableDesc = this.getTableDescriptionHelper(tableName);
        newTableDesc.setItemCount(Long.valueOf(0L));
        newTableDesc.setTableSizeBytes(Long.valueOf(0L));
        CreateTableResult createResult = new CreateTableResult().withTableDescription(newTableDesc);
        return createResult;
    }

    public DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = deleteItemRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        Map expected = deleteItemRequest.getExpected();
        ReturnValue returnVals = this.validateReturnType(deleteItemRequest.getReturnValues(), false);
        if (deleteItemRequest.getKey() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        HashMap<String, AttributeValue> primaryKey = new HashMap<String, AttributeValue>(deleteItemRequest.getKey());
        this.validateGetKey(primaryKey, tableInfo);
        Map<String, AttributeValue> oldItem = null;
        ReadWriteLock lockForTable = this.dbAccess.getLockForTable(tableName);
        Lock lock = expected == null && returnVals != ReturnValue.ALL_OLD ? lockForTable.readLock() : lockForTable.writeLock();
        lock.lock();
        try {
            if (returnVals == ReturnValue.ALL_OLD || expected != null) {
                oldItem = this.dbAccess.getRecord(tableName, primaryKey);
            }
            if (expected != null) {
                this.validateExpectedValues(expected);
                this.checkExpectations(oldItem, expected);
            }
            this.dbAccess.deleteRecord(tableName, primaryKey);
        }
        finally {
            lock.unlock();
        }
        DeleteItemResult deleteResult = new DeleteItemResult();
        if (oldItem != null) {
            deleteResult.setAttributes(oldItem);
        }
        return deleteResult;
    }

    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = deleteTableRequest.getTableName();
        this.validateTableName(tableName);
        TableDescription description = this.getTableDescriptionHelper(tableName);
        description = this.fillDescriptionHelper(description);
        Lock lock = this.dbAccess.getLockForTable(tableName).writeLock();
        lock.lock();
        try {
            this.dbAccess.deleteTable(tableName);
        }
        finally {
            lock.unlock();
        }
        DeleteTableResult deleteResult = new DeleteTableResult().withTableDescription(description);
        return deleteResult;
    }

    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = describeTableRequest.getTableName();
        this.validateTableName(tableName);
        TableDescription description = this.getTableDescriptionHelper(tableName);
        description = this.fillDescriptionHelper(description);
        DescribeTableResult describeResult = new DescribeTableResult().withTable(description);
        return describeResult;
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return null;
    }

    public GetItemResult getItem(GetItemRequest getItemRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = getItemRequest.getTableName();
        this.validateTableName(tableName);
        this.validateAttributesToGet(getItemRequest.getAttributesToGet());
        TableInfo tableInfo = this.validateTableExists(tableName);
        if (getItemRequest.getKey() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        HashMap<String, AttributeValue> primaryKey = new HashMap<String, AttributeValue>(getItemRequest.getKey());
        this.validateGetKey(primaryKey, tableInfo);
        Map<String, AttributeValue> item = this.dbAccess.getRecord(tableName, primaryKey);
        GetItemResult getResult = new GetItemResult().withItem(LocalDBUtils.filterAttributes(item, getItemRequest.getAttributesToGet()));
        return getResult;
    }

    public ListTablesResult listTables() throws AmazonServiceException, AmazonClientException {
        ListTablesResultInfo initResults = this.dbAccess.listTables(null, 100L);
        ListTablesResult listResult = new ListTablesResult().withTableNames(initResults.getTableNames()).withLastEvaluatedTableName(initResults.getLastEvaluatedTableName());
        return listResult;
    }

    public ListTablesResult listTables(ListTablesRequest listTablesRequest) throws AmazonServiceException, AmazonClientException {
        long limit = this.validateLimitValueListTables(listTablesRequest.getLimit());
        String exclusiveStartTableName = listTablesRequest.getExclusiveStartTableName();
        if (exclusiveStartTableName != null) {
            this.validateTableName(exclusiveStartTableName);
            this.validateTableExists(exclusiveStartTableName);
        }
        ListTablesResultInfo initResults = this.dbAccess.listTables(exclusiveStartTableName, limit);
        ListTablesResult listResult = new ListTablesResult().withTableNames(initResults.getTableNames()).withLastEvaluatedTableName(initResults.getLastEvaluatedTableName());
        return listResult;
    }

    public PutItemResult putItem(PutItemRequest putItemRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = putItemRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        ReturnValue returnVals = this.validateReturnType(putItemRequest.getReturnValues(), false);
        if (putItemRequest.getItem() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PUT_NULL.getMessage());
        }
        HashMap<String, AttributeValue> record = new HashMap<String, AttributeValue>(putItemRequest.getItem());
        Map<String, AttributeValue> key = this.validatePutItem(record, tableInfo);
        Map<String, AttributeValue> oldItem = null;
        Map expected = null;
        if (putItemRequest.getExpected() != null) {
            expected = putItemRequest.getExpected();
        }
        ReadWriteLock lockForTable = this.dbAccess.getLockForTable(tableName);
        Lock lock = expected == null ? lockForTable.readLock() : lockForTable.writeLock();
        lock.lock();
        try {
            if (returnVals == ReturnValue.ALL_OLD || expected != null) {
                oldItem = this.dbAccess.getRecord(tableName, key);
            }
            if (expected != null) {
                this.validateExpectedValues(expected);
                this.checkExpectations(oldItem, expected);
            }
            this.dbAccess.putRecord(tableName, record, key.get(tableInfo.getHashKey().getAttributeName()));
        }
        finally {
            lock.unlock();
        }
        PutItemResult putResult = new PutItemResult();
        if (returnVals == ReturnValue.ALL_OLD) {
            putResult.setAttributes(oldItem);
        }
        return putResult;
    }

    public QueryResult query(QueryRequest queryRequest) throws AmazonServiceException, AmazonClientException {
        Map<String, AttributeValue> lastKey;
        String tableName = queryRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        if (!tableInfo.hasRangeKey()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_QUERY_TABLE.getMessage());
        }
        long limit = this.validateLimitValue(queryRequest.getLimit());
        Boolean asc = queryRequest.getScanIndexForward();
        boolean ascending = asc == null ? true : asc;
        String indexName = queryRequest.getIndexName();
        if (indexName != null && !tableInfo.hasIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_QUERY_NON_EXISTENT_INDEX.getMessage());
        }
        List<String> attributesToGet = null;
        Select select = this.validateSelect(queryRequest.getSelect(), queryRequest.getAttributesToGet(), indexName);
        if (select == Select.SPECIFIC_ATTRIBUTES) {
            attributesToGet = queryRequest.getAttributesToGet();
        } else if (select == Select.ALL_PROJECTED_ATTRIBUTES) {
            Projection indexProjection = tableInfo.getProjection(indexName);
            switch (ProjectionType.fromValue((String)indexProjection.getProjectionType())) {
                case INCLUDE: {
                    attributesToGet = this.getKeyAttributes(tableInfo, indexName);
                    attributesToGet.addAll(indexProjection.getNonKeyAttributes());
                    break;
                }
                case KEYS_ONLY: {
                    attributesToGet = this.getKeyAttributes(tableInfo, indexName);
                    break;
                }
                case ALL: {
                    attributesToGet = null;
                    break;
                }
                default: {
                    LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
                    break;
                }
            }
        } else {
            attributesToGet = null;
        }
        if (queryRequest.getKeyConditions() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_QUERY_NO_CONDITIONS.getMessage());
        }
        HashMap<String, Condition> conditions = new HashMap<String, Condition>(queryRequest.getKeyConditions());
        if (conditions.size() > 2) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_QUERY_EXCESS_CONDITIONS.getMessage());
        }
        AttributeDefinition hashKeyDef = tableInfo.getHashKey();
        this.validateHashKeyCondition(hashKeyDef, conditions);
        AttributeDefinition rangeKeyDef = indexName == null ? tableInfo.getRangeKey() : tableInfo.getIndexRangeKey(indexName);
        this.validateRangeKeyCondition(rangeKeyDef, conditions);
        HashMap<String, AttributeValue> exclusiveStartKey = null;
        if (queryRequest.getExclusiveStartKey() != null) {
            exclusiveStartKey = new HashMap<String, AttributeValue>(queryRequest.getExclusiveStartKey());
        }
        ArrayList<AttributeDefinition> keyDefs = new ArrayList<AttributeDefinition>();
        keyDefs.add(tableInfo.getHashKey());
        keyDefs.add(tableInfo.getRangeKey());
        if (indexName != null) {
            keyDefs.add(tableInfo.getIndexRangeKey(indexName));
        }
        this.validateExclusiveStartKeyQuery(exclusiveStartKey, keyDefs, conditions, ascending);
        QueryResultInfo results = this.dbAccess.queryRecords(tableName, indexName, conditions, exclusiveStartKey, limit, null, ascending, null, null, false);
        QueryResult queryResult = new QueryResult();
        int itemsProcessed = 0;
        long totalSize = 0L;
        List<Map<String, AttributeValue>> initItemList = results.getReturnedRecords();
        while (itemsProcessed < initItemList.size()) {
            if ((totalSize += LocalDBUtils.getItemSizeBytes(initItemList.get(itemsProcessed))) >= 0x100000L) {
                ++itemsProcessed;
                break;
            }
            ++itemsProcessed;
        }
        queryResult.setCount(Integer.valueOf(itemsProcessed));
        if (select != Select.COUNT) {
            ArrayList<Map<String, AttributeValue>> filteredList = new ArrayList<Map<String, AttributeValue>>();
            filteredList.addAll(LocalDBUtils.filterAttributesList(initItemList.subList(0, itemsProcessed), attributesToGet));
            queryResult.setItems(filteredList);
        }
        Map<String, AttributeValue> lastItem = itemsProcessed > 0 && itemsProcessed < results.getReturnedRecords().size() ? results.getReturnedRecords().get(itemsProcessed - 1) : results.getLastEvaluatedItem();
        ArrayList<String> keyAttrs = new ArrayList<String>();
        keyAttrs.add(tableInfo.getHashKey().getAttributeName());
        keyAttrs.add(tableInfo.getRangeKey().getAttributeName());
        if (indexName != null) {
            keyAttrs.add(tableInfo.getIndexRangeKey(indexName).getAttributeName());
        }
        if ((lastKey = LocalDBUtils.filterAttributes(lastItem, keyAttrs)) != null && this.exclusiveStartFitsConditions(lastKey, conditions, ascending)) {
            queryResult.setLastEvaluatedKey(lastKey);
        } else {
            queryResult.setLastEvaluatedKey(null);
        }
        return queryResult;
    }

    private List<String> getKeyAttributes(TableInfo tableInfo, String indexName) {
        ArrayList<String> attributesToGet = new ArrayList<String>();
        attributesToGet.add(tableInfo.getHashKey().getAttributeName());
        attributesToGet.add(tableInfo.getRangeKey().getAttributeName());
        String indexRangeKeyName = tableInfo.getIndexRangeKey(indexName).getAttributeName();
        if (!((String)attributesToGet.get(1)).equals(indexRangeKeyName)) {
            attributesToGet.add(indexRangeKeyName);
        }
        return attributesToGet;
    }

    public ScanResult scan(ScanRequest scanRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = scanRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo info = this.validateTableExists(tableName);
        long limit = this.validateLimitValue(scanRequest.getLimit());
        List attributesToGet = null;
        Select select = this.validateSelect(scanRequest.getSelect(), scanRequest.getAttributesToGet(), null);
        if (select == Select.SPECIFIC_ATTRIBUTES) {
            attributesToGet = scanRequest.getAttributesToGet();
        } else if (select == Select.ALL_PROJECTED_ATTRIBUTES) {
            LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
        } else {
            attributesToGet = null;
        }
        Map<String, Condition> scanFilter = this.validateScanFilters(scanRequest);
        HashMap<String, AttributeValue> exclusiveStartKey = null;
        if (scanRequest.getExclusiveStartKey() != null) {
            exclusiveStartKey = new HashMap<String, AttributeValue>(scanRequest.getExclusiveStartKey());
        }
        ArrayList<AttributeDefinition> keyDefs = new ArrayList<AttributeDefinition>();
        keyDefs.add(info.getHashKey());
        if (info.getRangeKey() != null) {
            keyDefs.add(info.getRangeKey());
        }
        this.validateExclusiveStartKey(exclusiveStartKey, keyDefs);
        byte[] beginHash = null;
        byte[] endHash = null;
        if (scanRequest.getSegment() != null | scanRequest.getTotalSegments() != null) {
            this.validateParallelScanRequest(scanRequest.getSegment(), scanRequest.getTotalSegments());
            beginHash = LocalDBClient.getSegmentBeginningHashKey(scanRequest.getTotalSegments(), scanRequest.getSegment());
            endHash = LocalDBClient.getSegmentEndHashKey(scanRequest.getTotalSegments(), scanRequest.getSegment());
            this.validateParallelScanExclusiveStartKey(beginHash, endHash, exclusiveStartKey, info.getHashKey());
        }
        QueryResultInfo results = this.dbAccess.queryRecords(tableName, null, null, exclusiveStartKey, limit, null, true, beginHash, endHash, true);
        ScanResult scanResult = new ScanResult();
        int itemsProcessed = 0;
        long totalSize = 0L;
        List<Map<String, AttributeValue>> fetchedItems = results.getReturnedRecords();
        ArrayList<Map<String, AttributeValue>> matchingItems = new ArrayList<Map<String, AttributeValue>>();
        for (Map<String, AttributeValue> item : fetchedItems) {
            if (this.verifyItemConditions(item, scanFilter)) {
                long itemSize;
                if (select != Select.COUNT) {
                    Map<String, AttributeValue> filteredItem = LocalDBUtils.filterAttributes(item, attributesToGet);
                    if (!filteredItem.isEmpty()) {
                        matchingItems.add(filteredItem);
                    }
                } else {
                    matchingItems.add(item);
                }
                if (totalSize + (itemSize = LocalDBUtils.getItemSizeBytes(item)) >= 0x100000L) {
                    ++itemsProcessed;
                    break;
                }
                totalSize += itemSize;
            }
            ++itemsProcessed;
        }
        if (select != Select.COUNT) {
            scanResult.setItems(matchingItems);
        }
        scanResult.setCount(Integer.valueOf(matchingItems.size()));
        scanResult.setScannedCount(Integer.valueOf(fetchedItems.size()));
        Map<String, AttributeValue> lastItem = itemsProcessed > 0 && itemsProcessed < results.getReturnedRecords().size() ? results.getReturnedRecords().get(itemsProcessed - 1) : results.getLastEvaluatedItem();
        ArrayList<String> keyAttrs = new ArrayList<String>();
        keyAttrs.add(info.getHashKey().getAttributeName());
        if (info.hasRangeKey()) {
            keyAttrs.add(info.getRangeKey().getAttributeName());
        }
        Map<String, AttributeValue> lastKey = LocalDBUtils.filterAttributes(lastItem, keyAttrs);
        scanResult.setLastEvaluatedKey(lastKey);
        return scanResult;
    }

    private void validateParallelScanExclusiveStartKey(byte[] beginHash, byte[] endHash, Map<String, AttributeValue> exclusiveStartKey, AttributeDefinition hashKeyDef) {
        if (exclusiveStartKey == null) {
            return;
        }
        byte[] exclusiveStartHashVal = LocalDBUtils.getHashValue(exclusiveStartKey.get(hashKeyDef.getAttributeName()));
        if (LocalDBUtils.compareUnsignedByteArrays(exclusiveStartHashVal, beginHash) < 0 || LocalDBUtils.compareUnsignedByteArrays(exclusiveStartHashVal, endHash) > 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START_KEY_FOR_SCAN.getMessage());
        }
    }

    private void validateParallelScanRequest(Integer segment, Integer totalSegments) {
        if (segment == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SEGMENT_NOT_SET.getMessage());
        }
        if (totalSegments == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOTAL_SEGMENTS_NOT_SET.getMessage());
        }
        if (segment < 0 || segment >= totalSegments) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SEGMENT_VALUE.getMessage());
        }
        if (totalSegments <= 0 || totalSegments > 4096) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_TOTAL_SEGMENTS_VALUE.getMessage());
        }
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION, "Regions are not supported in LocalDynamoDB");
    }

    public void setRegion(Region region) throws IllegalArgumentException {
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION, "Regions are not supported in LocalDynamoDB");
    }

    public void shutdown() {
        this.dbAccess.close();
    }

    public UpdateItemResult updateItem(UpdateItemRequest updateItemRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = updateItemRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        Map expected = updateItemRequest.getExpected();
        ReturnValue returnVals = this.validateReturnType(updateItemRequest.getReturnValues(), true);
        HashMap<String, AttributeValueUpdate> updatesToMake = null;
        if (updateItemRequest.getAttributeUpdates() != null) {
            updatesToMake = new HashMap<String, AttributeValueUpdate>(updateItemRequest.getAttributeUpdates());
        }
        if (updateItemRequest.getKey() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        HashMap<String, AttributeValue> primaryKey = new HashMap<String, AttributeValue>(updateItemRequest.getKey());
        this.validateGetKey(primaryKey, tableInfo);
        HashMap<String, AttributeValue> oldItem = null;
        Map<String, AttributeValue> item = null;
        Lock lock = this.dbAccess.getLockForTable(tableName).writeLock();
        lock.lock();
        try {
            item = this.dbAccess.getRecord(tableName, primaryKey);
            if (item == null) {
                oldItem = null;
                item = new HashMap<String, AttributeValue>(primaryKey);
            } else {
                oldItem = new HashMap<String, AttributeValue>();
                for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
                    oldItem.put(entry.getKey(), entry.getValue());
                }
            }
            if (expected != null) {
                this.validateExpectedValues(expected);
                this.checkExpectations(oldItem, expected);
            }
            this.validateAttributeUpdates(updatesToMake, tableInfo, oldItem);
            this.doUpdates(updatesToMake, item);
            if (LocalDBUtils.getItemSizeBytes(item) > 65536L) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ITEM_TOO_BIG.getMessage());
            }
            this.dbAccess.putRecord(tableName, item, (AttributeValue)updateItemRequest.getKey().get(tableInfo.getHashKey().getAttributeName()));
        }
        finally {
            lock.unlock();
        }
        UpdateItemResult updateResult = new UpdateItemResult().withAttributes(this.getReturnedValsFromUpdate(returnVals, updatesToMake, oldItem, item));
        return updateResult;
    }

    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = updateTableRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo info = this.validateTableExists(tableName);
        ProvisionedThroughput curThroughput = info.getThroughput();
        ProvisionedThroughput newThroughput = updateTableRequest.getProvisionedThroughput();
        this.validateProvisionedThroughput(newThroughput);
        if (newThroughput.getReadCapacityUnits() > curThroughput.getReadCapacityUnits() || newThroughput.getWriteCapacityUnits() > curThroughput.getWriteCapacityUnits()) {
            if (newThroughput.getReadCapacityUnits() > 2L * curThroughput.getReadCapacityUnits() || newThroughput.getWriteCapacityUnits() > 2L * curThroughput.getWriteCapacityUnits()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT.getMessage());
            }
            this.validateProvisionedThroughputIncrease(tableName, newThroughput);
        }
        Lock lock = this.dbAccess.getLockForTable(tableName).readLock();
        lock.lock();
        try {
            this.dbAccess.updateTable(tableName, newThroughput);
        }
        finally {
            lock.unlock();
        }
        TableDescription description = this.getTableDescriptionHelper(tableName);
        description = this.fillDescriptionHelper(description);
        UpdateTableResult updateResult = new UpdateTableResult().withTableDescription(description);
        return updateResult;
    }

    private TableInfo validateTableExists(String tableName) {
        TableInfo tableInfo = this.dbAccess.getTableInfo(tableName);
        if (tableInfo == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, LocalDBClientExceptionMessage.TABLE_DOES_NOT_EXIST.getMessage());
        }
        return tableInfo;
    }

    private void validateTableName(String tableName) {
        if (tableName == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_TABLE_NAME.getMessage());
        }
        if (tableName.length() < 3 || tableName.length() > 255) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_TABLE_NAME.getMessage());
        }
        if (!tableName.matches("[-a-zA-Z0-9._]*")) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_TABLE_NAME.getMessage());
        }
    }

    private void validateProvisionedThroughput(ProvisionedThroughput throughput) {
        if (throughput == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_NULL.getMessage());
        }
        Long readCapacity = throughput.getReadCapacityUnits();
        Long writeCapacity = throughput.getWriteCapacityUnits();
        if (readCapacity == null || writeCapacity == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES.getMessage());
        }
        if (readCapacity < 1L || writeCapacity < 1L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES.getMessage());
        }
    }

    private void validateProvisionedThroughputIncrease(String tableName, ProvisionedThroughput throughput) {
        if (throughput.getReadCapacityUnits() > 40000L || throughput.getWriteCapacityUnits() > 40000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_TABLE.getMessage());
        }
        long totalReadThroughput = 0L;
        long totalWriteThroughput = 0L;
        List<String> allTableNames = this.dbAccess.listTables(null, -1L).getTableNames();
        for (String table : allTableNames) {
            if (table.equals(tableName)) continue;
            ProvisionedThroughput existingThroughput = this.dbAccess.getTableInfo(table).getThroughput();
            totalReadThroughput += existingThroughput.getReadCapacityUnits().longValue();
            totalWriteThroughput += existingThroughput.getWriteCapacityUnits().longValue();
        }
        if ((totalReadThroughput += throughput.getReadCapacityUnits().longValue()) > 80000L || (totalWriteThroughput += throughput.getWriteCapacityUnits().longValue()) > 80000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_ACCOUNT.getMessage());
        }
    }

    private void validateKeySchema(List<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_KEY_SCHEMA.getMessage());
        }
        int size = keySchema.size();
        if (size > 2) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.KEY_SCHEMA_TOO_BIG.getMessage());
        }
        int numHashKeys = 0;
        int i = 0;
        while (i < size) {
            if (keySchema.get(i).getKeyType() == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.UNSPECIFIED_KEY_TYPE.getMessage());
            }
            if (keySchema.get(i).getAttributeName() == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_NAME.getMessage());
            }
            if (keySchema.get(i).getKeyType().equals(KeyType.HASH.toString())) {
                ++numHashKeys;
            }
            ++i;
        }
        if (numHashKeys == 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_HASH_KEY.getMessage());
        }
        if (numHashKeys == 2) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_HASH_KEYS.getMessage());
        }
        if (size == 2 && keySchema.get(1).getKeyType().equals(KeyType.HASH.toString())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCORRECT_KEY_SCHEMA_ORDER.getMessage());
        }
        if (size == 2 && keySchema.get(0).getAttributeName().equals(keySchema.get(1).getAttributeName())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICALLY_NAMED_KEYS.getMessage());
        }
    }

    private int validateLSISchema(List<LocalSecondaryIndex> lsiList, String hashKeyName, List<AttributeDefinition> allAttributes, AttributeDefinition rangeKeyDef) {
        if (lsiList == null) {
            return 0;
        }
        if (lsiList.size() > 5) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_LSI.getMessage());
        }
        HashSet<String> lsiNames = new HashSet<String>();
        HashSet<AttributeDefinition> lsiRangeKeys = new HashSet<AttributeDefinition>();
        int totalProjectedAttrs = 0;
        for (LocalSecondaryIndex lsi : lsiList) {
            String lsiName = lsi.getIndexName();
            this.validateTableName(lsiName);
            if (lsiNames.contains(lsiName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_NAME_LSI.getMessage());
            }
            if ((totalProjectedAttrs += this.validateProjection(lsi.getProjection())) > 20) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_PROJECTED.getMessage());
            }
            lsiNames.add(lsiName);
            List lsiSchema = lsi.getKeySchema();
            this.validateKeySchema(lsiSchema);
            if (lsiSchema.size() < 2) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI_NO_RANGE.getMessage());
            }
            KeySchemaElement lsiHashKey = (KeySchemaElement)lsiSchema.get(0);
            if (lsiHashKey == null || !lsiHashKey.getAttributeName().equals(hashKeyName) || !lsiHashKey.getKeyType().equals(KeyType.HASH.toString())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI.getMessage());
            }
            KeySchemaElement lsiRangeKey = (KeySchemaElement)lsiSchema.get(1);
            if (lsiRangeKey == null || !lsiRangeKey.getKeyType().equals(KeyType.RANGE.toString())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI_NO_RANGE.getMessage());
            }
            AttributeDefinition lsiRangeKeyDef = LocalDBUtils.findAttributeDefinition(lsiRangeKey, allAttributes);
            if (lsiRangeKeyDef == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_LSI_RANGE_KEY.getMessage());
            }
            if (lsiRangeKeyDef.equals((Object)rangeKeyDef)) continue;
            lsiRangeKeys.add(lsiRangeKeyDef);
        }
        return lsiRangeKeys.size();
    }

    private int validateProjection(Projection curProjection) {
        if (curProjection == null || curProjection.getProjectionType() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI_NO_PROJECTION.getMessage());
        }
        int projectedAttrs = 0;
        try {
            ProjectionType curProjectionType = ProjectionType.fromValue((String)curProjection.getProjectionType());
            if (curProjectionType == ProjectionType.INCLUDE) {
                List nonKeyAttrs = curProjection.getNonKeyAttributes();
                if (nonKeyAttrs == null || nonKeyAttrs.size() == 0) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_PROJECTED_ATTRS.getMessage());
                }
                HashSet<String> nonKeyNamesSet = new HashSet<String>();
                for (String attrName : nonKeyAttrs) {
                    this.validateAttributeName(attrName);
                    if (nonKeyNamesSet.contains(attrName)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICAL_ATTRIBUTE_NAMES.getMessage());
                    }
                    ++projectedAttrs;
                    nonKeyNamesSet.add(attrName);
                }
            } else if (curProjection.getNonKeyAttributes() != null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PROJECTED_ATTRS.getMessage());
            }
        }
        catch (IllegalArgumentException invalidException) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PROJECTION_TYPE.getMessage());
        }
        return projectedAttrs;
    }

    private void validateAttributeDefinitions(List<AttributeDefinition> attrDefs) {
        if (attrDefs == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_SCHEMA.getMessage());
        }
        HashSet<String> names = new HashSet<String>();
        for (AttributeDefinition curAttr : attrDefs) {
            String curName = curAttr.getAttributeName();
            this.validateAttributeName(curName);
            if (names.contains(curName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICAL_ATTRIBUTE_NAMES.getMessage());
            }
            names.add(curName);
            LocalDBUtils.getDataTypeOfAttributeDefinition(curAttr);
        }
    }

    private void validateAttributeName(String attrName) {
        if (attrName == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_NAME.getMessage());
        }
        int length = attrName.getBytes(StandardCharsets.UTF_8).length;
        if (length < 1 || length > 255) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ATTRIBUTE_NAME_TOO_LONG.getMessage());
        }
    }

    private Map<String, AttributeValue> validatePutItem(Map<String, AttributeValue> item, TableInfo tableInfo) {
        HashMap<String, AttributeValue> nonKeyAttrs = new HashMap<String, AttributeValue>(item);
        HashMap<String, AttributeValue> keyAttrs = new HashMap<String, AttributeValue>();
        this.validateKeyValue(item, tableInfo.getHashKey(), true, 2048L);
        String hashKeyName = tableInfo.getHashKey().getAttributeName();
        nonKeyAttrs.remove(hashKeyName);
        keyAttrs.put(hashKeyName, item.get(hashKeyName));
        if (tableInfo.hasRangeKey()) {
            this.validateKeyValue(item, tableInfo.getRangeKey(), true, 1024L);
            String rangeKeyName = tableInfo.getRangeKey().getAttributeName();
            nonKeyAttrs.remove(rangeKeyName);
            keyAttrs.put(rangeKeyName, item.get(rangeKeyName));
            for (String curIndex : tableInfo.getIndexNames()) {
                this.validateKeyValue(item, tableInfo.getIndexRangeKey(curIndex), false, null);
                nonKeyAttrs.remove(tableInfo.getIndexRangeKey(curIndex).getAttributeName());
            }
        }
        for (String nonKeyAttrName : nonKeyAttrs.keySet()) {
            AttributeValue nonKeyAttr = (AttributeValue)nonKeyAttrs.get(nonKeyAttrName);
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(nonKeyAttr);
            if (type == DDBType.N) {
                item.put(nonKeyAttrName, new AttributeValue().withN(LocalDBUtils.validateNumericValue(nonKeyAttr.getN()).toPlainString()));
                continue;
            }
            if (type != DDBType.NS) continue;
            item.put(nonKeyAttrName, new AttributeValue().withNS(LocalDBUtils.validateNumberSet(nonKeyAttr.getNS())));
        }
        if (LocalDBUtils.getItemSizeBytes(item) > 65536L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ITEM_TOO_BIG.getMessage());
        }
        return keyAttrs;
    }

    private void validateKeyValue(Map<String, AttributeValue> item, AttributeDefinition keyDef, boolean essential, Long maxSize) {
        String keyName = keyDef.getAttributeName();
        AttributeValue val = item.get(keyName);
        DDBType expectedType = LocalDBUtils.getDataTypeOfAttributeDefinition(keyDef);
        if (val == null) {
            if (essential) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_SPECIFED_KEY_VALUE.getMessage());
            }
            return;
        }
        DDBType valueType = LocalDBUtils.getDataTypeOfScalarAttributeValue(val);
        if (valueType != expectedType) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage());
        }
        if (valueType == DDBType.N) {
            item.put(keyName, new AttributeValue().withN(LocalDBUtils.validateNumericValue(val.getN()).toPlainString()));
        } else if (valueType == DDBType.NS) {
            item.put(keyName, new AttributeValue().withNS(LocalDBUtils.validateNumberSet(val.getNS())));
        }
        if (maxSize != null && LocalDBUtils.getAttributeValueSizeBytes(val) > maxSize) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.KEY_VALUE_TOO_BIG.getMessage());
        }
    }

    private void validateGetKey(Map<String, AttributeValue> conditions, TableInfo tableInfo) {
        if (conditions == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        int conditionsSize = conditions.size();
        if (conditionsSize > 2 || conditionsSize == 0 || conditionsSize == 2 && !tableInfo.hasRangeKey() || conditionsSize == 1 && tableInfo.hasRangeKey()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCONSISTENT_GET_CONDITION_SIZE.getMessage());
        }
        this.validateGetKeyValue(conditions, tableInfo.getHashKey());
        if (tableInfo.hasRangeKey()) {
            this.validateGetKeyValue(conditions, tableInfo.getRangeKey());
        }
    }

    private void validateGetKeyValue(Map<String, AttributeValue> conditions, AttributeDefinition keyDef) {
        DDBType keyDefType;
        String keyName = keyDef.getAttributeName();
        AttributeValue expectedValue = conditions.get(keyName);
        if (expectedValue == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_GET_CONDITION.getMessage());
        }
        DDBType expectedType = LocalDBUtils.getDataTypeOfScalarAttributeValue(expectedValue);
        if (expectedType != (keyDefType = LocalDBUtils.getDataTypeOfAttributeDefinition(keyDef))) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage());
        }
        if (expectedType == DDBType.N) {
            conditions.put(keyName, new AttributeValue().withN(LocalDBUtils.validateNumericValue(expectedValue.getN()).toPlainString()));
        }
    }

    private long validateLimitValue(Integer limit) {
        if (limit == null) {
            return -1L;
        }
        if (limit < 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LIMIT_VALUE.getMessage());
        }
        return limit.intValue();
    }

    private long validateLimitValueListTables(Integer limitInit) {
        long limit = this.validateLimitValue(limitInit);
        if (limit > 100L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LIMIT_TOO_BIG.getMessage());
        }
        return limit == -1L ? 100L : limit;
    }

    private ComparisonOperator validateConditionType(Condition requestCondition) {
        try {
            return ComparisonOperator.fromValue((String)requestCondition.getComparisonOperator());
        }
        catch (IllegalArgumentException ie) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON.getMessage());
        }
    }

    private void validateQueryCondition(AttributeDefinition attrDef, Condition requestCondition) {
        ComparisonOperator comparisonOperator = this.validateConditionType(requestCondition);
        List expectedVals = requestCondition.getAttributeValueList();
        if (expectedVals == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_QUERY_KEY_NOT_SPECIFIED.getMessage());
        }
        LocalDBComparisonOperator localOp = LocalDBComparisonOperator.fromValue(comparisonOperator);
        if (!localOp.isValidForQuery()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_QUERY.getMessage());
        }
        localOp.isValidAttributeList(expectedVals);
        AttributeValue expectedVal = (AttributeValue)expectedVals.get(0);
        AttributeValue expectedVal2 = null;
        if (expectedVals.size() == 2) {
            expectedVal2 = (AttributeValue)expectedVals.get(1);
        }
        LocalDBUtils.validateConsistentTypes(attrDef, expectedVal);
        if (expectedVal2 != null) {
            LocalDBUtils.validateConsistentTypes(attrDef, expectedVal2);
        }
    }

    private void validateHashKeyCondition(AttributeDefinition hashKeyDef, Map<String, Condition> keyConditions) {
        Condition requestHashCondition = keyConditions.get(hashKeyDef.getAttributeName());
        if (requestHashCondition == null || requestHashCondition.getComparisonOperator() == null || !requestHashCondition.getComparisonOperator().equals(ComparisonOperator.EQ.toString())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_QUERY_NO_HASH.getMessage());
        }
        this.validateQueryCondition(hashKeyDef, requestHashCondition);
    }

    private void validateRangeKeyCondition(AttributeDefinition rangeKeyDef, Map<String, Condition> keyConditions) {
        Condition requestRangeCondition = keyConditions.get(rangeKeyDef.getAttributeName());
        if (requestRangeCondition == null) {
            if (keyConditions.size() > 1) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_QUERY_NON_MATCHING_RANGE.getMessage());
            }
        } else {
            this.validateQueryCondition(rangeKeyDef, requestRangeCondition);
        }
    }

    private void validateExclusiveStartKeyQuery(Map<String, AttributeValue> exclusiveStartKey, List<AttributeDefinition> keyDefs, Map<String, Condition> queryConditions, boolean asc) {
        this.validateExclusiveStartKey(exclusiveStartKey, keyDefs);
        if (exclusiveStartKey == null) {
            return;
        }
        if (!this.exclusiveStartFitsConditions(exclusiveStartKey, queryConditions, asc)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START_QUERY.getMessage());
        }
    }

    private boolean exclusiveStartFitsConditions(Map<String, AttributeValue> exclusiveStartKey, Map<String, Condition> queryConditions, boolean asc) {
        for (Map.Entry<String, AttributeValue> entry : exclusiveStartKey.entrySet()) {
            Condition keyCondition = queryConditions.get(entry.getKey());
            AttributeValue val = entry.getValue();
            if (keyCondition == null || LocalDBComparisonOperator.fromValue(keyCondition.getComparisonOperator()).evaluateExclusive(keyCondition.getAttributeValueList(), val, asc)) continue;
            return false;
        }
        return true;
    }

    private void validateExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey, List<AttributeDefinition> keyDefs) {
        if (exclusiveStartKey == null) {
            return;
        }
        if (exclusiveStartKey.size() != keyDefs.size()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START_SIZE.getMessage());
        }
        AttributeDefinition hashKeyDef = keyDefs.get(0);
        String hashKeyName = hashKeyDef.getAttributeName();
        AttributeValue hashKeyVal = exclusiveStartKey.get(hashKeyName);
        if (hashKeyVal == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START_HASH.getMessage());
        }
        DDBType hashType = LocalDBUtils.validateConsistentTypes(hashKeyDef, hashKeyVal);
        if (hashType == DDBType.N) {
            exclusiveStartKey.put(hashKeyName, new AttributeValue().withN(LocalDBUtils.validateNumericValue(hashKeyVal.getN()).toPlainString()));
        }
        int i = 1;
        while (i < keyDefs.size()) {
            AttributeDefinition rangeKeyDef = keyDefs.get(1);
            String rangeKeyName = rangeKeyDef.getAttributeName();
            AttributeValue rangeKeyVal = exclusiveStartKey.get(rangeKeyName);
            if (rangeKeyVal == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START_RANGE.getMessage());
            }
            DDBType rangeType = LocalDBUtils.validateConsistentTypes(rangeKeyDef, rangeKeyVal);
            if (rangeType == DDBType.N) {
                exclusiveStartKey.put(rangeKeyName, new AttributeValue().withN(LocalDBUtils.validateNumericValue(rangeKeyVal.getN()).toPlainString()));
            }
            ++i;
        }
    }

    private ReturnValue validateReturnType(String returnValsString, boolean update) {
        ReturnValue returnType;
        if (returnValsString == null) {
            return ReturnValue.NONE;
        }
        try {
            returnType = ReturnValue.fromValue((String)returnValsString);
        }
        catch (IllegalArgumentException illegalArgs) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_RETURN_VALUES_TYPE.getMessage());
        }
        if (!(update || returnType != ReturnValue.ALL_NEW && returnType != ReturnValue.UPDATED_NEW && returnType != ReturnValue.UPDATED_OLD)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_RETURN_VALUES_TYPE.getMessage());
        }
        return returnType;
    }

    private TableDescription getTableDescriptionHelper(String tableName) {
        TableInfo tableInfo = this.validateTableExists(tableName);
        TableDescription tableDescription = new TableDescription().withTableName(tableName).withAttributeDefinitions(tableInfo.getAttributeDefinitions()).withKeySchema(tableInfo.getKeySchema()).withTableStatus(TableStatus.ACTIVE).withCreationDateTime(new Date(tableInfo.getCreationDateTime())).withProvisionedThroughput(tableInfo.getThroughputDescription()).withLocalSecondaryIndexes(tableInfo.getIndexDescriptions());
        return tableDescription;
    }

    private void validateExpectedValues(Map<String, ExpectedAttributeValue> expected) {
        for (Map.Entry<String, ExpectedAttributeValue> entry : expected.entrySet()) {
            ExpectedAttributeValue curExpected = entry.getValue();
            Boolean exists = curExpected.getExists();
            if (exists == null) {
                exists = true;
            }
            AttributeValue expectedVal = curExpected.getValue();
            if (exists.booleanValue()) {
                if (expectedVal == null) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXPECTED_TRUE.getMessage());
                }
                DDBType expectedType = LocalDBUtils.getDataTypeOfAttributeValue(expectedVal);
                if (expectedType == DDBType.N) {
                    LocalDBUtils.validateNumericValue(expectedVal.getN());
                    continue;
                }
                if (expectedType == DDBType.NS) {
                    LocalDBUtils.validateNumberSet(expectedVal.getNS());
                    continue;
                }
                if (expectedType == DDBType.BS) {
                    LocalDBUtils.validateItemSet(expectedVal.getBS());
                    continue;
                }
                if (expectedType != DDBType.SS) continue;
                LocalDBUtils.validateItemSet(expectedVal.getSS());
                continue;
            }
            if (exists.booleanValue() || expectedVal == null) continue;
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXPECTED_FALSE.getMessage());
        }
    }

    private void checkExpectedValue(AttributeValue a, ExpectedAttributeValue e) {
        LocalDBUtils.ldClientAssertTrue(e != null, LocalDBClientExceptionType.INVALID_VALUES, "Expected value cannot be null", new Object[0]);
        if (e.isExists().booleanValue()) {
            DDBType expectedType;
            if (a == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_EXISTS.getMessage());
            }
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(a);
            if (type != (expectedType = LocalDBUtils.getDataTypeOfAttributeValue(e.getValue()))) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_EXISTS.getMessage());
            }
            if (type == DDBType.S || type == DDBType.B) {
                if (!a.equals((Object)e.getValue())) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_EXISTS.getMessage());
                }
            } else if (type == DDBType.N) {
                BigDecimal expectedValBigDec;
                BigDecimal actualValBigDec = new BigDecimal(a.getN());
                if (actualValBigDec.compareTo(expectedValBigDec = new BigDecimal(e.getValue().getN())) != 0) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_EXISTS.getMessage());
                }
            } else if (type == DDBType.SS) {
                if (!a.getSS().containsAll(e.getValue().getSS()) || !e.getValue().getSS().containsAll(a.getSS())) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_EXISTS.getMessage());
                }
            } else if (type == DDBType.BS) {
                if (!a.getBS().containsAll(e.getValue().getBS()) || !e.getValue().getBS().containsAll(a.getBS())) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_EXISTS.getMessage());
                }
            } else if (type == DDBType.NS) {
                Set<BigDecimal> actualSetBigDec = this.convertNumberSet(a);
                Set<BigDecimal> expectedSetBigDec = this.convertNumberSet(e.getValue());
                for (BigDecimal actualBigDec : actualSetBigDec) {
                    boolean isEquals = false;
                    for (BigDecimal expectedBigDec : expectedSetBigDec) {
                        if (expectedBigDec.compareTo(actualBigDec) != 0) continue;
                        isEquals = true;
                    }
                    if (isEquals) continue;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_EXISTS.getMessage());
                }
                if (expectedSetBigDec.size() > actualSetBigDec.size()) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_EXISTS.getMessage());
                }
            }
        } else if (a != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CHECK_FAILED_NOT_EXISTS.getMessage());
        }
    }

    private void checkExpectations(Map<String, AttributeValue> retrievedItem, Map<String, ExpectedAttributeValue> expected) {
        for (Map.Entry<String, ExpectedAttributeValue> entry : expected.entrySet()) {
            ExpectedAttributeValue expectation = entry.getValue();
            if (expectation.getExists() == null) {
                expectation.setExists(Boolean.valueOf(true));
            }
            if (retrievedItem == null) {
                if (!expectation.getExists().booleanValue()) continue;
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, "Expected attribute not found.");
            }
            this.checkExpectedValue(retrievedItem.get(entry.getKey()), expectation);
        }
    }

    private void validateAttributesToGet(List<String> attributesToGet) {
        if (attributesToGet == null) {
            return;
        }
        if (attributesToGet.size() == 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ATTRIBUTES_EMPTY.getMessage());
        }
        HashSet<String> attributesToGetSet = new HashSet<String>();
        for (String attr : attributesToGet) {
            if (attributesToGetSet.contains(attr)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICAL_ATTRIBUTE_NAMES.getMessage());
            }
            attributesToGetSet.add(attr);
        }
    }

    private TableDescription fillDescriptionHelper(TableDescription description) {
        String tableName = description.getTableName();
        long tableItemCount = this.dbAccess.getTableItemCount(tableName);
        description.setItemCount(Long.valueOf(tableItemCount));
        description.setTableSizeBytes(Long.valueOf(this.dbAccess.getTableByteSize(tableName)));
        if (description.getLocalSecondaryIndexes() != null) {
            for (LocalSecondaryIndexDescription lsiDesc : description.getLocalSecondaryIndexes()) {
                String indexName = lsiDesc.getIndexName();
                long indexItemCount = this.dbAccess.getIndexItemCount(tableName, indexName);
                lsiDesc.setItemCount(Long.valueOf(indexItemCount));
                lsiDesc.setIndexSizeBytes(Long.valueOf(this.dbAccess.getIndexByteSize(tableName, indexName)));
            }
        }
        return description;
    }

    public Select validateSelect(String selectStr, List<String> attributesToGet, String indexName) {
        Select select;
        if (selectStr == null && attributesToGet == null) {
            return indexName == null ? Select.ALL_ATTRIBUTES : Select.ALL_PROJECTED_ATTRIBUTES;
        }
        if (selectStr == null && attributesToGet != null) {
            select = Select.SPECIFIC_ATTRIBUTES;
        } else {
            try {
                select = Select.fromValue((String)selectStr);
            }
            catch (IllegalArgumentException ie) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SELECT.getMessage());
            }
        }
        if (select == Select.ALL_PROJECTED_ATTRIBUTES && indexName == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SELECT_INDEX.getMessage());
        }
        if (select != Select.SPECIFIC_ATTRIBUTES && attributesToGet != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SELECT_ATTRIBUTES.getMessage());
        }
        if (select == Select.SPECIFIC_ATTRIBUTES) {
            if (attributesToGet == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SELECT_NO_ATTRIBUTES.getMessage());
            }
            this.validateAttributesToGet(attributesToGet);
        }
        return select;
    }

    private void validateAttributeUpdates(Map<String, AttributeValueUpdate> updates, TableInfo tableInfo, Map<String, AttributeValue> oldItem) {
        if (updates == null) {
            return;
        }
        for (Map.Entry<String, AttributeValueUpdate> entry : updates.entrySet()) {
            AttributeAction curAction;
            String attributeName = entry.getKey();
            if (attributeName.equals(tableInfo.getHashKey().getAttributeName()) || tableInfo.hasRangeKey() && attributeName.equals(tableInfo.getRangeKey().getAttributeName())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_UPDATE_PRIMARY_KEY.getMessage());
            }
            AttributeValueUpdate curUpdate = entry.getValue();
            try {
                curAction = AttributeAction.fromValue((String)curUpdate.getAction());
            }
            catch (IllegalArgumentException illegalArgs) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ACTION_TYPE.getMessage());
            }
            AttributeValue curAttr = curUpdate.getValue();
            AttributeValue curAttrOld = null;
            if (oldItem != null && oldItem.containsKey(attributeName)) {
                curAttrOld = oldItem.get(attributeName);
            }
            switch (curAction) {
                case DELETE: {
                    this.validateAttributeDelete(curAttr, curAttrOld);
                    break;
                }
                case PUT: {
                    this.validateAttributePut(curAttr);
                    break;
                }
                case ADD: {
                    this.validateAttributeAdd(curAttr, curAttrOld);
                }
            }
            AttributeDefinition lsiKeyDef = tableInfo.getLsiRangeKey(attributeName);
            if (lsiKeyDef != null && curAttr != null) {
                try {
                    LocalDBUtils.validateConsistentTypes(lsiKeyDef, curAttr);
                }
                catch (AmazonServiceException serviceException) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_UPDATE_INDEX_KEY.getMessage());
                }
            }
            if (curAttr == null) continue;
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(curAttr);
            if (type == DDBType.N) {
                curUpdate.setValue(new AttributeValue().withN(LocalDBUtils.validateNumericValue(curAttr.getN()).toPlainString()));
                continue;
            }
            if (!type.isSet()) continue;
            if (type == DDBType.NS) {
                curUpdate.setValue(new AttributeValue().withNS(LocalDBUtils.validateNumberSet(curAttr.getNS())));
                continue;
            }
            LocalDBUtils.validateItemSet(curAttr.getBS());
            LocalDBUtils.validateItemSet(curAttr.getSS());
        }
    }

    private void validateAttributeDelete(AttributeValue curAttr, AttributeValue oldAttr) {
        boolean isSet;
        try {
            isSet = LocalDBUtils.getDataTypeOfAttributeValue(curAttr).isSet();
        }
        catch (NullPointerException npe) {
            isSet = false;
        }
        if (curAttr != null && !isSet) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ACTION_DELETE.getMessage());
        }
        if (isSet && oldAttr != null) {
            LocalDBUtils.validateConsistentTypes(curAttr, oldAttr);
        }
    }

    private void validateAttributePutAdd(AttributeValue curAttr) {
        if (curAttr == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ACTION_NO_VALUE.getMessage());
        }
    }

    private void validateAttributePut(AttributeValue curAttr) {
        this.validateAttributePutAdd(curAttr);
        LocalDBUtils.getDataTypeOfAttributeValue(curAttr);
    }

    private void validateAttributeAdd(AttributeValue curAttr, AttributeValue oldAttr) {
        this.validateAttributePutAdd(curAttr);
        DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(curAttr);
        if (type != DDBType.N && !type.isSet()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ACTION_ADD.getMessage());
        }
        if (oldAttr != null) {
            LocalDBUtils.validateConsistentTypes(curAttr, oldAttr);
        }
    }

    private Map<String, AttributeValue> doUpdates(Map<String, AttributeValueUpdate> updatesToMake, Map<String, AttributeValue> item) {
        if (updatesToMake == null) {
            return item;
        }
        for (Map.Entry<String, AttributeValueUpdate> entry : updatesToMake.entrySet()) {
            String attr = entry.getKey();
            AttributeValueUpdate curUpdate = entry.getValue();
            AttributeAction curAction = AttributeAction.valueOf((String)curUpdate.getAction());
            switch (curAction) {
                case ADD: {
                    this.doAdd(attr, curUpdate, item);
                    break;
                }
                case DELETE: {
                    this.doDelete(attr, curUpdate, item);
                    break;
                }
                case PUT: {
                    this.doPut(attr, curUpdate, item);
                }
            }
        }
        return item;
    }

    private void doDelete(String attrName, AttributeValueUpdate attrUpdate, Map<String, AttributeValue> item) {
        AttributeValue updateVal = attrUpdate.getValue();
        if (updateVal == null) {
            item.remove(attrName);
        } else {
            AttributeValue curAttr = item.get(attrName);
            if (curAttr == null) {
                return;
            }
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(curAttr);
            switch (type) {
                case BS: {
                    ArrayList curValBlobSet = new ArrayList();
                    curValBlobSet.addAll(curAttr.getBS());
                    curValBlobSet.removeAll(updateVal.getBS());
                    if (curValBlobSet.isEmpty()) {
                        item.remove(attrName);
                        break;
                    }
                    item.put(attrName, new AttributeValue().withBS(curValBlobSet));
                    break;
                }
                case NS: {
                    ArrayList curValNumSet = new ArrayList();
                    curValNumSet.addAll(curAttr.getNS());
                    curValNumSet.removeAll(updateVal.getNS());
                    if (curValNumSet.isEmpty()) {
                        item.remove(attrName);
                        break;
                    }
                    item.put(attrName, new AttributeValue().withNS(curValNumSet));
                    break;
                }
                case SS: {
                    ArrayList curValStrSet = new ArrayList();
                    curValStrSet.addAll(curAttr.getSS());
                    curValStrSet.removeAll(updateVal.getSS());
                    if (curValStrSet.isEmpty()) {
                        item.remove(attrName);
                        break;
                    }
                    item.put(attrName, new AttributeValue().withSS(curValStrSet));
                    break;
                }
                default: {
                    LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
                }
            }
        }
    }

    private void doPut(String attrName, AttributeValueUpdate attrUpdate, Map<String, AttributeValue> item) {
        AttributeValue updateVal = attrUpdate.getValue();
        item.put(attrName, updateVal);
    }

    private void doAdd(String attrName, AttributeValueUpdate attrUpdate, Map<String, AttributeValue> item) {
        AttributeValue updateVal = attrUpdate.getValue();
        AttributeValue curAttr = item.get(attrName);
        DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(updateVal);
        if (type == DDBType.N) {
            if (curAttr == null) {
                item.put(attrName, updateVal);
            } else {
                BigDecimal curValNum = new BigDecimal(curAttr.getN());
                BigDecimal updateValNum = new BigDecimal(updateVal.getN());
                BigDecimal newValNum = curValNum.add(updateValNum);
                item.put(attrName, new AttributeValue().withN(newValNum.toPlainString()));
            }
        } else if (type.isSet()) {
            if (curAttr == null) {
                item.put(attrName, updateVal);
            } else {
                switch (LocalDBUtils.getDataTypeOfAttributeValue(curAttr)) {
                    case BS: {
                        ArrayList<ByteBuffer> curValBlobSet = new ArrayList<ByteBuffer>();
                        curValBlobSet.addAll(curAttr.getBS());
                        for (ByteBuffer curBuf : updateVal.getBS()) {
                            if (curValBlobSet.contains(curBuf)) continue;
                            curValBlobSet.add(curBuf);
                        }
                        item.put(attrName, new AttributeValue().withBS(curValBlobSet));
                        break;
                    }
                    case NS: {
                        ArrayList<String> curValNumSet = new ArrayList<String>();
                        curValNumSet.addAll(curAttr.getNS());
                        for (String curNum : updateVal.getNS()) {
                            if (curValNumSet.contains(curNum)) continue;
                            curValNumSet.add(curNum);
                        }
                        item.put(attrName, new AttributeValue().withNS(curValNumSet));
                        break;
                    }
                    case SS: {
                        ArrayList<String> curValStrSet = new ArrayList<String>();
                        curValStrSet.addAll(curAttr.getSS());
                        for (String curStr : updateVal.getSS()) {
                            if (curValStrSet.contains(curStr)) continue;
                            curValStrSet.add(curStr);
                        }
                        item.put(attrName, new AttributeValue().withSS(curValStrSet));
                    }
                }
            }
        }
    }

    private Map<String, AttributeValue> getReturnedValsFromUpdate(ReturnValue returnVals, Map<String, AttributeValueUpdate> updatesToMake, Map<String, AttributeValue> oldItem, Map<String, AttributeValue> updatedItem) {
        HashMap<String, AttributeValue> returnedVals = new HashMap<String, AttributeValue>();
        switch (returnVals) {
            case ALL_OLD: {
                if (oldItem == null) {
                    return null;
                }
                returnedVals.putAll(oldItem);
                break;
            }
            case ALL_NEW: {
                returnedVals.putAll(updatedItem);
                break;
            }
            case UPDATED_OLD: {
                if (oldItem == null) {
                    return null;
                }
                for (Map.Entry<String, AttributeValueUpdate> entry : updatesToMake.entrySet()) {
                    String attr = entry.getKey();
                    if (!oldItem.containsKey(attr)) continue;
                    returnedVals.put(attr, oldItem.get(attr));
                }
                break;
            }
            case UPDATED_NEW: {
                for (Map.Entry<String, AttributeValueUpdate> entry : updatesToMake.entrySet()) {
                    String attr = entry.getKey();
                    if (!updatedItem.containsKey(attr)) continue;
                    returnedVals.put(attr, updatedItem.get(attr));
                }
                break;
            }
            case NONE: {
                returnedVals = null;
            }
        }
        if (returnedVals != null && returnedVals.isEmpty()) {
            returnedVals = null;
        }
        return returnedVals;
    }

    private int validateBatchGetEntry(String tableName, KeysAndAttributes requests, int count) {
        this.validateTableName(tableName);
        TableInfo info = this.validateTableExists(tableName);
        if (requests == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_GET_NULL_REQUEST_ENTRY.getMessage());
        }
        this.validateAttributesToGet(requests.getAttributesToGet());
        List keys = requests.getKeys();
        if (keys == null || keys.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_KEYS.getMessage());
        }
        if ((count += keys.size()) > 100) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_REQUESTED_ITEMS.getMessage());
        }
        for (Map primaryKey : keys) {
            if (primaryKey == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_GET_CONDITION.getMessage());
            }
            this.validateGetKey(primaryKey, info);
        }
        return count;
    }

    public long doBatchGet(String tableName, KeysAndAttributes requests, Map<String, List<Map<String, AttributeValue>>> responses, Map<String, KeysAndAttributes> unprocessedKeys, long totalSize) {
        ArrayList<Map<String, AttributeValue>> fetchedItems = new ArrayList<Map<String, AttributeValue>>();
        responses.put(tableName, fetchedItems);
        List attributesToGet = requests.getAttributesToGet();
        ArrayList keys = new ArrayList(requests.getKeys());
        while (!keys.isEmpty()) {
            Map primaryKey = (Map)keys.remove(0);
            Map<String, AttributeValue> item = this.dbAccess.getRecord(tableName, primaryKey);
            if (item == null) continue;
            if ((totalSize += LocalDBUtils.getItemSizeBytes(item)) > 0x100000L) break;
            fetchedItems.add(LocalDBUtils.filterAttributes(item, attributesToGet));
        }
        if (!fetchedItems.isEmpty()) {
            responses.put(tableName, fetchedItems);
        }
        if (!keys.isEmpty()) {
            KeysAndAttributes tableUnprocessedKeys = new KeysAndAttributes().withAttributesToGet((Collection)attributesToGet);
            tableUnprocessedKeys.setKeys(keys);
            unprocessedKeys.put(tableName, tableUnprocessedKeys);
        }
        return totalSize;
    }

    private void validateTableNotExists(String tableName) {
        if (this.dbAccess.getTableInfo(tableName) != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.TABLE_ALREADY_EXISTS.getMessage());
        }
    }

    private Set<BigDecimal> convertNumberSet(AttributeValue attrVal) {
        HashSet<BigDecimal> setBigDec = new HashSet<BigDecimal>();
        for (String numString : attrVal.getNS()) {
            setBigDec.add(new BigDecimal(numString));
        }
        return setBigDec;
    }

    public Map<String, Condition> validateScanFilters(ScanRequest scanRequest) {
        HashMap scanFilter = null;
        if (scanRequest.getScanFilter() != null) {
            scanFilter = new HashMap(scanRequest.getScanFilter());
            for (Map.Entry entry : scanFilter.entrySet()) {
                Condition requestCondition = (Condition)entry.getValue();
                ComparisonOperator comparisonOperator = this.validateConditionType(requestCondition);
                List expectedVals = requestCondition.getAttributeValueList();
                LocalDBComparisonOperator localOp = LocalDBComparisonOperator.fromValue(comparisonOperator);
                localOp.isValidAttributeList(expectedVals);
            }
        }
        return scanFilter;
    }

    public boolean verifyItemConditions(Map<String, AttributeValue> item, Map<String, Condition> scanFilter) {
        boolean fitsAllConditions = true;
        if (scanFilter != null) {
            for (Map.Entry<String, Condition> entry : scanFilter.entrySet()) {
                String attrName = entry.getKey();
                Condition condition = entry.getValue();
                LocalDBComparisonOperator compOp = LocalDBComparisonOperator.fromValue(condition.getComparisonOperator());
                AttributeValue value = item.get(attrName);
                if (compOp.evaluate(condition.getAttributeValueList(), value)) continue;
                fitsAllConditions = false;
                break;
            }
        }
        return fitsAllConditions;
    }

    private Map<String, AttributeValue> validateBatchWriteDelete(WriteRequest writeRequest, List<Map<String, AttributeValue>> deletesList, TableInfo tableInfo) {
        if (writeRequest.getPutRequest() != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_TWO_IN_ONE.getMessage());
        }
        DeleteRequest deleteRequest = writeRequest.getDeleteRequest();
        if (deleteRequest.getKey() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        HashMap<String, AttributeValue> primaryKey = new HashMap<String, AttributeValue>(deleteRequest.getKey());
        this.validateGetKey(primaryKey, tableInfo);
        deletesList.add(primaryKey);
        return primaryKey;
    }

    private Map<String, AttributeValue> validateBatchWritePut(WriteRequest writeRequest, List<Map<String, AttributeValue>> putsList, TableInfo tableInfo) {
        if (writeRequest.getPutRequest() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_NO_REQUEST_TYPE.getMessage());
        }
        PutRequest putRequest = writeRequest.getPutRequest();
        if (putRequest.getItem() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PUT_NULL.getMessage());
        }
        HashMap<String, AttributeValue> record = new HashMap<String, AttributeValue>(putRequest.getItem());
        Map<String, AttributeValue> primaryKey = this.validatePutItem(record, tableInfo);
        putsList.add(record);
        return primaryKey;
    }

    private Long validateBatchWriteWriteRequest(WriteRequest writeRequest, TableInfo tableInfo, List<Map<String, AttributeValue>> putsList, List<Map<String, AttributeValue>> deletesList, Set<Map<String, AttributeValue>> keySet, Long totalRequestSize) {
        boolean isDelete;
        if (writeRequest == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_NULL_INDIVIDUAL_REQUEST.getMessage());
        }
        Map<String, AttributeValue> primaryKey = null;
        boolean bl = isDelete = writeRequest.getDeleteRequest() != null;
        if (isDelete) {
            primaryKey = this.validateBatchWriteDelete(writeRequest, deletesList, tableInfo);
        } else {
            primaryKey = this.validateBatchWritePut(writeRequest, putsList, tableInfo);
            totalRequestSize = totalRequestSize + Long.valueOf(LocalDBUtils.getItemSizeBytes(putsList.get(putsList.size() - 1)));
        }
        if (keySet.contains(primaryKey)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_SAME_ITEM.getMessage());
        }
        keySet.add(primaryKey);
        if (totalRequestSize > 0x100000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_TOO_BIG.getMessage());
        }
        return totalRequestSize;
    }

    private static byte[] getSegmentBeginningHashKey(int totalSegments, int segment) {
        BigInteger delta = LocalDBUtils.MAX_HASH_KEY.divide(BigInteger.valueOf(totalSegments));
        delta = delta.multiply(BigInteger.valueOf(segment));
        return LocalDBUtils.bigIntegerToMD5Bytes(delta);
    }

    private static byte[] getSegmentEndHashKey(int totalSegments, int segment) {
        if (segment + 1 == totalSegments) {
            return LocalDBUtils.bigIntegerToMD5Bytes(LocalDBUtils.MAX_HASH_KEY);
        }
        BigInteger delta = LocalDBUtils.MAX_HASH_KEY.divide(BigInteger.valueOf(totalSegments));
        delta = delta.multiply(BigInteger.valueOf(segment + 1));
        return LocalDBUtils.bigIntegerToMD5Bytes(delta.subtract(BigInteger.valueOf(1L)));
    }
}

