/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.common.JarHelper;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class UnpackMojo
extends AbstractAndroidMojo {
    private boolean lazyLibraryUnpack;

    public void execute() throws MojoExecutionException, MojoFailureException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        if (this.generateApk) {
            this.unpackClasses();
        }
    }

    private File unpackClasses() throws MojoExecutionException {
        File outputDirectory = new File(this.project.getBuild().getDirectory(), "android-classes");
        if (this.lazyLibraryUnpack && outputDirectory.exists()) {
            this.getLog().info((CharSequence)"skip library unpacking due to lazyLibraryUnpack policy");
        } else {
            for (Artifact artifact : this.getRelevantCompileArtifacts()) {
                if (artifact.getFile().isDirectory()) {
                    try {
                        FileUtils.copyDirectory((File)artifact.getFile(), (File)outputDirectory);
                        continue;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("IOException while copying " + artifact.getFile().getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
                    }
                }
                try {
                    JarHelper.unjar(new JarFile(artifact.getFile()), outputDirectory, new JarHelper.UnjarListener(){

                        @Override
                        public boolean include(JarEntry jarEntry) {
                            return !jarEntry.getName().startsWith("META-INF") && jarEntry.getName().endsWith(".class");
                        }
                    });
                }
                catch (IOException e) {
                    throw new MojoExecutionException("IOException while unjarring " + artifact.getFile().getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
                }
            }
        }
        try {
            File sourceDirectory = new File(this.project.getBuild().getOutputDirectory());
            FileUtils.copyDirectory((File)sourceDirectory, (File)outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while copying " + this.sourceDirectory.getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
        }
        return outputDirectory;
    }
}

