/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.common;

import com.google.common.io.PatternFilenameFilter;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.util.filter.AndDependencyFilter;
import org.sonatype.aether.util.filter.ExclusionsDependencyFilter;
import org.sonatype.aether.util.filter.ScopeDependencyFilter;
import org.sonatype.aether.util.graph.PreorderNodeListGenerator;

public class NativeHelper {
    public static final int NDK_REQUIRED_VERSION = 7;
    private MavenProject project;
    private RepositorySystemSession repoSession;
    private RepositorySystem repoSystem;
    private ArtifactFactory artifactFactory;
    private Log log;
    private List<RemoteRepository> projectRepos;

    public NativeHelper(MavenProject project, List<RemoteRepository> projectRepos, RepositorySystemSession repoSession, RepositorySystem repoSystem, ArtifactFactory artifactFactory, Log log) {
        this.project = project;
        this.projectRepos = projectRepos;
        this.repoSession = repoSession;
        this.repoSystem = repoSystem;
        this.artifactFactory = artifactFactory;
        this.log = log;
    }

    public static boolean hasStaticNativeLibraryArtifact(Set<org.apache.maven.artifact.Artifact> resolveNativeLibraryArtifacts, File unpackDirectory, String ndkArchitecture) {
        for (org.apache.maven.artifact.Artifact resolveNativeLibraryArtifact : resolveNativeLibraryArtifacts) {
            File[] aFiles;
            if ("a".equals(resolveNativeLibraryArtifact.getType())) {
                return true;
            }
            if (!"apklib".equals(resolveNativeLibraryArtifact.getType()) || (aFiles = NativeHelper.listNativeFiles(resolveNativeLibraryArtifact, unpackDirectory, ndkArchitecture, true)) == null || aFiles.length <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSharedNativeLibraryArtifact(Set<org.apache.maven.artifact.Artifact> resolveNativeLibraryArtifacts, File unpackDirectory, String ndkArchitecture) {
        for (org.apache.maven.artifact.Artifact resolveNativeLibraryArtifact : resolveNativeLibraryArtifacts) {
            File[] soFiles;
            if ("so".equals(resolveNativeLibraryArtifact.getType())) {
                return true;
            }
            if (!"apklib".equals(resolveNativeLibraryArtifact.getType()) || (soFiles = NativeHelper.listNativeFiles(resolveNativeLibraryArtifact, unpackDirectory, ndkArchitecture, false)) == null || soFiles.length <= 0) continue;
            return true;
        }
        return false;
    }

    public static File[] listNativeFiles(org.apache.maven.artifact.Artifact a, File unpackDirectory, String ndkArchitecture, final boolean staticLibrary) {
        File libsFolder = new File(AbstractAndroidMojo.getLibraryUnpackDirectory(unpackDirectory, a), File.separator + "libs" + File.separator + ndkArchitecture);
        if (libsFolder.exists()) {
            File[] libFiles = libsFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("lib") && name.endsWith(staticLibrary ? ".a" : ".so");
                }
            });
            return libFiles;
        }
        return null;
    }

    public Set<org.apache.maven.artifact.Artifact> getNativeDependenciesArtifacts(File unpackDirectory, boolean sharedLibraries) throws MojoExecutionException {
        LinkedHashSet<org.apache.maven.artifact.Artifact> filteredArtifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        LinkedHashSet allArtifacts = new LinkedHashSet();
        allArtifacts.addAll(this.project.getDependencyArtifacts());
        allArtifacts.addAll(this.project.getAttachedArtifacts());
        for (org.apache.maven.artifact.Artifact artifact : allArtifacts) {
            File libsFolder;
            if (this.isNativeLibrary(sharedLibraries, artifact.getType()) && artifact.getScope() == null) {
                this.log.debug((CharSequence)("Including attached artifact: " + artifact.getArtifactId() + "(" + artifact.getGroupId() + "). Artifact scope is not set."));
                filteredArtifacts.add(artifact);
                continue;
            }
            if (this.isNativeLibrary(sharedLibraries, artifact.getType()) && ("compile".equals(artifact.getScope()) || "runtime".equals(artifact.getScope()))) {
                this.log.debug((CharSequence)("Including attached artifact: " + artifact.getArtifactId() + "(" + artifact.getGroupId() + "). Artifact scope is Compile or Runtime."));
                filteredArtifacts.add(artifact);
                continue;
            }
            if (!"apklib".equals(artifact.getType()) || !(libsFolder = new File(AbstractAndroidMojo.getLibraryUnpackDirectory(unpackDirectory, artifact) + "/libs")).exists() || libsFolder.list((FilenameFilter)new PatternFilenameFilter(".+[^.jar]$")).length <= 0) continue;
            this.log.debug((CharSequence)("Including attached artifact: " + artifact.getArtifactId() + "(" + artifact.getGroupId() + "). Artifact is APKLIB."));
            filteredArtifacts.add(artifact);
        }
        Set<org.apache.maven.artifact.Artifact> transientArtifacts = this.processTransientDependencies(this.project.getDependencies(), sharedLibraries);
        filteredArtifacts.addAll(transientArtifacts);
        return filteredArtifacts;
    }

    private boolean isNativeLibrary(boolean sharedLibraries, String artifactType) {
        return sharedLibraries ? "so".equals(artifactType) : "a".equals(artifactType);
    }

    private Set<org.apache.maven.artifact.Artifact> processTransientDependencies(List<org.apache.maven.model.Dependency> dependencies, boolean sharedLibraries) throws MojoExecutionException {
        LinkedHashSet<org.apache.maven.artifact.Artifact> transientArtifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        for (org.apache.maven.model.Dependency dependency : dependencies) {
            if ("provided".equals(dependency.getScope()) || dependency.isOptional()) continue;
            transientArtifacts.addAll(this.processTransientDependencies(RepositoryUtils.toDependency((org.apache.maven.model.Dependency)dependency, (ArtifactTypeRegistry)this.repoSession.getArtifactTypeRegistry()), sharedLibraries));
        }
        return transientArtifacts;
    }

    private Set<org.apache.maven.artifact.Artifact> processTransientDependencies(Dependency dependency, boolean sharedLibraries) throws MojoExecutionException {
        try {
            LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(dependency);
            collectRequest.setRepositories(this.projectRepos);
            DependencyNode node = this.repoSystem.collectDependencies(this.repoSession, collectRequest).getRoot();
            ArrayList<String> exclusionPatterns = new ArrayList<String>();
            if (dependency.getExclusions() != null && !dependency.getExclusions().isEmpty()) {
                for (Exclusion exclusion : dependency.getExclusions()) {
                    exclusionPatterns.add(exclusion.getGroupId() + ":" + exclusion.getArtifactId());
                }
            }
            DependencyRequest dependencyRequest = new DependencyRequest(node, (DependencyFilter)new AndDependencyFilter(new DependencyFilter[]{new ExclusionsDependencyFilter(exclusionPatterns), new AndDependencyFilter(new DependencyFilter[]{new ScopeDependencyFilter(Arrays.asList("compile", "runtime"), Arrays.asList("test")), new DependencyFilter(){

                public boolean accept(DependencyNode dependencyNode, List<DependencyNode> dependencyNodes) {
                    return !dependencyNode.getDependency().isOptional();
                }
            }})}));
            this.repoSystem.resolveDependencies(this.repoSession, dependencyRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            List dependencies = nlg.getDependencies(false);
            for (Dependency dep : dependencies) {
                Artifact depAetherArtifact = dep.getArtifact();
                if (!this.isNativeLibrary(sharedLibraries, depAetherArtifact.getExtension())) continue;
                org.apache.maven.artifact.Artifact mavenArtifact = this.artifactFactory.createDependencyArtifact(depAetherArtifact.getGroupId(), depAetherArtifact.getArtifactId(), VersionRange.createFromVersion((String)depAetherArtifact.getVersion()), depAetherArtifact.getExtension(), depAetherArtifact.getClassifier(), dep.getScope());
                mavenArtifact.setFile(depAetherArtifact.getFile());
                artifacts.add(mavenArtifact);
            }
            return artifacts;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while processing transient dependencies", e);
        }
    }

    public static void validateNDKVersion(File ndkHomeDir) throws MojoExecutionException {
        File ndkVersionFile = new File(ndkHomeDir, "RELEASE.TXT");
        if (!ndkVersionFile.exists()) {
            throw new MojoExecutionException("Could not locate RELEASE.TXT in the Android NDK base directory '" + ndkHomeDir.getAbsolutePath() + "'.  Please verify your setup! " + "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.");
        }
        try {
            String versionStr = FileUtils.readFileToString((File)ndkVersionFile);
            NativeHelper.validateNDKVersion(7, versionStr);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while extracting NDK version from '" + ndkVersionFile.getAbsolutePath() + "'. Please verify your setup! " + "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.");
        }
    }

    public static void validateNDKVersion(int desiredVersion, String versionStr) throws MojoExecutionException {
        int version = 0;
        if (versionStr != null) {
            versionStr = versionStr.trim();
            Pattern pattern = Pattern.compile("[r]([0-9]{1,3})([a-z]{0,1}).*");
            Matcher m = pattern.matcher(versionStr);
            if (m.matches()) {
                String group = m.group(1);
                version = Integer.parseInt(group);
            }
        }
        if (version < desiredVersion) {
            throw new MojoExecutionException("You are running an old NDK (version " + versionStr + "), please update " + "to at least r'" + desiredVersion + "' or later");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAppAbi(File applicationMakefile) {
        block8: {
            Scanner scanner = null;
            try {
                if (applicationMakefile == null || !applicationMakefile.exists()) break block8;
                scanner = new Scanner(applicationMakefile);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith("APP_ABI")) continue;
                    String[] stringArray = line.substring(line.indexOf(":=") + 2).trim().split(" ");
                    return stringArray;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return null;
    }

    public static String[] getNdkArchitectures(String ndkClassifier, String ndkArchitecture, String applicationMakefile, File basedir) throws MojoExecutionException {
        String[] foundNdkArchitectures;
        File appMK;
        if (ndkClassifier != null) {
            return new String[]{ndkClassifier};
        }
        if (ndkArchitecture != null) {
            return new String[]{ndkArchitecture};
        }
        String applicationMakefileToUse = applicationMakefile;
        if (applicationMakefileToUse == null) {
            applicationMakefileToUse = "jni/Application.mk";
        }
        if ((appMK = new File(basedir, applicationMakefileToUse)).exists() && (foundNdkArchitectures = NativeHelper.getAppAbi(appMK)) != null) {
            return foundNdkArchitectures;
        }
        return new String[]{"armeabi"};
    }
}

