/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.configuration.Zipalign;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractZipalignMojo
extends AbstractAndroidMojo {
    private Zipalign zipalign;
    private Boolean zipalignSkip;
    private Boolean zipalignVerbose;
    private String zipalignInputApk;
    private String zipalignOutputApk;
    private Boolean parsedSkip;
    private Boolean parsedVerbose;
    private String parsedInputApk;
    private String parsedOutputApk;
    private File apkFile;
    private File alignedApkFile;

    protected void zipalign() throws MojoExecutionException {
        if (!SUPPORTED_PACKAGING_TYPES.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping zipalign on " + this.project.getPackaging()));
            return;
        }
        this.parseParameters();
        if (this.parsedSkip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping zipalign");
        } else {
            CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
            executor.setLogger(this.getLog());
            String command = this.getAndroidSdk().getZipalignPath();
            ArrayList<String> parameters = new ArrayList<String>();
            if (this.parsedVerbose.booleanValue()) {
                parameters.add("-v");
            }
            parameters.add("-f");
            parameters.add("4");
            parameters.add(this.parsedInputApk);
            parameters.add(this.parsedOutputApk);
            try {
                this.getLog().info((CharSequence)("Running command: " + command));
                this.getLog().info((CharSequence)("with parameters: " + parameters));
                executor.executeCommand(command, parameters);
                File aligned = new File(this.parsedOutputApk);
                if (aligned.exists()) {
                    this.projectHelper.attachArtifact(this.project, "apk", "aligned", aligned);
                    this.getLog().info((CharSequence)("Attach " + aligned.getAbsolutePath() + " to the project"));
                } else {
                    this.getLog().error((CharSequence)("Cannot attach " + aligned.getAbsolutePath() + " to the project - the file does " + "not exist"));
                }
            }
            catch (ExecutionException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
    }

    private void parseParameters() {
        this.getLog().debug((CharSequence)"Parsing parameters");
        if (this.zipalign != null) {
            this.parsedSkip = this.zipalign.isSkip() != null ? this.zipalign.isSkip() : this.determineSkip();
            this.parsedVerbose = this.zipalign.isVerbose() != null ? this.zipalign.isVerbose() : this.determineVerbose();
            this.parsedInputApk = this.zipalign.getInputApk() != null ? this.zipalign.getInputApk() : this.determineInputApk();
            this.parsedOutputApk = this.zipalign.getOutputApk() != null ? this.zipalign.getOutputApk() : this.determineOutputApk();
        } else {
            this.parsedSkip = this.determineSkip();
            this.parsedVerbose = this.determineVerbose();
            this.parsedInputApk = this.determineInputApk();
            this.parsedOutputApk = this.determineOutputApk();
        }
        this.getLog().debug((CharSequence)("skip:" + this.parsedSkip));
        this.getLog().debug((CharSequence)("verbose:" + this.parsedVerbose));
        this.getLog().debug((CharSequence)("inputApk:" + this.parsedInputApk));
        this.getLog().debug((CharSequence)("outputApk:" + this.parsedOutputApk));
    }

    private Boolean determineSkip() {
        Boolean enabled;
        if (this.zipalignSkip != null) {
            enabled = this.zipalignSkip;
        } else {
            this.getLog().debug((CharSequence)"Using default for zipalign.skip=false");
            enabled = Boolean.FALSE;
        }
        return enabled;
    }

    private Boolean determineVerbose() {
        Boolean enabled;
        if (this.zipalignVerbose != null) {
            enabled = this.zipalignVerbose;
        } else {
            this.getLog().debug((CharSequence)"Using default for zipalign.verbose=false");
            enabled = Boolean.FALSE;
        }
        return enabled;
    }

    private String getApkLocation() {
        if (this.apkFile == null) {
            this.apkFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + "apk");
        }
        return this.apkFile.getAbsolutePath();
    }

    private String getAlignedApkLocation() {
        if (this.alignedApkFile == null) {
            this.alignedApkFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-aligned." + "apk");
        }
        return this.alignedApkFile.getAbsolutePath();
    }

    private String determineInputApk() {
        String inputApk;
        if (this.zipalignInputApk != null) {
            inputApk = this.zipalignInputApk;
        } else {
            String inputPath = this.getApkLocation();
            this.getLog().debug((CharSequence)("Using default for zipalign.inputApk: " + inputPath));
            inputApk = inputPath;
        }
        return inputApk;
    }

    private String determineOutputApk() {
        String outputApk;
        if (this.zipalignOutputApk != null) {
            outputApk = this.zipalignOutputApk;
        } else {
            String outputPath = this.getAlignedApkLocation();
            this.getLog().debug((CharSequence)("Using default for zipalign.outputApk: " + outputPath));
            outputApk = outputPath;
        }
        return outputApk;
    }
}

