/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.internal;

import com.influxdb.v3.client.InfluxDBApiException;
import com.influxdb.v3.client.InfluxDBClient;
import com.influxdb.v3.client.Point;
import com.influxdb.v3.client.PointValues;
import com.influxdb.v3.client.config.ClientConfig;
import com.influxdb.v3.client.internal.Arguments;
import com.influxdb.v3.client.internal.FlightSqlClient;
import com.influxdb.v3.client.internal.RestClient;
import com.influxdb.v3.client.internal.VectorSchemaRootConverter;
import com.influxdb.v3.client.query.QueryOptions;
import com.influxdb.v3.client.write.WriteOptions;
import com.influxdb.v3.client.write.WritePrecision;
import io.netty.handler.codec.http.HttpMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.vector.VectorSchemaRoot;

public final class InfluxDBClientImpl
implements InfluxDBClient {
    private static final Logger LOG = Logger.getLogger(InfluxDBClientImpl.class.getName());
    private static final String DATABASE_REQUIRED_MESSAGE = "Please specify the 'Database' as a method parameter or use default configuration at 'ClientConfig.database'.";
    private static final Map<String, Object> NO_PARAMETERS = Map.of();
    private static final List<Class<?>> ALLOWED_NAMED_PARAMETER_TYPES = List.of(String.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class);
    private boolean closed = false;
    private final ClientConfig config;
    private final RestClient restClient;
    private final FlightSqlClient flightSqlClient;

    public InfluxDBClientImpl(@Nonnull ClientConfig config) {
        this(config, null, null);
    }

    InfluxDBClientImpl(@Nonnull ClientConfig config, @Nullable RestClient restClient, @Nullable FlightSqlClient flightSqlClient) {
        Arguments.checkNotNull(config, "config");
        config.validate();
        this.config = config;
        this.restClient = restClient != null ? restClient : new RestClient(config);
        this.flightSqlClient = flightSqlClient != null ? flightSqlClient : new FlightSqlClient(config);
    }

    @Override
    public void writeRecord(@Nullable String record) {
        this.writeRecord(record, WriteOptions.DEFAULTS);
    }

    @Override
    public void writeRecord(@Nullable String record, @Nonnull WriteOptions options) {
        if (record == null) {
            return;
        }
        this.writeRecords(Collections.singletonList(record), options);
    }

    @Override
    public void writeRecords(@Nonnull List<String> records) {
        this.writeRecords(records, WriteOptions.DEFAULTS);
    }

    @Override
    public void writeRecords(@Nonnull List<String> records, @Nonnull WriteOptions options) {
        this.writeData(records, options);
    }

    @Override
    public void writePoint(@Nullable Point point) {
        this.writePoint(point, WriteOptions.DEFAULTS);
    }

    @Override
    public void writePoint(@Nullable Point point, @Nonnull WriteOptions options) {
        if (point == null) {
            return;
        }
        this.writePoints(Collections.singletonList(point), options);
    }

    @Override
    public void writePoints(@Nonnull List<Point> points) {
        this.writePoints(points, WriteOptions.DEFAULTS);
    }

    @Override
    public void writePoints(@Nonnull List<Point> points, @Nonnull WriteOptions options) {
        this.writeData(points, options);
    }

    @Override
    @Nonnull
    public Stream<Object[]> query(@Nonnull String query) {
        return this.query(query, NO_PARAMETERS, QueryOptions.DEFAULTS);
    }

    @Override
    @Nonnull
    public Stream<Object[]> query(@Nonnull String query, @Nonnull QueryOptions options) {
        return this.query(query, NO_PARAMETERS, options);
    }

    @Override
    @Nonnull
    public Stream<Object[]> query(@Nonnull String query, @Nonnull Map<String, Object> parameters) {
        return this.query(query, parameters, QueryOptions.DEFAULTS);
    }

    @Override
    @Nonnull
    public Stream<Object[]> query(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        return this.queryData(query, parameters, options).flatMap(vector -> IntStream.range(0, vector.getRowCount()).mapToObj(rowNumber -> VectorSchemaRootConverter.INSTANCE.getArrayObjectFromVectorSchemaRoot((VectorSchemaRoot)vector, rowNumber)));
    }

    @Override
    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String query) {
        return this.queryPoints(query, QueryOptions.DEFAULTS);
    }

    @Override
    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String query, @Nonnull QueryOptions options) {
        return this.queryPoints(query, NO_PARAMETERS, options);
    }

    @Override
    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String query, @Nonnull Map<String, Object> parameters) {
        return this.queryPoints(query, parameters, QueryOptions.DEFAULTS);
    }

    @Override
    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        return this.queryData(query, parameters, options).flatMap(vector -> {
            List fieldVectors = vector.getFieldVectors();
            return IntStream.range(0, vector.getRowCount()).mapToObj(row -> VectorSchemaRootConverter.INSTANCE.toPointValues(row, fieldVectors));
        });
    }

    @Override
    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String query) {
        return this.queryBatches(query, QueryOptions.DEFAULTS);
    }

    @Override
    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String query, @Nonnull QueryOptions options) {
        return this.queryBatches(query, NO_PARAMETERS, options);
    }

    @Override
    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String query, @Nonnull Map<String, Object> parameters) {
        return this.queryBatches(query, parameters, QueryOptions.DEFAULTS);
    }

    @Override
    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        return this.queryData(query, parameters, options);
    }

    @Override
    public void close() throws Exception {
        this.restClient.close();
        this.flightSqlClient.close();
        this.closed = true;
    }

    private <T> void writeData(@Nonnull List<T> data, @Nonnull WriteOptions options) {
        Arguments.checkNotNull(data, "data");
        Arguments.checkNotNull(options, "options");
        if (this.closed) {
            throw new IllegalStateException("InfluxDBClient has been closed.");
        }
        final String database = options.databaseSafe(this.config);
        if (database == null || database.isEmpty()) {
            throw new IllegalStateException(DATABASE_REQUIRED_MESSAGE);
        }
        final WritePrecision precision = options.precisionSafe(this.config);
        HashMap<String, String> queryParams = new HashMap<String, String>(){
            {
                this.put("bucket", database);
                this.put("org", InfluxDBClientImpl.this.config.getOrganization());
                this.put("precision", precision.name().toLowerCase());
            }
        };
        Map<String, String> defaultTags = options.defaultTagsSafe(this.config);
        String lineProtocol = data.stream().map(item -> {
            if (item == null) {
                return null;
            }
            if (item instanceof Point) {
                for (String key : defaultTags.keySet()) {
                    ((Point)item).setTag(key, (String)defaultTags.get(key));
                }
                return ((Point)item).toLineProtocol();
            }
            return item.toString();
        }).filter(it -> it != null && !it.isEmpty()).collect(Collectors.joining("\n"));
        if (lineProtocol.isEmpty()) {
            LOG.warning("No data to write, please check your input data.");
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>(Map.of("Content-Type", "text/plain; charset=utf-8"));
        byte[] body = lineProtocol.getBytes(StandardCharsets.UTF_8);
        if (lineProtocol.length() >= options.gzipThresholdSafe(this.config)) {
            try {
                body = this.gzipData(lineProtocol.getBytes(StandardCharsets.UTF_8));
                headers.put("Content-Encoding", "gzip");
            }
            catch (IOException e) {
                throw new InfluxDBApiException(e);
            }
        }
        headers.putAll(options.headersSafe());
        this.restClient.request("api/v2/write", HttpMethod.POST, body, (Map<String, String>)queryParams, headers);
    }

    @Nonnull
    private Stream<VectorSchemaRoot> queryData(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNotNull(parameters, "parameters");
        Arguments.checkNotNull(options, "options");
        if (this.closed) {
            throw new IllegalStateException("InfluxDBClient has been closed.");
        }
        String database = options.databaseSafe(this.config);
        if (database == null || database.isEmpty()) {
            throw new IllegalStateException(DATABASE_REQUIRED_MESSAGE);
        }
        parameters.forEach((k, v) -> {
            if (!Objects.isNull(v) && !ALLOWED_NAMED_PARAMETER_TYPES.contains(v.getClass())) {
                throw new IllegalArgumentException(String.format("The parameter %s value has unsupported type: %s", k, v.getClass()));
            }
        });
        CallOption[] callOptions = options.grpcCallOptions().getCallOptions();
        return this.flightSqlClient.execute(query, database, options.queryTypeSafe(), parameters, options.headersSafe(), callOptions);
    }

    @Nonnull
    private byte[] gzipData(@Nonnull byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(data);
        gzip.close();
        return out.toByteArray();
    }
}

