/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.locale.LSR;
import com.ibm.icu.impl.locale.LocaleDistance;
import com.ibm.icu.impl.locale.XLikelySubtags;
import com.ibm.icu.util.LocalePriorityList;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class XLocaleMatcher {
    private static final LSR UND_LSR = new LSR("und", "", "");
    private static final ULocale UND_LOCALE = new ULocale("und");
    private static final Iterator<ULocale> NULL_ITERATOR = null;
    private static final boolean TRACE_MATCHER = false;
    private final int thresholdDistance;
    private final int demotionPerAdditionalDesiredLocale;
    private final LocaleDistance.DistanceOption distanceOption;
    private final ULocale[] supportedLocales;
    private final Locale[] supportedJavaLocales;
    private final Map<ULocale, Integer> supportedToIndex;
    private final Map<LSR, Indexes> supportedLsrToIndexes;
    private final LSR[] supportedLsrs;
    private final Indexes[] supportedIndexes;
    private final ULocale defaultLocale;
    private final Locale defaultJavaLocale;
    private final int defaultLocaleIndex;

    public static Builder builder() {
        return new Builder();
    }

    public XLocaleMatcher(String supportedLocales) {
        this(XLocaleMatcher.builder().setSupportedLocales(supportedLocales));
    }

    public XLocaleMatcher(LocalePriorityList supportedLocales) {
        this(XLocaleMatcher.builder().setSupportedLocales(supportedLocales));
    }

    public XLocaleMatcher(Set<ULocale> supportedLocales) {
        this(XLocaleMatcher.builder().setSupportedLocales((Collection<ULocale>)supportedLocales));
    }

    private XLocaleMatcher(Builder builder) {
        ULocale def;
        this.thresholdDistance = builder.thresholdDistance < 0 ? LocaleDistance.INSTANCE.getDefaultScriptDistance() : builder.thresholdDistance;
        int supportedLocalesLength = builder.supportedLocales.size();
        this.supportedLocales = new ULocale[supportedLocalesLength];
        this.supportedJavaLocales = new Locale[supportedLocalesLength];
        this.supportedToIndex = new HashMap<ULocale, Integer>(supportedLocalesLength);
        this.supportedLsrToIndexes = new LinkedHashMap<LSR, Indexes>(supportedLocalesLength);
        LinkedHashMap otherLsrToIndexes = null;
        LSR firstLSR = null;
        int i = 0;
        Iterator iterator = builder.supportedLocales.iterator();
        while (iterator.hasNext()) {
            ULocale locale;
            this.supportedLocales[i] = locale = (ULocale)iterator.next();
            this.supportedJavaLocales[i] = locale.toLocale();
            Integer oldIndex = this.supportedToIndex.get(locale);
            if (oldIndex == null) {
                this.supportedToIndex.put(locale, i);
            }
            LSR lsr = XLocaleMatcher.getMaximalLsrOrUnd(locale);
            if (i == 0) {
                firstLSR = lsr;
                this.supportedLsrToIndexes.put(lsr, new Indexes(0));
            } else if (lsr.equals(firstLSR) || LocaleDistance.INSTANCE.isParadigmLSR(lsr)) {
                XLocaleMatcher.addIndex(this.supportedLsrToIndexes, lsr, i);
            } else {
                if (otherLsrToIndexes == null) {
                    otherLsrToIndexes = new LinkedHashMap(supportedLocalesLength);
                }
                XLocaleMatcher.addIndex(otherLsrToIndexes, lsr, i);
            }
            ++i;
        }
        if (otherLsrToIndexes != null) {
            this.supportedLsrToIndexes.putAll(otherLsrToIndexes);
        }
        int numSuppLsrs = this.supportedLsrToIndexes.size();
        this.supportedLsrs = this.supportedLsrToIndexes.keySet().toArray(new LSR[numSuppLsrs]);
        this.supportedIndexes = this.supportedLsrToIndexes.values().toArray(new Indexes[numSuppLsrs]);
        Locale jdef = null;
        int idef = -1;
        if (builder.defaultLocale != null) {
            def = builder.defaultLocale;
        } else if (supportedLocalesLength > 0) {
            def = this.supportedLocales[0];
            jdef = this.supportedJavaLocales[0];
            idef = 0;
        } else {
            def = null;
        }
        if (jdef == null && def != null) {
            jdef = def.toLocale();
        }
        this.defaultLocale = def;
        this.defaultJavaLocale = jdef;
        this.defaultLocaleIndex = idef;
        this.demotionPerAdditionalDesiredLocale = builder.demotionPerAdditionalDesiredLocale < 0 ? LocaleDistance.INSTANCE.getDefaultRegionDistance() + 1 : builder.demotionPerAdditionalDesiredLocale;
        this.distanceOption = builder.distanceOption;
    }

    private static final void addIndex(Map<LSR, Indexes> lsrToIndexes, LSR lsr, int i) {
        Indexes indexes = lsrToIndexes.get(lsr);
        if (indexes == null) {
            lsrToIndexes.put(lsr, new Indexes(i));
        } else {
            indexes.add(i);
        }
    }

    private static final LSR getMaximalLsrOrUnd(ULocale locale) {
        if (locale.equals(UND_LOCALE)) {
            return UND_LSR;
        }
        return XLikelySubtags.INSTANCE.makeMaximizedLsrFrom(locale);
    }

    public ULocale getBestMatch(ULocale ulocale) {
        return this.getBestMatch((ULocale)ulocale, XLocaleMatcher.NULL_ITERATOR).supportedLocale;
    }

    public ULocale getBestMatch(String languageList) {
        return this.getBestMatch(LocalePriorityList.add(languageList).build(), null);
    }

    public ULocale getBestMatch(ULocale ... locales) {
        return this.getBestMatch(Arrays.asList(locales), null);
    }

    public ULocale getBestMatch(Iterable<ULocale> desiredLocales) {
        return this.getBestMatch(desiredLocales, null);
    }

    public ULocale getBestMatch(Iterable<ULocale> desiredLocales, Output<ULocale> outputBestDesired) {
        Iterator<ULocale> desiredIter = desiredLocales.iterator();
        if (!desiredIter.hasNext()) {
            if (outputBestDesired != null) {
                outputBestDesired.value = null;
            }
            return this.defaultLocale;
        }
        ULocale desiredLocale = desiredIter.next();
        return this.getBestMatch(desiredLocale, desiredIter, outputBestDesired);
    }

    private ULocale getBestMatch(ULocale desiredLocale, Iterator<ULocale> remainingIter, Output<ULocale> outputBestDesired) {
        Result result = this.getBestMatch(desiredLocale, remainingIter);
        if (outputBestDesired != null) {
            outputBestDesired.value = result.desiredLocale;
        }
        return result.supportedLocale;
    }

    private Result getBestMatch(ULocale desiredLocale, Iterator<ULocale> remainingIter) {
        int suppIndex;
        int desiredIndex = 0;
        int bestDesiredIndex = -1;
        ULocale bestDesiredLocale = null;
        int bestSupportedLsrIndex = 0;
        for (int bestDistance = this.thresholdDistance; bestDistance > 0; bestDistance -= this.demotionPerAdditionalDesiredLocale) {
            Integer supportedIndex = this.supportedToIndex.get(desiredLocale);
            if (supportedIndex != null) {
                int suppIndex2 = supportedIndex;
                return new Result(desiredLocale, this.supportedLocales[suppIndex2], this.supportedJavaLocales[suppIndex2], desiredIndex, suppIndex2);
            }
            LSR desiredLSR = XLocaleMatcher.getMaximalLsrOrUnd(desiredLocale);
            Indexes indexes = this.supportedLsrToIndexes.get(desiredLSR);
            if (indexes != null) {
                int suppIndex3 = indexes.getFirst();
                ULocale result = this.supportedLocales[suppIndex3];
                return new Result(desiredLocale, result, this.supportedJavaLocales[suppIndex3], desiredIndex, suppIndex3);
            }
            int bestIndexAndDistance = LocaleDistance.INSTANCE.getBestIndexAndDistance(desiredLSR, this.supportedLsrs, bestDistance, this.distanceOption);
            if (bestIndexAndDistance >= 0) {
                bestDistance = bestIndexAndDistance & 0xFF;
                bestDesiredIndex = desiredIndex;
                bestDesiredLocale = desiredLocale;
                bestSupportedLsrIndex = bestIndexAndDistance >> 8;
                if (bestDistance == 0) break;
            }
            if (remainingIter == null || !remainingIter.hasNext()) break;
            desiredLocale = remainingIter.next();
            ++desiredIndex;
        }
        if (bestDesiredIndex < 0) {
            return new Result(null, this.defaultLocale, this.defaultJavaLocale, -1, this.defaultLocaleIndex);
        }
        Indexes bestSupportedIndexes = this.supportedIndexes[bestSupportedLsrIndex];
        int i = 0;
        while ((suppIndex = bestSupportedIndexes.get(i)) >= 0) {
            ULocale locale = this.supportedLocales[suppIndex];
            if (bestDesiredLocale.equals(locale)) {
                return new Result(bestDesiredLocale, locale, this.supportedJavaLocales[suppIndex], bestDesiredIndex, suppIndex);
            }
            ++i;
        }
        suppIndex = bestSupportedIndexes.getFirst();
        ULocale result = this.supportedLocales[suppIndex];
        return new Result(bestDesiredLocale, result, this.supportedJavaLocales[suppIndex], bestDesiredIndex, suppIndex);
    }

    public ULocale getBestMatch(ULocale desiredLocale, Output<ULocale> outputBestDesired) {
        return this.getBestMatch(desiredLocale, null, outputBestDesired);
    }

    public Locale getBestJavaMatch(Iterable<Locale> desiredLocales, Output<Locale> outputBestDesired) {
        Iterator<Locale> desiredIter = desiredLocales.iterator();
        if (!desiredIter.hasNext()) {
            if (outputBestDesired != null) {
                outputBestDesired.value = null;
            }
            return this.defaultJavaLocale;
        }
        LocalesWrapper wrapper = new LocalesWrapper(desiredIter);
        ULocale desiredLocale = wrapper.next();
        Result result = this.getBestMatch(desiredLocale, NULL_ITERATOR);
        if (outputBestDesired != null) {
            outputBestDesired.value = result.desiredIndex >= 0 ? wrapper.getJavaLocale(result.desiredIndex) : null;
        }
        return result.supportedJavaLocale;
    }

    public Locale getBestJavaMatch(Locale desiredLocale, Output<Locale> outputBestDesired) {
        ULocale desiredULocale = ULocale.forLocale(desiredLocale);
        Result result = this.getBestMatch(desiredULocale, NULL_ITERATOR);
        if (outputBestDesired != null) {
            outputBestDesired.value = result.desiredIndex >= 0 ? desiredLocale : null;
        }
        return result.supportedJavaLocale;
    }

    public static ULocale combine(ULocale bestSupported, ULocale bestDesired) {
        if (!bestSupported.equals(bestDesired) && bestDesired != null) {
            String variants;
            ULocale.Builder b = new ULocale.Builder().setLocale(bestSupported);
            String region = bestDesired.getCountry();
            if (!region.isEmpty()) {
                b.setRegion(region);
            }
            if (!(variants = bestDesired.getVariant()).isEmpty()) {
                b.setVariant(variants);
            }
            for (char extensionKey : bestDesired.getExtensionKeys()) {
                b.setExtension(extensionKey, bestDesired.getExtension(extensionKey));
            }
            bestSupported = b.build();
        }
        return bestSupported;
    }

    public int distance(ULocale desired, ULocale supported) {
        return LocaleDistance.INSTANCE.getBestIndexAndDistance(XLikelySubtags.INSTANCE.makeMaximizedLsrFrom(desired), new LSR[]{XLikelySubtags.INSTANCE.makeMaximizedLsrFrom(supported)}, this.thresholdDistance, this.distanceOption) & 0xFF;
    }

    public int distance(String desiredLanguage, String supportedLanguage) {
        return LocaleDistance.INSTANCE.getBestIndexAndDistance(XLikelySubtags.INSTANCE.makeMaximizedLsrFrom(new ULocale(desiredLanguage)), new LSR[]{XLikelySubtags.INSTANCE.makeMaximizedLsrFrom(new ULocale(supportedLanguage))}, this.thresholdDistance, this.distanceOption) & 0xFF;
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("{XLocaleMatcher");
        if (this.supportedLocales.length > 0) {
            s.append(" supported={").append(this.supportedLocales[0].toString());
            for (int i = 1; i < this.supportedLocales.length; ++i) {
                s.append(", ").append(this.supportedLocales[1].toString());
            }
            s.append('}');
        }
        s.append(" default=").append(Objects.toString(this.defaultLocale));
        if (this.distanceOption != null) {
            s.append(" distance=").append(this.distanceOption.toString());
        }
        if (this.thresholdDistance >= 0) {
            s.append(String.format(" threshold=%d", this.thresholdDistance));
        }
        s.append(String.format(" demotion=%d", this.demotionPerAdditionalDesiredLocale));
        return s.append('}').toString();
    }

    public double match(ULocale desired, ULocale supported) {
        return (double)(100 - this.distance(desired, supported)) / 100.0;
    }

    @Deprecated
    public double match(ULocale desired, ULocale desiredMax, ULocale supported, ULocale supportedMax) {
        return this.match(desired, supported);
    }

    public ULocale canonicalize(ULocale ulocale) {
        return null;
    }

    public int getThresholdDistance() {
        return this.thresholdDistance;
    }

    private static final class LocalesWrapper
    implements Iterator<ULocale> {
        private Iterator<Locale> locales;
        private Locale first;
        private Locale second;
        private List<Locale> remaining;

        LocalesWrapper(Iterator<Locale> locales) {
            this.locales = locales;
        }

        @Override
        public boolean hasNext() {
            return this.locales.hasNext();
        }

        @Override
        public ULocale next() {
            Locale locale = this.locales.next();
            if (this.first == null) {
                this.first = locale;
            } else if (this.second == null) {
                this.second = locale;
            } else {
                if (this.remaining == null) {
                    this.remaining = new ArrayList<Locale>();
                }
                this.remaining.add(locale);
            }
            return ULocale.forLocale(locale);
        }

        Locale getJavaLocale(int i) {
            if (i == 0) {
                return this.first;
            }
            if (i == 1) {
                return this.second;
            }
            return this.remaining.get(i - 2);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder {
        private Set<ULocale> supportedLocales;
        private int thresholdDistance = -1;
        private int demotionPerAdditionalDesiredLocale = -1;
        private ULocale defaultLocale;
        private LocaleDistance.DistanceOption distanceOption;

        public Builder setSupportedLocales(String locales) {
            return this.setSupportedLocales(LocalePriorityList.add(locales).build());
        }

        public Builder setSupportedLocales(Iterable<ULocale> locales) {
            this.supportedLocales = new LinkedHashSet<ULocale>();
            for (ULocale locale : locales) {
                this.supportedLocales.add(locale);
            }
            return this;
        }

        public Builder setSupportedLocales(Collection<ULocale> locales) {
            this.supportedLocales = new LinkedHashSet<ULocale>(locales);
            return this;
        }

        public Builder setSupportedJavaLocales(Collection<Locale> locales) {
            this.supportedLocales = new LinkedHashSet<ULocale>(locales.size());
            for (Locale locale : locales) {
                this.supportedLocales.add(ULocale.forLocale(locale));
            }
            return this;
        }

        public Builder addSupportedLocale(ULocale locale) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new LinkedHashSet<ULocale>();
            }
            this.supportedLocales.add(locale);
            return this;
        }

        public Builder addSupportedLocale(Locale locale) {
            return this.addSupportedLocale(ULocale.forLocale(locale));
        }

        public Builder setThresholdDistance(int thresholdDistance) {
            if (thresholdDistance > 100) {
                thresholdDistance = 100;
            }
            this.thresholdDistance = thresholdDistance;
            return this;
        }

        public Builder setDemotionPerAdditionalDesiredLocale(int demotionPerAdditionalDesiredLocale) {
            this.demotionPerAdditionalDesiredLocale = demotionPerAdditionalDesiredLocale;
            return this;
        }

        public Builder setDefaultLanguage(ULocale defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public Builder setDistanceOption(LocaleDistance.DistanceOption distanceOption) {
            this.distanceOption = distanceOption;
            return this;
        }

        public XLocaleMatcher build() {
            return new XLocaleMatcher(this);
        }

        public String toString() {
            StringBuilder s = new StringBuilder().append("{XLocaleMatcher.Builder");
            if (!this.supportedLocales.isEmpty()) {
                s.append(" supported={").append(this.supportedLocales.toString()).append('}');
            }
            if (this.defaultLocale != null) {
                s.append(" default=").append(this.defaultLocale.toString());
            }
            if (this.distanceOption != null) {
                s.append(" distance=").append(this.distanceOption.toString());
            }
            if (this.thresholdDistance >= 0) {
                s.append(String.format(" threshold=%d", this.thresholdDistance));
            }
            if (this.demotionPerAdditionalDesiredLocale >= 0) {
                s.append(String.format(" demotion=%d", this.demotionPerAdditionalDesiredLocale));
            }
            return s.append('}').toString();
        }
    }

    private static final class Result {
        ULocale desiredLocale;
        ULocale supportedLocale;
        Locale supportedJavaLocale;
        int desiredIndex;
        int supportedIndex;

        private Result(ULocale desired, ULocale supported, Locale jsupported, int desIndex, int suppIndex) {
            this.desiredLocale = desired;
            this.supportedLocale = supported;
            this.supportedJavaLocale = jsupported;
            this.desiredIndex = desIndex;
            this.supportedIndex = suppIndex;
        }
    }

    private static final class Indexes {
        int first;
        int second = -1;
        List<Integer> remaining;

        Indexes(int firstIndex) {
            this.first = firstIndex;
        }

        void add(int i) {
            if (this.second < 0) {
                this.second = i;
            } else {
                if (this.remaining == null) {
                    this.remaining = new ArrayList<Integer>();
                }
                this.remaining.add(i);
            }
        }

        int getFirst() {
            return this.first;
        }

        int get(int i) {
            if (i == 0) {
                return this.first;
            }
            if (i == 1) {
                return this.second;
            }
            if (this.remaining != null && (i -= 2) < this.remaining.size()) {
                return this.remaining.get(i);
            }
            return -1;
        }
    }
}

