/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.client;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hortonworks.registries.schemaregistry.SchemaMetadataInfo;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.exceptions.RegistryException;
import com.hortonworks.registries.schemaregistry.exceptions.RegistryRetryableException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaMetadataCache {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaMetadataCache.class);
    private final LoadingCache<Key, SchemaMetadataInfo> loadingCache;

    public SchemaMetadataCache(Long size, Long expiryInSecs, final SchemaMetadataFetcher schemaMetadataFetcher) {
        this.loadingCache = CacheBuilder.newBuilder().maximumSize(size.longValue()).expireAfterAccess(expiryInSecs.longValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Key, SchemaMetadataInfo>(){

            public SchemaMetadataInfo load(Key key) throws Exception {
                if (key.getName() != null) {
                    return schemaMetadataFetcher.fetch(key.getName());
                }
                if (key.getId() != null) {
                    return schemaMetadataFetcher.fetch(key.getId());
                }
                throw new RegistryException("Key should have name or id as non null");
            }
        });
    }

    public SchemaMetadataInfo get(Key key) {
        SchemaMetadataInfo schemaMetadataInfo;
        try {
            schemaMetadataInfo = (SchemaMetadataInfo)this.loadingCache.get((Object)key);
        }
        catch (ExecutionException e) {
            LOG.error("Error occurred while retrieving schema metadata for [{}]", (Object)key, (Object)e);
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new RegistryRetryableException(cause.getMessage(), cause);
            }
            if (cause instanceof RuntimeException) {
                if (cause.getCause() instanceof IOException) {
                    throw new RegistryRetryableException(cause.getMessage(), cause);
                }
                throw new RegistryException(cause.getMessage(), cause);
            }
            if (!(cause instanceof SchemaNotFoundException)) {
                throw new RegistryException(cause.getMessage(), cause);
            }
            schemaMetadataInfo = null;
        }
        return schemaMetadataInfo;
    }

    public void put(Key key, SchemaMetadataInfo schemaMetadataInfo) {
        this.loadingCache.put((Object)key, (Object)schemaMetadataInfo);
    }

    public SchemaMetadataInfo getIfPresent(Key key) {
        return (SchemaMetadataInfo)this.loadingCache.getIfPresent((Object)key);
    }

    public static class Key {
        private String name;
        private Long id;

        private Key(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name can not be null");
            this.name = name;
        }

        private Key(Long id) {
            Preconditions.checkNotNull((Object)id, (Object)"id can not be null");
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public Long getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.name != null ? !this.name.equals(key.name) : key.name != null) {
                return false;
            }
            return this.id != null ? this.id.equals(key.id) : key.id == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }

        public static Key of(String name) {
            return new Key(name);
        }

        public static Key of(Long id) {
            return new Key(id);
        }
    }

    public static interface SchemaMetadataFetcher {
        public SchemaMetadataInfo fetch(String var1) throws SchemaNotFoundException;

        public SchemaMetadataInfo fetch(Long var1) throws SchemaNotFoundException;
    }
}

