/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsImmutableObject;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.clone.CloneHelper;
import com.helger.base.clone.ICloneable;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.state.EChange;
import com.helger.collection.ECollectionBaseType;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class CollectionHelper {
    protected CollectionHelper() {
    }

    public static @Nullable ECollectionBaseType getCollectionBaseTypeOfClass(@Nullable Class<?> clazz) {
        if (clazz != null) {
            if (Set.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.SET;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.COLLECTION;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.MAP;
            }
            if (ClassHelper.isArrayClass(clazz)) {
                return ECollectionBaseType.ARRAY;
            }
            if (Iterator.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.ITERATOR;
            }
            if (Iterable.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.ITERABLE;
            }
            if (Enumeration.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.ENUMERATION;
            }
        }
        return null;
    }

    public static @Nullable ECollectionBaseType getCollectionBaseTypeOfObject(@Nullable Object object) {
        return object == null ? null : CollectionHelper.getCollectionBaseTypeOfClass(object.getClass());
    }

    public static boolean isCollectionClass(@Nullable Class<?> clazz) {
        return CollectionHelper.getCollectionBaseTypeOfClass(clazz) != null;
    }

    public static boolean isCollectionObject(@Nullable Object object) {
        return CollectionHelper.getCollectionBaseTypeOfObject(object) != null;
    }

    public static boolean isEmpty(@Nullable Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Iterable<?> iterable) {
        return iterable != null && iterable.iterator().hasNext();
    }

    public static boolean isNotEmpty(@Nullable Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    @Nonnegative
    public static int getSize(@Nullable Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    @Nonnegative
    public static int getSize(@Nullable Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }

    @Nonnegative
    public static int getSizeIterator(@Nullable Iterator<?> iterator) {
        int n = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getSize(@Nullable Iterable<?> iterable) {
        return iterable == null ? 0 : CollectionHelper.getSizeIterator(iterable.iterator());
    }

    @Nonnegative
    public static int getSize(@Nullable Enumeration<?> enumeration) {
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static <ELEMENTTYPE> int getCount(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return CollectionHelper.getSize(iterable);
        }
        int n = 0;
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static <ELEMENTTYPE> int getCount(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return CollectionHelper.getSize(collection);
        }
        int n = 0;
        if (CollectionHelper.isNotEmpty(collection)) {
            for (ELEMENTTYPE ELEMENTTYPE : collection) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                ++n;
            }
        }
        return n;
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE getAtIndex(@Nullable List<? extends ELEMENTTYPE> list, int n) {
        return CollectionHelper.getAtIndex(list, n, null);
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE getAtIndex(@Nullable List<? extends ELEMENTTYPE> list, int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return list != null && n >= 0 && n < list.size() ? list.get(n) : ELEMENTTYPE;
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE getAtIndex(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnegative int n) {
        return CollectionHelper.getAtIndex(iterable, n, null);
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE getAtIndex(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (n >= 0) {
            int n2 = 0;
            for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
                if (n2 == n) {
                    return ELEMENTTYPE2;
                }
                ++n2;
            }
        }
        return ELEMENTTYPE;
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE getAtIndex(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n) {
        return CollectionHelper.getAtIndex(iterable, predicate, n, null);
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE getAtIndex(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (predicate == null) {
            return CollectionHelper.getAtIndex(iterable, n, ELEMENTTYPE);
        }
        if (n >= 0) {
            int n2 = 0;
            for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
                if (!predicate.test(ELEMENTTYPE2)) continue;
                if (n2 == n) {
                    return ELEMENTTYPE2;
                }
                ++n2;
            }
        }
        return ELEMENTTYPE;
    }

    public static <SRCTYPE, DSTTYPE> @Nullable DSTTYPE getAtIndexMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnegative int n, @NonNull Function<? super SRCTYPE, ? extends DSTTYPE> function) {
        return CollectionHelper.getAtIndexMapped(iterable, n, function, null);
    }

    public static <SRCTYPE, DSTTYPE> @Nullable DSTTYPE getAtIndexMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnegative int n, @NonNull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        if (n >= 0) {
            int n2 = 0;
            for (SRCTYPE SRCTYPE : iterable) {
                if (n2 == n) {
                    return function.apply(SRCTYPE);
                }
                ++n2;
            }
        }
        return DSTTYPE;
    }

    public static <SRCTYPE, DSTTYPE> @Nullable DSTTYPE getAtIndexMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnegative int n, @NonNull Function<? super SRCTYPE, ? extends DSTTYPE> function) {
        return CollectionHelper.getAtIndexMapped(iterable, predicate, n, function, null);
    }

    public static <SRCTYPE, DSTTYPE> @Nullable DSTTYPE getAtIndexMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnegative int n, @NonNull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        if (predicate == null) {
            return CollectionHelper.getAtIndexMapped(iterable, n, function, DSTTYPE);
        }
        if (n >= 0) {
            int n2 = 0;
            for (SRCTYPE SRCTYPE : iterable) {
                if (!predicate.test(SRCTYPE)) continue;
                if (n2 == n) {
                    return function.apply(SRCTYPE);
                }
                ++n2;
            }
        }
        return DSTTYPE;
    }

    @SafeVarargs
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> @Nullable List<ELEMENTTYPE> makeUnmodifiable(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ELEMENTTYPEArray == null ? null : Collections.unmodifiableList(Arrays.asList(ELEMENTTYPEArray));
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> @Nullable Collection<ELEMENTTYPE> makeUnmodifiable(@Nullable Collection<ELEMENTTYPE> collection) {
        return collection == null ? null : Collections.unmodifiableCollection(collection);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> @Nullable List<ELEMENTTYPE> makeUnmodifiable(@Nullable List<ELEMENTTYPE> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> @Nullable Set<ELEMENTTYPE> makeUnmodifiable(@Nullable Set<ELEMENTTYPE> set) {
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <KEYTYPE, VALUETYPE> @Nullable Map<KEYTYPE, VALUETYPE> makeUnmodifiable(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> @Nullable NavigableSet<ELEMENTTYPE> makeUnmodifiable(@Nullable NavigableSet<ELEMENTTYPE> navigableSet) {
        return navigableSet == null ? null : Collections.unmodifiableNavigableSet(navigableSet);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <KEYTYPE, VALUETYPE> @Nullable NavigableMap<KEYTYPE, VALUETYPE> makeUnmodifiable(@Nullable NavigableMap<KEYTYPE, VALUETYPE> navigableMap) {
        return navigableMap == null ? null : Collections.unmodifiableNavigableMap(navigableMap);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> @NonNull Collection<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable Collection<ELEMENTTYPE> collection) {
        return collection == null ? Collections.emptyList() : Collections.unmodifiableCollection(collection);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> @NonNull List<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable List<ELEMENTTYPE> list) {
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> @NonNull Set<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable Set<ELEMENTTYPE> set) {
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <KEYTYPE, VALUETYPE> @NonNull Map<KEYTYPE, VALUETYPE> makeUnmodifiableNotNull(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> @NonNull NavigableSet<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable NavigableSet<ELEMENTTYPE> navigableSet) {
        return navigableSet == null ? Collections.emptyNavigableSet() : Collections.unmodifiableNavigableSet(navigableSet);
    }

    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> @NonNull NavigableMap<KEYTYPE, VALUETYPE> makeUnmodifiableNotNull(@Nullable NavigableMap<KEYTYPE, VALUETYPE> navigableMap) {
        return navigableMap == null ? Collections.emptyNavigableMap() : Collections.unmodifiableNavigableMap(navigableMap);
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE removeFirstElement(@Nullable List<ELEMENTTYPE> list) {
        return CollectionHelper.isEmpty(list) ? null : (ELEMENTTYPE)list.remove(0);
    }

    public static @NonNull EChange removeAtIndex(@Nullable List<?> list, int n) {
        if (list == null || n < 0 || n >= list.size()) {
            return EChange.UNCHANGED;
        }
        list.remove(n);
        return EChange.CHANGED;
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE removeAndReturnElementAtIndex(@Nullable List<ELEMENTTYPE> list, int n) {
        if (list == null || n < 0 || n >= list.size()) {
            return null;
        }
        return list.remove(n);
    }

    public static <ELEMENTTYPE> @Nullable ELEMENTTYPE removeLastElement(@Nullable List<ELEMENTTYPE> list) {
        int n = CollectionHelper.getSize(list);
        return n == 0 ? null : (ELEMENTTYPE)list.remove(n - 1);
    }

    @ReturnsMutableCopy
    public static <DATATYPE> @NonNull ICommonsList<DATATYPE> getGenericClonedList(@Nullable Iterable<DATATYPE> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iterable != null) {
            for (DATATYPE DATATYPE : iterable) {
                commonsArrayList.add(CloneHelper.getClonedValue(DATATYPE));
            }
        }
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public static <DATATYPE extends ICloneable<DATATYPE>> @NonNull ICommonsList<DATATYPE> getClonedList(@Nullable Iterable<DATATYPE> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iterable != null) {
            for (ICloneable iCloneable : iterable) {
                commonsArrayList.add(CloneHelper.getCloneIfNotNull((ICloneable)iCloneable));
            }
        }
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @Nullable CommonsArrayList<ELEMENTTYPE> getReverseList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return new CommonsArrayList(0);
        }
        CommonsArrayList<Collection<ELEMENTTYPE>> commonsArrayList = new CommonsArrayList<Collection<ELEMENTTYPE>>(collection);
        commonsArrayList.reverse();
        return commonsArrayList;
    }

    @ReturnsMutableObject(value="semantics of this method")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, LISTTYPE extends List<ELEMENTTYPE>> @Nullable LISTTYPE getReverseInlineList(@Nullable LISTTYPE LISTTYPE) {
        if (LISTTYPE == null) {
            return null;
        }
        Collections.reverse(LISTTYPE);
        return LISTTYPE;
    }
}

