/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mavennatives.nativedependencies;

import com.googlecode.mavennatives.nativedependencies.IJarUnpacker;
import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public class CopyNativesMojo
extends AbstractMojo {
    private MavenProject project;
    private File nativesTargetDir;
    private boolean separateDirs;
    private IJarUnpacker jarUnpacker;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)("Saving natives in " + this.nativesTargetDir));
            if (this.separateDirs) {
                this.getLog().info((CharSequence)"Storing artifacts in separate dirs according to classifier");
            }
            Set artifacts = this.project.getArtifacts();
            this.nativesTargetDir.mkdirs();
            for (Artifact artifact : artifacts) {
                String classifier = artifact.getClassifier();
                if (classifier == null || !classifier.startsWith("natives-")) continue;
                this.getLog().info((CharSequence)String.format("G:%s - A:%s - C:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier()));
                File artifactDir = this.nativesTargetDir;
                if (this.separateDirs) {
                    String suffix = classifier.substring("natives-".length());
                    artifactDir = new File(this.nativesTargetDir, suffix);
                    artifactDir.mkdirs();
                }
                this.jarUnpacker.copyJarContent(artifact.getFile(), artifactDir);
            }
            this.buildContext.refresh(this.nativesTargetDir);
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to copy natives", (Throwable)e);
        }
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.project = mavenProject;
    }

    public void setNativesTargetDir(File nativesTargetDir2) {
        this.nativesTargetDir = nativesTargetDir2;
    }

    public void setJarUnpacker(IJarUnpacker jarUnpacker) {
        this.jarUnpacker = jarUnpacker;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }
}

