/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapConsumerFactory;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapping;
import com.google.gwt.thirdparty.debugging.sourcemap.proto.Mapping;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceDeobfuscator {
    private static Pattern JsniRefPattern = Pattern.compile("@?([^:]+)::([^(]+)(\\((.*)\\))?");
    private static final int LINE_NUMBER_UNKNOWN = -1;
    Pattern fragmentIdPattern = Pattern.compile(".*(\\d+)\\.js");
    protected File symbolMapsDirectory;
    private Map<String, SourceMapping> sourceMaps = new HashMap<String, SourceMapping>();
    private Map<String, SymbolMap> symbolMaps = new HashMap<String, SymbolMap>();

    public StackTraceDeobfuscator(String symbolMapsDirectory) {
        this.setSymbolMapsDirectory(symbolMapsDirectory);
    }

    public LogRecord deobfuscateLogRecord(LogRecord lr, String strongName) {
        if (lr.getThrown() != null && strongName != null) {
            lr.setThrown(this.deobfuscateThrowable(lr.getThrown(), strongName));
        }
        return lr;
    }

    public StackTraceElement[] deobfuscateStackTrace(StackTraceElement[] st, String strongName) {
        StackTraceElement[] newSt = new StackTraceElement[st.length];
        for (int i = 0; i < st.length; ++i) {
            newSt[i] = this.resymbolize(st[i], strongName);
        }
        return newSt;
    }

    public StackTraceElement resymbolize(StackTraceElement ste, String strongName) {
        Mapping.OriginalMapping mappingForLine;
        SourceMapping sourceMapping;
        String[] parts;
        int columnMarkerIndex;
        String declaringClass = null;
        String methodName = null;
        String filename = null;
        int lineNumber = -1;
        int fragmentId = -1;
        String steFilename = ste.getFileName();
        SymbolMap map = this.loadSymbolMap(strongName);
        String symbolData = map == null ? null : (String)map.get(ste.getMethodName());
        boolean sourceMapCapable = false;
        int column = 1;
        if (steFilename != null && (columnMarkerIndex = steFilename.indexOf("@")) != -1) {
            try {
                column = Integer.parseInt(steFilename.substring(columnMarkerIndex + 1));
                sourceMapCapable = true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            steFilename = steFilename.substring(0, columnMarkerIndex);
        }
        if (symbolData != null && (parts = symbolData.split(",")).length == 6) {
            String[] ref = this.parse(parts[0].substring(0, parts[0].lastIndexOf(41) + 1));
            if (ref != null) {
                declaringClass = ref[0];
                methodName = ref[1];
            } else {
                declaringClass = ste.getClassName();
                methodName = ste.getMethodName();
            }
            filename = "Unknown".equals(parts[3]) ? null : parts[3].substring(parts[3].lastIndexOf(47) + 1);
            lineNumber = ste.getLineNumber();
            if (lineNumber == -1 || sourceMapCapable && column == -1) {
                lineNumber = Integer.parseInt(parts[4]);
            }
            fragmentId = Integer.parseInt(parts[5]);
        }
        if (fragmentId == -1 && steFilename != null) {
            Matcher matcher = this.fragmentIdPattern.matcher(steFilename);
            if (matcher.matches()) {
                String fragment = matcher.group(1);
                try {
                    fragmentId = Integer.parseInt(fragment);
                }
                catch (Exception e) {}
            } else if (steFilename.contains(strongName)) {
                fragmentId = 0;
            }
        }
        int jsLineNumber = ste.getLineNumber();
        if (sourceMapCapable && fragmentId != -1 && column != -1 && (sourceMapping = this.loadSourceMap(strongName, fragmentId)) != null && ste.getLineNumber() > -1 && (mappingForLine = sourceMapping.getMappingForLine(jsLineNumber, column)) != null) {
            if (declaringClass == null || declaringClass.equals(ste.getClassName())) {
                declaringClass = mappingForLine.getOriginalFile();
                methodName = mappingForLine.getIdentifier();
            }
            filename = mappingForLine.getOriginalFile();
            lineNumber = mappingForLine.getLineNumber();
        }
        if (declaringClass != null) {
            return new StackTraceElement(declaringClass, methodName, filename, lineNumber);
        }
        return ste;
    }

    public void setSymbolMapsDirectory(String symbolMapsDirectory) {
        this.symbolMapsDirectory = new File(symbolMapsDirectory);
    }

    protected InputStream getSourceMapInputStream(String permutationStrongName, int fragmentNumber) throws IOException {
        String filename = this.symbolMapsDirectory.getCanonicalPath() + File.separatorChar + permutationStrongName + "_sourceMap" + fragmentNumber + ".json";
        return new FileInputStream(filename);
    }

    protected InputStream getSymbolMapInputStream(String permutationStrongName) throws IOException {
        String filename = this.symbolMapsDirectory.getCanonicalPath() + File.separatorChar + permutationStrongName + ".symbolMap";
        return new FileInputStream(filename);
    }

    private Throwable deobfuscateThrowable(Throwable old, String strongName) {
        Throwable t = new Throwable(old.getMessage());
        if (old.getStackTrace() != null) {
            t.setStackTrace(this.deobfuscateStackTrace(old.getStackTrace(), strongName));
        } else {
            t.setStackTrace(new StackTraceElement[0]);
        }
        if (old.getCause() != null) {
            t.initCause(this.deobfuscateThrowable(old.getCause(), strongName));
        }
        return t;
    }

    private SourceMapping loadSourceMap(String permutationStrongName, int fragmentId) {
        SourceMapping toReturn = this.sourceMaps.get(permutationStrongName + fragmentId);
        if (toReturn == null) {
            try {
                String sourceMapString = this.loadStreamAsString(this.getSourceMapInputStream(permutationStrongName, fragmentId));
                toReturn = SourceMapConsumerFactory.parse(sourceMapString);
                this.sourceMaps.put(permutationStrongName + fragmentId, toReturn);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return toReturn;
    }

    private String loadStreamAsString(InputStream stream) {
        return new Scanner(stream).useDelimiter("\\A").next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SymbolMap loadSymbolMap(String strongName) {
        SymbolMap toReturn = this.symbolMaps.get(strongName);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = new SymbolMap();
        try {
            BufferedReader bin = new BufferedReader(new InputStreamReader(this.getSymbolMapInputStream(strongName)));
            try {
                String line;
                while ((line = bin.readLine()) != null) {
                    if (line.charAt(0) == '#') continue;
                    int idx = line.indexOf(44);
                    toReturn.put(new String(line.substring(0, idx)), line.substring(idx + 1));
                }
            }
            finally {
                bin.close();
            }
        }
        catch (IOException e) {
            toReturn = new SymbolMap();
        }
        this.symbolMaps.put(strongName, toReturn);
        return toReturn;
    }

    private String[] parse(String refString) {
        Matcher matcher = JsniRefPattern.matcher(refString);
        if (!matcher.matches()) {
            return null;
        }
        String className = matcher.group(1);
        String memberName = matcher.group(2);
        String[] toReturn = new String[]{className, memberName};
        return toReturn;
    }

    private static class SymbolMap
    extends HashMap<String, String> {
        private SymbolMap() {
        }
    }
}

