/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.vm.impl;

import com.google.gwt.core.client.impl.WeakMapping;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.impl.AbstractAutoBean;
import com.google.web.bindery.autobean.vm.Configuration;
import com.google.web.bindery.autobean.vm.impl.BeanMethod;
import com.google.web.bindery.autobean.vm.impl.BeanPropertyContext;
import com.google.web.bindery.autobean.vm.impl.GetterPropertyContext;
import com.google.web.bindery.autobean.vm.impl.MethodPropertyContext;
import com.google.web.bindery.autobean.vm.impl.ShimHandler;
import com.google.web.bindery.autobean.vm.impl.SimpleBeanHandler;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyAutoBean<T>
extends AbstractAutoBean<T> {
    private static final Map<Class<?>, Data> cache = new WeakHashMap();
    private final Class<T> beanType;
    private final Configuration configuration;
    private final Data data;
    private WeakReference<T> shim;

    public static <T> T makeProxy(Class<T> intf, InvocationHandler handler, Class<?> ... extraInterfaces) {
        Class[] intfs;
        if (extraInterfaces == null) {
            intfs = new Class[]{intf};
        } else {
            intfs = new Class[extraInterfaces.length + 1];
            intfs[0] = intf;
            System.arraycopy(extraInterfaces, 0, intfs, 1, extraInterfaces.length);
        }
        return intf.cast(Proxy.newProxyInstance(intf.getClassLoader(), intfs, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Data calculateData(Class<?> beanType) {
        Data toReturn;
        Map<Class<?>, Data> map = cache;
        synchronized (map) {
            toReturn = cache.get(beanType);
            if (toReturn == null) {
                toReturn = new Data();
                for (Method method : beanType.getMethods()) {
                    if (!BeanMethod.GET.matches(method)) continue;
                    toReturn.getters.add(method);
                    AutoBean.PropertyName annotation = method.getAnnotation(AutoBean.PropertyName.class);
                    String name = annotation != null ? annotation.value() : BeanMethod.GET.inferName(method);
                    toReturn.getterNames.add(name);
                    Class<?> returnType = method.getReturnType();
                    if (TypeUtils.isValueType(returnType)) {
                        toReturn.propertyType.add(PropertyType.VALUE);
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(returnType)) {
                        toReturn.propertyType.add(PropertyType.COLLECTION);
                        continue;
                    }
                    if (Map.class.isAssignableFrom(returnType)) {
                        toReturn.propertyType.add(PropertyType.MAP);
                        continue;
                    }
                    toReturn.propertyType.add(PropertyType.REFERENCE);
                }
                cache.put(beanType, toReturn);
            }
        }
        return toReturn;
    }

    public ProxyAutoBean(AutoBeanFactory factory, Class<?> beanType, Configuration configuration) {
        super(factory);
        this.beanType = beanType;
        this.configuration = configuration;
        this.data = ProxyAutoBean.calculateData(beanType);
    }

    public ProxyAutoBean(AutoBeanFactory factory, Class<?> beanType, Configuration configuration, T toWrap) {
        super(toWrap, factory);
        this.beanType = beanType;
        this.configuration = configuration;
        this.data = ProxyAutoBean.calculateData(beanType);
    }

    @Override
    public T as() {
        Object toReturn;
        Object t = toReturn = this.shim == null ? null : (Object)this.shim.get();
        if (toReturn == null) {
            toReturn = this.createShim();
            this.shim = new WeakReference<Object>(toReturn);
        }
        return toReturn;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Class<T> getType() {
        return this.beanType;
    }

    @Override
    protected void call(String method, Object returned, Object ... parameters) {
        super.call(method, returned, parameters);
    }

    @Override
    protected void checkFrozen() {
        super.checkFrozen();
    }

    @Override
    protected void checkWrapped() {
        super.checkWrapped();
    }

    @Override
    protected T createSimplePeer() {
        return null;
    }

    @Override
    protected <V> V get(String method, V toReturn) {
        return super.get(method, toReturn);
    }

    @Override
    protected <V> V getOrReify(String propertyName) {
        return (V)super.getOrReify(propertyName);
    }

    @Override
    protected T getWrapped() {
        if (this.wrapped == null && this.isUsingSimplePeer()) {
            this.wrapped = ProxyAutoBean.makeProxy(this.beanType, new SimpleBeanHandler(this), new Class[0]);
        }
        return super.getWrapped();
    }

    @Override
    protected void set(String method, Object value) {
        super.set(method, value);
    }

    @Override
    protected void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    @Override
    protected void traverseProperties(AutoBeanVisitor visitor, AbstractAutoBean.OneShotContext ctx) {
        assert (this.data.getters.size() == this.data.getterNames.size() && this.data.getters.size() == this.data.propertyType.size());
        Iterator<Method> getterIt = this.data.getters.iterator();
        Iterator<String> nameIt = this.data.getterNames.iterator();
        Iterator<PropertyType> typeIt = this.data.propertyType.iterator();
        while (getterIt.hasNext()) {
            Object value;
            Method getter = getterIt.next();
            String name = nameIt.next();
            PropertyType propertyType = typeIt.next();
            try {
                getter.setAccessible(true);
                value = getter.invoke(this.as(), new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            MethodPropertyContext x = this.isUsingSimplePeer() ? new BeanPropertyContext(this, getter) : new GetterPropertyContext(this, getter);
            switch (propertyType) {
                case VALUE: {
                    if (visitor.visitValueProperty(name, value, x)) {
                        // empty if block
                    }
                    visitor.endVisitValueProperty(name, value, x);
                    break;
                }
                case COLLECTION: {
                    AutoBean<Collection<?>> temp;
                    AutoBean<Collection<?>> bean = temp = AutoBeanUtils.getAutoBean((Collection)value);
                    if (visitor.visitCollectionProperty(name, bean, x) && value != null) {
                        ((ProxyAutoBean)bean).traverse(visitor, ctx);
                    }
                    visitor.endVisitCollectionProperty(name, bean, x);
                    break;
                }
                case MAP: {
                    AutoBean<Collection<?>> temp;
                    AutoBean<Collection<?>> bean = temp = AutoBeanUtils.getAutoBean((Map)value);
                    if (visitor.visitMapProperty(name, bean, x) && value != null) {
                        ((ProxyAutoBean)bean).traverse(visitor, ctx);
                    }
                    visitor.endVisitMapProperty(name, bean, x);
                    break;
                }
                case REFERENCE: {
                    ProxyAutoBean bean = (ProxyAutoBean)AutoBeanUtils.getAutoBean(value);
                    if (visitor.visitReferenceProperty(name, bean, x) && value != null) {
                        bean.traverse(visitor, ctx);
                    }
                    visitor.endVisitReferenceProperty(name, bean, x);
                    break;
                }
            }
        }
    }

    Class<?> getBeanType() {
        return this.beanType;
    }

    private T createShim() {
        T toReturn = ProxyAutoBean.makeProxy(this.beanType, new ShimHandler<T>(this, this.getWrapped()), new Class[0]);
        WeakMapping.setWeak(toReturn, AutoBean.class.getName(), this);
        return toReturn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyType {
        VALUE,
        REFERENCE,
        COLLECTION,
        MAP;

    }

    private static class Data {
        final List<Method> getters = new ArrayList<Method>();
        final List<String> getterNames = new ArrayList<String>();
        final List<PropertyType> propertyType = new ArrayList<PropertyType>();

        private Data() {
        }
    }
}

