/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.model.CellTower;
import com.google.maps.model.WifiAccessPoint;
import java.util.ArrayList;
import java.util.List;

public class GeolocationPayload {
    public Integer homeMobileCountryCode = null;
    public Integer homeMobileNetworkCode = null;
    public String radioType = null;
    public String carrier = null;
    public Boolean considerIp = null;
    public CellTower[] cellTowers;
    public WifiAccessPoint[] wifiAccessPoints;

    public GeolocationPayload() {
    }

    private GeolocationPayload(Integer _homeMobileCountryCode, Integer _homeMobileNetworkCode, String _radioType, String _carrier, Boolean _considerIp, CellTower[] _cellTowers, WifiAccessPoint[] _wifiAccessPoints) {
        this.homeMobileCountryCode = _homeMobileCountryCode;
        this.homeMobileNetworkCode = _homeMobileNetworkCode;
        this.radioType = _radioType;
        this.carrier = _carrier;
        this.considerIp = _considerIp;
        this.cellTowers = _cellTowers;
        this.wifiAccessPoints = _wifiAccessPoints;
    }

    public static class GeolocationPayloadBuilder {
        private Integer _homeMobileCountryCode = null;
        private Integer _homeMobileNetworkCode = null;
        private String _radioType = null;
        private String _carrier = null;
        private Boolean _considerIp = null;
        private CellTower[] _cellTowers = null;
        private List<CellTower> _addedCellTowers = new ArrayList<CellTower>();
        private WifiAccessPoint[] _wifiAccessPoints = null;
        private List<WifiAccessPoint> _addedWifiAccessPoints = new ArrayList<WifiAccessPoint>();

        public GeolocationPayload createGeolocationPayload() {
            if (!this._addedWifiAccessPoints.isEmpty()) {
                this._wifiAccessPoints = this._addedWifiAccessPoints.toArray(new WifiAccessPoint[0]);
            }
            if (!this._addedCellTowers.isEmpty()) {
                this._cellTowers = this._addedCellTowers.toArray(new CellTower[0]);
            }
            return new GeolocationPayload(this._homeMobileCountryCode, this._homeMobileNetworkCode, this._radioType, this._carrier, this._considerIp, this._cellTowers, this._wifiAccessPoints);
        }

        public GeolocationPayloadBuilder HomeMobileCountryCode(int newHomeMobileCountryCode) {
            this._homeMobileCountryCode = new Integer(newHomeMobileCountryCode);
            return this;
        }

        public GeolocationPayloadBuilder HomeMobileNetworkCode(int newHomeMobileNetworkCode) {
            this._homeMobileNetworkCode = new Integer(newHomeMobileNetworkCode);
            return this;
        }

        public GeolocationPayloadBuilder RadioType(String newRadioType) {
            this._radioType = newRadioType;
            return this;
        }

        public GeolocationPayloadBuilder Carrier(String newCarrier) {
            this._carrier = newCarrier;
            return this;
        }

        public GeolocationPayloadBuilder ConsiderIp(boolean newConsiderIp) {
            this._considerIp = new Boolean(newConsiderIp);
            return this;
        }

        public GeolocationPayloadBuilder CellTowers(CellTower[] newCellTowers) {
            this._cellTowers = newCellTowers;
            return this;
        }

        public GeolocationPayloadBuilder AddCellTower(CellTower newCellTower) {
            this._addedCellTowers.add(newCellTower);
            return this;
        }

        public GeolocationPayloadBuilder WifiAccessPoints(WifiAccessPoint[] newWifiAccessPoints) {
            this._wifiAccessPoints = newWifiAccessPoints;
            return this;
        }

        public GeolocationPayloadBuilder AddWifiAccessPoint(WifiAccessPoint newWifiAccessPoint) {
            this._addedWifiAccessPoints.add(newWifiAccessPoint);
            return this;
        }
    }
}

