/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.parsing.Annotation;
import java.util.Map;
import java.util.Set;

public class Config {
    final boolean parseJsDocDocumentation;
    final boolean isIdeMode;
    final Map<String, Annotation> annotationNames;
    final Set<String> suppressionNames;
    final LanguageMode languageMode;
    final boolean acceptConstKeyword;
    final boolean useExperimentalParser;

    Config(Set<String> annotationWhitelist, Set<String> suppressionNames, boolean isIdeMode, LanguageMode languageMode, boolean acceptConstKeyword) {
        this(annotationWhitelist, suppressionNames, isIdeMode, languageMode, acceptConstKeyword, false);
    }

    Config(Set<String> annotationWhitelist, Set<String> suppressionNames, boolean isIdeMode, LanguageMode languageMode, boolean acceptConstKeyword, boolean useExperimentalParser) {
        this.annotationNames = Config.buildAnnotationNames(annotationWhitelist);
        this.parseJsDocDocumentation = isIdeMode;
        this.suppressionNames = suppressionNames;
        this.isIdeMode = isIdeMode;
        this.languageMode = languageMode;
        this.acceptConstKeyword = acceptConstKeyword;
        this.useExperimentalParser = useExperimentalParser;
    }

    private static Map<String, Annotation> buildAnnotationNames(Set<String> annotationWhitelist) {
        ImmutableMap.Builder annotationBuilder = ImmutableMap.builder();
        annotationBuilder.putAll(Annotation.recognizedAnnotations);
        for (String unrecognizedAnnotation : annotationWhitelist) {
            if (Annotation.recognizedAnnotations.containsKey(unrecognizedAnnotation)) continue;
            annotationBuilder.put((Object)unrecognizedAnnotation, (Object)Annotation.NOT_IMPLEMENTED);
        }
        return annotationBuilder.build();
    }

    public static enum LanguageMode {
        ECMASCRIPT3,
        ECMASCRIPT5,
        ECMASCRIPT5_STRICT,
        ECMASCRIPT6,
        ECMASCRIPT6_STRICT;

    }
}

