/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class Tracer {
    static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static volatile boolean defaultPrettyPrint;
    private static List<TracingStatistic> extraTracingStatistics;
    private long[] extraTracingValues;
    @Nullable
    private final String type;
    private final String comment;
    private final long startTimeMs;
    private long stopTimeMs;
    final Thread startThread;
    static final int MAX_TRACE_SIZE = 1000;
    static InternalClock clock;
    @Nullable
    private static AtomicTracerStatMap typeToCountMap;
    @Nullable
    private static AtomicTracerStatMap typeToSilentMap;
    @Nullable
    private static AtomicTracerStatMap typeToTimeMap;
    private static final Stat ZERO_STAT;
    private static ThreadLocal<ThreadTrace> traces;

    Tracer(@Nullable String type, @Nullable String comment) {
        ThreadTrace trace;
        this.type = type;
        this.comment = comment == null ? "" : comment;
        this.startTimeMs = clock.currentTimeMillis();
        this.startThread = Thread.currentThread();
        if (!extraTracingStatistics.isEmpty()) {
            int size = extraTracingStatistics.size();
            this.extraTracingValues = new long[size];
            int i = 0;
            for (TracingStatistic tracingStatistic : extraTracingStatistics) {
                this.extraTracingValues[i] = tracingStatistic.start(this.startThread);
                ++i;
            }
        }
        if (!(trace = Tracer.getThreadTrace()).isInitialized()) {
            return;
        }
        if (trace.events.size() >= 1000) {
            logger.log(Level.WARNING, "Giant thread trace. Too many Tracers created. Clearing to avoid memory leak.", new Throwable(trace.toString()));
            trace.truncateEvents();
        }
        if (trace.outstandingEvents.size() >= 1000) {
            logger.log(Level.WARNING, "Too many outstanding Tracers. Tracer.stop() is missing or Tracer.stop() is not wrapped in a try/finally block. Clearing to avoid memory leak.", new Throwable(trace.toString()));
            trace.truncateOutstandingEvents();
        }
        trace.startEvent(this);
    }

    Tracer(String comment) {
        this(null, comment);
    }

    static Tracer shortName(Object object, String comment) {
        if (object == null) {
            return new Tracer(comment);
        }
        return new Tracer(object.getClass().getSimpleName(), comment);
    }

    private static String longToPaddedString(long v, int digitsColumnWidth) {
        int digitWidth = Tracer.numDigits(v);
        StringBuilder sb = new StringBuilder();
        Tracer.appendSpaces(sb, digitsColumnWidth - digitWidth);
        sb.append(v);
        return sb.toString();
    }

    private static int numDigits(long n) {
        int i = 0;
        do {
            ++i;
        } while ((n /= 10L) > 0L);
        return i;
    }

    @VisibleForTesting
    static void appendSpaces(StringBuilder sb, int numSpaces) {
        if (numSpaces > 16) {
            logger.warning("Tracer.appendSpaces called with large numSpaces");
            numSpaces = 16;
        }
        while (numSpaces >= 5) {
            sb.append("     ");
            numSpaces -= 5;
        }
        switch (numSpaces) {
            case 1: {
                sb.append(" ");
                break;
            }
            case 2: {
                sb.append("  ");
                break;
            }
            case 3: {
                sb.append("   ");
                break;
            }
            case 4: {
                sb.append("    ");
            }
        }
    }

    static int addTracingStatistic(TracingStatistic tracingStatistic) {
        if (tracingStatistic.enable()) {
            extraTracingStatistics.add(tracingStatistic);
            return extraTracingStatistics.lastIndexOf(tracingStatistic);
        }
        return -1;
    }

    @VisibleForTesting
    static void clearTracingStatisticsTestingOnly() {
        extraTracingStatistics.clear();
    }

    long stop(int silenceThreshold) {
        Preconditions.checkState((Thread.currentThread() == this.startThread ? 1 : 0) != 0);
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            return 0L;
        }
        this.stopTimeMs = clock.currentTimeMillis();
        if (this.extraTracingValues != null) {
            for (int i = 0; i < this.extraTracingValues.length; ++i) {
                long value = extraTracingStatistics.get(i).stop(this.startThread);
                this.extraTracingValues[i] = value - this.extraTracingValues[i];
            }
        }
        if (!trace.isInitialized()) {
            return 0L;
        }
        trace.endEvent(this, silenceThreshold);
        return this.stopTimeMs - this.startTimeMs;
    }

    long stop() {
        return this.stop(-1);
    }

    public String toString() {
        if (this.type == null) {
            return this.comment;
        }
        return "[" + this.type + "] " + this.comment;
    }

    static void setDefaultSilenceThreshold(int threshold) {
        Tracer.getThreadTrace().defaultSilenceThreshold = threshold;
    }

    static void initCurrentThreadTrace() {
        ThreadTrace events = Tracer.getThreadTrace();
        if (!events.isEmpty()) {
            logger.log(Level.WARNING, "Non-empty timer log:\n" + events, new Throwable());
            Tracer.clearThreadTrace();
            events = Tracer.getThreadTrace();
        }
        events.init();
    }

    static void initCurrentThreadTrace(int defaultSilenceThreshold) {
        Tracer.initCurrentThreadTrace();
        Tracer.setDefaultSilenceThreshold(defaultSilenceThreshold);
    }

    static String getCurrentThreadTraceReport() {
        return Tracer.getThreadTrace().toString();
    }

    static void logCurrentThreadTrace() {
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            logger.log(Level.WARNING, "Tracer log requested for this thread but was not initialized using Tracer.initCurrentThreadTrace().", new Throwable());
            return;
        }
        if (!trace.isEmpty()) {
            logger.log(Level.WARNING, "timers:\n{0}", Tracer.getCurrentThreadTraceReport());
        }
    }

    static void clearCurrentThreadTrace() {
        Tracer.clearThreadTrace();
    }

    static void logAndClearCurrentThreadTrace() {
        Tracer.logCurrentThreadTrace();
        Tracer.clearThreadTrace();
    }

    static void setPrettyPrint(boolean enabled) {
        defaultPrettyPrint = enabled;
    }

    static synchronized void enableTypeMaps() {
        if (typeToCountMap == null) {
            typeToCountMap = new AtomicTracerStatMap();
            typeToSilentMap = new AtomicTracerStatMap();
            typeToTimeMap = new AtomicTracerStatMap();
        }
    }

    @Nullable
    static Map<String, Long> getTypeToCountMap() {
        return typeToCountMap != null ? typeToCountMap.getMap() : null;
    }

    @Nullable
    static Map<String, Long> getTypeToSilentMap() {
        return typeToSilentMap != null ? typeToSilentMap.getMap() : null;
    }

    @Nullable
    static Map<String, Long> getTypeToTimeMap() {
        return typeToTimeMap != null ? typeToTimeMap.getMap() : null;
    }

    static Stat getStatsForType(String type) {
        Stat stat = Tracer.getThreadTrace().stats.get(type);
        return stat != null ? stat : ZERO_STAT;
    }

    private static String formatTime(long time) {
        int sec = (int)(time / 1000L % 60L);
        int ms = (int)(time % 1000L);
        return String.format("%02d.%03d", sec, ms);
    }

    static ThreadTrace getThreadTrace() {
        ThreadTrace t = traces.get();
        if (t == null) {
            t = new ThreadTrace();
            t.prettyPrint = defaultPrettyPrint;
            traces.set(t);
        }
        return t;
    }

    static void clearThreadTrace() {
        traces.remove();
    }

    static {
        extraTracingStatistics = new CopyOnWriteArrayList<TracingStatistic>();
        clock = new InternalClock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        ZERO_STAT = new Stat();
        traces = new ThreadLocal();
    }

    static final class AtomicTracerStatMap {
        private final ConcurrentMap<String, Long> map = new ConcurrentHashMap<String, Long>();

        AtomicTracerStatMap() {
        }

        void incrementBy(String key, long delta) {
            Long oldValue = (Long)this.map.get(key);
            if (oldValue == null && (oldValue = this.map.putIfAbsent(key, delta)) == null) {
                return;
            }
            while (!this.map.replace(key, oldValue, oldValue + delta)) {
                oldValue = (Long)this.map.get(key);
            }
        }

        Map<String, Long> getMap() {
            return this.map;
        }
    }

    static interface TracingStatistic {
        public long start(Thread var1);

        public long stop(Thread var1);

        public boolean enable();

        public AtomicTracerStatMap getTracingStat();

        public String getUnits();
    }

    static final class ThreadTrace {
        int defaultSilenceThreshold;
        final ArrayList<Event> events = new ArrayList();
        final HashSet<Tracer> outstandingEvents = new HashSet();
        final Map<String, Stat> stats = new HashMap<String, Stat>();
        boolean isOutstandingEventsTruncated = false;
        boolean isEventsTruncated = false;
        boolean isInitialized = false;
        boolean prettyPrint = false;

        ThreadTrace() {
        }

        void init() {
            this.isInitialized = true;
        }

        boolean isInitialized() {
            return this.isInitialized;
        }

        void startEvent(Tracer t) {
            this.events.add(new Event(true, t));
            boolean notAlreadyOutstanding = this.outstandingEvents.add(t);
            Preconditions.checkState((boolean)notAlreadyOutstanding);
        }

        void endEvent(Tracer t, int silenceThreshold) {
            boolean wasOutstanding = this.outstandingEvents.remove(t);
            if (!wasOutstanding) {
                if (this.isOutstandingEventsTruncated) {
                    logger.log(Level.WARNING, "event not found, probably because the event stack overflowed and was truncated", new Throwable());
                } else {
                    throw new IllegalStateException();
                }
            }
            long elapsed = t.stopTimeMs - t.startTimeMs;
            if (silenceThreshold == -1) {
                silenceThreshold = this.defaultSilenceThreshold;
            }
            if (elapsed < (long)silenceThreshold) {
                boolean removed = false;
                for (int i = 0; i < this.events.size(); ++i) {
                    Event e = this.events.get(i);
                    if (e.tracer != t) continue;
                    Preconditions.checkState((boolean)e.isStart);
                    this.events.remove(i);
                    removed = true;
                    break;
                }
                Preconditions.checkState((removed || this.isEventsTruncated ? 1 : 0) != 0);
            } else {
                this.events.add(new Event(false, t));
            }
            if (t.type != null) {
                Stat stat = this.stats.get(t.type);
                if (stat == null) {
                    stat = new Stat();
                    if (!extraTracingStatistics.isEmpty()) {
                        Stat.access$702(stat, new int[extraTracingStatistics.size()]);
                    }
                    this.stats.put(t.type, stat);
                }
                stat.count++;
                if (typeToCountMap != null) {
                    typeToCountMap.incrementBy(t.type, 1L);
                }
                stat.clockTime = (int)((long)stat.clockTime + elapsed);
                if (typeToTimeMap != null) {
                    typeToTimeMap.incrementBy(t.type, elapsed);
                }
                if (stat.extraInfo != null && t.extraTracingValues != null) {
                    int overlapLength = Math.min(stat.extraInfo.length, t.extraTracingValues.length);
                    for (int i = 0; i < overlapLength; ++i) {
                        int[] nArray = stat.extraInfo;
                        int n = i;
                        nArray[n] = (int)((long)nArray[n] + t.extraTracingValues[i]);
                        AtomicTracerStatMap map = ((TracingStatistic)extraTracingStatistics.get(i)).getTracingStat();
                        if (map == null) continue;
                        map.incrementBy(t.type, t.extraTracingValues[i]);
                    }
                }
                if (elapsed < (long)silenceThreshold) {
                    stat.silent++;
                    if (typeToSilentMap != null) {
                        typeToSilentMap.incrementBy(t.type, 1L);
                    }
                }
            }
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.outstandingEvents.isEmpty();
        }

        void truncateOutstandingEvents() {
            this.isOutstandingEventsTruncated = true;
            this.outstandingEvents.clear();
        }

        void truncateEvents() {
            this.isEventsTruncated = true;
            this.events.clear();
        }

        public String toString() {
            int numDigits = this.getMaxDigits();
            StringBuilder sb = new StringBuilder();
            long etime = -1L;
            LinkedList<String> indent = this.prettyPrint ? new LinkedList<String>() : null;
            for (Event event : this.events) {
                if (this.prettyPrint && !event.isStart && !indent.isEmpty()) {
                    indent.pop();
                }
                sb.append(" ");
                if (this.prettyPrint) {
                    sb.append(event.toString(etime, Joiner.on((String)"").join(indent), numDigits));
                } else {
                    sb.append(event.toString(etime, "", 4));
                }
                etime = event.eventTime();
                sb.append('\n');
                if (!this.prettyPrint || !event.isStart) continue;
                indent.push("|  ");
            }
            if (!this.outstandingEvents.isEmpty()) {
                long now = clock.currentTimeMillis();
                sb.append(" Unstopped timers:\n");
                for (Tracer t : this.outstandingEvents) {
                    sb.append("  ").append(t).append(" (").append(now - t.startTimeMs).append(" ms, started at ").append(Tracer.formatTime(t.startTimeMs)).append(")\n");
                }
            }
            for (Map.Entry entry : this.stats.entrySet()) {
                Stat stat = (Stat)entry.getValue();
                if (stat.count <= 1) continue;
                sb.append(" TOTAL ").append((String)entry.getKey()).append(" ").append(stat.count).append(" (").append(stat.clockTime).append(" ms");
                if (stat.extraInfo != null) {
                    for (int i = 0; i < stat.extraInfo.length; ++i) {
                        sb.append("; ");
                        sb.append(stat.extraInfo[i]).append(' ').append(((TracingStatistic)extraTracingStatistics.get(i)).getUnits());
                    }
                }
                sb.append(")\n");
            }
            return sb.toString();
        }

        private int getMaxDigits() {
            long etime = -1L;
            long maxTime = 0L;
            for (Event e : this.events) {
                long time;
                if (etime != -1L) {
                    time = e.eventTime() - etime;
                    maxTime = Math.max(maxTime, time);
                }
                if (!e.isStart) {
                    time = e.tracer.stopTimeMs - e.tracer.startTimeMs;
                    maxTime = Math.max(maxTime, time);
                }
                etime = e.eventTime();
            }
            return Math.max(3, Tracer.numDigits(maxTime));
        }
    }

    private static final class Event {
        boolean isStart;
        Tracer tracer;

        Event(boolean start, Tracer t) {
            this.isStart = start;
            this.tracer = t;
        }

        long eventTime() {
            return this.isStart ? this.tracer.startTimeMs : this.tracer.stopTimeMs;
        }

        String toString(long prevEventTime, String indent, int digitsColWidth) {
            StringBuilder sb = new StringBuilder(120);
            if (prevEventTime == -1L) {
                Tracer.appendSpaces(sb, digitsColWidth);
            } else {
                sb.append(Tracer.longToPaddedString(this.eventTime() - prevEventTime, digitsColWidth));
            }
            sb.append(' ');
            sb.append(Tracer.formatTime(this.eventTime()));
            if (this.isStart) {
                sb.append(" Start ");
                Tracer.appendSpaces(sb, digitsColWidth);
                sb.append("   ");
            } else {
                sb.append(" Done ");
                long delta = this.tracer.stopTimeMs - this.tracer.startTimeMs;
                sb.append(Tracer.longToPaddedString(delta, digitsColWidth));
                sb.append(" ms ");
                if (this.tracer.extraTracingValues != null) {
                    for (int i = 0; i < this.tracer.extraTracingValues.length; ++i) {
                        delta = this.tracer.extraTracingValues[i];
                        sb.append(String.format("%4d", delta));
                        sb.append(((TracingStatistic)extraTracingStatistics.get(i)).getUnits());
                        sb.append(";  ");
                    }
                }
            }
            sb.append(indent);
            sb.append(this.tracer.toString());
            return sb.toString();
        }
    }

    static final class Stat {
        private int count;
        private int silent;
        private int clockTime;
        private int[] extraInfo;

        Stat() {
        }

        int getCount() {
            return this.count;
        }

        int getSilentCount() {
            return this.silent;
        }

        int getTotalTime() {
            return this.clockTime;
        }

        @VisibleForTesting
        int getExtraInfo(int index) {
            return index >= this.extraInfo.length ? 0 : this.extraInfo[index];
        }

        static /* synthetic */ int[] access$702(Stat x0, int[] x1) {
            x0.extraInfo = x1;
            return x1;
        }
    }

    static interface InternalClock {
        public long currentTimeMillis();
    }
}

