/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalTypeInfo
implements CompilerPass {
    static final DiagnosticType DUPLICATE_JSDOC = DiagnosticType.warning("JSC_DUPLICATE_JSDOC", "Found two JsDoc comments for variable: {0}.\n");
    static final DiagnosticType REDECLARED_PROPERTY = DiagnosticType.warning("JSC_REDECLARED_PROPERTY", "Found two declarations for property {0} of type {1}.\n");
    static final DiagnosticType INVALID_PROP_OVERRIDE = DiagnosticType.warning("JSC_INVALID_PROP_OVERRIDE", "Invalid redeclaration of property {0}.\ninherited type  : {1}\noverriding type : {2}\n");
    static final DiagnosticType EXTENDS_NOT_ON_CTOR_OR_INTERF = DiagnosticType.warning("JSC_EXTENDS_NOT_ON_CTOR_OR_INTERF", "@extends used without @constructor or @interface for {0}.\n");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} extends non-object type {1}.\n");
    static final DiagnosticType CTOR_IN_DIFFERENT_SCOPE = DiagnosticType.warning("JSC_CTOR_IN_DIFFERENT_SCOPE", "Modifying the prototype is only allowed if the constructor is in the same scope\n");
    static final DiagnosticType UNRECOGNIZED_TYPE_NAME = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPE_NAME", "Type annotation references non-existent type {0}.");
    static final DiagnosticType INTERFACE_WITH_A_BODY = DiagnosticType.warning("JSC_INTERFACE_WITH_A_BODY", "Interface definitions should have an empty body.");
    static final DiagnosticType INHERITANCE_CYCLE = DiagnosticType.warning("JSC_INHERITANCE_CYCLE", "Cycle detected in inheritance chain of type {0}");
    static final DiagnosticType DICT_IMPLEMENTS_INTERF = DiagnosticType.warning("JSC_DICT_IMPLEMENTS_INTERF", "Class {0} is a dict. Dicts can't implement interfaces.");
    static final DiagnosticType CONSTRUCTOR_REQUIRED = DiagnosticType.warning("JSC_CONSTRUCTOR_REQUIRED", "{0} used without @constructor.");
    static final DiagnosticType INEXISTENT_PARAM = DiagnosticType.warning("JSC_INEXISTENT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType IMPLEMENTS_WITHOUT_CONSTRUCTOR = DiagnosticType.warning("JSC_IMPLEMENTS_WITHOUT_CONSTRUCTOR", "@implements used without @constructor or @interface for {0}");
    static final DiagnosticType CONST_WITHOUT_INITIALIZER = DiagnosticType.warning("JSC_CONST_WITHOUT_INITIALIZER", "Constants must be initialized when they are defined.");
    static final DiagnosticType COULD_NOT_INFER_CONST_TYPE = DiagnosticType.warning("JSC_COULD_NOT_INFER_CONST_TYPE", "All constants must be typed. The compiler could not infer the typeof this constant. Please use an explicit type annotation.");
    static final DiagnosticType MISPLACED_CONST_ANNOTATION = DiagnosticType.warning("JSC_MISPLACED_CONST_ANNOTATION", "This property cannot be @const.The @const annotation is only allowed for properties of namespaces, prototype properties, static properties of constructors, and properties of the form this.prop declared inside constructors.");
    static final DiagnosticType CANNOT_OVERRIDE_FINAL_METHOD = DiagnosticType.warning("JSC_CANNOT_OVERRIDE_FINAL_METHOD", "Final method {0} cannot be overriden.");
    static final DiagnosticType CANNOT_INIT_TYPEDEF = DiagnosticType.warning("JSC_CANNOT_INIT_TYPEDEF", "A typedef variable represents a type name; it cannot be assigned a value.");
    static final DiagnosticType ANONYMOUS_NOMINAL_TYPE = DiagnosticType.warning("JSC_ANONYMOUS_NOMINAL_TYPE", "Must specify a name when defining a class or interface.");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(ANONYMOUS_NOMINAL_TYPE, CANNOT_INIT_TYPEDEF, CANNOT_OVERRIDE_FINAL_METHOD, CONSTRUCTOR_REQUIRED, CONST_WITHOUT_INITIALIZER, COULD_NOT_INFER_CONST_TYPE, CTOR_IN_DIFFERENT_SCOPE, DICT_IMPLEMENTS_INTERF, DUPLICATE_JSDOC, EXTENDS_NON_OBJECT, EXTENDS_NOT_ON_CTOR_OR_INTERF, REDECLARED_PROPERTY, IMPLEMENTS_WITHOUT_CONSTRUCTOR, INEXISTENT_PARAM, INHERITANCE_CYCLE, INTERFACE_WITH_A_BODY, INVALID_PROP_OVERRIDE, MISPLACED_CONST_ANNOTATION, UNRECOGNIZED_TYPE_NAME, RhinoErrorReporter.BAD_JSDOC_ANNOTATION, TypeCheck.CONFLICTING_EXTENDED_TYPE, TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, TypeCheck.CONFLICTING_SHAPE_TYPE, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, TypeCheck.MULTIPLE_VAR_DEF, TypeCheck.UNKNOWN_OVERRIDE, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED, VarCheck.UNDEFINED_VAR_ERROR, VariableReferenceCheck.REDECLARED_VARIABLE, VariableReferenceCheck.UNDECLARED_REFERENCE);
    private final Deque<Scope> scopes = Lists.newLinkedList();
    private Scope globalScope;
    private final Deque<Scope> scopeWorkset = Lists.newLinkedList();
    private Set<JSError> warnings = Sets.newHashSet();
    private JSTypeCreatorFromJSDoc typeParser = new JSTypeCreatorFromJSDoc();
    private final AbstractCompiler compiler;
    private final Map<Node, String> anonFunNames = Maps.newHashMap();
    private static final String ANON_FUN_PREFIX = "%anon_fun";
    private int freshId = 1;
    private Map<Node, NominalType.RawNominalType> nominaltypesByNode = Maps.newHashMap();
    private HashBasedTable<Integer, String, PropertyDef> propertyDefs = HashBasedTable.create();
    private Map<Node, JSType> castTypes = Maps.newHashMap();
    private Map<Node, JSType> declaredObjLitProps = Maps.newHashMap();

    GlobalTypeInfo(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    Collection<Scope> getScopes() {
        return this.scopes;
    }

    Scope getGlobalScope() {
        return this.globalScope;
    }

    JSType getCastType(Node n) {
        JSType t = this.castTypes.get(n);
        Preconditions.checkNotNull((Object)t);
        return t;
    }

    JSType getPropDeclaredType(Node n) {
        return this.declaredObjLitProps.get(n);
    }

    String getFunInternalName(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        Node fnNameNode = NodeUtil.getFunctionNameNode(n);
        if (fnNameNode != null && fnNameNode.isName()) {
            return fnNameNode.getString();
        }
        return this.anonFunNames.get(n);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((externs == null || externs.isSyntheticBlock() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)root.isSyntheticBlock());
        this.globalScope = new Scope(root, null, new ArrayList(), null);
        this.scopes.addFirst(this.globalScope);
        CollectNamedTypes rootCnt = new CollectNamedTypes(this.globalScope);
        if (externs != null) {
            new NodeTraversal(this.compiler, rootCnt).traverse(externs);
        }
        new NodeTraversal(this.compiler, rootCnt).traverse(root);
        this.globalScope.resolveTypedefs(this.typeParser);
        ProcessScope rootPs = new ProcessScope(this.globalScope);
        if (externs != null) {
            new NodeTraversal(this.compiler, rootPs).traverse(externs);
        }
        new NodeTraversal(this.compiler, rootPs).traverse(root);
        rootPs.finishProcessingScope();
        while (!this.scopeWorkset.isEmpty()) {
            Scope s = this.scopeWorkset.removeFirst();
            Node scopeBody = s.getBody();
            new NodeTraversal(this.compiler, new CollectNamedTypes(s)).traverse(scopeBody);
            s.resolveTypedefs(this.typeParser);
            ProcessScope ps = new ProcessScope(s);
            new NodeTraversal(this.compiler, ps).traverse(scopeBody);
            ps.finishProcessingScope();
        }
        this.reportInheritanceErrors();
        this.nominaltypesByNode = null;
        this.propertyDefs = null;
        for (Scope s : this.scopes) {
            s.removeTmpData();
        }
        Map<Node, String> unknownTypes = this.typeParser.getUnknownTypesMap();
        for (Map.Entry<Node, String> unknownTypeEntry : unknownTypes.entrySet()) {
            this.warnings.add(JSError.make(unknownTypeEntry.getKey(), UNRECOGNIZED_TYPE_NAME, unknownTypeEntry.getValue()));
        }
        for (String warningText : this.typeParser.getWarnings()) {
            this.warnings.add(JSError.make(root, RhinoErrorReporter.BAD_JSDOC_ANNOTATION, warningText));
        }
        this.typeParser = null;
        this.compiler.setSymbolTable(this);
        for (JSError warning : this.warnings) {
            this.compiler.report(warning);
        }
        this.warnings = null;
    }

    private Collection<PropertyDef> getPropDefsFromInterface(NominalType nominalType, String pname) {
        Preconditions.checkArgument((boolean)nominalType.isFinalized());
        Preconditions.checkArgument((boolean)nominalType.isInterface());
        if (nominalType.getPropDeclaredType(pname) == null) {
            return ImmutableSet.of();
        }
        if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
            return ImmutableSet.of((Object)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : nominalType.getInstantiatedInterfaces()) {
            result.addAll(this.getPropDefsFromInterface(interf, pname));
        }
        return result.build();
    }

    private PropertyDef getPropDefFromClass(NominalType nominalType, String pname) {
        while (nominalType.getPropDeclaredType(pname) != null) {
            Preconditions.checkArgument((boolean)nominalType.isFinalized());
            Preconditions.checkArgument((boolean)nominalType.isClass());
            if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
                return (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
            }
            nominalType = nominalType.getInstantiatedSuperclass();
        }
        return null;
    }

    private void reportInheritanceErrors() {
        LinkedList workset = Lists.newLinkedList(this.nominaltypesByNode.keySet());
        int iterations = 0;
        int MAX_ITERATIONS = 50000;
        block0: while (!workset.isEmpty()) {
            Preconditions.checkState((iterations < 50000 ? 1 : 0) != 0);
            Node funNode = (Node)workset.removeFirst();
            NominalType.RawNominalType rawNominalType = this.nominaltypesByNode.get(funNode);
            NominalType superClass = rawNominalType.getSuperClass();
            Set<String> nonInheritedPropNames = rawNominalType.getAllOwnProps();
            if (superClass != null && !superClass.isFinalized()) {
                workset.addLast(funNode);
                ++iterations;
                continue;
            }
            for (NominalType superInterf : rawNominalType.getInterfaces()) {
                if (superInterf.isFinalized()) continue;
                workset.addLast(funNode);
                ++iterations;
                continue block0;
            }
            HashMultimap propMethodTypesToProcess = HashMultimap.create();
            HashMultimap propTypesToProcess = HashMultimap.create();
            if (superClass != null) {
                Preconditions.checkState((boolean)superClass.isFinalized());
                for (String pname : superClass.getAllPropsOfClass()) {
                    nonInheritedPropNames.remove(pname);
                    this.checkSuperProperty(rawNominalType, superClass, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
                }
            }
            for (NominalType superInterf : rawNominalType.getInterfaces()) {
                Preconditions.checkState((boolean)superInterf.isFinalized());
                for (String pname : superInterf.getAllPropsOfInterface()) {
                    nonInheritedPropNames.remove(pname);
                    this.checkSuperProperty(rawNominalType, superInterf, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
                }
            }
            for (String pname : propMethodTypesToProcess.keySet()) {
                Collection methodTypes = propMethodTypesToProcess.get((Object)pname);
                Preconditions.checkState((!methodTypes.isEmpty() ? 1 : 0) != 0);
                PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)rawNominalType.getId(), (Object)pname);
                DeclaredFunctionType superMethodType = DeclaredFunctionType.meet(methodTypes);
                DeclaredFunctionType updatedMethodType = localPropDef.methodType.withTypeInfoFromSuper(superMethodType);
                localPropDef.updateMethodType(updatedMethodType);
                propTypesToProcess.put((Object)pname, (Object)JSType.fromFunctionType(updatedMethodType.toFunctionType()));
            }
            block6: for (String pname : propTypesToProcess.keySet()) {
                Collection defs = propTypesToProcess.get((Object)pname);
                Preconditions.checkState((!defs.isEmpty() ? 1 : 0) != 0);
                JSType resultType = JSType.TOP;
                for (JSType inheritedType : defs) {
                    if (inheritedType.isSubtypeOf(resultType)) {
                        resultType = inheritedType;
                        continue;
                    }
                    if (resultType.isSubtypeOf(inheritedType)) continue;
                    this.warnings.add(JSError.make(funNode, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, NodeUtil.getFunctionName(funNode), pname, "", ""));
                    continue block6;
                }
                rawNominalType.addProtoProperty(pname, resultType, false);
            }
            for (String pname : nonInheritedPropNames) {
                Node defSite = ((PropertyDef)this.propertyDefs.get((Object)Integer.valueOf((int)rawNominalType.getId()), (Object)pname)).defSite;
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
                if (jsdoc == null || !jsdoc.isOverride()) continue;
                this.warnings.add(JSError.make(defSite, TypeCheck.UNKNOWN_OVERRIDE, pname, rawNominalType.getName()));
            }
            rawNominalType.finalizeNominalType();
        }
    }

    private void checkSuperProperty(NominalType.RawNominalType current, NominalType superType, String pname, Multimap<String, DeclaredFunctionType> propMethodTypesToProcess, Multimap<String, JSType> propTypesToProcess) {
        JSType localPropType;
        JSType inheritedPropType = superType.getPropDeclaredType(pname);
        if (inheritedPropType == null) {
            return;
        }
        ImmutableSet inheritedPropDefs = superType.isInterface() ? this.getPropDefsFromInterface(superType, pname) : ImmutableSet.of((Object)this.getPropDefFromClass(superType, pname));
        if (superType.isInterface() && current.isClass() && !current.mayHaveProp(pname)) {
            this.warnings.add(JSError.make(((PropertyDef)inheritedPropDefs.iterator().next()).defSite, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED, pname, superType.toString(), current.toString()));
            return;
        }
        PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)current.getId(), (Object)pname);
        JSType jSType = localPropType = localPropDef == null ? null : current.getPropDeclaredType(pname);
        if (localPropDef != null && superType.isClass() && localPropType.getFunType() != null && superType.hasConstantProp(pname)) {
            this.warnings.add(JSError.make(localPropDef.defSite, CANNOT_OVERRIDE_FINAL_METHOD, pname));
            return;
        }
        if (localPropType != null && !localPropType.isSubtypeOf(inheritedPropType)) {
            this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
        } else if (localPropType == null) {
            propTypesToProcess.put((Object)pname, (Object)inheritedPropType);
        } else if (localPropDef.methodType != null) {
            for (PropertyDef inheritedPropDef : inheritedPropDefs) {
                if (inheritedPropDef.methodType == null) continue;
                propMethodTypesToProcess.put((Object)pname, (Object)inheritedPropDef.methodType);
            }
        }
    }

    private JSType getTypeDeclarationFromJsdoc(JSDocInfo jsdoc, Scope s) {
        return this.typeParser.getNodeTypeDeclaration(jsdoc, null, s);
    }

    static class Scope
    implements DeclaredTypeRegistry {
        private final Scope parent;
        private final Node root;
        private final String name;
        private final Map<String, JSType> locals = Maps.newHashMap();
        private final Set<String> constVars = Sets.newHashSet();
        private final ArrayList<String> formals;
        private final Set<String> outerVars = Sets.newHashSet();
        private final Map<String, Scope> localFunDefs = Maps.newHashMap();
        private Map<String, NominalType.RawNominalType> localClassDefs = Maps.newHashMap();
        private Map<String, Typedef> localTypedefs = Maps.newHashMap();
        private Set<String> localNamespaces = Sets.newHashSet();
        private DeclaredFunctionType declaredType;

        private Scope(Node root, Scope parent, ArrayList<String> formals, DeclaredFunctionType declaredType) {
            String nameOnAst;
            this.name = parent == null ? null : ((nameOnAst = root.getFirstChild().getString()).isEmpty() ? null : nameOnAst);
            this.root = root;
            this.parent = parent;
            this.formals = formals;
            this.declaredType = declaredType;
        }

        Node getRoot() {
            return this.root;
        }

        private Node getBody() {
            Preconditions.checkArgument((boolean)this.root.isFunction());
            return NodeUtil.getFunctionBody(this.root);
        }

        String getReadableName() {
            return this.parent == null ? null : NodeUtil.getFunctionName(this.root);
        }

        String getName() {
            return this.name;
        }

        private void setDeclaredType(DeclaredFunctionType declaredType) {
            this.declaredType = declaredType;
        }

        DeclaredFunctionType getDeclaredType() {
            return this.declaredType;
        }

        boolean isFunction() {
            return this.root.isFunction();
        }

        private boolean isConstructor() {
            if (!this.root.isFunction()) {
                return false;
            }
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(this.root);
            return fnDoc != null && fnDoc.isConstructor();
        }

        private boolean isPrototypeMethod() {
            Preconditions.checkArgument((this.root != null ? 1 : 0) != 0);
            return NodeUtil.isPrototypeMethod(this.root);
        }

        private void addLocalFunDef(String name, Scope scope) {
            Preconditions.checkArgument((!name.isEmpty() && !this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.localFunDefs.put(name, scope);
        }

        boolean isFormalParam(String name) {
            return this.formals.contains(name);
        }

        boolean isLocalVar(String name) {
            return this.locals.containsKey(name);
        }

        boolean isLocalFunDef(String name) {
            return this.localFunDefs.containsKey(name);
        }

        boolean isDefinedLocally(String name) {
            Preconditions.checkNotNull((Object)name);
            return this.locals.containsKey(name) || this.formals.contains(name) || this.localFunDefs.containsKey(name) || "this".equals(name) || this.localTypedefs != null && this.localTypedefs.containsKey(name);
        }

        private boolean isNamespace(Node expr) {
            if (expr.isName()) {
                return this.localNamespaces.contains(expr.getString());
            }
            if (!expr.isGetProp()) {
                return false;
            }
            QualifiedName qname = QualifiedName.fromGetprop(expr);
            if (qname == null) {
                return false;
            }
            String leftmost = qname.getLeftmostName();
            if (!this.localNamespaces.contains(leftmost)) {
                return false;
            }
            JSType propType = this.getDeclaredTypeOf(leftmost).getProp(qname.getAllButLeftmost());
            if (propType == null) {
                return false;
            }
            return propType.isRecordType();
        }

        private boolean isNamespace(String name) {
            Preconditions.checkState((!name.contains(".") ? 1 : 0) != 0);
            return this.localNamespaces.contains(name);
        }

        private boolean isVisibleInScope(String name) {
            Preconditions.checkNotNull((Object)name);
            return this.isDefinedLocally(name) || name.equals(this.name) || this.parent != null && this.parent.isVisibleInScope(name);
        }

        boolean isConstVar(String name) {
            return this.constVars.contains(name) || this.parent != null && this.parent.isConstVar(name);
        }

        private boolean isOuterVarEarly(String name) {
            return !this.isDefinedLocally(name) && this.parent != null && this.parent.isVisibleInScope(name);
        }

        boolean isUndeclaredFormal(String name) {
            return this.formals.contains(name) && this.getDeclaredTypeOf(name) == null;
        }

        List<String> getFormals() {
            return Lists.newArrayList(this.formals);
        }

        Set<String> getOuterVars() {
            return Sets.newHashSet(this.outerVars);
        }

        Set<String> getLocalFunDefs() {
            return Sets.newHashSet(this.localFunDefs.keySet());
        }

        boolean isOuterVar(String name) {
            return this.outerVars.contains(name);
        }

        boolean hasThis() {
            return this.isFunction() && this.getDeclaredType().getThisType() != null;
        }

        private NominalType.RawNominalType getNominalType(String name) {
            NominalType.RawNominalType rnt = this.localClassDefs.get(name);
            if (rnt != null) {
                return rnt;
            }
            return this.parent == null ? null : this.parent.getNominalType(name);
        }

        @Override
        public JSType lookupTypeByName(String name) {
            if (this.declaredType != null && this.declaredType.isGeneric() && this.declaredType.getTypeParameters().contains((Object)name)) {
                return JSType.fromTypeVar(name);
            }
            NominalType.RawNominalType rawNominalType = this.localClassDefs.get(name);
            if (rawNominalType != null) {
                return JSType.fromObjectType(ObjectType.fromNominalType(NominalType.fromRaw(rawNominalType)));
            }
            return this.parent == null ? null : this.parent.lookupTypeByName(name);
        }

        JSType getDeclaredTypeOf(String name) {
            Preconditions.checkArgument((name.indexOf(46) == -1 ? 1 : 0) != 0);
            if ("this".equals(name)) {
                if (!this.hasThis()) {
                    return null;
                }
                return JSType.fromObjectType(ObjectType.fromNominalType(this.getDeclaredType().getThisType()));
            }
            int formalIndex = this.formals.indexOf(name);
            if (formalIndex != -1) {
                JSType formalType = this.declaredType.getFormalType(formalIndex);
                if (formalType == null || formalType.isBottom()) {
                    return null;
                }
                return formalType;
            }
            JSType localType = this.locals.get(name);
            if (localType != null) {
                Preconditions.checkState((!localType.isBottom() ? 1 : 0) != 0);
                return localType;
            }
            Scope s = this.localFunDefs.get(name);
            if (s != null) {
                return JSType.fromFunctionType(s.getDeclaredType().toFunctionType());
            }
            if (name.equals(this.name)) {
                return JSType.fromFunctionType(this.getDeclaredType().toFunctionType());
            }
            if (this.parent != null) {
                return this.parent.getDeclaredTypeOf(name);
            }
            return null;
        }

        private Scope getScopeHelper(String fnName) {
            Scope s = this.localFunDefs.get(fnName);
            if (s != null) {
                return s;
            }
            if (this.parent != null) {
                return this.parent.getScopeHelper(fnName);
            }
            return null;
        }

        boolean isKnownFunction(String fnName) {
            return this.getScopeHelper(fnName) != null;
        }

        Scope getScope(String fnName) {
            Scope s = this.getScopeHelper(fnName);
            Preconditions.checkState((s != null ? 1 : 0) != 0);
            return s;
        }

        Set<String> getLocals() {
            return ImmutableSet.copyOf(this.locals.keySet());
        }

        private void addLocal(String name, JSType declType, boolean isConstant) {
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            if (isConstant) {
                this.constVars.add(name);
            }
            this.locals.put(name, declType);
        }

        private void addNamespace(String name) {
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.locals.put(name, JSType.TOP_OBJECT);
            this.localNamespaces.add(name);
        }

        private void updateTypeOfLocal(String name, JSType newDeclType) {
            this.locals.put(name, newDeclType);
        }

        private void addOuterVar(String name) {
            this.outerVars.add(name);
        }

        private void addNominalType(String name, NominalType.RawNominalType rawNominalType) {
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
            this.localClassDefs.put(name, rawNominalType);
        }

        private void addTypedef(String name, Typedef td) {
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.localTypedefs.put(name, td);
        }

        @Override
        public Typedef getTypedef(String name) {
            if (this.isDefinedLocally(name)) {
                return this.localTypedefs.get(name);
            }
            if (this.parent != null) {
                return this.parent.getTypedef(name);
            }
            return null;
        }

        private void resolveTypedefs(JSTypeCreatorFromJSDoc typeParser) {
            for (Map.Entry<String, Typedef> entry : this.localTypedefs.entrySet()) {
                String name = entry.getKey();
                Typedef td = entry.getValue();
                if (td.isResolved()) continue;
                td.resolveTypedef(typeParser.getTypedefType(name, this));
            }
        }

        private void sanityCheck() {
            HashSet names = this.localFunDefs.keySet();
            for (String s : this.localClassDefs.keySet()) {
                Preconditions.checkState((boolean)names.contains(s));
            }
            names = this.locals.keySet();
            for (String s : this.constVars) {
                Preconditions.checkState((boolean)names.contains(s));
            }
            for (String s : this.localNamespaces) {
                Preconditions.checkState((boolean)names.contains(s));
            }
            names = Sets.newHashSet(this.formals);
            for (String s : this.locals.keySet()) {
                Preconditions.checkState((!names.contains(s) ? 1 : 0) != 0, (String)"Name %s is defined twice.", (Object[])new Object[]{s});
                names.add(s);
            }
            for (String s : this.localFunDefs.keySet()) {
                Preconditions.checkState((!names.contains(s) ? 1 : 0) != 0, (String)"Name %s is defined twice.", (Object[])new Object[]{s});
                names.add(s);
            }
            for (String s : this.localTypedefs.keySet()) {
                Preconditions.checkState((!names.contains(s) ? 1 : 0) != 0, (String)"Name %s is defined twice.", (Object[])new Object[]{s});
            }
        }

        private void removeTmpData() {
            Iterator<String> it = this.localFunDefs.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                if (!name.contains(".")) continue;
                it.remove();
            }
            this.localNamespaces = null;
            this.localClassDefs = null;
            this.localTypedefs = null;
        }
    }

    private static class PropertyDef {
        final Node defSite;
        DeclaredFunctionType methodType;
        final Scope methodScope;

        PropertyDef(Node defSite, DeclaredFunctionType methodType, Scope methodScope) {
            Preconditions.checkArgument((boolean)defSite.isGetProp());
            this.defSite = defSite;
            this.methodType = methodType;
            this.methodScope = methodScope;
        }

        void updateMethodType(DeclaredFunctionType updatedType) {
            this.methodType = updatedType;
            if (this.methodScope != null) {
                this.methodScope.setDeclaredType(updatedType);
            }
        }
    }

    private class ProcessScope
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;
        private final Multimap<String, Node> undeclaredVars;
        private Set<Node> lendsObjlits = Sets.newHashSet();

        ProcessScope(Scope currentScope) {
            this.currentScope = currentScope;
            this.undeclaredVars = HashMultimap.create();
        }

        void finishProcessingScope() {
            for (Node objlit : this.lendsObjlits) {
                this.processLendsNode(objlit);
            }
            this.lendsObjlits = null;
            for (Node nameNode : this.undeclaredVars.values()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, VarCheck.UNDEFINED_VAR_ERROR, nameNode.getString()));
            }
        }

        void processLendsNode(Node objlit) {
            JSDocInfo jsdoc = objlit.getJSDocInfo();
            String lendsName = jsdoc.getLendsName();
            Preconditions.checkNotNull((Object)lendsName);
            Preconditions.checkState((!lendsName.contains(".") ? 1 : 0) != 0);
            JSType borrowerType = this.currentScope.getDeclaredTypeOf(lendsName);
            if (borrowerType == null || borrowerType.isUnknown()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, TypedScopeCreator.LENDS_ON_NON_OBJECT, lendsName, "unknown"));
                return;
            }
            if (!borrowerType.isSubtypeOf(JSType.TOP_OBJECT)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, TypedScopeCreator.LENDS_ON_NON_OBJECT, lendsName, borrowerType.toString()));
                return;
            }
            if (!this.currentScope.isNamespace(lendsName)) {
                return;
            }
            for (Node prop : objlit.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                QualifiedName qname = new QualifiedName(pname);
                JSType propDeclType = (JSType)GlobalTypeInfo.this.declaredObjLitProps.get(prop);
                if (propDeclType != null) {
                    this.currentScope.updateTypeOfLocal(lendsName, borrowerType.withDeclaredProperty(qname, propDeclType, false));
                    continue;
                }
                JSType t = this.simpleInferExprType(prop.getFirstChild());
                if (t == null) {
                    t = JSType.UNKNOWN;
                }
                this.currentScope.updateTypeOfLocal(lendsName, borrowerType.withProperty(qname, t));
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    Node grandparent = parent.getParent();
                    if (grandparent != null && (grandparent.isVar() || NodeUtil.isPrototypePropertyDeclaration(grandparent))) break;
                    this.visitFunctionDef(n, null);
                    break;
                }
                case 38: {
                    String name = n.getString();
                    if (name == null || "undefined".equals(name) || parent.isFunction()) {
                        return;
                    }
                    if (parent.isVar() || parent.isCatch()) {
                        if (NodeUtil.isTypedefDecl(parent)) break;
                        if (this.currentScope.isDefinedLocally(name)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(n, VariableReferenceCheck.REDECLARED_VARIABLE, name));
                            break;
                        }
                        for (Node useBeforeDeclNode : this.undeclaredVars.get((Object)name)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(useBeforeDeclNode, VariableReferenceCheck.UNDECLARED_REFERENCE, name));
                        }
                        this.undeclaredVars.removeAll((Object)name);
                        Node initializer = n.getFirstChild();
                        if (initializer != null && initializer.isFunction()) {
                            this.visitFunctionDef(initializer, null);
                            break;
                        }
                        if (initializer != null && NodeUtil.isNamespaceDecl(n)) {
                            this.currentScope.addNamespace(name);
                            break;
                        }
                        if (parent.isCatch()) {
                            this.currentScope.addLocal(name, JSType.UNKNOWN, false);
                            break;
                        }
                        boolean isConst = NodeUtil.hasConstAnnotation(parent);
                        JSType declType = this.getVarTypeFromAnnotation(n);
                        if (isConst && !this.mayWarnAboutNoInit(n) && declType == null) {
                            declType = this.inferConstTypeFromRhs(n);
                        }
                        this.currentScope.addLocal(name, declType, isConst);
                        break;
                    }
                    if (this.currentScope.isOuterVarEarly(name)) {
                        this.currentScope.addOuterVar(name);
                        break;
                    }
                    if (this.currentScope.getTypedef(name) == null && (name.equals(this.currentScope.getName()) || this.currentScope.isDefinedLocally(name))) break;
                    this.undeclaredVars.put((Object)name, (Object)n);
                    break;
                }
                case 33: {
                    if (!parent.isExprResult()) break;
                    this.visitPropertyDeclaration(n);
                    break;
                }
                case 86: {
                    Node lvalue = n.getFirstChild();
                    if (!lvalue.isGetProp()) break;
                    this.visitPropertyDeclaration(lvalue);
                    break;
                }
                case 155: {
                    GlobalTypeInfo.this.castTypes.put(n, GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(n.getJSDocInfo(), this.currentScope));
                    break;
                }
                case 64: {
                    JSDocInfo jsdoc = n.getJSDocInfo();
                    if (jsdoc != null && jsdoc.getLendsName() != null) {
                        this.lendsObjlits.add(n);
                    }
                    for (Node prop : n.children()) {
                        if (prop.getJSDocInfo() != null) {
                            GlobalTypeInfo.this.declaredObjLitProps.put(prop, GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(prop.getJSDocInfo(), this.currentScope));
                        }
                        if (!NodeUtil.hasConstAnnotation(prop)) continue;
                        GlobalTypeInfo.this.warnings.add(JSError.make(prop, MISPLACED_CONST_ANNOTATION, new String[0]));
                    }
                    break;
                }
            }
        }

        private void visitPropertyDeclaration(Node getProp) {
            if (this.isClassPropAccess(getProp, this.currentScope)) {
                if (NodeUtil.hasConstAnnotation(getProp) && this.currentScope.isPrototypeMethod()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
                }
                this.visitClassPropertyDeclaration(getProp);
                return;
            }
            if (this.isPropDecl(getProp) && NodeUtil.isPrototypeProperty(getProp)) {
                this.visitPrototypePropertyDeclaration(getProp);
                return;
            }
            if (this.isPropDecl(getProp) && this.isStaticCtorProp(getProp, this.currentScope)) {
                this.visitConstructorPropertyDeclaration(getProp);
                return;
            }
            if (this.isPropDecl(getProp) && this.currentScope.isNamespace(getProp.getFirstChild())) {
                this.visitNamespacePropertyDeclaration(getProp);
                return;
            }
            if (NodeUtil.hasConstAnnotation(getProp)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
            }
        }

        private boolean isClassPropAccess(Node n, Scope s) {
            return n.isGetProp() && n.getFirstChild().isThis() && (s.isConstructor() || s.isPrototypeMethod());
        }

        private boolean isStaticCtorProp(Node getProp, Scope s) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (!getProp.isQualifiedName()) {
                return false;
            }
            String receiverObjName = getProp.getFirstChild().getQualifiedName();
            return s.isLocalFunDef(receiverObjName) && s.getScope(receiverObjName).getDeclaredType().getNominalType() != null;
        }

        private boolean isPropDecl(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            return parent.isExprResult() || parent.isAssign() && parent.getParent().isExprResult();
        }

        private Scope visitFunctionDef(Node fn, NominalType.RawNominalType ownerType) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            Scope fnScope = this.computeFnScope(fn, ownerType, this.currentScope);
            GlobalTypeInfo.this.scopes.addFirst(fnScope);
            String fnName = NodeUtil.getFunctionName(fn);
            String internalName = GlobalTypeInfo.this.getFunInternalName(fn);
            if (fnName != null && this.currentScope.isDefinedLocally(fnName)) {
                if (!fnName.contains(".")) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, VariableReferenceCheck.REDECLARED_VARIABLE, fnName));
                }
                if (internalName.startsWith(GlobalTypeInfo.ANON_FUN_PREFIX)) {
                    this.currentScope.addLocalFunDef(internalName, this.currentScope.getScope(fnName));
                }
            } else {
                this.currentScope.addLocalFunDef(internalName, fnScope);
                if (fnName != null && fnName.contains(".")) {
                    this.currentScope.addLocalFunDef(fnName, fnScope);
                }
            }
            if (fnName != null && !fnName.contains(".")) {
                this.undeclaredVars.removeAll((Object)fnName);
            }
            GlobalTypeInfo.this.scopeWorkset.add(fnScope);
            return fnScope;
        }

        private void visitPrototypePropertyDeclaration(Node getProp) {
            JSType propDeclType;
            DeclaredFunctionType methodType;
            Scope methodScope;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            Node initializer = parent.isAssign() ? parent.getLastChild() : null;
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            String ctorName = ctorNameNode.getQualifiedName();
            NominalType.RawNominalType rawType = this.currentScope.getNominalType(ctorName);
            if (rawType == null) {
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionDef(initializer, null);
                }
                return;
            }
            if (!this.currentScope.isDefinedLocally(ctorName)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, CTOR_IN_DIFFERENT_SCOPE, new String[0]));
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionDef(initializer, rawType);
                }
                return;
            }
            String pname = NodeUtil.getPrototypePropertyName(getProp);
            if (initializer != null && initializer.isFunction()) {
                methodScope = this.visitFunctionDef(initializer, rawType);
                methodType = methodScope.getDeclaredType();
                propDeclType = JSType.fromFunctionType(methodType.toFunctionType());
            } else {
                methodScope = null;
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
                if (jsdoc != null && jsdoc.containsFunctionDeclaration()) {
                    methodType = this.computeFnDeclaredType(jsdoc, pname, getProp, rawType, this.currentScope);
                    propDeclType = JSType.fromFunctionType(methodType.toFunctionType());
                } else if (jsdoc != null && jsdoc.hasType()) {
                    methodType = null;
                    propDeclType = GlobalTypeInfo.this.typeParser.getNodeTypeDeclaration(jsdoc, rawType, this.currentScope);
                } else {
                    methodType = null;
                    propDeclType = null;
                }
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawType.getId(), (Object)pname, (Object)new PropertyDef(getProp, methodType, methodScope));
            boolean isConst = NodeUtil.hasConstAnnotation(getProp);
            if (propDeclType != null || isConst) {
                if (this.mayWarnAboutExistingProp(rawType, pname, getProp, propDeclType)) {
                    return;
                }
                if (isConst && !this.mayWarnAboutNoInit(getProp) && propDeclType == null) {
                    propDeclType = this.inferConstTypeFromRhs(getProp);
                }
                rawType.addProtoProperty(pname, propDeclType, isConst);
            } else {
                rawType.addUndeclaredProtoProperty(pname);
            }
        }

        private void visitConstructorPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            String ctorName = getProp.getFirstChild().getQualifiedName();
            Preconditions.checkState((boolean)this.currentScope.isLocalFunDef(ctorName));
            NominalType.RawNominalType classType = this.currentScope.getNominalType(ctorName);
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            JSType propDeclType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(jsdoc, this.currentScope);
            boolean isConst = NodeUtil.hasConstAnnotation(getProp);
            if (propDeclType != null || isConst) {
                JSType previousPropType = classType.getCtorPropDeclaredType(pname);
                if (classType.hasCtorProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, pname, classType.toString()));
                    return;
                }
                if (isConst && !this.mayWarnAboutNoInit(getProp) && propDeclType == null) {
                    propDeclType = this.inferConstTypeFromRhs(getProp);
                }
                classType.addCtorProperty(pname, propDeclType, isConst);
            } else {
                classType.addUndeclaredCtorProperty(pname);
            }
        }

        private void visitNamespacePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            QualifiedName qname = QualifiedName.fromGetprop(getProp);
            String leftmost = qname.getLeftmostName();
            QualifiedName allButLeftmost = qname.getAllButLeftmost();
            JSType currentType = this.currentScope.getDeclaredTypeOf(leftmost);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            JSType typeInJsdoc = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(jsdoc, this.currentScope);
            boolean isConst = NodeUtil.hasConstAnnotation(getProp);
            if (NodeUtil.isNamespaceDecl(getProp)) {
                this.currentScope.updateTypeOfLocal(leftmost, currentType.withProperty(allButLeftmost, JSType.TOP_OBJECT));
            } else if (typeInJsdoc != null || isConst) {
                JSType previousPropType = currentType.getDeclaredProp(allButLeftmost);
                if (currentType.mayHaveProp(allButLeftmost) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, typeInJsdoc, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, allButLeftmost.toString(), currentType.toString()));
                    return;
                }
                JSType declType = typeInJsdoc;
                if (isConst && !this.mayWarnAboutNoInit(getProp) && declType == null) {
                    declType = this.inferConstTypeFromRhs(getProp);
                }
                this.currentScope.updateTypeOfLocal(leftmost, currentType.withDeclaredProperty(allButLeftmost, declType, isConst));
            } else if (getProp.getParent().isAssign()) {
                JSType t = this.simpleInferExprType(getProp.getParent().getLastChild());
                if (t == null) {
                    t = JSType.UNKNOWN;
                }
                this.currentScope.updateTypeOfLocal(leftmost, currentType.withProperty(allButLeftmost, t));
            } else {
                this.currentScope.updateTypeOfLocal(leftmost, currentType.withProperty(allButLeftmost, JSType.UNKNOWN));
            }
        }

        private void visitClassPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            NominalType thisType = this.currentScope.getDeclaredType().getThisType();
            if (thisType == null) {
                return;
            }
            NominalType.RawNominalType rawNominalType = thisType.getRawNominalType();
            String pname = getProp.getLastChild().getString();
            JSType declType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            boolean isConst = NodeUtil.hasConstAnnotation(getProp);
            if (declType != null || isConst) {
                this.mayWarnAboutExistingProp(rawNominalType, pname, getProp, declType);
                if (isConst && !this.mayWarnAboutNoInit(getProp) && declType == null) {
                    declType = this.inferConstTypeFromRhs(getProp);
                }
                if (this.mayAddPropToType(getProp, rawNominalType)) {
                    rawNominalType.addClassProperty(pname, declType, isConst);
                }
            } else if (this.mayAddPropToType(getProp, rawNominalType)) {
                rawNominalType.addUndeclaredClassProperty(pname);
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawNominalType.getId(), (Object)pname, (Object)new PropertyDef(getProp, null, null));
        }

        boolean mayWarnAboutNoInit(Node constExpr) {
            if (constExpr.isFromExterns()) {
                return false;
            }
            boolean noInit = true;
            if (constExpr.isName()) {
                Preconditions.checkState((boolean)constExpr.getParent().isVar());
                noInit = constExpr.getFirstChild() == null;
            } else {
                Preconditions.checkState((boolean)constExpr.isGetProp());
                boolean bl = noInit = !constExpr.getParent().isAssign();
            }
            if (noInit) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, CONST_WITHOUT_INITIALIZER, new String[0]));
                return true;
            }
            return false;
        }

        private JSType inferConstTypeFromRhs(Node constExpr) {
            Node rhs;
            if (constExpr.isFromExterns()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, new String[0]));
                return null;
            }
            if (constExpr.isName()) {
                Preconditions.checkState((boolean)constExpr.getParent().isVar());
                rhs = constExpr.getFirstChild();
            } else {
                Preconditions.checkState((constExpr.isGetProp() && constExpr.getParent().isAssign() ? 1 : 0) != 0);
                rhs = constExpr.getParent().getLastChild();
            }
            JSType rhsType = this.simpleInferExprType(rhs);
            if (rhsType == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, new String[0]));
                return null;
            }
            return rhsType;
        }

        private JSType simpleInferExprType(Node n) {
            switch (n.getType()) {
                case 9: 
                case 10: 
                case 11: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 39: 
                case 102: 
                case 103: {
                    return JSType.NUMBER;
                }
                case 32: 
                case 40: {
                    return JSType.STRING;
                }
                case 44: {
                    return JSType.TRUE_TYPE;
                }
                case 43: {
                    return JSType.FALSE_TYPE;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 45: 
                case 46: 
                case 51: 
                case 52: {
                    return JSType.BOOLEAN;
                }
                case 41: {
                    return JSType.NULL;
                }
                case 122: {
                    return JSType.UNDEFINED;
                }
                case 38: {
                    String varName = n.getString();
                    if (varName.equals("undefined")) {
                        return JSType.UNDEFINED;
                    }
                    return this.currentScope.getDeclaredTypeOf(varName);
                }
                case 64: {
                    JSType objLitType = JSType.TOP_OBJECT;
                    for (Node prop : n.children()) {
                        JSType propType = this.simpleInferExprType(prop.getFirstChild());
                        if (propType == null) {
                            return null;
                        }
                        objLitType = objLitType.withProperty(new QualifiedName(NodeUtil.getObjectLitKeyName(prop)), propType);
                    }
                    return objLitType;
                }
                case 33: {
                    JSType recvType = this.simpleInferExprType(n.getFirstChild());
                    if (recvType == null) {
                        return null;
                    }
                    QualifiedName qname = new QualifiedName(n.getLastChild().getString());
                    JSType propType = recvType.getProp(qname);
                    return propType == null ? null : propType;
                }
                case 85: {
                    return this.simpleInferExprType(n.getLastChild());
                }
                case 30: 
                case 37: {
                    JSType ratorType = this.simpleInferExprType(n.getFirstChild());
                    if (ratorType == null) {
                        return null;
                    }
                    FunctionType funType = ratorType.getFunType();
                    return funType == null ? null : funType.getReturnType();
                }
            }
            return null;
        }

        private boolean mayAddPropToType(Node getProp, NominalType.RawNominalType rawType) {
            if (!rawType.isStruct()) {
                return true;
            }
            Node parent = getProp.getParent();
            return parent.isAssign() && getProp == parent.getFirstChild() && this.currentScope.isConstructor();
        }

        private boolean mayWarnAboutExistingProp(NominalType.RawNominalType classType, String pname, Node propCreationNode, JSType typeInJsdoc) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(propCreationNode);
            JSType previousPropType = classType.getPropDeclaredType(pname);
            if (classType.mayHaveOwnProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, typeInJsdoc, previousPropType)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(propCreationNode, REDECLARED_PROPERTY, pname, classType.toString()));
                return true;
            }
            return false;
        }

        private boolean suppressDupPropWarning(JSDocInfo propCreationJsdoc, JSType typeInJsdoc, JSType previousType) {
            if (propCreationJsdoc == null || !propCreationJsdoc.getSuppressions().contains("duplicate")) {
                return false;
            }
            return typeInJsdoc != null && previousType != null && typeInJsdoc.equals(previousType);
        }

        private DeclaredFunctionType computeFnDeclaredType(JSDocInfo fnDoc, String functionName, Node declNode, NominalType.RawNominalType ownerType, Scope parentScope) {
            Preconditions.checkArgument((declNode.isFunction() || declNode.isGetProp() ? 1 : 0) != 0);
            ImmutableList<String> typeParameters = fnDoc == null ? null : fnDoc.getTemplateTypeNames();
            FunctionTypeBuilder builder = GlobalTypeInfo.this.typeParser.getFunctionType(fnDoc, declNode, ownerType, parentScope);
            if (fnDoc != null) {
                NominalType parentClass = null;
                if (fnDoc.hasBaseType()) {
                    if (!fnDoc.isConstructor()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, EXTENDS_NOT_ON_CTOR_OR_INTERF, functionName));
                    } else {
                        Node docNode = fnDoc.getBaseType().getRootNode();
                        if (GlobalTypeInfo.this.typeParser.hasKnownType(docNode, ownerType, parentScope, typeParameters)) {
                            parentClass = GlobalTypeInfo.this.typeParser.getNominalType(docNode, ownerType, parentScope, typeParameters);
                            if (parentClass == null) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(declNode, EXTENDS_NON_OBJECT, functionName, docNode.toStringTree()));
                            } else if (!parentClass.isClass()) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_EXTENDED_TYPE, "constructor", functionName));
                                parentClass = null;
                            }
                        }
                    }
                }
                NominalType.RawNominalType ctorType = declNode.isFunction() ? (NominalType.RawNominalType)GlobalTypeInfo.this.nominaltypesByNode.get(declNode) : null;
                ImmutableSet<NominalType> implementedIntfs = GlobalTypeInfo.this.typeParser.getImplementedInterfaces(fnDoc, ownerType, parentScope, typeParameters);
                if (ctorType == null && (fnDoc.isConstructor() || fnDoc.isInterface())) {
                    return builder.buildDeclaration();
                }
                if (fnDoc.isConstructor()) {
                    String className = ctorType.toString();
                    if (parentClass != null) {
                        if (!ctorType.addSuperClass(parentClass)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(declNode, INHERITANCE_CYCLE, className));
                        } else if (ctorType.isStruct() && !parentClass.isStruct()) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_SHAPE_TYPE, className, "struct", "struct"));
                        } else if (ctorType.isDict() && !parentClass.isDict()) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_SHAPE_TYPE, className, "dict", "dict"));
                        }
                    }
                    if (ctorType.isDict() && !implementedIntfs.isEmpty()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, DICT_IMPLEMENTS_INTERF, className));
                    }
                    boolean noCycles = ctorType.addInterfaces(implementedIntfs);
                    Preconditions.checkState((boolean)noCycles);
                    builder.addNominalType(NominalType.fromRaw(ctorType));
                } else if (fnDoc.isInterface()) {
                    boolean noCycles;
                    if (declNode.isFunction() && !NodeUtil.isEmptyBlock(NodeUtil.getFunctionBody(declNode))) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, INTERFACE_WITH_A_BODY, new String[0]));
                    }
                    if (!implementedIntfs.isEmpty()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, functionName));
                    }
                    if (!(noCycles = ctorType.addInterfaces(GlobalTypeInfo.this.typeParser.getExtendedInterfaces(fnDoc, ownerType, parentScope, typeParameters)))) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, INHERITANCE_CYCLE, ctorType.toString()));
                    }
                    builder.addNominalType(NominalType.fromRaw(ctorType));
                } else if (!implementedIntfs.isEmpty()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(declNode, IMPLEMENTS_WITHOUT_CONSTRUCTOR, functionName));
                }
            }
            if (ownerType != null) {
                builder.addReceiverType(NominalType.fromRaw(ownerType));
            }
            return builder.buildDeclaration();
        }

        private Scope computeFnScope(Node fn, NominalType.RawNominalType ownerType, Scope parentScope) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(fn);
            String functionName = GlobalTypeInfo.this.getFunInternalName(fn);
            DeclaredFunctionType declFunType = this.computeFnDeclaredType(fnDoc, functionName, fn, ownerType, parentScope);
            ArrayList formals = Lists.newArrayList();
            ArrayList tmpRestFormals = Lists.newArrayList();
            Node param = NodeUtil.getFunctionParameters(fn).getFirstChild();
            int optionalArity = declFunType.getOptionalArity();
            int formalIndex = 0;
            while (param != null) {
                if (!GlobalTypeInfo.this.typeParser.isRestArg(fnDoc, param.getString()) || formalIndex < optionalArity) {
                    formals.add(param.getString());
                } else {
                    tmpRestFormals.add(param.getString());
                }
                param = param.getNext();
                ++formalIndex;
            }
            if (fnDoc != null) {
                for (String formalInJsdoc : fnDoc.getParameterNames()) {
                    if (formals.contains(formalInJsdoc) || tmpRestFormals.contains(formalInJsdoc)) continue;
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, INEXISTENT_PARAM, formalInJsdoc, functionName));
                }
            }
            return new Scope(fn, parentScope, formals, declFunType);
        }

        private JSType getVarTypeFromAnnotation(Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.getParent().isVar());
            Node varNode = nameNode.getParent();
            JSType varType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(varNode.getJSDocInfo(), this.currentScope);
            if (varNode.getChildCount() > 1 && varType != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(varNode, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
            }
            String varName = nameNode.getString();
            JSType nameNodeType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(nameNode.getJSDocInfo(), this.currentScope);
            if (nameNodeType != null) {
                if (varType != null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, DUPLICATE_JSDOC, varName));
                }
                return nameNodeType;
            }
            return varType;
        }
    }

    private class CollectNamedTypes
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;

        CollectNamedTypes(Scope s) {
            this.currentScope = s;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    this.initFnScope(n, this.currentScope);
                    break;
                }
                case 118: {
                    String varName;
                    if (!NodeUtil.isTypedefDecl(n)) break;
                    if (n.getFirstChild().getFirstChild() != null) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(n, CANNOT_INIT_TYPEDEF, new String[0]));
                    }
                    if (this.currentScope.isDefinedLocally(varName = n.getFirstChild().getString())) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(n, VariableReferenceCheck.REDECLARED_VARIABLE, varName));
                        break;
                    }
                    JSDocInfo jsdoc = n.getJSDocInfo();
                    Typedef td = Typedef.make(jsdoc.getTypedefType());
                    this.currentScope.addTypedef(varName, td);
                    break;
                }
            }
        }

        private void initFnScope(Node fn, Scope parentScope) {
            JSDocInfo fnDoc;
            String qname = NodeUtil.getFunctionName(fn);
            if (qname == null || qname.contains(".")) {
                GlobalTypeInfo.this.anonFunNames.put(fn, GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.freshId);
                GlobalTypeInfo.this.freshId++;
            }
            if ((fnDoc = NodeUtil.getFunctionJSDocInfo(fn)) != null && (fnDoc.isConstructor() || fnDoc.isInterface())) {
                if (qname == null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, ANONYMOUS_NOMINAL_TYPE, new String[0]));
                    return;
                }
                ImmutableList<String> typeParameters = fnDoc.getTemplateTypeNames();
                NominalType.RawNominalType rawNominalType = fnDoc.isInterface() ? NominalType.RawNominalType.makeInterface(qname, typeParameters) : (fnDoc.makesStructs() ? NominalType.RawNominalType.makeStructClass(qname, typeParameters) : (fnDoc.makesDicts() ? NominalType.RawNominalType.makeDictClass(qname, typeParameters) : NominalType.RawNominalType.makeUnrestrictedClass(qname, typeParameters)));
                GlobalTypeInfo.this.nominaltypesByNode.put(fn, rawNominalType);
                parentScope.addNominalType(qname, rawNominalType);
            } else if (fnDoc != null) {
                if (fnDoc.makesStructs()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, CONSTRUCTOR_REQUIRED, "@struct"));
                } else if (fnDoc.makesDicts()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, CONSTRUCTOR_REQUIRED, "@dict"));
                }
            }
        }
    }
}

