/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class UnionType
extends JSType {
    private static final long serialVersionUID = 1L;
    Collection<JSType> alternates;
    private final int hashcode;

    UnionType(JSTypeRegistry jSTypeRegistry, Collection<JSType> collection) {
        super(jSTypeRegistry);
        this.alternates = collection;
        this.hashcode = ((Object)this.alternates).hashCode();
    }

    public Iterable<JSType> getAlternates() {
        return this.alternates;
    }

    @Override
    void forgiveUnknownNames() {
        for (JSType jSType : this.getAlternates()) {
            jSType.forgiveUnknownNames();
        }
    }

    @Override
    public boolean matchesNumberContext() {
        for (JSType jSType : this.alternates) {
            if (!jSType.matchesNumberContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        for (JSType jSType : this.alternates) {
            if (!jSType.matchesStringContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesObjectContext() {
        for (JSType jSType : this.alternates) {
            if (!jSType.matchesObjectContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType findPropertyType(String string) {
        JSType jSType = null;
        for (JSType jSType2 : this.getAlternates()) {
            JSType jSType3;
            if (jSType2.isNullType() || jSType2.isVoidType() || (jSType3 = jSType2.findPropertyType(string)) == null) continue;
            if (jSType == null) {
                jSType = jSType3;
                continue;
            }
            jSType = jSType.getLeastSupertype(jSType3);
        }
        return jSType;
    }

    @Override
    public boolean canAssignTo(JSType jSType) {
        boolean bl = true;
        for (JSType jSType2 : this.alternates) {
            if (jSType2.isUnknownType()) {
                return true;
            }
            bl &= jSType2.canAssignTo(jSType);
        }
        return bl;
    }

    @Override
    public boolean canBeCalled() {
        for (JSType jSType : this.alternates) {
            if (jSType.canBeCalled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this.registry);
        for (JSType jSType : this.alternates) {
            unionTypeBuilder.addAlternate(jSType.restrictByNotNullOrUndefined());
        }
        return unionTypeBuilder.build();
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        TernaryValue ternaryValue = null;
        for (JSType jSType2 : this.alternates) {
            TernaryValue ternaryValue2 = jSType2.testForEquality(jSType);
            if (ternaryValue == null) {
                ternaryValue = ternaryValue2;
                continue;
            }
            if (ternaryValue.equals((Object)ternaryValue2)) continue;
            return TernaryValue.UNKNOWN;
        }
        return ternaryValue;
    }

    @Override
    public boolean isNullable() {
        for (JSType jSType : this.alternates) {
            if (!jSType.isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnknownType() {
        for (JSType jSType : this.alternates) {
            if (!jSType.isUnknownType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType getLeastSupertype(JSType jSType) {
        if (!jSType.isUnknownType()) {
            for (JSType jSType2 : this.alternates) {
                if (jSType2.isUnknownType() || !jSType.isSubtype(jSType2)) continue;
                return this;
            }
        }
        return UnionType.getLeastSupertype(this, jSType);
    }

    JSType meet(JSType jSType) {
        JSType jSType2;
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this.registry);
        Object object = this.alternates.iterator();
        while (object.hasNext()) {
            jSType2 = object.next();
            if (!jSType2.isSubtype(jSType)) continue;
            unionTypeBuilder.addAlternate(jSType2);
        }
        if (jSType instanceof UnionType) {
            object = ((UnionType)jSType).alternates.iterator();
            while (object.hasNext()) {
                jSType2 = (JSType)object.next();
                if (!jSType2.isSubtype(this)) continue;
                unionTypeBuilder.addAlternate(jSType2);
            }
        } else if (jSType.isSubtype(this)) {
            unionTypeBuilder.addAlternate(jSType);
        }
        if (!((JSType)(object = unionTypeBuilder.build())).isNoType()) {
            return object;
        }
        if (this.isObject() && jSType.isObject()) {
            return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        if (jSType instanceof UnionType) {
            UnionType unionType = (UnionType)jSType;
            if (this.alternates.size() != unionType.alternates.size()) {
                return false;
            }
            for (JSType jSType2 : unionType.alternates) {
                if (this.hasAlternate(jSType2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasAlternate(JSType jSType) {
        for (JSType jSType2 : this.alternates) {
            if (!jSType2.isEquivalentTo(jSType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    @Override
    public boolean isObject() {
        for (JSType jSType : this.alternates) {
            if (jSType.isObject()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(JSType jSType) {
        return this.alternates.contains(jSType);
    }

    public JSType getRestrictedUnion(JSType jSType) {
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this.registry);
        for (JSType jSType2 : this.alternates) {
            if (!jSType2.isUnknownType() && jSType2.isSubtype(jSType)) continue;
            unionTypeBuilder.addAlternate(jSType2);
        }
        return unionTypeBuilder.build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        stringBuilder.append("(");
        TreeSet<JSType> treeSet = new TreeSet<JSType>(ALPHA);
        treeSet.addAll(this.alternates);
        for (JSType jSType : treeSet) {
            if (!bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append(jSType.toString());
            bl = false;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        if (jSType.isUnknownType()) {
            return true;
        }
        if (jSType.isAllType()) {
            return true;
        }
        for (JSType jSType2 : this.alternates) {
            if (jSType2.isSubtype(jSType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSType getRestrictedTypeGivenToBooleanOutcome(boolean bl) {
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this.registry);
        for (JSType jSType : this.alternates) {
            unionTypeBuilder.addAlternate(jSType.getRestrictedTypeGivenToBooleanOutcome(bl));
        }
        return unionTypeBuilder.build();
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        JSType jSType;
        BooleanLiteralSet booleanLiteralSet = BooleanLiteralSet.EMPTY;
        Iterator<JSType> iterator = this.alternates.iterator();
        while (iterator.hasNext() && (booleanLiteralSet = booleanLiteralSet.union((jSType = iterator.next()).getPossibleToBooleanOutcomes())) != BooleanLiteralSet.BOTH) {
        }
        return booleanLiteralSet;
    }

    @Override
    public JSType.TypePair getTypesUnderEquality(JSType jSType) {
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder unionTypeBuilder2 = new UnionTypeBuilder(this.registry);
        for (JSType jSType2 : this.alternates) {
            JSType.TypePair typePair = jSType2.getTypesUnderEquality(jSType);
            if (typePair.typeA != null) {
                unionTypeBuilder.addAlternate(typePair.typeA);
            }
            if (typePair.typeB == null) continue;
            unionTypeBuilder2.addAlternate(typePair.typeB);
        }
        return new JSType.TypePair(unionTypeBuilder.build(), unionTypeBuilder2.build());
    }

    @Override
    public JSType.TypePair getTypesUnderInequality(JSType jSType) {
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder unionTypeBuilder2 = new UnionTypeBuilder(this.registry);
        for (JSType jSType2 : this.alternates) {
            JSType.TypePair typePair = jSType2.getTypesUnderInequality(jSType);
            if (typePair.typeA != null) {
                unionTypeBuilder.addAlternate(typePair.typeA);
            }
            if (typePair.typeB == null) continue;
            unionTypeBuilder2.addAlternate(typePair.typeB);
        }
        return new JSType.TypePair(unionTypeBuilder.build(), unionTypeBuilder2.build());
    }

    @Override
    public JSType.TypePair getTypesUnderShallowInequality(JSType jSType) {
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder unionTypeBuilder2 = new UnionTypeBuilder(this.registry);
        for (JSType jSType2 : this.alternates) {
            JSType.TypePair typePair = jSType2.getTypesUnderShallowInequality(jSType);
            if (typePair.typeA != null) {
                unionTypeBuilder.addAlternate(typePair.typeA);
            }
            if (typePair.typeB == null) continue;
            unionTypeBuilder2.addAlternate(typePair.typeB);
        }
        return new JSType.TypePair(unionTypeBuilder.build(), unionTypeBuilder2.build());
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseUnionType(this);
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        this.setResolvedTypeInternal(this);
        boolean bl = false;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSType jSType : this.alternates) {
            JSType jSType2;
            bl |= jSType != (jSType2 = jSType.resolve(errorReporter, staticScope));
            builder.add((Object)jSType);
        }
        if (bl) {
            ImmutableList immutableList = builder.build();
            Preconditions.checkState((immutableList.hashCode() == this.hashcode ? 1 : 0) != 0);
            this.alternates = immutableList;
        }
        return this;
    }

    @Override
    public String toDebugHashCodeString() {
        ArrayList arrayList = Lists.newArrayList();
        for (JSType jSType : this.alternates) {
            arrayList.add(jSType.toDebugHashCodeString());
        }
        return "{(" + Joiner.on((String)",").join((Iterable)arrayList) + ")}";
    }
}

