/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "my" locale.
 */
public class LocalizedNamesImpl_my extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "MM",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AG",
        "AL",
        "AW",
        "AX",
        "BB",
        "BF",
        "BI",
        "BJ",
        "BL",
        "BQ",
        "BV",
        "CD",
        "CG",
        "CP",
        "CV",
        "CW",
        "DG",
        "DJ",
        "EA",
        "ER",
        "FM",
        "GA",
        "GD",
        "GG",
        "GP",
        "GW",
        "GY",
        "HM",
        "IC",
        "IM",
        "KI",
        "KM",
        "KN",
        "LC",
        "LI",
        "LS",
        "LY",
        "MD",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "NF",
        "NR",
        "NU",
        "PM",
        "PN",
        "PW",
        "QO",
        "RE",
        "SC",
        "SH",
        "SJ",
        "SL",
        "SM",
        "SR",
        "SS",
        "ST",
        "SX",
        "SZ",
        "TA",
        "TC",
        "TG",
        "TK",
        "TM",
        "TT",
        "TV",
        "VC",
        "VU",
        "WF",
        "WS",
        "YT",
        "KE",
        "CM",
        "CA",
        "KH",
        "KZ",
        "QA",
        "CC",
        "CO",
        "KW",
        "KY",
        "CR",
        "CU",
        "CK",
        "KG",
        "CX",
        "HR",
        "CZ",
        "TD",
        "CL",
        "GM",
        "GL",
        "GR",
        "GH",
        "GN",
        "GU",
        "JP",
        "JM",
        "JE",
        "DE",
        "GI",
        "GE",
        "JO",
        "GT",
        "SG",
        "ES",
        "SK",
        "SI",
        "MF",
        "RS",
        "CY",
        "SO",
        "SN",
        "SY",
        "SD",
        "SA",
        "SB",
        "CH",
        "SE",
        "ZW",
        "ZM",
        "TZ",
        "CN",
        "TJ",
        "TN",
        "TR",
        "KR",
        "GS",
        "ZA",
        "TO",
        "TW",
        "TH",
        "DK",
        "DO",
        "DM",
        "NA",
        "NC",
        "NZ",
        "NL",
        "NE",
        "NG",
        "NI",
        "NP",
        "NO",
        "PA",
        "PK",
        "PG",
        "PY",
        "PS",
        "PL",
        "PE",
        "PT",
        "PR",
        "FR",
        "GF",
        "TF",
        "PF",
        "FI",
        "FO",
        "PH",
        "FJ",
        "FK",
        "VE",
        "VA",
        "VN",
        "VG",
        "IO",
        "BD",
        "BE",
        "BR",
        "BN",
        "BS",
        "BM",
        "BH",
        "BO",
        "BY",
        "BG",
        "BT",
        "BZ",
        "BA",
        "BW",
        "MO",
        "MX",
        "MG",
        "MY",
        "MK",
        "MH",
        "MW",
        "ML",
        "MZ",
        "MC",
        "MA",
        "MV",
        "MM",
        "KP",
        "MN",
        "ME",
        "YE",
        "UA",
        "UG",
        "GB",
        "US",
        "UM",
        "VI",
        "AE",
        "RW",
        "RO",
        "RU",
        "LB",
        "LT",
        "LV",
        "LA",
        "LR",
        "LU",
        "LK",
        "HU",
        "HT",
        "HK",
        "HN",
        "EE",
        "AO",
        "ID",
        "IL",
        "AZ",
        "EH",
        "AQ",
        "AI",
        "AS",
        "DZ",
        "SV",
        "TL",
        "CF",
        "AR",
        "AF",
        "AM",
        "IN",
        "IS",
        "CI",
        "IE",
        "OM",
        "GQ",
        "EC",
        "EG",
        "IT",
        "IQ",
        "IR",
        "ET",
        "UZ",
        "UY",
        "EU",
        "AT",
        "AU",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ကမ္ဘာ");
    namesMap.put("002", "အာဖရိက");
    namesMap.put("003", "မြောက် အမေရိက");
    namesMap.put("005", "တောင် အမေရိက");
    namesMap.put("009", "သမုဒ္ဒရာဒေသ");
    namesMap.put("011", "အနောက် အာဖရိက");
    namesMap.put("013", "အလယ်ပိုင်း အမေရိက");
    namesMap.put("014", "အရှေ့ပိုင်း အာဖရိက");
    namesMap.put("015", "မြောက်ပိုင်း အာဖရိက");
    namesMap.put("017", "အလယ်ပိုင်း အာဖရိက");
    namesMap.put("018", "တောင်ပိုင်း အာဖရိက");
    namesMap.put("019", "အမေရိကများ");
    namesMap.put("021", "မြောက်ပိုင်း အမေရိက");
    namesMap.put("029", "ကာရီဘီယံ");
    namesMap.put("030", "အရှေ့ပိုင်း အာရှ");
    namesMap.put("034", "တောင်ပိုင်း အာရှ");
    namesMap.put("035", "အ‌ရှေ့တောင်ပိုင်း အာရှ");
    namesMap.put("039", "တောင်ပိုင်း ဥရောပ");
    namesMap.put("053", "ဩစတြေးလျှ နှင့် နယူးဇီလန်");
    namesMap.put("142", "အာရှ");
    namesMap.put("143", "အလယ် အာရှ");
    namesMap.put("145", "အနောက် အာရှ");
    namesMap.put("150", "ဥရောပ");
    namesMap.put("151", "အရှေ့ပိုင်း ဥရောပ");
    namesMap.put("154", "မြောက်ပိုင်း ဥရောပ");
    namesMap.put("155", "အနောက်ပိုင်း ဥရောပ");
    namesMap.put("419", "လက်တင် အမေရိက နှင့် ကာရီဘီယန်");
    namesMap.put("AE", "ယူအေအီး");
    namesMap.put("AF", "အာဖဂန်နစ္စတန်");
    namesMap.put("AI", "အန်ကွီလာ");
    namesMap.put("AM", "အာမေနီးယား");
    namesMap.put("AO", "အင်ဂိုလာ");
    namesMap.put("AQ", "အန္တာတိက");
    namesMap.put("AR", "အာဂျင်တီးနား");
    namesMap.put("AS", "အမေရိကန် စမိုအ");
    namesMap.put("AT", "ဩစတြီးယား");
    namesMap.put("AU", "ဩစတြေးလျှား");
    namesMap.put("AZ", "အဇာဘိုင်ဂျန်");
    namesMap.put("BA", "ဘော့စနီးယား နှင့် ဟာဇီဂိုဘီးနား");
    namesMap.put("BD", "ဘင်္ဂလားဒေ့ရှ်");
    namesMap.put("BE", "ဘယ်လ်ဂျီယမ်");
    namesMap.put("BG", "ဘူဂေးရီးယား");
    namesMap.put("BH", "ဘာရိန်း");
    namesMap.put("BM", "ဘာမူဒါ");
    namesMap.put("BN", "ဘရူနိုင်း");
    namesMap.put("BO", "ဘိုလီးဘီးယား");
    namesMap.put("BR", "ဘရာဇီး");
    namesMap.put("BS", "ဘဟားမား");
    namesMap.put("BT", "ဘူတန်");
    namesMap.put("BW", "ဘော့စ်ဝါနာ");
    namesMap.put("BY", "ဘီလာရုစ်");
    namesMap.put("BZ", "ဘေလီဇ်");
    namesMap.put("CA", "ကနေဒါ");
    namesMap.put("CC", "ကိုကိုး ကျွန်းစု");
    namesMap.put("CF", "အလယ်ပိုင်း အာဖရိက ပြည်ထောင်စု");
    namesMap.put("CH", "ဆွစ်ဇလန်");
    namesMap.put("CI", "အိုင်ဗရီကိုစ့်");
    namesMap.put("CK", "ကွတ် ကျွန်းစု");
    namesMap.put("CL", "ချီလီ");
    namesMap.put("CM", "ကင်မရွန်း");
    namesMap.put("CN", "တရုတ်");
    namesMap.put("CO", "ကိုလံဘီယာ");
    namesMap.put("CR", "ကော့စ်တာရီကာ");
    namesMap.put("CU", "ကျူးဘား");
    namesMap.put("CX", "ခရစ်စမတ် ကျွန်း");
    namesMap.put("CY", "ဆိုက်ပရက်စ်");
    namesMap.put("CZ", "ချက် ပြည်ထောင်စု");
    namesMap.put("DE", "ဂျာမဏီ");
    namesMap.put("DK", "ဒိန်းမတ်");
    namesMap.put("DM", "ဒိုမီနီကာ");
    namesMap.put("DO", "ဒိုမီနီကန်");
    namesMap.put("DZ", "အယ်လ်ဂျီးရီးယား");
    namesMap.put("EC", "အီကွေဒေါ");
    namesMap.put("EE", "အက်စတိုးနီးယား");
    namesMap.put("EG", "အီဂျစ်");
    namesMap.put("EH", "အနောက်ပိုင်း ဆာဟာရ");
    namesMap.put("ES", "စပိန်");
    namesMap.put("ET", "အီသီယိုးပီးယား");
    namesMap.put("EU", "ဥရောပသမဂ္ဂ");
    namesMap.put("FI", "ဖင်လန်");
    namesMap.put("FJ", "ဖီဂျီ");
    namesMap.put("FK", "ဖောက်ကလန် ကျွန်းစု");
    namesMap.put("FO", "ဖာရိုး ကျွန်းစုများ");
    namesMap.put("FR", "ပြင်သစ်");
    namesMap.put("GB", "ယူနိုက်တက်ကင်းဒမ်း");
    namesMap.put("GE", "ဂျော်ဂျီယာ");
    namesMap.put("GF", "ပြင်သစ် ဂီယာနာ");
    namesMap.put("GH", "ဂါနာ");
    namesMap.put("GI", "ဂျီဘရော်လ်တာ");
    namesMap.put("GL", "ဂရင်းလန်း");
    namesMap.put("GM", "ဂန်ဘီရာ");
    namesMap.put("GN", "ဂီရာနာ");
    namesMap.put("GQ", "အီကွေတာ ဂီရာနာ");
    namesMap.put("GR", "ဂရိ");
    namesMap.put("GS", "တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ");
    namesMap.put("GT", "ဂွာတီမာလာ");
    namesMap.put("GU", "ဂူအမ်");
    namesMap.put("HK", "ဟောင်ကောင်");
    namesMap.put("HN", "ဟွန်ဒူးရပ်စ်");
    namesMap.put("HR", "ခရိုအေးရှား");
    namesMap.put("HT", "ဟေတီ");
    namesMap.put("HU", "ဟန်ဂေရီ");
    namesMap.put("ID", "အင်ဒိုနီးရှား");
    namesMap.put("IE", "အိုင်ယာလန်");
    namesMap.put("IL", "အစ္စရေး");
    namesMap.put("IN", "အိန္ဒိယ");
    namesMap.put("IO", "ဗြိတိသျှ အိန္ဒြိယ သမုဒ္ဒရာ ပိုင်နက်");
    namesMap.put("IQ", "အီရတ်");
    namesMap.put("IR", "အီရန်");
    namesMap.put("IS", "အိုက်စလန်");
    namesMap.put("IT", "အီတလီ");
    namesMap.put("JE", "ဂျာစီ");
    namesMap.put("JM", "ဂျမေနီကာ");
    namesMap.put("JO", "ဂျော်ဒန်");
    namesMap.put("JP", "ဂျပန်");
    namesMap.put("KE", "ကင်ညာ");
    namesMap.put("KG", "ခယ်ကစ်စတန်");
    namesMap.put("KH", "ကမ္ဘောဒီးယား");
    namesMap.put("KP", "မြောက်ကိုရီးယား");
    namesMap.put("KR", "တောင်ကိုရီးယား");
    namesMap.put("KW", "ကူဝိတ်");
    namesMap.put("KY", "ကေမန် ကျွန်းစု");
    namesMap.put("KZ", "ကာဇက်စတန်");
    namesMap.put("LA", "လာအို");
    namesMap.put("LB", "လက်ဘနွန်");
    namesMap.put("LK", "သီရိလင်္ကာ");
    namesMap.put("LR", "လိုင်ဘေးရီးယား");
    namesMap.put("LT", "လစ်သူယေးနီးယား");
    namesMap.put("LU", "လူဇင်ဘတ်");
    namesMap.put("LV", "လတ်ဗီးယား");
    namesMap.put("MA", "မော်ရိုကို");
    namesMap.put("MC", "မိုနကို");
    namesMap.put("ME", "မွန်တီနိဂရိုး");
    namesMap.put("MF", "စိန့်မာတင်");
    namesMap.put("MG", "မဒဂတ်စကာ");
    namesMap.put("MH", "မာရှယ် ကျွန်းစု");
    namesMap.put("MK", "မာစီဒိုးနီးယား");
    namesMap.put("ML", "မာလီ");
    namesMap.put("MM", "မြန်မာ");
    namesMap.put("MN", "မွန်ဂိုးလီးယား");
    namesMap.put("MO", "မကာအို");
    namesMap.put("MV", "မော်လဒိုက်");
    namesMap.put("MW", "မာလာဝီ");
    namesMap.put("MX", "မက္ကဆီကို");
    namesMap.put("MY", "မလေးရှား");
    namesMap.put("MZ", "မိုဇန်ဘစ်");
    namesMap.put("NA", "နမ်မီးဘီးယား");
    namesMap.put("NC", "နယူး ကယ်လီဒိုနီးယား");
    namesMap.put("NE", "နိုင်ဂျာ");
    namesMap.put("NG", "နိုင်ဂျီးရီးယား");
    namesMap.put("NI", "နီကာရာဂွာ");
    namesMap.put("NL", "နယ်သာလန်");
    namesMap.put("NO", "နော်ဝေ");
    namesMap.put("NP", "နီပေါ");
    namesMap.put("NZ", "နယူးဇီလန်");
    namesMap.put("OM", "အိုမန်");
    namesMap.put("PA", "ပနားမား");
    namesMap.put("PE", "ပီရူး");
    namesMap.put("PF", "ပြင်သစ် ပေါ်လီနေးရှား");
    namesMap.put("PG", "ပါပူရာနယူးဂီနီ");
    namesMap.put("PH", "ဖိလစ်ပိုင်");
    namesMap.put("PK", "ပါကစ္စတန်");
    namesMap.put("PL", "ပိုလန်");
    namesMap.put("PR", "ပေါ်တူရီကို");
    namesMap.put("PS", "ပါလက်စတိုင်း ပိုင်နက်");
    namesMap.put("PT", "ပေါ်တူဂီ");
    namesMap.put("PY", "ပါရာဂွေး");
    namesMap.put("QA", "ကာတာ");
    namesMap.put("RO", "ရိုမေးနီးယား");
    namesMap.put("RS", "ဆားဘီးယား");
    namesMap.put("RU", "ရုရှ");
    namesMap.put("RW", "ရဝန်ဒါ");
    namesMap.put("SA", "ဆော်ဒီအာရေးဗီးယား");
    namesMap.put("SB", "ဆော်လမွန်ကျွန်းစု");
    namesMap.put("SD", "ဆူဒန်");
    namesMap.put("SE", "ဆွီဒင်");
    namesMap.put("SG", "စင်္ကာပူ");
    namesMap.put("SI", "စလိုဗေးနီးယား");
    namesMap.put("SK", "စလိုဗေးကီးယား");
    namesMap.put("SN", "ဆီနီဂေါ");
    namesMap.put("SO", "ဆိုမာလီယာ");
    namesMap.put("SV", "အယ်လ်ဆာဗေးဒိုး");
    namesMap.put("SY", "ဆီးရီးယား");
    namesMap.put("TD", "ချဒ်");
    namesMap.put("TF", "ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ");
    namesMap.put("TH", "ထိုင်း");
    namesMap.put("TJ", "တာဂျီကစ္စတန်");
    namesMap.put("TL", "အရှေ့တီမော");
    namesMap.put("TN", "တူနီးရှား");
    namesMap.put("TO", "တွန်ဂါ");
    namesMap.put("TR", "တူရကီ");
    namesMap.put("TW", "ထိုင်ဝမ်");
    namesMap.put("TZ", "တန်ဇန်နီးယား");
    namesMap.put("UA", "ယူကရိန်း");
    namesMap.put("UG", "ယူဂန္ဒာ");
    namesMap.put("UM", "ယူနိုက်တက်စတိတ် အပြင်ထွက် နေသည့် သေးငယ်သောကျွန်းများ");
    namesMap.put("US", "ယူနိုက်တက်စတိတ်");
    namesMap.put("UY", "ဥရုဂွေး");
    namesMap.put("UZ", "ဥဘက်ကစ္စတန်");
    namesMap.put("VA", "ဗာတီကန်");
    namesMap.put("VE", "ဗင်နီဇွဲလား");
    namesMap.put("VG", "ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု");
    namesMap.put("VI", "ယူအက်စ် ဗာဂျင်း ကျွန်းစု");
    namesMap.put("VN", "ဗီယက်နမ်");
    namesMap.put("YE", "ယီမင်");
    namesMap.put("ZA", "တောင်အာဖရိက");
    namesMap.put("ZM", "ဇမ်ဘီယာ");
    namesMap.put("ZW", "ဇင်ဘာဘွေ");
    namesMap.put("ZZ", "မသိ သို့မဟုတ် မရှိ သော နေရာ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ကမ္ဘာ",
        "002": "အာဖရိက",
        "003": "မြောက် အမေရိက",
        "005": "တောင် အမေရိက",
        "009": "သမုဒ္ဒရာဒေသ",
        "011": "အနောက် အာဖရိက",
        "013": "အလယ်ပိုင်း အမေရိက",
        "014": "အရှေ့ပိုင်း အာဖရိက",
        "015": "မြောက်ပိုင်း အာဖရိက",
        "017": "အလယ်ပိုင်း အာဖရိက",
        "018": "တောင်ပိုင်း အာဖရိက",
        "019": "အမေရိကများ",
        "021": "မြောက်ပိုင်း အမေရိက",
        "029": "ကာရီဘီယံ",
        "030": "အရှေ့ပိုင်း အာရှ",
        "034": "တောင်ပိုင်း အာရှ",
        "035": "အ‌ရှေ့တောင်ပိုင်း အာရှ",
        "039": "တောင်ပိုင်း ဥရောပ",
        "053": "ဩစတြေးလျှ နှင့် နယူးဇီလန်",
        "142": "အာရှ",
        "143": "အလယ် အာရှ",
        "145": "အနောက် အာရှ",
        "150": "ဥရောပ",
        "151": "အရှေ့ပိုင်း ဥရောပ",
        "154": "မြောက်ပိုင်း ဥရောပ",
        "155": "အနောက်ပိုင်း ဥရောပ",
        "419": "လက်တင် အမေရိက နှင့် ကာရီဘီယန်",
        "AE": "ယူအေအီး",
        "AF": "အာဖဂန်နစ္စတန်",
        "AI": "အန်ကွီလာ",
        "AM": "အာမေနီးယား",
        "AO": "အင်ဂိုလာ",
        "AQ": "အန္တာတိက",
        "AR": "အာဂျင်တီးနား",
        "AS": "အမေရိကန် စမိုအ",
        "AT": "ဩစတြီးယား",
        "AU": "ဩစတြေးလျှား",
        "AZ": "အဇာဘိုင်ဂျန်",
        "BA": "ဘော့စနီးယား နှင့် ဟာဇီဂိုဘီးနား",
        "BD": "ဘင်္ဂလားဒေ့ရှ်",
        "BE": "ဘယ်လ်ဂျီယမ်",
        "BG": "ဘူဂေးရီးယား",
        "BH": "ဘာရိန်း",
        "BM": "ဘာမူဒါ",
        "BN": "ဘရူနိုင်း",
        "BO": "ဘိုလီးဘီးယား",
        "BR": "ဘရာဇီး",
        "BS": "ဘဟားမား",
        "BT": "ဘူတန်",
        "BW": "ဘော့စ်ဝါနာ",
        "BY": "ဘီလာရုစ်",
        "BZ": "ဘေလီဇ်",
        "CA": "ကနေဒါ",
        "CC": "ကိုကိုး ကျွန်းစု",
        "CF": "အလယ်ပိုင်း အာဖရိက ပြည်ထောင်စု",
        "CH": "ဆွစ်ဇလန်",
        "CI": "အိုင်ဗရီကိုစ့်",
        "CK": "ကွတ် ကျွန်းစု",
        "CL": "ချီလီ",
        "CM": "ကင်မရွန်း",
        "CN": "တရုတ်",
        "CO": "ကိုလံဘီယာ",
        "CR": "ကော့စ်တာရီကာ",
        "CU": "ကျူးဘား",
        "CX": "ခရစ်စမတ် ကျွန်း",
        "CY": "ဆိုက်ပရက်စ်",
        "CZ": "ချက် ပြည်ထောင်စု",
        "DE": "ဂျာမဏီ",
        "DK": "ဒိန်းမတ်",
        "DM": "ဒိုမီနီကာ",
        "DO": "ဒိုမီနီကန်",
        "DZ": "အယ်လ်ဂျီးရီးယား",
        "EC": "အီကွေဒေါ",
        "EE": "အက်စတိုးနီးယား",
        "EG": "အီဂျစ်",
        "EH": "အနောက်ပိုင်း ဆာဟာရ",
        "ES": "စပိန်",
        "ET": "အီသီယိုးပီးယား",
        "EU": "ဥရောပသမဂ္ဂ",
        "FI": "ဖင်လန်",
        "FJ": "ဖီဂျီ",
        "FK": "ဖောက်ကလန် ကျွန်းစု",
        "FO": "ဖာရိုး ကျွန်းစုများ",
        "FR": "ပြင်သစ်",
        "GB": "ယူနိုက်တက်ကင်းဒမ်း",
        "GE": "ဂျော်ဂျီယာ",
        "GF": "ပြင်သစ် ဂီယာနာ",
        "GH": "ဂါနာ",
        "GI": "ဂျီဘရော်လ်တာ",
        "GL": "ဂရင်းလန်း",
        "GM": "ဂန်ဘီရာ",
        "GN": "ဂီရာနာ",
        "GQ": "အီကွေတာ ဂီရာနာ",
        "GR": "ဂရိ",
        "GS": "တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ",
        "GT": "ဂွာတီမာလာ",
        "GU": "ဂူအမ်",
        "HK": "ဟောင်ကောင်",
        "HN": "ဟွန်ဒူးရပ်စ်",
        "HR": "ခရိုအေးရှား",
        "HT": "ဟေတီ",
        "HU": "ဟန်ဂေရီ",
        "ID": "အင်ဒိုနီးရှား",
        "IE": "အိုင်ယာလန်",
        "IL": "အစ္စရေး",
        "IN": "အိန္ဒိယ",
        "IO": "ဗြိတိသျှ အိန္ဒြိယ သမုဒ္ဒရာ ပိုင်နက်",
        "IQ": "အီရတ်",
        "IR": "အီရန်",
        "IS": "အိုက်စလန်",
        "IT": "အီတလီ",
        "JE": "ဂျာစီ",
        "JM": "ဂျမေနီကာ",
        "JO": "ဂျော်ဒန်",
        "JP": "ဂျပန်",
        "KE": "ကင်ညာ",
        "KG": "ခယ်ကစ်စတန်",
        "KH": "ကမ္ဘောဒီးယား",
        "KP": "မြောက်ကိုရီးယား",
        "KR": "တောင်ကိုရီးယား",
        "KW": "ကူဝိတ်",
        "KY": "ကေမန် ကျွန်းစု",
        "KZ": "ကာဇက်စတန်",
        "LA": "လာအို",
        "LB": "လက်ဘနွန်",
        "LK": "သီရိလင်္ကာ",
        "LR": "လိုင်ဘေးရီးယား",
        "LT": "လစ်သူယေးနီးယား",
        "LU": "လူဇင်ဘတ်",
        "LV": "လတ်ဗီးယား",
        "MA": "မော်ရိုကို",
        "MC": "မိုနကို",
        "ME": "မွန်တီနိဂရိုး",
        "MF": "စိန့်မာတင်",
        "MG": "မဒဂတ်စကာ",
        "MH": "မာရှယ် ကျွန်းစု",
        "MK": "မာစီဒိုးနီးယား",
        "ML": "မာလီ",
        "MM": "မြန်မာ",
        "MN": "မွန်ဂိုးလီးယား",
        "MO": "မကာအို",
        "MV": "မော်လဒိုက်",
        "MW": "မာလာဝီ",
        "MX": "မက္ကဆီကို",
        "MY": "မလေးရှား",
        "MZ": "မိုဇန်ဘစ်",
        "NA": "နမ်မီးဘီးယား",
        "NC": "နယူး ကယ်လီဒိုနီးယား",
        "NE": "နိုင်ဂျာ",
        "NG": "နိုင်ဂျီးရီးယား",
        "NI": "နီကာရာဂွာ",
        "NL": "နယ်သာလန်",
        "NO": "နော်ဝေ",
        "NP": "နီပေါ",
        "NZ": "နယူးဇီလန်",
        "OM": "အိုမန်",
        "PA": "ပနားမား",
        "PE": "ပီရူး",
        "PF": "ပြင်သစ် ပေါ်လီနေးရှား",
        "PG": "ပါပူရာနယူးဂီနီ",
        "PH": "ဖိလစ်ပိုင်",
        "PK": "ပါကစ္စတန်",
        "PL": "ပိုလန်",
        "PR": "ပေါ်တူရီကို",
        "PS": "ပါလက်စတိုင်း ပိုင်နက်",
        "PT": "ပေါ်တူဂီ",
        "PY": "ပါရာဂွေး",
        "QA": "ကာတာ",
        "RO": "ရိုမေးနီးယား",
        "RS": "ဆားဘီးယား",
        "RU": "ရုရှ",
        "RW": "ရဝန်ဒါ",
        "SA": "ဆော်ဒီအာရေးဗီးယား",
        "SB": "ဆော်လမွန်ကျွန်းစု",
        "SD": "ဆူဒန်",
        "SE": "ဆွီဒင်",
        "SG": "စင်္ကာပူ",
        "SI": "စလိုဗေးနီးယား",
        "SK": "စလိုဗေးကီးယား",
        "SN": "ဆီနီဂေါ",
        "SO": "ဆိုမာလီယာ",
        "SV": "အယ်လ်ဆာဗေးဒိုး",
        "SY": "ဆီးရီးယား",
        "TD": "ချဒ်",
        "TF": "ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ",
        "TH": "ထိုင်း",
        "TJ": "တာဂျီကစ္စတန်",
        "TL": "အရှေ့တီမော",
        "TN": "တူနီးရှား",
        "TO": "တွန်ဂါ",
        "TR": "တူရကီ",
        "TW": "ထိုင်ဝမ်",
        "TZ": "တန်ဇန်နီးယား",
        "UA": "ယူကရိန်း",
        "UG": "ယူဂန္ဒာ",
        "UM": "ယူနိုက်တက်စတိတ် အပြင်ထွက် နေသည့် သေးငယ်သောကျွန်းများ",
        "US": "ယူနိုက်တက်စတိတ်",
        "UY": "ဥရုဂွေး",
        "UZ": "ဥဘက်ကစ္စတန်",
        "VA": "ဗာတီကန်",
        "VE": "ဗင်နီဇွဲလား",
        "VG": "ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု",
        "VI": "ယူအက်စ် ဗာဂျင်း ကျွန်းစု",
        "VN": "ဗီယက်နမ်",
        "YE": "ယီမင်",
        "ZA": "တောင်အာဖရိက",
        "ZM": "ဇမ်ဘီယာ",
        "ZW": "ဇင်ဘာဘွေ",
        "ZZ": "မသိ သို့မဟုတ် မရှိ သော နေရာ"
    };
  }-*/;
}
