/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm.testing;

import com.google.web.bindery.requestfactory.shared.RequestTransport;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class UrlRequestTransport
implements RequestTransport {
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 60000;
    private final Map<String, String> cookies = new HashMap<String, String>();
    private final URL url;

    public UrlRequestTransport(URL url) {
        this.url = url;
        String proto = url.getProtocol().toLowerCase(Locale.ROOT);
        if (!proto.equals("http") && !proto.equals("https")) {
            throw new IllegalArgumentException("Only http and https URLs supported");
        }
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String payload, RequestTransport.TransportReceiver receiver) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            this.configureConnection(connection);
            OutputStream out = connection.getOutputStream();
            out.write(payload.getBytes("UTF-8"));
            out.close();
            int status = connection.getResponseCode();
            if (status != 200) {
                String string = String.valueOf(connection.getResponseMessage());
                ServerFailure failure = new ServerFailure(new StringBuilder(12 + String.valueOf(string).length()).append(status).append(" ").append(string).toString());
                receiver.onTransportFailure(failure);
                return;
            }
            List<String> cookieHeaders = connection.getHeaderFields().get("Set-Cookie");
            if (cookieHeaders != null) {
                for (String header : cookieHeaders) {
                    List<HttpCookie> headerCookies;
                    try {
                        headerCookies = HttpCookie.parse(header);
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    for (HttpCookie cookie : headerCookies) {
                        String path;
                        String domain = cookie.getDomain();
                        if (domain != null && !this.url.getHost().endsWith(domain) || (path = cookie.getPath()) != null && !this.url.getPath().startsWith(path)) continue;
                        this.cookies.put(cookie.getName(), cookie.getValue());
                    }
                }
            }
            String encoding = connection.getContentEncoding();
            InputStream in = connection.getInputStream();
            if ("gzip".equalsIgnoreCase(encoding)) {
                in = new GZIPInputStream(in);
            } else if ("deflate".equalsIgnoreCase(encoding)) {
                in = new InflaterInputStream(in);
            } else if (encoding != null) {
                String string = String.valueOf(encoding);
                receiver.onTransportFailure(new ServerFailure(string.length() != 0 ? "Unknown server encoding ".concat(string) : new String("Unknown server encoding ")));
                return;
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int read = in.read(buffer);
            while (read != -1) {
                bytes.write(buffer, 0, read);
                read = in.read(buffer);
            }
            in.close();
            String received = new String(bytes.toByteArray(), "UTF-8");
            receiver.onTransportSuccess(received);
        }
        catch (IOException e) {
            ServerFailure failure = new ServerFailure(e.getMessage(), e.getClass().getName(), null, true);
            receiver.onTransportFailure(failure);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected void configureConnection(HttpURLConnection connection) throws IOException {
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        connection.setRequestProperty("Host", this.url.getHost());
        connection.setRequestProperty("User-Agent", UrlRequestTransport.class.getCanonicalName());
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(60000);
        if (!this.cookies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean needsSemi = false;
            for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
                if (needsSemi) {
                    sb.append("; ");
                } else {
                    needsSemi = true;
                }
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
            connection.setRequestProperty("Cookie", sb.toString());
        }
    }
}

