/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.linker.rpc;

import com.google.gwt.core.ext.LinkerContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.AbstractLinker;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.linker.Shardable;
import com.google.gwt.core.ext.linker.SyntheticArtifact;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;

@LinkerOrder(value=LinkerOrder.Order.PRE)
@Shardable
public class RpcPolicyManifestLinker
extends AbstractLinker {
    private static final String MANIFEST_TXT = "manifest.txt";
    private StringBuilder manifestBody = new StringBuilder();

    public String getDescription() {
        return "RPC policy file manifest";
    }

    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts, boolean onePermutation) throws UnableToCompleteException {
        if (onePermutation) {
            return artifacts;
        }
        for (EmittedArtifact art : artifacts.find(EmittedArtifact.class)) {
            if (!art.getPartialPath().startsWith("rpcPolicyManifest/manifests")) continue;
            this.readOneManifest(logger, art.getContents(logger));
        }
        ArtifactSet toReturn = new ArtifactSet((Collection)artifacts);
        SyntheticArtifact manifestArt = this.emitString(logger, this.generateManifest(context), MANIFEST_TXT);
        manifestArt.setVisibility(EmittedArtifact.Visibility.LegacyDeploy);
        toReturn.add((Artifact)manifestArt);
        return toReturn;
    }

    private String generateManifest(LinkerContext context) {
        StringBuilder sb = new StringBuilder();
        String string = String.valueOf(context.getModuleName());
        sb.append(new StringBuilder(10 + String.valueOf(string).length()).append("# Module ").append(string).append("\n").toString());
        sb.append("# RPC service class, partial path of RPC policy file\n");
        sb.append(this.manifestBody.toString());
        return sb.toString();
    }

    private void readOneManifest(TreeLogger logger, InputStream manifestStream) throws UnableToCompleteException {
        HashMap<String, String> entries = new HashMap<String, String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(manifestStream, Util.DEFAULT_ENCODING));
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(58);
                if (idx < 0) {
                    String string = String.valueOf(line);
                    throw new InternalCompilerException(string.length() != 0 ? "invalid selection information line: ".concat(string) : new String("invalid selection information line: "));
                }
                String propName = line.substring(0, idx).trim();
                String propValue = line.substring(idx + 1).trim();
                entries.put(propName, propValue);
            }
            reader.close();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unexpected IOException", (Throwable)e);
            throw new UnableToCompleteException();
        }
        String serviceClass = (String)entries.get("serviceClass");
        if (serviceClass == null) {
            logger.log(TreeLogger.ERROR, "Internal error: manifest file does not include a serviceClass");
            throw new UnableToCompleteException();
        }
        String path = (String)entries.get("path");
        if (path == null) {
            logger.log(TreeLogger.ERROR, "Internal error: manifest file does not include a path");
            throw new UnableToCompleteException();
        }
        this.manifestBody.append(serviceClass);
        this.manifestBody.append(", ");
        this.manifestBody.append(path);
        this.manifestBody.append("\n");
    }
}

