/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.aria.client.SelectedValue;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import com.google.gwt.user.datepicker.client.CalendarView;
import com.google.gwt.user.datepicker.client.CellGridImpl;
import java.util.Date;

public final class DefaultCalendarView
extends CalendarView {
    private CellGrid grid = new CellGrid();
    private Date firstDisplayed;
    private Date lastDisplayed = new Date();
    private CellGrid.DateCell ariaSelectedCell;

    @Override
    public void addStyleToDate(String styleName, Date date) {
        if (!$assertionsDisabled && !this.getDatePicker().isDateVisible(date)) {
            String string = String.valueOf(date);
            String string2 = String.valueOf(this.getFirstDate());
            String string3 = String.valueOf(this.getLastDate());
            throw new AssertionError((Object)new StringBuilder(67 + String.valueOf(styleName).length() + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("You tried to add style ").append(styleName).append(" to ").append(string).append(". The calendar is currently showing ").append(string2).append(" to ").append(string3).toString());
        }
        this.getCell(date).addStyleName(styleName);
    }

    @Override
    public Date getFirstDate() {
        return this.firstDisplayed;
    }

    @Override
    public Date getLastDate() {
        return this.lastDisplayed;
    }

    @Override
    public boolean isDateEnabled(Date d) {
        return this.getCell(d).isEnabled();
    }

    @Override
    public void refresh() {
        this.firstDisplayed = this.getModel().getCurrentFirstDayOfFirstWeek();
        if (this.firstDisplayed.getDate() == 1) {
            DefaultCalendarView.addDays(this.firstDisplayed, -7);
        }
        this.lastDisplayed.setTime(this.firstDisplayed.getTime());
        for (int i = 0; i < this.grid.getNumCells(); ++i) {
            if (i != 0) {
                DefaultCalendarView.addDays(this.lastDisplayed, 1);
            }
            CellGrid.DateCell cell = (CellGrid.DateCell)this.grid.getCell(i);
            cell.update(this.lastDisplayed);
        }
        this.setAriaSelectedCell(null);
    }

    private static void addDays(Date date, int days) {
        CalendarUtil.addDaysToDate(date, days);
        CalendarUtil.resetTime(date);
    }

    @Override
    public void removeStyleFromDate(String styleName, Date date) {
        this.getCell(date).removeStyleName(styleName);
    }

    @Override
    public void setAriaSelectedCell(Date date) {
        CellGrid.DateCell newSelectedCell;
        if (this.ariaSelectedCell != null) {
            this.ariaSelectedCell.setAriaSelected(false);
        }
        CellGrid.DateCell dateCell = newSelectedCell = date != null ? this.getCell(date) : null;
        if (newSelectedCell != null) {
            newSelectedCell.setAriaSelected(true);
        }
        this.ariaSelectedCell = newSelectedCell;
    }

    @Override
    public void setEnabledOnDate(boolean enabled, Date date) {
        this.getCell(date).setEnabled(enabled);
    }

    @Override
    public void setup() {
        HTMLTable.CellFormatter formatter = this.grid.getCellFormatter();
        int weekendStartColumn = -1;
        int weekendEndColumn = -1;
        for (int i = 0; i < 7; ++i) {
            int shift = CalendarUtil.getStartingDayOfWeek();
            int dayIdx = i + shift < 7 ? i + shift : i + shift - 7;
            this.grid.setText(0, i, this.getModel().formatDayOfWeek(dayIdx));
            if (CalendarUtil.isWeekend(dayIdx)) {
                formatter.setStyleName(0, i, this.css().weekendLabel());
                if (weekendStartColumn == -1) {
                    weekendStartColumn = i;
                    continue;
                }
                weekendEndColumn = i;
                continue;
            }
            formatter.setStyleName(0, i, this.css().weekdayLabel());
        }
        for (int row = 1; row <= 6; ++row) {
            for (int column = 0; column < 7; ++column) {
                CellGrid cellGrid = this.grid;
                cellGrid.getClass();
                CellGrid.DateCell cell = cellGrid.new CellGrid.DateCell(column == weekendStartColumn || column == weekendEndColumn);
                this.grid.setWidget(row, column, cell);
            }
        }
        this.initWidget(this.grid);
        this.grid.setStyleName(this.css().days());
    }

    private CellGrid.DateCell getCell(Date d) {
        int index = CalendarUtil.getDaysBetween(this.firstDisplayed, d);
        if (index < 0 || this.grid.getNumCells() <= index) {
            return null;
        }
        CellGrid.DateCell cell = (CellGrid.DateCell)this.grid.getCell(index);
        if (((Date)cell.getValue()).getDate() != d.getDate()) {
            String string = String.valueOf(d);
            String string2 = String.valueOf(cell);
            String string3 = String.valueOf(cell.getValue());
            throw new IllegalStateException(new StringBuilder(48 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(" cannot be associated with cell ").append(string2).append(" as it has date ").append(string3).toString());
        }
        return cell;
    }

    class CellGrid
    extends CellGridImpl<Date> {
        CellGrid() {
            this.resize(7, 7);
        }

        @Override
        protected void onSelected(CellGridImpl.Cell lastSelected, CellGridImpl.Cell cell) {
        }

        class DateCell
        extends CellGridImpl.Cell {
            private String cellStyle;
            private String dateStyle;

            DateCell(boolean isWeekend) {
                super(new Date());
                this.cellStyle = DefaultCalendarView.this.css().day();
                if (isWeekend) {
                    String string = String.valueOf(this.cellStyle);
                    String string2 = DefaultCalendarView.this.css().dayIsWeekend();
                    this.cellStyle = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
                }
                this.getElement().setTabIndex(this.isFiller() ? -1 : 0);
                this.setAriaSelected(false);
            }

            @Override
            public void addStyleName(String styleName) {
                if (this.dateStyle.indexOf(new StringBuilder(2 + String.valueOf(styleName).length()).append(" ").append(styleName).append(" ").toString()) == -1) {
                    String string = String.valueOf(this.dateStyle);
                    this.dateStyle = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(styleName).length()).append(string).append(styleName).append(" ").toString();
                }
                this.updateStyle();
            }

            public boolean isFiller() {
                return !DefaultCalendarView.this.getModel().isInCurrentMonth((Date)this.getValue());
            }

            @Override
            public void onHighlighted(boolean highlighted) {
                DefaultCalendarView.this.setHighlightedDate((Date)this.getValue());
                this.updateStyle();
            }

            @Override
            public void onSelected(boolean selected) {
                if (selected) {
                    DefaultCalendarView.this.getDatePicker().setValue((Date)this.getValue(), true);
                    if (this.isFiller()) {
                        DefaultCalendarView.this.getDatePicker().setCurrentMonth((Date)this.getValue());
                    }
                }
                this.updateStyle();
            }

            @Override
            public void removeStyleName(String styleName) {
                this.dateStyle = this.dateStyle.replace(new StringBuilder(2 + String.valueOf(styleName).length()).append(" ").append(styleName).append(" ").toString(), " ");
                this.updateStyle();
            }

            public void setAriaSelected(boolean value) {
                Roles.getGridcellRole().setAriaSelectedState(this.getElement(), SelectedValue.of(value));
            }

            @Override
            public void updateStyle() {
                String string;
                String string2;
                String accum = this.dateStyle;
                if (this.isHighlighted()) {
                    string2 = String.valueOf(accum);
                    string = DefaultCalendarView.this.css().dayIsHighlighted();
                    accum = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" ").append(string).toString();
                    if (this.isHighlighted() && this.isSelected()) {
                        string2 = String.valueOf(accum);
                        string = DefaultCalendarView.this.css().dayIsValueAndHighlighted();
                        accum = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" ").append(string).toString();
                    }
                }
                if (!this.isEnabled()) {
                    string2 = String.valueOf(accum);
                    string = DefaultCalendarView.this.css().dayIsDisabled();
                    accum = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" ").append(string).toString();
                }
                this.setStyleName(accum);
            }

            void update(Date current) {
                this.setEnabled(true);
                ((Date)this.getValue()).setTime(current.getTime());
                String value = DefaultCalendarView.this.getModel().formatDayOfMonth((Date)this.getValue());
                this.setText(value);
                this.dateStyle = this.cellStyle;
                if (this.isFiller()) {
                    this.getElement().setTabIndex(-1);
                    String string = String.valueOf(this.dateStyle);
                    String string2 = DefaultCalendarView.this.css().dayIsFiller();
                    this.dateStyle = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
                } else {
                    this.getElement().setTabIndex(0);
                    String extraStyle = DefaultCalendarView.this.getDatePicker().getStyleOfDate(current);
                    if (extraStyle != null) {
                        String string = String.valueOf(this.dateStyle);
                        this.dateStyle = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(extraStyle).length()).append(string).append(" ").append(extraStyle).toString();
                    }
                }
                this.dateStyle = String.valueOf(this.dateStyle).concat(" ");
                this.updateStyle();
            }

            private void setText(String value) {
                this.getElement().setInnerText(value);
            }
        }
    }
}

