/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safecss.shared.SafeStylesUtils;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.Image;

public class ClippedImageImpl {
    protected static final SafeUri clearImage = UriUtils.fromTrustedString(String.valueOf(GWT.getModuleBaseURL()).concat("clear.cache.gif"));
    private static Template template;
    private static DraggableTemplate draggableTemplate;

    public void adjust(Element img, SafeUri url, int left, int top, int width, int height) {
        String string = url.asString();
        int n = -left;
        int n2 = -top;
        String style = new StringBuilder(45 + String.valueOf(string).length()).append("url(\"").append(string).append("\") no-repeat ").append(n).append("px ").append(n2).append("px").toString();
        img.getStyle().setProperty("background", style);
        img.getStyle().setPropertyPx("width", width);
        img.getStyle().setPropertyPx("height", height);
    }

    public Element createStructure(SafeUri url, int left, int top, int width, int height) {
        SpanElement tmp = Document.get().createSpanElement();
        tmp.setInnerSafeHtml(this.getSafeHtml(url, left, top, width, height));
        return tmp.getFirstChildElement();
    }

    public Element getImgElement(Image image) {
        return image.getElement();
    }

    public SafeHtml getSafeHtml(SafeUri url, int left, int top, int width, int height) {
        return this.getSafeHtml(url, left, top, width, height, false);
    }

    public SafeHtml getSafeHtml(SafeUri url, int left, int top, int width, int height, boolean isDraggable) {
        SafeStylesBuilder builder = new SafeStylesBuilder();
        String string = url.asString();
        int n = -left;
        int n2 = -top;
        builder.width(width, Style.Unit.PX).height(height, Style.Unit.PX).trustedNameAndValue("background", new StringBuilder(43 + String.valueOf(string).length()).append("url(").append(string).append(") ").append("no-repeat ").append(n).append("px ").append(n2).append("px").toString());
        if (!isDraggable) {
            return this.getTemplate().image(clearImage, SafeStylesUtils.fromTrustedString(builder.toSafeStyles().asString()));
        }
        return this.getDraggableTemplate().image(clearImage, SafeStylesUtils.fromTrustedString(builder.toSafeStyles().asString()));
    }

    private DraggableTemplate getDraggableTemplate() {
        if (draggableTemplate == null) {
            draggableTemplate = (DraggableTemplate)GWT.create(DraggableTemplate.class);
        }
        return draggableTemplate;
    }

    private Template getTemplate() {
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        return template;
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<img onload='this.__gwtLastUnhandledEvent=\"load\";' src='{0}' style='{1}' border='0'>")
        public SafeHtml image(SafeUri var1, SafeStyles var2);
    }

    static interface DraggableTemplate
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<img onload='this.__gwtLastUnhandledEvent=\"load\";' src='{0}' style='{1}' border='0' draggable='true'>")
        public SafeHtml image(SafeUri var1, SafeStyles var2);
    }
}

