/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.aria.client.ExpandedValue;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesUtils;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractHasData;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.CellTree;
import com.google.gwt.user.cellview.client.HasDataPresenter;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.LoadingStateChangeEvent;
import com.google.gwt.user.cellview.client.TreeNode;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.impl.FocusImpl;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.TreeViewModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CellTreeNodeView<T>
extends UIObject {
    private static final SafeHtml LEAF_IMAGE = SafeHtmlUtils.fromSafeConstant("<div style='position:absolute;display:none;'></div>");
    private static final Template template = (Template)GWT.create(Template.class);
    private static Element tmpElem;
    NodeCellList<?> listView;
    private boolean animate;
    private Element animationFrame;
    private Element childContainer;
    private List<CellTreeNodeView<?>> children;
    private Element contentContainer;
    private final int depth;
    private Element emptyMessageElem;
    private boolean isDestroyed;
    private final CellTree.CellTreeMessages messages;
    private TreeViewModel.NodeInfo<?> nodeInfo;
    private boolean nodeInfoLoaded;
    private boolean open;
    private CellTreeNodeView<?> parentNode;
    private final TreeViewModel.NodeInfo<T> parentNodeInfo;
    private AnchorElement showMoreElem;
    private final CellTree tree;
    private TreeNodeImpl treeNode;
    private T value;

    private static Element getCellParent(Element nodeElem) {
        return (Element)CellTreeNodeView.getSelectionElement(nodeElem).getFirstChildElement().getChild(1).cast();
    }

    private static Element getImageElement(Element nodeElem) {
        return CellTreeNodeView.getSelectionElement(nodeElem).getFirstChildElement().getFirstChildElement();
    }

    static Element getSelectionElement(Element nodeElem) {
        return nodeElem.getFirstChildElement();
    }

    private static Element getTmpElem() {
        if (tmpElem == null) {
            tmpElem = Document.get().createDivElement();
        }
        return tmpElem;
    }

    private static void showOrHide(Element element, boolean show) {
        if (show) {
            element.getStyle().clearDisplay();
        } else {
            element.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    CellTreeNodeView(CellTree tree, CellTreeNodeView<?> parent, TreeViewModel.NodeInfo<T> parentNodeInfo, Element elem, T value, CellTree.CellTreeMessages messages) {
        this.tree = tree;
        this.parentNode = parent;
        this.parentNodeInfo = parentNodeInfo;
        this.depth = this.parentNode == null ? 0 : this.parentNode.depth + 1;
        this.value = value;
        this.messages = messages;
        this.setElement(elem);
        Roles.getTreeitemRole().set(this.getElement());
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public CellTreeNodeView<?> getChildNode(int childIndex) {
        return this.children.get(childIndex);
    }

    public boolean isLeaf() {
        return this.tree.isLeaf(this.value);
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean setOpen(boolean open, boolean fireEvents) {
        if (this.open == open) {
            return this.open;
        }
        if (open && this.isLeaf()) {
            return false;
        }
        this.tree.cancelTreeNodeAnimation();
        this.animate = true;
        this.open = open;
        if (open) {
            if (!this.nodeInfoLoaded) {
                this.nodeInfoLoaded = true;
                this.nodeInfo = this.tree.getNodeInfo(this.value);
                if (this.nodeInfo != null) {
                    HashSet<String> eventsToSink = new HashSet<String>();
                    eventsToSink.add("focus");
                    eventsToSink.add("blur");
                    Set<String> consumedEvents = this.nodeInfo.getCell().getConsumedEvents();
                    if (consumedEvents != null) {
                        eventsToSink.addAll(consumedEvents);
                    }
                    CellBasedWidgetImpl.get().sinkEvents(this.tree, eventsToSink);
                }
            }
            if (this.nodeInfo != null) {
                this.ensureChildContainer();
                CellTreeNodeView.showOrHide(this.showMoreElem, false);
                CellTreeNodeView.showOrHide(this.emptyMessageElem, false);
                if (!this.isRootNode()) {
                    CellTreeNodeView.setStyleName(this.getCellParent(), this.tree.getStyle().cellTreeOpenItem(), true);
                }
                this.ensureAnimationFrame().getStyle().setProperty("display", "");
                this.onOpen(this.nodeInfo);
                if (fireEvents) {
                    OpenEvent.fire(this.tree, this.getTreeNode());
                }
            } else {
                this.open = false;
            }
        } else {
            if (!this.isRootNode()) {
                CellTreeNodeView.setStyleName(this.getCellParent(), this.tree.getStyle().cellTreeOpenItem(), false);
            }
            this.cleanup(false);
            this.tree.maybeAnimateTreeNode(this);
            this.updateImage(false);
            for (CellTreeNodeView<?> keySelected = this.tree.getKeyboardSelectedNode(); keySelected != null; keySelected = keySelected.getParentNode()) {
                if (keySelected != this) continue;
                this.tree.keyboardSelect(this, true);
                break;
            }
            if (fireEvents) {
                CloseEvent.fire(this.tree, this.getTreeNode());
            }
        }
        return this.open;
    }

    protected void cleanup(boolean destroy) {
        if (this.listView != null) {
            this.listView.cleanup();
            this.nodeInfo.unsetDataDisplay();
            this.listView = null;
        }
        if (this.children != null) {
            for (CellTreeNodeView<?> child : this.children) {
                child.cleanup(true);
            }
            this.children = null;
        }
        if (destroy) {
            this.isDestroyed = true;
            if (this == this.tree.getKeyboardSelectedNode()) {
                this.tree.keyboardSelect(this.parentNode, false);
            }
        }
    }

    protected boolean consumeAnimate() {
        boolean hasAnimate = this.animate;
        this.animate = false;
        return hasAnimate;
    }

    protected <C> CellTreeNodeView<C> createTreeNodeView(TreeViewModel.NodeInfo<C> nodeInfo, Element childElem, C childValue, Object viewData) {
        return new CellTreeNodeView<C>(this.tree, this, nodeInfo, childElem, childValue, this.messages);
    }

    protected void fireEventToCell(NativeEvent event) {
        boolean isSelectionHandled;
        boolean cellWasEditing;
        if (this.parentNodeInfo == null) {
            return;
        }
        Cell<T> parentCell = this.parentNodeInfo.getCell();
        String eventType = event.getType();
        Element cellParent = this.getCellParent();
        Object key = this.getValueKey();
        NodeCellList<?> display = this.parentNode.listView;
        Cell.Context context = new Cell.Context(this.getIndex(), 0, key);
        CellPreviewEvent<?> previewEvent = CellPreviewEvent.fire(display, event, display, context, this.value, cellWasEditing = parentCell.isEditing(context, cellParent, this.value), isSelectionHandled = parentCell.handlesSelection() || HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.tree.getKeyboardSelectionPolicy());
        if (previewEvent.isCanceled() || !cellParent.isOrHasChild(Element.as(event.getEventTarget()))) {
            return;
        }
        Set<String> consumedEvents = parentCell.getConsumedEvents();
        if (consumedEvents != null && consumedEvents.contains(eventType)) {
            parentCell.onBrowserEvent(context, cellParent, this.value, event, this.parentNodeInfo.getValueUpdater());
            this.tree.cellIsEditing = parentCell.isEditing(context, cellParent, this.value);
            if (cellWasEditing && !this.tree.cellIsEditing) {
                CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

                    @Override
                    public void execute() {
                        CellTreeNodeView.this.tree.setFocus(true);
                    }
                });
            }
        }
    }

    protected Element getCellParent() {
        return CellTreeNodeView.getCellParent(this.getElement());
    }

    protected Element getImageElement() {
        return CellTreeNodeView.getImageElement(this.getElement());
    }

    protected Element getSelectionElement() {
        return CellTreeNodeView.getSelectionElement(this.getElement());
    }

    protected Object getValueKey() {
        return this.parentNodeInfo.getProvidesKey().getKey(this.value);
    }

    protected <C> void onOpen(TreeViewModel.NodeInfo<C> nodeInfo) {
        NodeCellList<C> view = new NodeCellList<C>(nodeInfo, this, this.tree.getDefaultNodeSize());
        this.listView = view;
        view.setSelectionModel(nodeInfo.getSelectionModel());
        nodeInfo.setDataDisplay(view);
    }

    boolean belongsToTree(CellTree tree) {
        return this.tree == tree;
    }

    Element ensureAnimationFrame() {
        if (this.animationFrame == null) {
            this.animationFrame = Document.get().createDivElement();
            this.animationFrame.getStyle().setOverflow(Style.Overflow.HIDDEN);
            this.animationFrame.getStyle().setDisplay(Style.Display.NONE);
            this.getElement().appendChild(this.animationFrame);
        }
        return this.animationFrame;
    }

    Element ensureChildContainer() {
        if (this.childContainer == null) {
            this.childContainer = Document.get().createDivElement();
            this.ensureContentContainer().insertFirst(this.childContainer);
        }
        return this.childContainer;
    }

    Element ensureContentContainer() {
        if (this.contentContainer == null) {
            this.contentContainer = Document.get().createDivElement();
            this.ensureAnimationFrame().appendChild(this.contentContainer);
            this.emptyMessageElem = Document.get().createDivElement();
            this.emptyMessageElem.setInnerHTML(this.messages.emptyTree());
            CellTreeNodeView.setStyleName(this.emptyMessageElem, this.tree.getStyle().cellTreeEmptyMessage(), true);
            CellTreeNodeView.showOrHide(this.emptyMessageElem, false);
            this.contentContainer.appendChild(this.emptyMessageElem);
            this.showMoreElem = Document.get().createAnchorElement();
            this.showMoreElem.setHref("javascript:;");
            this.showMoreElem.setInnerText(this.messages.showMore());
            CellTreeNodeView.setStyleName(this.showMoreElem, this.tree.getStyle().cellTreeShowMoreButton(), true);
            CellTreeNodeView.showOrHide(this.showMoreElem, false);
            this.contentContainer.appendChild(this.showMoreElem);
        }
        return this.contentContainer;
    }

    int getIndex() {
        return this.parentNode == null ? 0 : this.parentNode.indexOf(this);
    }

    CellTreeNodeView<?> getParentNode() {
        return this.parentNode;
    }

    Element getShowMoreElement() {
        return this.showMoreElem;
    }

    TreeNode getTreeNode() {
        if (this.treeNode == null) {
            this.treeNode = new TreeNodeImpl(this);
        }
        return this.treeNode;
    }

    int indexOf(CellTreeNodeView<?> child) {
        return this.children.indexOf(child);
    }

    boolean isDestroyed() {
        return this.isDestroyed;
    }

    boolean isRootNode() {
        return this.parentNode == null;
    }

    boolean isSelected() {
        SelectionModel<T> selectionModel;
        if (this.parentNodeInfo != null && (selectionModel = this.parentNodeInfo.getSelectionModel()) != null) {
            return selectionModel.isSelected(this.value);
        }
        return false;
    }

    boolean resetFocusOnCell() {
        if (this.parentNodeInfo != null) {
            Cell.Context context = new Cell.Context(this.getIndex(), 0, this.getValueKey());
            Cell<T> cell = this.parentNodeInfo.getCell();
            return cell.resetFocus(context, this.getCellParent(), this.value);
        }
        return false;
    }

    void setKeyboardSelected(boolean selected, boolean stealFocus) {
        if (this.tree.isKeyboardSelectionDisabled()) {
            return;
        }
        if (!selected || this.tree.isFocused || stealFocus) {
            this.setKeyboardSelectedStyle(selected);
        }
        Element cellParent = this.getCellParent();
        if (!selected) {
            cellParent.setTabIndex(-1);
            cellParent.removeAttribute("tabIndex");
            cellParent.removeAttribute("accessKey");
        } else {
            FocusImpl focusImpl = FocusImpl.getFocusImplForWidget();
            focusImpl.setTabIndex(cellParent, this.tree.getTabIndex());
            char accessKey = this.tree.getAccessKey();
            if (accessKey != '\u0000') {
                focusImpl.setAccessKey(cellParent, accessKey);
            }
            if (stealFocus && !this.tree.cellIsEditing) {
                cellParent.focus();
            }
        }
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.tree.getKeyboardSelectionPolicy()) {
            this.setSelected(selected);
        }
    }

    void setKeyboardSelectedStyle(boolean selected) {
        Element selectionElem;
        if (!this.isRootNode() && (selectionElem = CellTreeNodeView.getSelectionElement(this.getElement())) != null) {
            CellTreeNodeView.setStyleName(selectionElem, this.tree.getStyle().cellTreeKeyboardSelectedItem(), selected);
        }
    }

    void setSelected(boolean selected) {
        SelectionModel<T> selectionModel;
        if (this.parentNodeInfo != null && (selectionModel = this.parentNodeInfo.getSelectionModel()) != null) {
            selectionModel.setSelected(this.value, selected);
        }
    }

    void showFewer() {
        Range range = this.listView.getVisibleRange();
        int defaultPageSize = this.listView.getDefaultPageSize();
        int maxSize = Math.max(defaultPageSize, range.getLength() - defaultPageSize);
        this.listView.setVisibleRange(range.getStart(), maxSize);
    }

    void showMore() {
        Range range = this.listView.getVisibleRange();
        int pageSize = range.getLength() + this.listView.getDefaultPageSize();
        this.listView.setVisibleRange(range.getStart(), pageSize);
    }

    private void updateAriaAttributes(int setSize) {
        if (this.isRootNode()) {
            return;
        }
        Roles.getTreeitemRole().setAriaSetsizeProperty(this.getElement(), setSize);
        int selectionIndex = this.parentNode.indexOf(this);
        Roles.getTreeitemRole().setAriaPosinsetProperty(this.getElement(), selectionIndex + 1);
        if (this.isLeaf()) {
            Roles.getTreeitemRole().removeAriaExpandedState(this.getElement());
        } else {
            Roles.getTreeitemRole().setAriaExpandedState(this.getElement(), ExpandedValue.of(this.open));
        }
        Roles.getTreeitemRole().setAriaLevelProperty(this.getElement(), this.depth);
    }

    private void updateImage(boolean isLoading) {
        if (this.isRootNode()) {
            return;
        }
        boolean isTopLevel = this.parentNode.isRootNode();
        SafeHtml html = this.tree.getClosedImageHtml(isTopLevel);
        if (this.open) {
            SafeHtml safeHtml = html = isLoading ? this.tree.getLoadingImageHtml() : this.tree.getOpenImageHtml(isTopLevel);
        }
        if (this.nodeInfoLoaded && this.nodeInfo == null) {
            html = LEAF_IMAGE;
        }
        DivElement tmp = Document.get().createDivElement();
        tmp.setInnerSafeHtml(html);
        Element imageElem = tmp.getFirstChildElement();
        Element oldImg = this.getImageElement();
        oldImg.getParentElement().replaceChild(imageElem, oldImg);
        if (this.isLeaf()) {
            Roles.getTreeitemRole().removeAriaExpandedState(this.getElement());
        } else {
            Roles.getTreeitemRole().setAriaExpandedState(this.getElement(), ExpandedValue.of(this.open));
        }
    }

    static class TreeNodeImpl
    implements TreeNode {
        private CellTreeNodeView<?> nodeView;

        public TreeNodeImpl(CellTreeNodeView<?> nodeView) {
            this.nodeView = nodeView;
        }

        @Override
        public int getChildCount() {
            this.assertNotDestroyed();
            this.flush();
            return this.nodeView.getChildCount();
        }

        @Override
        public Object getChildValue(int index) {
            this.assertNotDestroyed();
            this.checkChildBounds(index);
            this.flush();
            return ((CellTreeNodeView)this.nodeView.getChildNode(index)).value;
        }

        @Override
        public int getIndex() {
            this.assertNotDestroyed();
            return ((CellTreeNodeView)this.nodeView).parentNode == null ? 0 : ((CellTreeNodeView)((CellTreeNodeView)this.nodeView).parentNode).children.indexOf(this.nodeView);
        }

        final CellTreeNodeView<?> getNodeView() {
            return this.nodeView;
        }

        @Override
        public TreeNode getParent() {
            this.assertNotDestroyed();
            return this.getParentImpl();
        }

        @Override
        public Object getValue() {
            return ((CellTreeNodeView)this.nodeView).value;
        }

        @Override
        public boolean isChildLeaf(int index) {
            this.assertNotDestroyed();
            this.checkChildBounds(index);
            this.flush();
            return this.nodeView.getChildNode(index).isLeaf();
        }

        @Override
        public boolean isChildOpen(int index) {
            this.assertNotDestroyed();
            this.checkChildBounds(index);
            this.flush();
            return this.nodeView.getChildNode(index).isOpen();
        }

        @Override
        public boolean isDestroyed() {
            TreeNodeImpl parent;
            if (!((CellTreeNodeView)this.nodeView).isDestroyed && (parent = this.getParentImpl()) != null && !parent.isDestroyed()) {
                parent.flush();
            }
            return ((CellTreeNodeView)this.nodeView).isDestroyed || !this.nodeView.isOpen();
        }

        @Override
        public TreeNode setChildOpen(int index, boolean open) {
            return this.setChildOpen(index, open, true);
        }

        @Override
        public TreeNode setChildOpen(int index, boolean open, boolean fireEvents) {
            this.assertNotDestroyed();
            this.checkChildBounds(index);
            CellTreeNodeView<?> child = this.nodeView.getChildNode(index);
            return child.setOpen(open, fireEvents) ? ((CellTreeNodeView)child).treeNode : null;
        }

        private void assertNotDestroyed() {
            if (this.isDestroyed()) {
                throw new IllegalStateException("TreeNode no longer exists.");
            }
        }

        private void checkChildBounds(int index) {
            if (index < 0 || index >= this.getChildCount()) {
                throw new IndexOutOfBoundsException();
            }
        }

        void flush() {
            if (this.nodeView.listView != null) {
                this.nodeView.listView.presenter.flush();
            }
        }

        private TreeNodeImpl getParentImpl() {
            return this.nodeView.isRootNode() ? null : ((CellTreeNodeView)((CellTreeNodeView)this.nodeView).parentNode).treeNode;
        }
    }

    static class NodeCellList<C>
    implements HasData<C> {
        final HasDataPresenter<C> presenter;
        private final Cell<C> cell;
        private final int defaultPageSize;
        private HandlerManager handlerManger = new HandlerManager(this);
        private final TreeViewModel.NodeInfo<C> nodeInfo;
        private CellTreeNodeView<?> nodeView;

        public NodeCellList(TreeViewModel.NodeInfo<C> nodeInfo, final CellTreeNodeView<?> nodeView, int pageSize) {
            this.defaultPageSize = pageSize;
            this.nodeInfo = nodeInfo;
            this.nodeView = nodeView;
            this.cell = nodeInfo.getCell();
            this.presenter = new HasDataPresenter<C>(this, new View(nodeView.ensureChildContainer()), pageSize, nodeInfo.getProvidesKey());
            this.presenter.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
            this.presenter.addRowCountChangeHandler(new RowCountChangeEvent.Handler(){

                @Override
                public void onRowCountChange(RowCountChangeEvent event) {
                    int rowCount = event.getNewRowCount();
                    boolean isExact = event.isNewRowCountExact();
                    int pageSize = NodeCellList.this.getVisibleRange().getLength();
                    CellTreeNodeView.showOrHide(nodeView.showMoreElem, isExact && rowCount > pageSize);
                }
            });
        }

        @Override
        public HandlerRegistration addCellPreviewHandler(CellPreviewEvent.Handler<C> handler) {
            return this.presenter.addCellPreviewHandler(handler);
        }

        @Override
        public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
            return this.presenter.addRangeChangeHandler(handler);
        }

        @Override
        public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
            return this.presenter.addRowCountChangeHandler(handler);
        }

        public void cleanup() {
            this.presenter.clearSelectionModel();
        }

        @Override
        public void fireEvent(GwtEvent<?> event) {
            this.handlerManger.fireEvent(event);
        }

        public int getDefaultPageSize() {
            return this.defaultPageSize;
        }

        @Override
        public int getRowCount() {
            return this.presenter.getRowCount();
        }

        @Override
        public SelectionModel<? super C> getSelectionModel() {
            return this.presenter.getSelectionModel();
        }

        @Override
        public C getVisibleItem(int indexOnPage) {
            return this.presenter.getVisibleItem(indexOnPage);
        }

        @Override
        public int getVisibleItemCount() {
            return this.presenter.getVisibleItemCount();
        }

        @Override
        public List<C> getVisibleItems() {
            return this.presenter.getVisibleItems();
        }

        @Override
        public Range getVisibleRange() {
            return this.presenter.getVisibleRange();
        }

        @Override
        public boolean isRowCountExact() {
            return this.presenter.isRowCountExact();
        }

        @Override
        public final void setRowCount(int count) {
            this.setRowCount(count, true);
        }

        @Override
        public void setRowCount(int size, boolean isExact) {
            this.presenter.setRowCount(size, isExact);
        }

        @Override
        public void setRowData(int start, List<? extends C> values) {
            this.presenter.setRowData(start, values);
        }

        @Override
        public void setSelectionModel(SelectionModel<? super C> selectionModel) {
            this.presenter.setSelectionModel(selectionModel);
        }

        @Override
        public final void setVisibleRange(int start, int length) {
            this.setVisibleRange(new Range(start, length));
        }

        @Override
        public void setVisibleRange(Range range) {
            this.presenter.setVisibleRange(range);
        }

        @Override
        public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
            this.presenter.setVisibleRangeAndClearData(range, forceRangeChangeEvent);
        }

        private class View
        implements HasDataPresenter.View<C> {
            private final Element childContainer;

            public View(Element childContainer) {
                this.childContainer = childContainer;
            }

            @Override
            public <H extends EventHandler> HandlerRegistration addHandler(H handler, GwtEvent.Type<H> type) {
                return NodeCellList.this.handlerManger.addHandler(type, handler);
            }

            public void render(SafeHtmlBuilder sb, List<C> values, int start, SelectionModel<? super C> selectionModel) {
                CellTree.Style style = ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getStyle();
                String itemValueStyle = style.cellTreeItemValue();
                String string = String.valueOf(style.cellTreeSelectedItem());
                String selectedStyle = string.length() != 0 ? " ".concat(string) : new String(" ");
                String itemStyle = style.cellTreeItem();
                String string2 = String.valueOf(style.cellTreeItemImageValue());
                String itemImageValueStyle = string2.length() != 0 ? " ".concat(string2) : new String(" ");
                String string3 = String.valueOf(style.cellTreeOpenItem());
                String openStyle = string3.length() != 0 ? " ".concat(string3) : new String(" ");
                String string4 = String.valueOf(style.cellTreeTopItem());
                String topStyle = string4.length() != 0 ? " ".concat(string4) : new String(" ");
                String string5 = String.valueOf(style.cellTreeTopItemImageValue());
                String topImageValueStyle = string5.length() != 0 ? " ".concat(string5) : new String(" ");
                boolean isRootNode = NodeCellList.this.nodeView.isRootNode();
                SafeHtml openImage = ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getOpenImageHtml(isRootNode);
                SafeHtml closedImage = ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getClosedImageHtml(isRootNode);
                int imageWidth = ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getImageWidth();
                String paddingDirection = LocaleInfo.getCurrentLocale().isRTL() ? "right" : "left";
                int paddingAmount = imageWidth * ((CellTreeNodeView)NodeCellList.this.nodeView).depth;
                HashSet<Object> openNodes = new HashSet<Object>();
                int childCount = NodeCellList.this.nodeView.getChildCount();
                int end = start + values.size();
                for (int i = start; i < end && i < childCount; ++i) {
                    CellTreeNodeView<?> child = NodeCellList.this.nodeView.getChildNode(i);
                    if (!child.isOpen()) continue;
                    openNodes.add(child.getValueKey());
                }
                ProvidesKey keyProvider = NodeCellList.this.nodeInfo.getProvidesKey();
                TreeViewModel model = ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getTreeViewModel();
                for (int i = start; i < end; ++i) {
                    Object value = values.get(i - start);
                    Object key = keyProvider.getKey(value);
                    boolean isOpen = openNodes.contains(key);
                    StringBuilder outerClasses = new StringBuilder(itemStyle);
                    if (isOpen) {
                        outerClasses.append(openStyle);
                    }
                    if (isRootNode) {
                        outerClasses.append(topStyle);
                    }
                    boolean isSelected = selectionModel != null && selectionModel.isSelected(value);
                    String ariaSelected = String.valueOf(isSelected);
                    if (isSelected) {
                        outerClasses.append(selectedStyle);
                    }
                    StringBuilder innerClasses = new StringBuilder(itemStyle);
                    innerClasses.append(itemImageValueStyle);
                    if (isRootNode) {
                        innerClasses.append(topImageValueStyle);
                    }
                    SafeHtml image = isOpen ? openImage : (model.isLeaf(value) ? LEAF_IMAGE : closedImage);
                    SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
                    Cell.Context context = new Cell.Context(i, 0, key);
                    NodeCellList.this.cell.render(context, value, cellBuilder);
                    SafeStyles innerPadding = SafeStylesUtils.fromTrustedString(new StringBuilder(24 + String.valueOf(paddingDirection).length()).append("padding-").append(paddingDirection).append(": ").append(imageWidth).append("px;").toString());
                    SafeHtml innerDiv = template.innerDiv(innerPadding, innerClasses.toString(), image, itemValueStyle, cellBuilder.toSafeHtml());
                    SafeStyles outerPadding = SafeStylesUtils.fromTrustedString(new StringBuilder(24 + String.valueOf(paddingDirection).length()).append("padding-").append(paddingDirection).append(": ").append(paddingAmount).append("px;").toString());
                    sb.append(template.outerDiv(outerPadding, outerClasses.toString(), innerDiv, ariaSelected));
                }
            }

            @Override
            public void replaceAllChildren(List<C> values, SelectionModel<? super C> selectionModel, boolean stealFocus) {
                SafeHtmlBuilder sb = new SafeHtmlBuilder();
                this.render(sb, values, 0, selectionModel);
                if (((CellTreeNodeView)NodeCellList.this.nodeView).tree.isAnimationEnabled()) {
                    NodeCellList.this.nodeView.ensureAnimationFrame().getStyle().setDisplay(Style.Display.NONE);
                }
                ((CellTreeNodeView)((NodeCellList)NodeCellList.this).nodeView).tree.isRefreshing = true;
                Map<Object, CellTreeNodeView<?>> savedViews = this.saveChildState(values, 0);
                AbstractHasData.replaceAllChildren(((CellTreeNodeView)NodeCellList.this.nodeView).tree, this.childContainer, sb.toSafeHtml());
                ((CellTreeNodeView)((NodeCellList)NodeCellList.this).nodeView).tree.isRefreshing = false;
                int size = values.size();
                int childCount = ((CellTreeNodeView)NodeCellList.this.nodeView).children.size();
                while (childCount > size) {
                    CellTreeNodeView deleted = (CellTreeNodeView)((CellTreeNodeView)NodeCellList.this.nodeView).children.remove(--childCount);
                    deleted.cleanup(true);
                }
                this.loadChildState(values, 0, savedViews);
                if (NodeCellList.this.nodeView.isRootNode() && ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getKeyboardSelectedNode() == NodeCellList.this.nodeView && values.size() > 0) {
                    ((CellTreeNodeView)NodeCellList.this.nodeView).tree.keyboardSelect((CellTreeNodeView)((CellTreeNodeView)NodeCellList.this.nodeView).children.get(0), false);
                }
                if (((CellTreeNodeView)NodeCellList.this.nodeView).tree.isAnimationEnabled()) {
                    ((CellTreeNodeView)NodeCellList.this.nodeView).tree.maybeAnimateTreeNode(NodeCellList.this.nodeView);
                }
            }

            @Override
            public void replaceChildren(List<C> values, int start, SelectionModel<? super C> selectionModel, boolean stealFocus) {
                SafeHtmlBuilder sb = new SafeHtmlBuilder();
                this.render(sb, values, 0, selectionModel);
                Map<Object, CellTreeNodeView<?>> savedViews = this.saveChildState(values, start);
                ((CellTreeNodeView)((NodeCellList)NodeCellList.this).nodeView).tree.isRefreshing = true;
                SafeHtml html = sb.toSafeHtml();
                Element newChildren = AbstractHasData.convertToElements(((CellTreeNodeView)NodeCellList.this.nodeView).tree, CellTreeNodeView.getTmpElem(), html);
                AbstractHasData.replaceChildren(((CellTreeNodeView)NodeCellList.this.nodeView).tree, this.childContainer, newChildren, start, html);
                ((CellTreeNodeView)((NodeCellList)NodeCellList.this).nodeView).tree.isRefreshing = false;
                this.loadChildState(values, start, savedViews);
            }

            @Override
            public void resetFocus() {
                ((CellTreeNodeView)NodeCellList.this.nodeView).tree.resetFocus();
            }

            @Override
            public void setKeyboardSelected(int index, boolean selected, boolean stealFocus) {
                Element elem = (Element)this.childContainer.getChild(index).cast();
                CellTreeNodeView.setStyleName(CellTreeNodeView.getSelectionElement(elem), ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getStyle().cellTreeKeyboardSelectedItem(), selected);
            }

            @Override
            public void setLoadingState(LoadingStateChangeEvent.LoadingState state) {
                ((CellTreeNodeView)NodeCellList.this.nodeView).updateImage(state == LoadingStateChangeEvent.LoadingState.LOADING);
                CellTreeNodeView.showOrHide(((CellTreeNodeView)NodeCellList.this.nodeView).emptyMessageElem, state == LoadingStateChangeEvent.LoadingState.LOADED && NodeCellList.this.presenter.isEmpty());
            }

            private void loadChildState(List<C> values, int start, Map<Object, CellTreeNodeView<?>> savedViews) {
                int len = values.size();
                int end = start + len;
                int childCount = NodeCellList.this.nodeView.getChildCount();
                int setSize = childCount > len ? childCount : end;
                ProvidesKey keyProvider = NodeCellList.this.nodeInfo.getProvidesKey();
                Element container = NodeCellList.this.nodeView.ensureChildContainer();
                Element childElem = values.size() == 0 ? null : Element.as(container.getChild(start));
                CellTreeNodeView keyboardSelected = ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getKeyboardSelectedNode();
                for (int i = start; i < end; ++i) {
                    Object childValue = values.get(i - start);
                    CellTreeNodeView child = NodeCellList.this.nodeView.createTreeNodeView(NodeCellList.this.nodeInfo, childElem, childValue, null);
                    CellTreeNodeView<?> savedChild = savedViews.remove(keyProvider.getKey(childValue));
                    if (savedChild != null) {
                        child.animationFrame = ((CellTreeNodeView)savedChild).animationFrame;
                        child.contentContainer = ((CellTreeNodeView)savedChild).contentContainer;
                        child.childContainer = ((CellTreeNodeView)savedChild).childContainer;
                        child.children = ((CellTreeNodeView)savedChild).children;
                        child.emptyMessageElem = ((CellTreeNodeView)savedChild).emptyMessageElem;
                        child.nodeInfo = ((CellTreeNodeView)savedChild).nodeInfo;
                        child.nodeInfoLoaded = ((CellTreeNodeView)savedChild).nodeInfoLoaded;
                        child.open = ((CellTreeNodeView)savedChild).open;
                        child.showMoreElem = ((CellTreeNodeView)savedChild).showMoreElem;
                        child.treeNode = ((CellTreeNodeView)savedChild).treeNode;
                        if (child.treeNode != null) {
                            child.treeNode.nodeView = child;
                        }
                        child.listView = savedChild.listView;
                        if (child.listView != null) {
                            ((NodeCellList)child.listView).nodeView = child;
                        }
                        if (child.children != null) {
                            for (CellTreeNodeView grandchild : child.children) {
                                grandchild.parentNode = child;
                            }
                        }
                        if (keyboardSelected == savedChild) {
                            keyboardSelected = child;
                        }
                        child.getElement().appendChild(savedChild.ensureAnimationFrame());
                        ((CellTreeNodeView)savedChild).isDestroyed = true;
                    }
                    if (childCount > i) {
                        ((CellTreeNodeView)NodeCellList.this.nodeView).children.set(i, child);
                    } else {
                        ((CellTreeNodeView)NodeCellList.this.nodeView).children.add(child);
                    }
                    child.updateAriaAttributes(setSize);
                    childElem = childElem.getNextSiblingElement();
                }
                CellTreeNodeView curNode = keyboardSelected;
                while (curNode != null) {
                    if (curNode == NodeCellList.this.nodeView) {
                        ((CellTreeNodeView)NodeCellList.this.nodeView).tree.keyboardSelect(keyboardSelected, false);
                        break;
                    }
                    curNode = curNode.parentNode;
                }
            }

            private Map<Object, CellTreeNodeView<?>> saveChildState(List<C> values, int start) {
                if (((CellTreeNodeView)NodeCellList.this.nodeView).children == null) {
                    ((CellTreeNodeView)NodeCellList.this.nodeView).children = new ArrayList();
                }
                int len = values.size();
                int end = start + len;
                int childCount = NodeCellList.this.nodeView.getChildCount();
                CellTreeNodeView<?> keyboardSelected = ((CellTreeNodeView)NodeCellList.this.nodeView).tree.getKeyboardSelectedNode();
                HashMap openNodes = new HashMap();
                for (int i = start; i < end && i < childCount; ++i) {
                    CellTreeNodeView<?> child = NodeCellList.this.nodeView.getChildNode(i);
                    if (child.isOpen() || child == keyboardSelected) {
                        openNodes.put(child.getValueKey(), child);
                        continue;
                    }
                    child.cleanup(true);
                }
                ProvidesKey keyProvider = NodeCellList.this.nodeInfo.getProvidesKey();
                HashMap savedViews = new HashMap();
                for (Object childValue : values) {
                    Object key = keyProvider.getKey(childValue);
                    CellTreeNodeView savedView = (CellTreeNodeView)openNodes.remove(key);
                    if (savedView == null) continue;
                    savedView.ensureAnimationFrame().removeFromParent();
                    savedViews.put(key, savedView);
                }
                for (CellTreeNodeView lostNode : openNodes.values()) {
                    lostNode.cleanup(true);
                }
                return savedViews;
            }
        }
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div onclick=\"\" style=\"{0}position:relative;\" class=\"{1}\">{2}<div class=\"{3}\">{4}</div></div>")
        public SafeHtml innerDiv(SafeStyles var1, String var2, SafeHtml var3, String var4, SafeHtml var5);

        @SafeHtmlTemplates.Template(value="<div aria-selected=\"{3}\"><div style=\"{0}\" class=\"{1}\">{2}</div></div>")
        public SafeHtml outerDiv(SafeStyles var1, String var2, SafeHtml var3, String var4);
    }
}

